/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.Extension;
import org.apache.catalina.util.ManifestResource;
import org.apache.naming.resources.Resource;
import org.glassfish.logging.annotation.LogMessageInfo;

public final class ExtensionValidator {
    private static final Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    private static volatile HashMap<String, Extension> containerAvailableExtensions = null;
    private static ArrayList<ManifestResource> containerManifestResources = new ArrayList();
    @LogMessageInfo(message="Failed to load manifest resources {0}", level="SEVERE", cause="Could not find MANIFEST from JAR file", action="Verify the JAR file")
    public static final String FAILED_LOAD_MANIFEST_RESOURCES_EXCEPTION = "AS-WEB-CORE-00484";
    @LogMessageInfo(message="ExtensionValidator[{0}][{1}]: Required extension \"{2}\" not found.", level="INFO")
    public static final String EXTENSION_NOT_FOUND_INFO = "AS-WEB-CORE-00485";
    @LogMessageInfo(message="ExtensionValidator[{0}]: Failure to find {1} required extension(s).", level="INFO")
    public static final String FAILED_FIND_EXTENSION_INFO = "AS-WEB-CORE-00486";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean validateApplication(DirContext dirContext, StandardContext context) throws IOException {
        ManifestResource mre;
        Binding binding;
        String appName = context.getPath();
        ArrayList<ManifestResource> appManifestResources = new ArrayList<ManifestResource>();
        Object appManifestResource = null;
        if (dirContext == null) {
            return false;
        }
        InputStream inputStream = null;
        try {
            NamingEnumeration<Binding> wne = dirContext.listBindings("/META-INF/");
            binding = (Binding)wne.nextElement();
            if (binding.getName().toUpperCase(Locale.ENGLISH).equals("MANIFEST.MF")) {
                Resource resource = (Resource)dirContext.lookup("/META-INF/" + binding.getName());
                inputStream = resource.streamContent();
                Manifest manifest = new Manifest(inputStream);
                inputStream.close();
                inputStream = null;
                String resourceName = "Web Application Manifest";
                mre = new ManifestResource(resourceName, manifest, 2);
                appManifestResources.add(mre);
            }
        }
        catch (NamingException nex) {
        }
        catch (NoSuchElementException nse) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable t) {}
            }
        }
        NamingEnumeration<Binding> ne = null;
        try {
            ne = dirContext.listBindings("WEB-INF/lib/");
            while (ne != null && ne.hasMoreElements()) {
                Resource resource;
                Manifest jmanifest;
                Object obj;
                binding = (Binding)ne.nextElement();
                if (!binding.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !((obj = dirContext.lookup("/WEB-INF/lib/" + binding.getName())) instanceof Resource) || (jmanifest = ExtensionValidator.getManifest((resource = (Resource)obj).streamContent())) == null) continue;
                mre = new ManifestResource(binding.getName(), jmanifest, 3);
                appManifestResources.add(mre);
            }
        }
        catch (NamingException nex) {
            // empty catch block
        }
        return ExtensionValidator.validateManifestResources(appName, appManifestResources);
    }

    private static boolean validateManifestResources(String appName, ArrayList<ManifestResource> resources) {
        boolean passes = true;
        int failureCount = 0;
        HashMap<String, Extension> availableExtensions = null;
        for (ManifestResource mre : resources) {
            ArrayList<Extension> requiredList = mre.getRequiredExtensions();
            if (requiredList == null) continue;
            if (availableExtensions == null) {
                availableExtensions = ExtensionValidator.buildAvailableExtensionsMap(resources);
            }
            if (containerAvailableExtensions == null) {
                containerAvailableExtensions = ExtensionValidator.buildAvailableExtensionsMap(containerManifestResources);
            }
            for (Extension requiredExt : requiredList) {
                Extension targetExt;
                String extId = requiredExt.getUniqueId();
                if (availableExtensions != null && availableExtensions.containsKey(extId)) {
                    targetExt = availableExtensions.get(extId);
                    if (!targetExt.isCompatibleWith(requiredExt)) continue;
                    requiredExt.setFulfilled(true);
                    continue;
                }
                if (containerAvailableExtensions != null && containerAvailableExtensions.containsKey(extId)) {
                    targetExt = containerAvailableExtensions.get(extId);
                    if (!targetExt.isCompatibleWith(requiredExt)) continue;
                    requiredExt.setFulfilled(true);
                    continue;
                }
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, EXTENSION_NOT_FOUND_INFO, new Object[]{appName, mre.getResourceName(), requiredExt.getExtensionName()});
                }
                passes = false;
                ++failureCount;
            }
        }
        if (!passes && log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, FAILED_FIND_EXTENSION_INFO, new Object[]{appName, failureCount});
        }
        return passes;
    }

    private static HashMap<String, Extension> buildAvailableExtensionsMap(ArrayList<ManifestResource> resources) {
        HashMap<String, Extension> availableMap = null;
        for (ManifestResource mre : resources) {
            HashMap<String, Extension> map = mre.getAvailableExtensions();
            if (map == null) continue;
            for (Extension ext : map.values()) {
                if (availableMap == null) {
                    availableMap = new HashMap<String, Extension>();
                    availableMap.put(ext.getUniqueId(), ext);
                    continue;
                }
                if (availableMap.containsKey(ext.getUniqueId())) continue;
                availableMap.put(ext.getUniqueId(), ext);
            }
        }
        return availableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(InputStream inStream) throws IOException {
        Manifest manifest = null;
        JarInputStream jin = null;
        try {
            jin = new JarInputStream(inStream);
            manifest = jin.getManifest();
            jin.close();
            jin = null;
        }
        finally {
            if (jin != null) {
                try {
                    jin.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return manifest;
    }

    private static void addSystemResource(File jarFile) throws IOException {
        Manifest manifest = ExtensionValidator.getManifest(new FileInputStream(jarFile));
        if (manifest != null) {
            ManifestResource mre = new ManifestResource(jarFile.getAbsolutePath(), manifest, 1);
            containerManifestResources.add(mre);
        }
    }

    static {
        String systemClasspath = System.getProperty("java.class.path");
        StringTokenizer strTok = new StringTokenizer(systemClasspath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            File item;
            String classpathItem = strTok.nextToken();
            if (!classpathItem.toLowerCase(Locale.ENGLISH).endsWith(".jar") || !(item = new File(classpathItem)).exists()) continue;
            try {
                ExtensionValidator.addSystemResource(item);
            }
            catch (IOException e) {
                String msg = MessageFormat.format(rb.getString(FAILED_LOAD_MANIFEST_RESOURCES_EXCEPTION), item);
                log.log(Level.SEVERE, msg, e);
            }
        }
        String extensionsDir = System.getProperty("java.ext.dirs");
        if (extensionsDir != null) {
            StringTokenizer extensionsTok = new StringTokenizer(extensionsDir, File.pathSeparator);
            while (extensionsTok.hasMoreTokens()) {
                File targetDir = new File(extensionsTok.nextToken());
                if (!targetDir.exists() || !targetDir.isDirectory()) continue;
                File[] files = targetDir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
                    try {
                        ExtensionValidator.addSystemResource(files[i]);
                        continue;
                    }
                    catch (IOException e) {
                        String msg = MessageFormat.format(rb.getString(FAILED_LOAD_MANIFEST_RESOURCES_EXCEPTION), files[i]);
                        log.log(Level.SEVERE, msg, e);
                    }
                }
            }
        }
    }
}

