/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.UserDatabase;
import org.glassfish.logging.annotation.LogMessageInfo;

public final class UserConfig
implements LifecycleListener {
    private static final java.util.logging.Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="Deploying user web applications", level="INFO")
    public static final String DEPLOYING_USER_WEB_APP_INFO = "AS-WEB-CORE-00476";
    @LogMessageInfo(message="Exception loading user database", level="WARNING")
    public static final String LOADING_USER_DATABASE_EXCEPTION = "AS-WEB-CORE-00477";
    @LogMessageInfo(message="Deploying web application for user {0}", level="INFO")
    public static final String DEPLOYING_WEB_APP_FOR_USER_INFO = "AS-WEB-CORE-00478";
    @LogMessageInfo(message="Error deploying web application for user {0}", level="WARNING")
    public static final String DEPLOYING_WEB_APP_FOR_USER_EXCEPTION = "AS-WEB-CORE-00479";
    @LogMessageInfo(message="UserConfig[{0}]: {1}", level="INFO")
    public static final String USER_CONFIG = "AS-WEB-CORE-00480";
    @LogMessageInfo(message="UserConfig[null]: {0}", level="INFO")
    public static final String USER_CONFIG_NULL = "AS-WEB-CORE-00481";
    @LogMessageInfo(message="UserConfig: Processing START", level="INFO")
    public static final String PROCESSING_START_INFO = "AS-WEB-CORE-00482";
    @LogMessageInfo(message="UserConfig: Processing STOP", level="INFO")
    public static final String PROCESSING_STOP_INFO = "AS-WEB-CORE-00483";
    private String configClass = ContextConfig.class.getName();
    private String contextClass = StandardContext.class.getName();
    private int debug = 999;
    private String directoryName = "public_html";
    private String homeBase = null;
    private Host host = null;
    private String userClass = "org.apache.catalina.startup.PasswdUserDatabase";

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getHomeBase() {
        return this.homeBase;
    }

    public void setHomeBase(String homeBase) {
        this.homeBase = homeBase;
    }

    public String getUserClass() {
        return this.userClass;
    }

    public void setUserClass(String userClass) {
        this.userClass = userClass;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.host = (Host)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00450"), event.getLifecycle());
            this.log(msg, e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void deploy() {
        if (this.debug >= 1) {
            this.log(rb.getString(DEPLOYING_USER_WEB_APP_INFO));
        }
        UserDatabase database = null;
        try {
            Class<?> clazz = Class.forName(this.userClass);
            database = (UserDatabase)clazz.newInstance();
            database.setUserConfig(this);
        }
        catch (Exception e) {
            this.log(rb.getString(LOADING_USER_DATABASE_EXCEPTION), e);
            return;
        }
        Enumeration users = database.getUsers();
        while (users.hasMoreElements()) {
            String user = (String)users.nextElement();
            String home = database.getHome(user);
            this.deploy(user, home);
        }
    }

    private void deploy(String user, String home) {
        String contextPath = "/~" + user;
        if (this.host.findChild(contextPath) != null) {
            return;
        }
        File app = new File(home, this.directoryName);
        if (!app.exists() || !app.isDirectory()) {
            return;
        }
        String msg = MessageFormat.format(rb.getString(DEPLOYING_WEB_APP_FOR_USER_INFO), user);
        this.log(msg);
        try {
            Class<?> clazz = Class.forName(this.contextClass);
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(app.toString());
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.configClass);
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            this.host.addChild(context);
        }
        catch (Exception e) {
            String deployWebAppMsg = MessageFormat.format(rb.getString(DEPLOYING_WEB_APP_FOR_USER_EXCEPTION), user);
            this.log(deployWebAppMsg, e);
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
            if (logger != null) {
                logger.log("UserConfig[" + this.host.getName() + "]: " + message);
            } else if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, USER_CONFIG, new Object[]{this.host.getName(), message});
            }
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, USER_CONFIG_NULL, message);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        if (this.host != null) {
            logger = this.host.getLogger();
            if (logger != null) {
                logger.log("UserConfig[" + this.host.getName() + "] " + message, t, 2);
            } else {
                String msg = MessageFormat.format(rb.getString(USER_CONFIG), this.host.getName(), message);
                log.log(Level.WARNING, msg, t);
            }
        } else {
            String msg = MessageFormat.format(rb.getString(USER_CONFIG_NULL), message);
            log.log(Level.WARNING, msg, t);
        }
    }

    private void start() {
        if (this.debug > 0) {
            this.log(rb.getString(PROCESSING_START_INFO));
        }
        this.deploy();
    }

    private void stop() {
        if (this.debug > 0) {
            this.log(rb.getString(PROCESSING_STOP_INFO));
        }
    }
}

