/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FilenameFilter;
import org.pf.file.ExtendedFileFilter;
import org.pf.file.FileHandler;
import org.pf.text.StringUtil;

public class FileWalker {
    public static final char PATTERN_SEPARATOR_CHAR = ';';
    public static final String PATTERN_SEPARATOR = ";";
    private FileHandler fileHandler = null;
    private boolean goOn = true;
    private Character digitWildcard = null;

    protected FileHandler getFileHandler() {
        return this.fileHandler;
    }

    protected void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    protected boolean getGoOn() {
        return this.goOn;
    }

    protected void setGoOn(boolean bl) {
        this.goOn = bl;
    }

    protected Character getDigitWildcard() {
        return this.digitWildcard;
    }

    protected void setDigitWildcard(Character c) {
        this.digitWildcard = c;
    }

    public FileWalker(FileHandler fileHandler) {
        this.setFileHandler(fileHandler);
    }

    public FileWalker(FileHandler fileHandler, char c) {
        this(fileHandler);
        this.setDigitWildcardChar(c);
    }

    public long walkThrough(String string, String string2, boolean bl) {
        ExtendedFileFilter extendedFileFilter = null;
        String[] stringArray = null;
        this.setGoOn(true);
        extendedFileFilter = new ExtendedFileFilter();
        stringArray = this.extractPatterns(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (this.hasDigitWildcard()) {
                extendedFileFilter.addPattern(string3, true, this.getDigitWildcardChar());
                continue;
            }
            extendedFileFilter.addPattern(string3, true);
        }
        if (bl) {
            extendedFileFilter.alwaysIncludeDirectories();
        } else {
            extendedFileFilter.alwaysExcludeDirectories();
        }
        return this.walkThrough(string, extendedFileFilter, bl);
    }

    public void setDigitWildcardChar(char c) {
        if (c <= '\u0000') {
            this.setDigitWildcard(null);
        } else {
            this.setDigitWildcard(new Character(c));
        }
    }

    protected long walkThrough(String string, FilenameFilter filenameFilter, boolean bl) {
        long l = 0L;
        File file = null;
        File file2 = null;
        File[] fileArray = null;
        int n = 0;
        file = new File(string);
        fileArray = file.listFiles(filenameFilter);
        if (fileArray == null) {
            return l;
        }
        this.setGoOn(this.getFileHandler().directoryStart(file, fileArray.length));
        if (!this.getGoOn()) {
            return l;
        }
        for (n = 0; n < fileArray.length; ++n) {
            file2 = fileArray[n];
            if (file2.isDirectory()) {
                if (bl) {
                    l += this.walkThrough(file2.getPath(), filenameFilter, bl);
                }
            } else {
                this.setGoOn(this.getFileHandler().handleFile(file2));
                ++l;
            }
            if (!this.getGoOn()) break;
        }
        this.setGoOn(this.getFileHandler().directoryEnd(file));
        return l;
    }

    protected String[] extractPatterns(String string) {
        return StringUtil.current().parts(string, PATTERN_SEPARATOR);
    }

    protected char getDigitWildcardChar() {
        if (this.hasDigitWildcard()) {
            return this.getDigitWildcard().charValue();
        }
        return '\u0000';
    }

    protected boolean hasDigitWildcard() {
        return this.getDigitWildcard() != null;
    }
}

