/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.tracker;

import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerPeer;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentRemovalVetoException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentWillBeRemovedListener;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestDispatcher;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;

public class RPTrackerTorrent
extends RPObject
implements TrackerTorrent {
    protected transient TrackerTorrent delegate;
    public RPTorrent torrent;
    public int status;
    public long total_uploaded;
    public long total_downloaded;
    public long average_uploaded;
    public long average_downloaded;
    public long total_left;
    public long completed_count;
    public long total_bytes_in;
    public long average_bytes_in;
    public long total_bytes_out;
    public long average_bytes_out;
    public long scrape_count;
    public long average_scrape_count;
    public long announce_count;
    public long average_announce_count;
    public int seed_count;
    public int leecher_count;
    public int bad_NAT_count;

    public static RPTrackerTorrent create(TrackerTorrent trackerTorrent) {
        RPTrackerTorrent rPTrackerTorrent = (RPTrackerTorrent)RPTrackerTorrent._lookupLocal(trackerTorrent);
        if (rPTrackerTorrent == null) {
            rPTrackerTorrent = new RPTrackerTorrent(trackerTorrent);
        }
        return rPTrackerTorrent;
    }

    protected RPTrackerTorrent(TrackerTorrent trackerTorrent) {
        super(trackerTorrent);
        if (this.delegate.getTorrent() != null) {
            this.torrent = (RPTorrent)RPTrackerTorrent._lookupLocal(this.delegate.getTorrent());
            if (this.torrent == null) {
                this.torrent = RPTorrent.create(this.delegate.getTorrent());
            }
        }
    }

    @Override
    protected void _setDelegate(Object object) {
        this.delegate = (TrackerTorrent)object;
        this.status = this.delegate.getStatus();
        this.total_uploaded = this.delegate.getTotalUploaded();
        this.total_downloaded = this.delegate.getTotalDownloaded();
        this.average_uploaded = this.delegate.getAverageUploaded();
        this.average_downloaded = this.delegate.getAverageDownloaded();
        this.total_left = this.delegate.getTotalLeft();
        this.completed_count = this.delegate.getCompletedCount();
        this.total_bytes_in = this.delegate.getTotalBytesIn();
        this.average_bytes_in = this.delegate.getAverageBytesIn();
        this.total_bytes_out = this.delegate.getTotalBytesOut();
        this.average_bytes_out = this.delegate.getAverageBytesOut();
        this.scrape_count = this.delegate.getScrapeCount();
        this.average_scrape_count = this.delegate.getAverageScrapeCount();
        this.announce_count = this.delegate.getAnnounceCount();
        this.average_announce_count = this.delegate.getAverageAnnounceCount();
        this.seed_count = this.delegate.getSeedCount();
        this.leecher_count = this.delegate.getLeecherCount();
        this.bad_NAT_count = this.delegate.getBadNATCount();
    }

    @Override
    public Object _setLocal() throws RPException {
        Object object = this._fixupLocal();
        if (this.torrent != null) {
            this.torrent._setLocal();
        }
        return object;
    }

    @Override
    public void _setRemote(RPRequestDispatcher rPRequestDispatcher) {
        super._setRemote(rPRequestDispatcher);
        if (this.torrent != null) {
            this.torrent._setRemote(rPRequestDispatcher);
        }
    }

    @Override
    public RPReply _process(RPRequest rPRequest) {
        String string = rPRequest.getMethod();
        throw new RPException("Unknown method: " + string);
    }

    @Override
    public void start() throws TrackerException {
        this.notSupported();
    }

    @Override
    public void stop() throws TrackerException {
        this.notSupported();
    }

    @Override
    public void remove() throws TrackerTorrentRemovalVetoException {
        this.notSupported();
    }

    @Override
    public boolean canBeRemoved() throws TrackerTorrentRemovalVetoException {
        this.notSupported();
        return false;
    }

    @Override
    public Torrent getTorrent() {
        return this.torrent;
    }

    @Override
    public TrackerPeer[] getPeers() {
        this.notSupported();
        return null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public long getTotalUploaded() {
        return this.total_uploaded;
    }

    @Override
    public long getTotalDownloaded() {
        return this.total_downloaded;
    }

    @Override
    public long getAverageUploaded() {
        return this.average_uploaded;
    }

    @Override
    public long getAverageDownloaded() {
        return this.average_downloaded;
    }

    @Override
    public long getTotalLeft() {
        return this.total_left;
    }

    @Override
    public long getCompletedCount() {
        return this.completed_count;
    }

    @Override
    public long getTotalBytesIn() {
        return this.total_bytes_in;
    }

    @Override
    public long getAverageBytesIn() {
        return this.average_bytes_in;
    }

    @Override
    public long getTotalBytesOut() {
        return this.total_bytes_out;
    }

    @Override
    public long getAverageBytesOut() {
        return this.average_bytes_out;
    }

    @Override
    public long getScrapeCount() {
        return this.scrape_count;
    }

    @Override
    public long getAverageScrapeCount() {
        return this.average_scrape_count;
    }

    @Override
    public long getAnnounceCount() {
        return this.announce_count;
    }

    @Override
    public long getAverageAnnounceCount() {
        return this.average_announce_count;
    }

    @Override
    public int getSeedCount() {
        return this.seed_count;
    }

    @Override
    public int getLeecherCount() {
        return this.leecher_count;
    }

    @Override
    public int getBadNATCount() {
        return this.bad_NAT_count;
    }

    @Override
    public void disableReplyCaching() {
        this.notSupported();
    }

    @Override
    public boolean isPassive() {
        this.notSupported();
        return false;
    }

    @Override
    public long getDateAdded() {
        this.notSupported();
        return 0L;
    }

    @Override
    public void addListener(TrackerTorrentListener trackerTorrentListener) {
        this.notSupported();
    }

    @Override
    public void removeListener(TrackerTorrentListener trackerTorrentListener) {
        this.notSupported();
    }

    @Override
    public void addRemovalListener(TrackerTorrentWillBeRemovedListener trackerTorrentWillBeRemovedListener) {
        this.notSupported();
    }

    @Override
    public void removeRemovalListener(TrackerTorrentWillBeRemovedListener trackerTorrentWillBeRemovedListener) {
        this.notSupported();
    }
}

