/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.tracker;

import java.net.InetAddress;
import java.net.URL;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationListener;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;
import org.gudy.azureus2.pluginsimpl.remote.tracker.RPTrackerTorrent;

public class RPTracker
extends RPObject
implements Tracker {
    protected transient Tracker delegate;

    public static RPTracker create(Tracker tracker) {
        RPTracker rPTracker = (RPTracker)RPTracker._lookupLocal(tracker);
        if (rPTracker == null) {
            rPTracker = new RPTracker(tracker);
        }
        return rPTracker;
    }

    protected RPTracker(Tracker tracker) {
        super(tracker);
    }

    @Override
    protected void _setDelegate(Object object) {
        this.delegate = (Tracker)object;
    }

    @Override
    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    @Override
    public RPReply _process(RPRequest rPRequest) {
        String string = rPRequest.getMethod();
        Object[] objectArray = rPRequest.getParams();
        if (string.equals("host[Torrent,boolean]")) {
            try {
                Torrent torrent;
                Torrent torrent2 = torrent = objectArray[0] == null ? null : (Torrent)((RPTorrent)objectArray[0])._setLocal();
                if (torrent == null) {
                    throw new RPException("Invalid torrent");
                }
                TrackerTorrent trackerTorrent = this.delegate.host(torrent, (Boolean)objectArray[1]);
                RPTrackerTorrent rPTrackerTorrent = RPTrackerTorrent.create(trackerTorrent);
                return new RPReply(rPTrackerTorrent);
            }
            catch (TrackerException trackerException) {
                return new RPReply(trackerException);
            }
        }
        if (string.equals("getTorrents")) {
            TrackerTorrent[] trackerTorrentArray = this.delegate.getTorrents();
            RPTrackerTorrent[] rPTrackerTorrentArray = new RPTrackerTorrent[trackerTorrentArray.length];
            for (int i = 0; i < rPTrackerTorrentArray.length; ++i) {
                rPTrackerTorrentArray[i] = RPTrackerTorrent.create(trackerTorrentArray[i]);
            }
            return new RPReply(rPTrackerTorrentArray);
        }
        throw new RPException("Unknown method: " + string);
    }

    @Override
    public TrackerTorrent host(Torrent torrent, boolean bl) throws TrackerException {
        try {
            RPTrackerTorrent rPTrackerTorrent = (RPTrackerTorrent)this._dispatcher.dispatch(new RPRequest(this, "host[Torrent,boolean]", new Object[]{torrent, new Boolean(bl)})).getResponse();
            rPTrackerTorrent._setRemote(this._dispatcher);
            return rPTrackerTorrent;
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof TrackerException) {
                throw (TrackerException)rPException.getCause();
            }
            throw rPException;
        }
    }

    @Override
    public TrackerTorrent host(Torrent torrent, boolean bl, boolean bl2) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerTorrent publish(Torrent torrent) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerTorrent[] getTorrents() {
        TrackerTorrent[] trackerTorrentArray = (RPTrackerTorrent[])this._dispatcher.dispatch(new RPRequest(this, "getTorrents", null)).getResponse();
        for (int i = 0; i < trackerTorrentArray.length; ++i) {
            ((RPTrackerTorrent)trackerTorrentArray[i])._setRemote(this._dispatcher);
        }
        return trackerTorrentArray;
    }

    @Override
    public TrackerTorrent getTorrent(Torrent torrent) {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerWebContext createWebContext(int n, int n2) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerWebContext createWebContext(String string, int n, int n2) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public TrackerWebContext createWebContext(String string, int n, int n2, InetAddress inetAddress) throws TrackerException {
        this.notSupported();
        return null;
    }

    @Override
    public void addListener(TrackerListener trackerListener) {
    }

    @Override
    public void removeListener(TrackerListener trackerListener) {
    }

    @Override
    public String getName() {
        this.notSupported();
        return null;
    }

    @Override
    public void setEnableKeepAlive(boolean bl) {
        this.notSupported();
    }

    @Override
    public URL[] getURLs() {
        this.notSupported();
        return null;
    }

    @Override
    public InetAddress getBindIP() {
        this.notSupported();
        return null;
    }

    @Override
    public void addPageGenerator(TrackerWebPageGenerator trackerWebPageGenerator) {
    }

    @Override
    public void removePageGenerator(TrackerWebPageGenerator trackerWebPageGenerator) {
    }

    @Override
    public TrackerWebPageGenerator[] getPageGenerators() {
        this.notSupported();
        return null;
    }

    @Override
    public void addAuthenticationListener(TrackerAuthenticationListener trackerAuthenticationListener) {
    }

    @Override
    public void removeAuthenticationListener(TrackerAuthenticationListener trackerAuthenticationListener) {
    }

    @Override
    public void destroy() {
        this.notSupported();
    }
}

