/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.security;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.security.CryptoManagerException;
import com.aelitis.azureus.core.security.CryptoSTSEngine;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnectionListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.security.SEPublicKey;
import org.gudy.azureus2.plugins.utils.security.SEPublicKeyLocator;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SEPublicKeyImpl;

public class SESTSConnectionImpl
implements GenericMessageConnection {
    private static final int CRYPTO_SETUP_TIMEOUT = 60000;
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final byte[] AES_IV1 = new byte[]{21, -32, 107, 126, -104, 89, -28, -89, 52, 102, -83, 72, 53, -30, -48, 36};
    private static final byte[] AES_IV2 = new byte[]{-60, -17, 6, 60, -104, 35, -24, -76, 38, 88, -82, -71, 44, 36, -74, 17};
    private final int AES_KEY_SIZE_BYTES = AES_IV1.length;
    private static long last_incoming_sts_create;
    private static List connections;
    private static final int BLOOM_RECREATE = 30000;
    private static final int BLOOM_INCREASE = 500;
    private static BloomFilter generate_bloom;
    private static long generate_bloom_create_time;
    private AzureusCore core;
    private GenericMessageConnectionImpl connection;
    private SEPublicKey my_public_key;
    private SEPublicKeyLocator key_locator;
    private String reason;
    private int block_crypto;
    private long create_time;
    private CryptoSTSEngine sts_engine;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private boolean sent_keys;
    private boolean sent_auth;
    private PooledByteBuffer pending_message;
    private AESemaphore crypto_complete = new AESemaphore("SESTSConnection:send");
    private Cipher outgoing_cipher;
    private Cipher incoming_cipher;
    private volatile boolean failed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SESTSConnectionImpl(AzureusCore azureusCore, GenericMessageConnectionImpl genericMessageConnectionImpl, SEPublicKey sEPublicKey, SEPublicKeyLocator sEPublicKeyLocator, String string, int n) throws Exception {
        this.core = azureusCore;
        this.connection = genericMessageConnectionImpl;
        this.my_public_key = sEPublicKey;
        this.key_locator = sEPublicKeyLocator;
        this.reason = string;
        this.block_crypto = n;
        this.create_time = SystemTime.getCurrentTime();
        List list = connections;
        synchronized (list) {
            connections.add(this);
        }
        if (this.connection.isIncoming()) {
            SESTSConnectionImpl.rateLimit(this.connection.getEndpoint().getNotionalAddress());
        }
        this.sts_engine = this.core.getCryptoManager().getECCHandler().getSTSEngine(this.reason);
        this.connection.addListener(new GenericMessageConnectionListener(){

            @Override
            public void connected(GenericMessageConnection genericMessageConnection) {
                SESTSConnectionImpl.this.reportConnected();
            }

            @Override
            public void receive(GenericMessageConnection genericMessageConnection, PooledByteBuffer pooledByteBuffer) throws MessageException {
                SESTSConnectionImpl.this.receive(pooledByteBuffer);
            }

            @Override
            public void failed(GenericMessageConnection genericMessageConnection, Throwable throwable) throws MessageException {
                SESTSConnectionImpl.this.reportFailed(throwable);
            }
        });
    }

    protected int getConnectMethodCount() {
        return this.connection.getConnectMethodCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void rateLimit(InetSocketAddress inetSocketAddress) throws Exception {
        Class<SESTSConnectionImpl> clazz = SESTSConnectionImpl.class;
        synchronized (SESTSConnectionImpl.class) {
            int n = generate_bloom.add(inetSocketAddress.getAddress().getAddress());
            long l = SystemTime.getCurrentTime();
            if (generate_bloom.getSize() / generate_bloom.getEntryCount() < 10) {
                generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize() + 500);
                generate_bloom_create_time = l;
                Logger.log(new LogEvent(LOGID, "STS bloom: size increased to " + generate_bloom.getSize()));
            } else if (l < generate_bloom_create_time || l - generate_bloom_create_time > 30000L) {
                generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize());
                generate_bloom_create_time = l;
            }
            if (n >= 15) {
                Logger.log(new LogEvent(LOGID, "STS bloom: too many recent connection attempts from " + inetSocketAddress));
                Debug.out("STS: too many recent connection attempts from " + inetSocketAddress);
                throw new IOException("Too many recent connection attempts (sts)");
            }
            long l2 = l - last_incoming_sts_create;
            long l3 = 100L - l2;
            if (l3 > 0L && l3 < 100L) {
                try {
                    Logger.log(new LogEvent(LOGID, "STS: too many recent connection attempts, delaying " + l3));
                    Thread.sleep(l3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            last_incoming_sts_create = l;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public GenericMessageEndpoint getEndpoint() {
        return this.connection.getEndpoint();
    }

    @Override
    public int getMaximumMessageSize() {
        int n = this.connection.getMaximumMessageSize();
        if (this.outgoing_cipher != null) {
            n -= this.outgoing_cipher.getBlockSize();
        }
        return n;
    }

    @Override
    public String getType() {
        String string = this.connection.getType();
        if (string.length() == 0) {
            return "";
        }
        return "AES " + string;
    }

    @Override
    public int getTransportType() {
        return this.connection.getTransportType();
    }

    @Override
    public void addInboundRateLimiter(RateLimiter rateLimiter) {
        this.connection.addInboundRateLimiter(rateLimiter);
    }

    @Override
    public void removeInboundRateLimiter(RateLimiter rateLimiter) {
        this.connection.removeInboundRateLimiter(rateLimiter);
    }

    @Override
    public void addOutboundRateLimiter(RateLimiter rateLimiter) {
        this.connection.addOutboundRateLimiter(rateLimiter);
    }

    @Override
    public void removeOutboundRateLimiter(RateLimiter rateLimiter) {
        this.connection.removeOutboundRateLimiter(rateLimiter);
    }

    @Override
    public void connect() throws MessageException {
        if (this.connection.isIncoming()) {
            this.connection.connect();
        } else {
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(32768);
                this.sts_engine.getKeys(byteBuffer);
                byteBuffer.flip();
                this.sent_keys = true;
                this.connection.connect(byteBuffer);
            }
            catch (CryptoManagerException cryptoManagerException) {
                throw new MessageException("Failed to get initial keys", cryptoManagerException);
            }
        }
    }

    protected void setFailed() {
        this.failed = true;
        try {
            this.cryptoComplete();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(PooledByteBuffer pooledByteBuffer) throws MessageException {
        try {
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer byteBuffer = null;
            SESTSConnectionImpl sESTSConnectionImpl = this;
            synchronized (sESTSConnectionImpl) {
                if (this.crypto_complete.isReleasedForever()) {
                    bl = true;
                } else {
                    ByteBuffer byteBuffer2 = ByteBuffer.wrap(pooledByteBuffer.toByteArray());
                    pooledByteBuffer.returnToPool();
                    if (!this.sent_keys) {
                        byteBuffer = ByteBuffer.allocate(65536);
                        this.sts_engine.getKeys(byteBuffer);
                        this.sent_keys = true;
                        this.sts_engine.putKeys(byteBuffer2);
                        this.sts_engine.getAuth(byteBuffer);
                        this.sent_auth = true;
                    } else if (!this.sent_auth) {
                        byteBuffer = ByteBuffer.allocate(65536);
                        this.sts_engine.putKeys(byteBuffer2);
                        this.sts_engine.getAuth(byteBuffer);
                        this.sent_auth = true;
                        this.sts_engine.putAuth(byteBuffer2);
                        byte[] byArray = this.sts_engine.getRemotePublicKey();
                        if (!this.key_locator.accept(this, new SEPublicKeyImpl(this.my_public_key.getType(), byArray))) {
                            throw new MessageException("remote public key not accepted");
                        }
                        this.setupBlockCrypto();
                        if (this.pending_message != null) {
                            byte[] byArray2 = this.pending_message.toByteArray();
                            int n = byArray2.length;
                            if (this.outgoing_cipher != null && (n = (n + this.AES_KEY_SIZE_BYTES - 1) / this.AES_KEY_SIZE_BYTES * this.AES_KEY_SIZE_BYTES) == 0) {
                                n = this.AES_KEY_SIZE_BYTES;
                            }
                            if (byteBuffer.remaining() >= n) {
                                if (this.outgoing_cipher != null) {
                                    byteBuffer.put(this.outgoing_cipher.doFinal(byArray2));
                                } else {
                                    byteBuffer.put(byArray2);
                                }
                                this.pending_message = null;
                            }
                        }
                        bl2 = true;
                    } else {
                        this.sts_engine.putAuth(byteBuffer2);
                        byte[] byArray = this.sts_engine.getRemotePublicKey();
                        if (!this.key_locator.accept(this, new SEPublicKeyImpl(this.my_public_key.getType(), byArray))) {
                            this.connection.closing();
                            throw new MessageException("remote public key not accepted");
                        }
                        this.setupBlockCrypto();
                        bl2 = true;
                        if (byteBuffer2.hasRemaining()) {
                            pooledByteBuffer = new PooledByteBufferImpl(new DirectByteBuffer(byteBuffer2.slice()));
                            bl = true;
                        }
                    }
                }
            }
            if (byteBuffer != null) {
                byteBuffer.flip();
                this.connection.send(new PooledByteBufferImpl(new DirectByteBuffer(byteBuffer)));
            }
            if (bl2) {
                this.cryptoComplete();
            }
            if (bl) {
                this.receiveContent(pooledByteBuffer);
            }
        }
        catch (Throwable throwable) {
            this.reportFailed(throwable);
            if (throwable instanceof MessageException) {
                throw (MessageException)throwable;
            }
            throw new MessageException("Receive failed", throwable);
        }
    }

    protected void setupBlockCrypto() throws MessageException {
        if (!this.failed) {
            if (this.block_crypto == 1) {
                return;
            }
            try {
                byte[] byArray = this.sts_engine.getSharedSecret();
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 0, 16, "AES");
                SecretKeySpec secretKeySpec2 = new SecretKeySpec(byArray, 8, 16, "AES");
                IvParameterSpec ivParameterSpec = new IvParameterSpec(AES_IV1);
                IvParameterSpec ivParameterSpec2 = new IvParameterSpec(AES_IV2);
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                Cipher cipher2 = Cipher.getInstance("AES/CBC/PKCS5Padding");
                if (this.connection.isIncoming()) {
                    cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
                    cipher2.init(2, (Key)secretKeySpec2, ivParameterSpec2);
                    this.incoming_cipher = cipher2;
                    this.outgoing_cipher = cipher;
                } else {
                    cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                    cipher2.init(1, (Key)secretKeySpec2, ivParameterSpec2);
                    this.incoming_cipher = cipher;
                    this.outgoing_cipher = cipher2;
                }
            }
            catch (Throwable throwable) {
                throw new MessageException("Failed to setup block encryption", throwable);
            }
        }
    }

    protected void cryptoComplete() throws MessageException {
        this.crypto_complete.releaseForever();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(PooledByteBuffer pooledByteBuffer) throws MessageException {
        if (this.failed) {
            throw new MessageException("Connection failed");
        }
        try {
            if (this.crypto_complete.isReleasedForever()) {
                this.sendContent(pooledByteBuffer);
            } else {
                SESTSConnectionImpl sESTSConnectionImpl = this;
                synchronized (sESTSConnectionImpl) {
                    if (this.pending_message == null) {
                        this.pending_message = pooledByteBuffer;
                    }
                }
            }
            this.crypto_complete.reserve();
            boolean bl = false;
            SESTSConnectionImpl sESTSConnectionImpl = this;
            synchronized (sESTSConnectionImpl) {
                if (this.pending_message == pooledByteBuffer) {
                    this.pending_message = null;
                    bl = true;
                }
            }
            if (bl) {
                this.sendContent(pooledByteBuffer);
            }
        }
        catch (Throwable throwable) {
            this.setFailed();
            if (throwable instanceof MessageException) {
                throw (MessageException)throwable;
            }
            throw new MessageException("Send failed", throwable);
        }
    }

    protected void sendContent(PooledByteBuffer pooledByteBuffer) throws MessageException {
        block6: {
            if (this.outgoing_cipher != null) {
                try {
                    byte[] byArray = pooledByteBuffer.toByteArray();
                    byte[] byArray2 = this.outgoing_cipher.doFinal(byArray);
                    PooledByteBufferImpl pooledByteBufferImpl = new PooledByteBufferImpl(byArray2);
                    try {
                        this.connection.send(pooledByteBufferImpl);
                        pooledByteBuffer.returnToPool();
                        break block6;
                    }
                    catch (Throwable throwable) {
                        pooledByteBufferImpl.returnToPool();
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    throw new MessageException("Failed to encrypt data", throwable);
                }
            }
            if (this.block_crypto != 1) {
                this.connection.close();
                throw new MessageException("Crypto isn't setup");
            }
            this.connection.send(pooledByteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveContent(PooledByteBuffer pooledByteBuffer) throws MessageException {
        boolean bl = false;
        try {
            Object object;
            Object object2;
            if (this.incoming_cipher != null) {
                try {
                    object2 = pooledByteBuffer.toByteArray();
                    object = this.incoming_cipher.doFinal((byte[])object2);
                    PooledByteBufferImpl pooledByteBufferImpl = new PooledByteBufferImpl((byte[])object);
                    pooledByteBuffer.returnToPool();
                    bl = true;
                    pooledByteBuffer = pooledByteBufferImpl;
                }
                catch (Throwable throwable) {
                    throw new MessageException("Failed to decrypt data", throwable);
                }
            } else if (this.block_crypto != 1) {
                throw new MessageException("Crypto isn't setup");
            }
            object2 = this.listeners.getList();
            object = null;
            for (int i = 0; i < object2.size(); ++i) {
                PooledByteBuffer pooledByteBuffer2 = i == 0 ? pooledByteBuffer : new PooledByteBufferImpl(pooledByteBuffer.toByteArray());
                try {
                    ((GenericMessageConnectionListener)object2.get(i)).receive(this, pooledByteBuffer2);
                    if (pooledByteBuffer2 != pooledByteBuffer) continue;
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {
                    pooledByteBuffer2.returnToPool();
                    if (pooledByteBuffer2 == pooledByteBuffer) {
                        bl = true;
                    }
                    object = throwable instanceof MessageException ? (Object)((MessageException)throwable) : (Object)new MessageException("Failed to process message", throwable);
                }
            }
            if (object != null) {
                throw object;
            }
        }
        finally {
            if (!bl) {
                pooledByteBuffer.returnToPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws MessageException {
        List list = connections;
        synchronized (list) {
            connections.remove(this);
        }
        this.connection.close();
    }

    protected void reportConnected() {
        new AEThread2("SESTSConnection:connected", true){

            @Override
            public void run() {
                List list = SESTSConnectionImpl.this.listeners.getList();
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        ((GenericMessageConnectionListener)list.get(i)).connected(SESTSConnectionImpl.this);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }.start();
    }

    protected void reportFailed(final Throwable throwable) {
        this.setFailed();
        new AEThread2("SESTSConnection:failed", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List list = SESTSConnectionImpl.this.listeners.getList();
                    for (int i = 0; i < list.size(); ++i) {
                        try {
                            ((GenericMessageConnectionListener)list.get(i)).failed(SESTSConnectionImpl.this, throwable);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            Debug.printStackTrace(throwable2);
                        }
                    }
                }
                finally {
                    try {
                        SESTSConnectionImpl.this.close();
                    }
                    catch (Throwable throwable3) {
                        Debug.printStackTrace(throwable3);
                    }
                }
            }
        }.start();
    }

    @Override
    public void addListener(GenericMessageConnectionListener genericMessageConnectionListener) {
        this.listeners.add(genericMessageConnectionListener);
    }

    @Override
    public void removeListener(GenericMessageConnectionListener genericMessageConnectionListener) {
        this.listeners.remove(genericMessageConnectionListener);
    }

    static {
        connections = new ArrayList();
        SimpleTimer.addPeriodicEvent("SESTSConnectionTimer", 15000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent timerEvent2) {
                ArrayList<SESTSConnectionImpl> arrayList = new ArrayList<SESTSConnectionImpl>();
                List list = connections;
                synchronized (list) {
                    for (int i = 0; i < connections.size(); ++i) {
                        SESTSConnectionImpl sESTSConnectionImpl = (SESTSConnectionImpl)connections.get(i);
                        if (sESTSConnectionImpl.crypto_complete.isReleasedForever()) continue;
                        long l = SystemTime.getCurrentTime();
                        if (sESTSConnectionImpl.create_time > l) {
                            sESTSConnectionImpl.create_time = l;
                            continue;
                        }
                        int n = sESTSConnectionImpl.getConnectMethodCount() * 60000;
                        if (l - sESTSConnectionImpl.create_time <= (long)n) continue;
                        arrayList.add(sESTSConnectionImpl);
                    }
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((SESTSConnectionImpl)arrayList.get(i)).reportFailed(new Exception("Timeout during crypto setup"));
                }
            }
        });
        generate_bloom = BloomFilterFactory.createAddRemove4Bit(500);
        generate_bloom_create_time = SystemTime.getCurrentTime();
    }
}

