/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;

public class Test
implements ResourceDownloaderListener,
Plugin {
    @Override
    public void initialize(PluginInterface pluginInterface) {
        try {
            ResourceDownloaderFactory resourceDownloaderFactory = pluginInterface.getUtilities().getResourceDownloaderFactory();
            ResourceDownloader resourceDownloader = resourceDownloaderFactory.create(new URL("http://torrent.vuze.com:88/files/Azureus3009-B5.jar"));
            resourceDownloader.addListener(new ResourceDownloaderAdapter(){

                @Override
                public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
                    System.out.println("complete");
                    return true;
                }

                @Override
                public void reportPercentComplete(ResourceDownloader resourceDownloader, int n) {
                    System.out.println("percentage = " + n);
                }

                @Override
                public void reportAmountComplete(ResourceDownloader resourceDownloader, long l) {
                    System.out.println("amount = " + l);
                }

                @Override
                public void reportActivity(ResourceDownloader resourceDownloader, String string) {
                    System.out.println("activity = " + string);
                }

                @Override
                public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
                    System.out.println("failed");
                    resourceDownloaderException.printStackTrace();
                }
            });
            InputStream inputStream = resourceDownloader.download();
            FileUtil.copyFile(inputStream, new File("C:\\temp\\file.jar"));
            inputStream.close();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    @Override
    public void reportPercentComplete(ResourceDownloader resourceDownloader, int n) {
        System.out.println("percent = " + n);
    }

    @Override
    public void reportAmountComplete(ResourceDownloader resourceDownloader, long l) {
    }

    @Override
    public void reportActivity(ResourceDownloader resourceDownloader, String string) {
        System.out.println("activity = " + string);
    }

    @Override
    public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
        System.out.println("Completed");
        return true;
    }

    @Override
    public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
        System.out.println("Failed");
        Debug.printStackTrace(resourceDownloaderException);
    }

    public static void main(String[] stringArray) {
        try {
            PluginManager.registerPlugin(Test.class);
            PluginManager.startAzureus(0, new Properties());
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }
}

