/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderAlternateImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    protected ResourceDownloader[] delegates;
    protected int max_to_try;
    protected boolean random;
    protected boolean cancelled;
    protected ResourceDownloader current_downloader;
    protected int current_index;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDAlternate");
    protected long size = -2L;

    public ResourceDownloaderAlternateImpl(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl, ResourceDownloader[] resourceDownloaderArray, int n, boolean bl) {
        super(resourceDownloaderBaseImpl);
        this.delegates = resourceDownloaderArray;
        this.max_to_try = n;
        this.random = bl;
        for (int i = 0; i < this.delegates.length; ++i) {
            ((ResourceDownloaderBaseImpl)this.delegates[i]).setParent(this);
        }
        this.max_to_try = this.max_to_try < 0 ? this.delegates.length : Math.min(this.max_to_try, this.delegates.length);
        if (this.random) {
            ArrayList<ResourceDownloader> arrayList = new ArrayList<ResourceDownloader>(Arrays.asList(this.delegates));
            this.delegates = new ResourceDownloader[this.delegates.length];
            for (int i = 0; i < this.delegates.length; ++i) {
                this.delegates[i] = (ResourceDownloader)arrayList.remove((int)(Math.random() * (double)arrayList.size()));
            }
        }
    }

    @Override
    public String getName() {
        String string = "[";
        for (int i = 0; i < this.delegates.length; ++i) {
            string = string + (i == 0 ? "" : ",") + this.delegates[i].getName();
        }
        return string + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() throws ResourceDownloaderException {
        if (this.delegates.length == 0) {
            ResourceDownloaderException resourceDownloaderException = new ResourceDownloaderException(this, "Alternate download fails - 0 alteratives");
            this.informFailed(resourceDownloaderException);
            throw resourceDownloaderException;
        }
        if (this.size != -2L) {
            return this.size;
        }
        try {
            for (int i = 0; i < this.max_to_try; ++i) {
                try {
                    ResourceDownloaderBaseImpl resourceDownloaderBaseImpl = ((ResourceDownloaderBaseImpl)this.delegates[i]).getClone(this);
                    this.addReportListener(resourceDownloaderBaseImpl);
                    this.size = resourceDownloaderBaseImpl.getSize();
                    this.setProperties(resourceDownloaderBaseImpl);
                    break;
                }
                catch (ResourceDownloaderException resourceDownloaderException) {
                    if (i != this.delegates.length - 1) continue;
                    throw resourceDownloaderException;
                }
            }
        }
        finally {
            if (this.size == -2L) {
                this.size = -1L;
            }
            this.setSize(this.size);
        }
        return this.size;
    }

    @Override
    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            for (int i = 0; i < this.delegates.length; ++i) {
                ((ResourceDownloaderBaseImpl)this.delegates[i]).setSize(this.size);
            }
        }
    }

    @Override
    public void setProperty(String string, Object object) throws ResourceDownloaderException {
        this.setPropertySupport(string, object);
        for (int i = 0; i < this.delegates.length; ++i) {
            ((ResourceDownloaderBaseImpl)this.delegates[i]).setProperty(string, object);
        }
    }

    @Override
    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl resourceDownloaderBaseImpl) {
        ResourceDownloader[] resourceDownloaderArray = new ResourceDownloader[this.delegates.length];
        for (int i = 0; i < this.delegates.length; ++i) {
            resourceDownloaderArray[i] = ((ResourceDownloaderBaseImpl)this.delegates[i]).getClone(this);
        }
        ResourceDownloaderAlternateImpl resourceDownloaderAlternateImpl = new ResourceDownloaderAlternateImpl(resourceDownloaderBaseImpl, resourceDownloaderArray, this.max_to_try, this.random);
        resourceDownloaderAlternateImpl.setSize(this.size);
        resourceDownloaderAlternateImpl.setProperties(this);
        return resourceDownloaderAlternateImpl;
    }

    @Override
    public InputStream download() throws ResourceDownloaderException {
        if (this.delegates.length == 0) {
            ResourceDownloaderException resourceDownloaderException = new ResourceDownloaderException(this, "Alternate download fails - 0 alteratives");
            this.informFailed(resourceDownloaderException);
            throw resourceDownloaderException;
        }
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.current_index == this.max_to_try || this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else {
                this.current_downloader = ((ResourceDownloaderBaseImpl)this.delegates[this.current_index]).getClone(this);
                this.informActivity(this.getLogIndent() + "Downloading: " + this.getName());
                ++this.current_index;
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderCancelledException(this);
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
        if (this.informComplete(inputStream)) {
            this.result = inputStream;
            this.done_sem.release();
            return true;
        }
        return false;
    }

    @Override
    public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
        this.result = resourceDownloaderException;
        this.asyncDownload();
    }
}

