/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.plugins.peers.PeerManagerStats;

public class PeerManagerStatsImpl
implements PeerManagerStats {
    protected PEPeerManager manager;
    protected PEPeerManagerStats stats;

    protected PeerManagerStatsImpl(PEPeerManager pEPeerManager) {
        this.manager = pEPeerManager;
        this.stats = this.manager.getStats();
    }

    @Override
    public int getConnectedSeeds() {
        return this.manager.getNbSeeds();
    }

    @Override
    public int getConnectedLeechers() {
        return this.manager.getNbPeers();
    }

    @Override
    public long getDownloaded() {
        return this.stats.getTotalDataBytesReceived();
    }

    @Override
    public long getUploaded() {
        return this.stats.getTotalDataBytesSent();
    }

    @Override
    public long getDownloadAverage() {
        return this.stats.getDataReceiveRate();
    }

    @Override
    public long getUploadAverage() {
        return this.stats.getDataSendRate();
    }

    @Override
    public long getDiscarded() {
        return this.stats.getTotalDiscarded();
    }

    @Override
    public long getHashFailBytes() {
        return this.stats.getTotalHashFailBytes();
    }

    @Override
    public int getPermittedBytesToReceive() {
        return this.stats.getPermittedBytesToReceive();
    }

    @Override
    public void permittedReceiveBytesUsed(int n) {
        this.stats.permittedReceiveBytesUsed(n);
    }

    @Override
    public int getPermittedBytesToSend() {
        return this.stats.getPermittedBytesToSend();
    }

    @Override
    public void permittedSendBytesUsed(int n) {
        this.stats.permittedSendBytesUsed(n);
    }
}

