/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.network;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.TransportCipher;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterStreamCipher;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransport;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransportHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.plugins.messaging.MessageStreamDecoder;
import org.gudy.azureus2.plugins.messaging.MessageStreamEncoder;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.plugins.network.TransportException;
import org.gudy.azureus2.plugins.network.TransportFilter;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageStreamDecoderAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageStreamEncoderAdapter;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.network.TransportCipherImpl;
import org.gudy.azureus2.pluginsimpl.local.network.TransportFilterImpl;
import org.gudy.azureus2.pluginsimpl.local.network.TransportImpl;

public class ConnectionManagerImpl
implements ConnectionManager {
    private static ConnectionManagerImpl instance;
    private AzureusCore azureus_core;

    public static synchronized ConnectionManagerImpl getSingleton(AzureusCore azureusCore) {
        if (instance == null) {
            instance = new ConnectionManagerImpl(azureusCore);
        }
        return instance;
    }

    private ConnectionManagerImpl(AzureusCore azureusCore) {
        this.azureus_core = azureusCore;
    }

    @Override
    public Connection createConnection(InetSocketAddress inetSocketAddress, MessageStreamEncoder messageStreamEncoder, MessageStreamDecoder messageStreamDecoder) {
        ConnectionEndpoint connectionEndpoint = new ConnectionEndpoint(inetSocketAddress);
        connectionEndpoint.addProtocol(new ProtocolEndpointTCP(inetSocketAddress));
        NetworkConnection networkConnection = NetworkManager.getSingleton().createConnection(connectionEndpoint, new MessageStreamEncoderAdapter(messageStreamEncoder), new MessageStreamDecoderAdapter(messageStreamDecoder), false, false, null);
        return new ConnectionImpl(networkConnection, false);
    }

    @Override
    public int getNATStatus() {
        return this.azureus_core.getGlobalManager().getNATStatus();
    }

    @Override
    public org.gudy.azureus2.plugins.network.TransportCipher createTransportCipher(String string, int n, SecretKeySpec secretKeySpec, AlgorithmParameterSpec algorithmParameterSpec) throws TransportException {
        try {
            TransportCipher transportCipher = new TransportCipher(string, n, secretKeySpec, algorithmParameterSpec);
            return new TransportCipherImpl(transportCipher);
        }
        catch (Exception exception) {
            throw new TransportException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TransportFilter createTransportFilter(Connection connection, org.gudy.azureus2.plugins.network.TransportCipher transportCipher, org.gudy.azureus2.plugins.network.TransportCipher transportCipher2) throws TransportException {
        TransportHelper transportHelper;
        TransportHelperFilter transportHelperFilter;
        Transport transport;
        org.gudy.azureus2.plugins.network.Transport transport2 = connection.getTransport();
        try {
            transport = ((TransportImpl)transport2).coreTransport();
        }
        catch (IOException iOException) {
            throw new TransportException(iOException);
        }
        if (transport instanceof TCPTransportImpl) {
            transportHelperFilter = ((TCPTransportImpl)transport).getFilter();
            transportHelper = transportHelperFilter != null ? transportHelperFilter.getHelper() : new TCPTransportHelper(((TCPTransportImpl)transport).getSocketChannel());
        } else {
            if (!(transport instanceof UDPTransport)) throw new TransportException("transport type not supported - " + transport);
            transportHelperFilter = ((UDPTransport)transport).getFilter();
            if (transportHelperFilter != null) {
                transportHelper = transportHelperFilter.getHelper();
            } else {
                transportHelper = ((UDPTransport)transport).getFilter().getHelper();
                InetSocketAddress inetSocketAddress = transport.getTransportEndpoint().getProtocolEndpoint().getConnectionEndpoint().getNotionalAddress();
                if (connection.isIncoming()) throw new TransportException("udp incoming transport type not supported - " + transport);
                try {
                    transportHelper = new UDPTransportHelper(UDPNetworkManager.getSingleton().getConnectionManager(), inetSocketAddress, (UDPTransport)transport);
                }
                catch (IOException iOException) {
                    throw new TransportException(iOException);
                }
            }
        }
        transportHelperFilter = new TransportHelperFilterStreamCipher(transportHelper, ((TransportCipherImpl)transportCipher).cipher, ((TransportCipherImpl)transportCipher2).cipher);
        return new TransportFilterImpl(transportHelperFilter);
    }
}

