/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.config;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.LightHashSet;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.config.PluginConfigSource;

public class PluginConfigSourceImpl
implements COConfigurationListener,
ParameterListener,
PluginConfigSource {
    private PluginConfig plugin_config;
    private File source_file;
    private boolean initialised;
    private Map data_map;
    private String key_prefix = null;
    private boolean dirty = false;
    private boolean migrate_settings = false;
    private LightHashSet params_monitored;

    public PluginConfigSourceImpl(PluginConfig pluginConfig, String string) {
        this.plugin_config = pluginConfig;
        this.key_prefix = null;
        this.initialised = false;
        this.params_monitored = new LightHashSet();
        this.setConfigFilename(string + ".config");
    }

    @Override
    public void initialize() {
        this.shouldBeInitialised(false);
        this.initialised = true;
        this.data_map = FileUtil.readResilientFile(this.source_file.getParentFile(), this.source_file.getName(), true);
        this.key_prefix = this.plugin_config.getPluginConfigKeyPrefix();
        Iterator iterator = this.data_map.entrySet().iterator();
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = this.key_prefix + (String)entry.getKey();
            this.params_monitored.add(string);
            configurationManager.registerTransientParameter(string);
            configurationManager.setParameterRawNoNotify(string, entry.getValue());
            configurationManager.addParameterListener(string, this);
        }
        configurationManager.addListener(this);
    }

    @Override
    public File getConfigFile() {
        return this.source_file;
    }

    @Override
    public void setConfigFilename(String string) {
        this.shouldBeInitialised(false);
        this.source_file = this.plugin_config.getPluginUserFile(FileUtil.convertOSSpecificChars(string, false));
    }

    @Override
    public void save(boolean bl) {
        this.shouldBeInitialised(true);
        if (!bl && !this.dirty) {
            return;
        }
        FileUtil.writeResilientFile(this.source_file.getParentFile(), this.source_file.getName(), this.data_map, true);
        this.dirty = false;
    }

    @Override
    public void configurationSaved() {
        this.save(false);
    }

    @Override
    public void parameterChanged(String string) {
        this.shouldBeInitialised(true);
        String string2 = this.toPluginName(string);
        if (COConfigurationManager.hasParameter(string, true)) {
            Object object = ConfigurationManager.getInstance().getParameter(string);
            this.data_map.put(string2, object);
        } else {
            this.data_map.remove(string2);
        }
        this.dirty = true;
    }

    public void registerParameter(String string) {
        this.shouldBeInitialised(true);
        if (!this.params_monitored.add(string)) {
            return;
        }
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        configurationManager.registerTransientParameter(string);
        configurationManager.addParameterListener(string, this);
        if (this.migrate_settings && COConfigurationManager.hasParameter(string, true)) {
            this.parameterChanged(string);
        }
    }

    public String getUsedKeyPrefix() {
        return this.key_prefix;
    }

    private String toPluginName(String string) {
        if (!string.startsWith(this.key_prefix)) {
            throw new RuntimeException("mismatch key prefix: " + string + ", " + this.key_prefix);
        }
        return string.substring(this.key_prefix.length());
    }

    private void shouldBeInitialised(boolean bl) {
        if (bl && !this.initialised) {
            throw new RuntimeException("source not yet initialised");
        }
        if (!bl && this.initialised) {
            throw new RuntimeException("source already initialised");
        }
    }

    @Override
    public void forceSettingsMigration() {
        this.shouldBeInitialised(false);
        this.migrate_settings = true;
    }
}

