/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.unix;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.net.InetAddress;
import java.util.HashSet;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class PlatformManagerImpl
implements PlatformManager {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String ERR_UNSUPPORTED = "Unsupported capability called on platform manager";
    protected static PlatformManagerImpl singleton;
    protected static AEMonitor class_mon;
    private final HashSet capabilitySet = new HashSet();
    private static final Object migrate_lock;

    public static PlatformManagerImpl getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSingleton() {
        try {
            class_mon.enter();
            singleton = new PlatformManagerImpl();
        }
        catch (Throwable throwable) {
            Logger.log(new LogEvent(LOGID, "Failed to initialize platform manager for Unix Compatable OS", throwable));
        }
        finally {
            class_mon.exit();
        }
    }

    public PlatformManagerImpl() {
        this.capabilitySet.add(PlatformManagerCapabilities.GetUserDataDirectory);
    }

    @Override
    public void copyFilePermissions(String string, String string2) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void createProcess(String string, boolean bl) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getApplicationCommandLine() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public int getPlatformType() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserDataDirectory() throws PlatformManagerException {
        String string = System.getProperty("user.home");
        String string2 = string + SystemProperties.SEP + "." + SystemProperties.APPLICATION_NAME.toLowerCase() + SystemProperties.SEP;
        Object object = migrate_lock;
        synchronized (object) {
            String string3;
            File file;
            File file2 = new File(string2);
            if (!file2.exists() && (file = new File(string3 = string + SystemProperties.SEP + "." + SystemProperties.APPLICATION_NAME + SystemProperties.SEP)).exists()) {
                String string4 = "Migrating unix user config dir [" + string3 + "] ===> [" + string2 + "]";
                System.out.println(string4);
                Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Unix): " + string4));
                try {
                    file.renameTo(file2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Logger.log(new LogEvent(LOGID, "migration rename failed:", throwable));
                }
            }
        }
        return string2;
    }

    @Override
    public String getComputerName() {
        String string = System.getenv("HOST");
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    @Override
    public String getVersion() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public boolean hasCapability(PlatformManagerCapabilities platformManagerCapabilities) {
        return this.capabilitySet.contains(platformManagerCapabilities);
    }

    @Override
    public boolean isApplicationRegistered() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void performRecoverableFileDelete(String string) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void ping(InetAddress inetAddress, InetAddress inetAddress2, PlatformManagerPingCallback platformManagerPingCallback) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void registerApplication() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void addListener(PlatformManagerListener platformManagerListener) {
    }

    @Override
    public void removeListener(PlatformManagerListener platformManagerListener) {
    }

    @Override
    public File getVMOptionFile() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public String[] getExplicitVMOptions() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void setExplicitVMOptions(String[] stringArray) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public boolean getRunAtLogin() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void setRunAtLogin(boolean bl) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void startup(AzureusCore azureusCore) throws PlatformManagerException {
    }

    @Override
    public int getShutdownTypes() {
        return 0;
    }

    @Override
    public void shutdown(int n) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void setTCPTOSEnabled(boolean bl) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public boolean testNativeAvailability(String string) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void traceRoute(InetAddress inetAddress, InetAddress inetAddress2, PlatformManagerPingCallback platformManagerPingCallback) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public File getLocation(long l) throws PlatformManagerException {
        switch ((int)l) {
            case 1: {
                return new File(this.getUserDataDirectory());
            }
            case 3: {
                return new File(System.getProperty("user.home"));
            }
        }
        return null;
    }

    @Override
    public boolean isAdditionalFileTypeRegistered(String string, String string2) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void registerAdditionalFileType(String string, String string2, String string3, String string4) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void showFile(String string) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void unregisterAdditionalFileType(String string, String string2) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    public String getAzComputerID() throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    @Override
    public void requestUserAttention(int n, Object object) throws PlatformManagerException {
        throw new PlatformManagerException(ERR_UNSUPPORTED);
    }

    static {
        class_mon = new AEMonitor("PlatformManager");
        migrate_lock = new Object();
        PlatformManagerImpl.initializeSingleton();
    }
}

