/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.xml.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class XMLElement {
    protected Object single_content = null;
    protected Map attributes = null;
    protected Collection contents = null;
    protected String tag_name;
    protected boolean auto_order;
    private static Comparator ATTRIBUTE_COMPARATOR = String.CASE_INSENSITIVE_ORDER;
    private static Comparator CONTENT_COMPARATOR = new ContentComparator();

    public XMLElement(String string) {
        this(string, false);
    }

    public XMLElement(String string, boolean bl) {
        this.tag_name = string;
        this.auto_order = bl;
    }

    public String getTag() {
        return this.tag_name;
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(string);
    }

    public void addAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new TreeMap(ATTRIBUTE_COMPARATOR);
        }
        this.attributes.put(string, string2);
    }

    public void addAttribute(String string, int n) {
        this.addAttribute(string, String.valueOf(n));
    }

    public void addAttribute(String string, boolean bl) {
        this.addAttribute(string, bl ? "yes" : "no");
    }

    public void addContent(String string) {
        this.addContent((Object)string);
    }

    public void addContent(XMLElement xMLElement) {
        this.addContent((Object)xMLElement);
    }

    protected void addContent(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.contents == null && this.single_content != null) {
            this.contents = !this.auto_order ? new ArrayList() : new TreeSet(CONTENT_COMPARATOR);
            this.contents.add(this.single_content);
            this.single_content = null;
        }
        if (this.contents == null) {
            this.single_content = object;
        } else {
            this.contents.add(object);
        }
    }

    public void printTo(PrintWriter printWriter) {
        this.printTo(printWriter, 0, false);
    }

    public void printTo(PrintWriter printWriter, boolean bl) {
        this.printTo(printWriter, 0, bl);
    }

    public void printTo(PrintWriter printWriter, int n) {
        this.printTo(printWriter, n, false);
    }

    public void printTo(PrintWriter printWriter, int n, boolean bl) {
        int n2;
        for (int i = 0; i < n; ++i) {
            printWriter.print(" ");
        }
        if (this.attributes == null && this.contents == null && this.single_content == null) {
            if (!bl) {
                printWriter.print("<");
                printWriter.print(this.tag_name);
                printWriter.print(" />");
            }
            return;
        }
        printWriter.print("<");
        printWriter.print(this.tag_name);
        Iterator<Object> iterator = null;
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                printWriter.print(" ");
                printWriter.print(entry.getKey());
                printWriter.print("=\"");
                printWriter.print(this.quote((String)entry.getValue()));
                printWriter.print("\"");
            }
        }
        boolean bl2 = this.contents != null || this.single_content instanceof XMLElement;
        boolean bl3 = bl2 || this.single_content != null;
        bl2 = bl2 || bl;
        boolean bl4 = bl3 = bl3 || bl;
        if (bl2) {
            printWriter.println(">");
        } else if (bl3) {
            printWriter.print(">");
        } else {
            printWriter.print(" />");
        }
        iterator = null;
        iterator = this.contents != null ? this.contents.iterator() : (this.single_content != null ? Collections.singletonList(this.single_content).iterator() : Collections.singletonList("").iterator());
        Object object = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object instanceof XMLElement) {
                    ((XMLElement)object).printTo(printWriter, n + 2, bl);
                    continue;
                }
                if (bl) {
                    for (n2 = 0; n2 < n + 2; ++n2) {
                        printWriter.print(" ");
                    }
                    printWriter.print(this.quote((String)object));
                    printWriter.println();
                    continue;
                }
                printWriter.print(this.quote((String)object));
            }
        }
        if (bl2) {
            for (n2 = 0; n2 < n; ++n2) {
                printWriter.print(" ");
            }
        }
        if (bl3) {
            printWriter.print("</");
            printWriter.print(this.tag_name);
            printWriter.println(">");
        }
    }

    private String quote(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("--", "&#45;&#45;");
        return string;
    }

    public XMLElement makeContent(String string) {
        return this.makeContent(string, false);
    }

    public XMLElement makeContent(String string, boolean bl) {
        XMLElement xMLElement = new XMLElement(string, bl);
        this.addContent(xMLElement);
        return xMLElement;
    }

    public void clear() {
        this.single_content = null;
        this.attributes = null;
        this.contents = null;
    }

    public void setAutoOrdering(boolean bl) {
        if (bl == this.auto_order) {
            return;
        }
        this.auto_order = bl;
        if (this.contents == null) {
            return;
        }
        Collection collection = this.contents;
        if (this.auto_order) {
            this.contents = new TreeSet(CONTENT_COMPARATOR);
            this.contents.addAll(collection);
        } else {
            this.contents = new ArrayList(collection);
        }
    }

    public String toString() {
        return "XMLElement[" + this.tag_name + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private static class ContentComparator
    implements Comparator {
        private ContentComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof XMLElement) {
                if (object2 instanceof XMLElement) {
                    XMLElement xMLElement = (XMLElement)object;
                    XMLElement xMLElement2 = (XMLElement)object2;
                    int n = String.CASE_INSENSITIVE_ORDER.compare(xMLElement.getTag(), xMLElement2.getTag());
                    if (n == 0) {
                        int n2 = 0;
                        int n3 = 0;
                        try {
                            n2 = Integer.parseInt(xMLElement.getAttribute("index"));
                            n3 = Integer.parseInt(xMLElement2.getAttribute("index"));
                        }
                        catch (NullPointerException nullPointerException) {
                            n3 = 0;
                            n2 = 0;
                        }
                        catch (NumberFormatException numberFormatException) {
                            n3 = 0;
                            n2 = 0;
                        }
                        if (n2 != n3) {
                            return n2 - n3;
                        }
                        throw new RuntimeException("Shouldn't be using sorting for contents if you have tags with same name and no index attribute! (e.g. " + object + ")");
                    }
                    return n;
                }
                return -1;
            }
            if (object2 instanceof XMLElement) {
                return 1;
            }
            int n = String.CASE_INSENSITIVE_ORDER.compare((String)object, (String)object2);
            if (n == 0) {
                return -1;
            }
            return n;
        }
    }
}

