/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class Timer
extends AERunnable
implements SystemTime.ChangeListener {
    private static boolean DEBUG_TIMERS = true;
    private static ArrayList timers = null;
    private static AEMonitor timers_mon = new AEMonitor("timers list");
    private ThreadPool thread_pool;
    private Set events = new TreeSet();
    private long unique_id_next = 0L;
    private volatile boolean destroyed;
    private boolean indestructable;
    private boolean log;
    private int max_events_logged;

    public Timer(String string) {
        this(string, 1);
    }

    public Timer(String string, int n) {
        this(string, n, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer(String string, int n, int n2) {
        if (DEBUG_TIMERS) {
            try {
                timers_mon.enter();
                if (timers == null) {
                    timers = new ArrayList();
                    AEDiagnostics.addEvidenceGenerator(new evidenceGenerator());
                }
                timers.add(new WeakReference<Timer>(this));
            }
            finally {
                timers_mon.exit();
            }
        }
        this.thread_pool = new ThreadPool(string, n);
        SystemTime.registerClockChangeListener(this);
        Thread thread = new Thread((Runnable)this, "Timer:" + string);
        thread.setDaemon(true);
        thread.setPriority(n2);
        thread.start();
    }

    public void setIndestructable() {
        this.indestructable = true;
    }

    public synchronized List getEvents() {
        return new ArrayList(this.events);
    }

    public void setLogging(boolean bl) {
        this.log = bl;
    }

    public boolean getLogging() {
        return this.log;
    }

    public void setWarnWhenFull() {
        this.thread_pool.setWarnWhenFull();
    }

    public void setLogCPU() {
        this.thread_pool.setLogCPU();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSupport() {
        block5: while (true) {
            try {
                while (true) {
                    TimerEvent timerEvent2 = null;
                    Timer timer = this;
                    synchronized (timer) {
                        Object object;
                        long l;
                        if (this.destroyed) {
                            break block5;
                        }
                        if (this.events.isEmpty()) {
                            this.wait();
                        } else {
                            l = SystemTime.getCurrentTime();
                            object = (TimerEvent)this.events.iterator().next();
                            long l2 = ((TimerEvent)object).getWhen() - l;
                            if (l2 > 0L) {
                                this.wait(l2);
                            }
                        }
                        if (this.destroyed) {
                            break block5;
                        }
                        l = SystemTime.getCurrentTime();
                        object = this.events.iterator();
                        while (object.hasNext()) {
                            TimerEvent timerEvent3 = (TimerEvent)object.next();
                            if (timerEvent3.getWhen() > l) continue;
                            timerEvent2 = timerEvent3;
                            object.remove();
                            break;
                        }
                    }
                    if (timerEvent2 == null) continue;
                    timerEvent2.setHasRun();
                    if (this.log) {
                        System.out.println("running: " + timerEvent2.getString());
                    }
                    this.thread_pool.run(timerEvent2.getRunnable());
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clockChanged(long l, long l2) {
        if (Math.abs(l2) >= 60000L) {
            Timer timer = this;
            synchronized (timer) {
                boolean bl = false;
                for (TimerEvent timerEvent2 : this.events) {
                    TimerEventPeriodic timerEventPeriodic;
                    long l3;
                    if (timerEvent2.isAbsolute()) {
                        bl = true;
                        continue;
                    }
                    long l4 = timerEvent2.getWhen();
                    long l5 = l4 + l2;
                    TimerEventPerformer timerEventPerformer = timerEvent2.getPerformer();
                    if (timerEventPerformer instanceof TimerEventPeriodic && l5 > l + (l3 = (timerEventPeriodic = (TimerEventPeriodic)timerEventPerformer).getFrequency()) + 5000L) {
                        long l6 = l + l3;
                        Debug.outNoStack(timerEventPeriodic.getName() + ": clock change sanity check. Reduced schedule time from " + l5 + " to " + l6);
                        l5 = l6;
                    }
                    if (l4 > 0L && l5 < 0L && l2 > 0L) continue;
                    timerEvent2.setWhen(l5);
                }
                if (bl) {
                    this.events = new TreeSet(this.events);
                }
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustAllBy(long l) {
        Timer timer = this;
        synchronized (timer) {
            for (TimerEvent timerEvent2 : this.events) {
                long l2 = timerEvent2.getWhen();
                long l3 = l2 + l;
                if (l2 > 0L && l3 < 0L && l > 0L) continue;
                timerEvent2.setWhen(l3);
            }
            this.notify();
        }
    }

    public synchronized TimerEvent addEvent(long l, TimerEventPerformer timerEventPerformer) {
        return this.addEvent(SystemTime.getCurrentTime(), l, timerEventPerformer);
    }

    public synchronized TimerEvent addEvent(String string, long l, TimerEventPerformer timerEventPerformer) {
        return this.addEvent(string, SystemTime.getCurrentTime(), l, timerEventPerformer);
    }

    public synchronized TimerEvent addEvent(String string, long l, boolean bl, TimerEventPerformer timerEventPerformer) {
        return this.addEvent(string, SystemTime.getCurrentTime(), l, bl, timerEventPerformer);
    }

    public synchronized TimerEvent addEvent(long l, long l2, TimerEventPerformer timerEventPerformer) {
        return this.addEvent(null, l, l2, timerEventPerformer);
    }

    public synchronized TimerEvent addEvent(long l, long l2, boolean bl, TimerEventPerformer timerEventPerformer) {
        return this.addEvent(null, l, l2, bl, timerEventPerformer);
    }

    public synchronized TimerEvent addEvent(String string, long l, long l2, TimerEventPerformer timerEventPerformer) {
        return this.addEvent(string, l, l2, false, timerEventPerformer);
    }

    public synchronized TimerEvent addEvent(String string, long l, long l2, boolean bl, TimerEventPerformer timerEventPerformer) {
        TimerEvent timerEvent2 = new TimerEvent(this, this.unique_id_next++, l, l2, bl, timerEventPerformer);
        if (string != null) {
            timerEvent2.setName(string);
        }
        this.events.add(timerEvent2);
        if (this.log && this.events.size() > this.max_events_logged) {
            this.max_events_logged = this.events.size();
            System.out.println("Timer '" + this.thread_pool.getName() + "' - events = " + this.max_events_logged);
        }
        this.notify();
        return timerEvent2;
    }

    public synchronized TimerEventPeriodic addPeriodicEvent(long l, TimerEventPerformer timerEventPerformer) {
        return this.addPeriodicEvent(null, l, timerEventPerformer);
    }

    public synchronized TimerEventPeriodic addPeriodicEvent(String string, long l, TimerEventPerformer timerEventPerformer) {
        return this.addPeriodicEvent(string, l, false, timerEventPerformer);
    }

    public synchronized TimerEventPeriodic addPeriodicEvent(String string, long l, boolean bl, TimerEventPerformer timerEventPerformer) {
        TimerEventPeriodic timerEventPeriodic = new TimerEventPeriodic(this, l, bl, timerEventPerformer);
        if (string != null) {
            timerEventPeriodic.setName(string);
        }
        if (this.log) {
            System.out.println("Timer '" + this.thread_pool.getName() + "' - added " + timerEventPeriodic.getString());
        }
        return timerEventPeriodic;
    }

    protected synchronized void cancelEvent(TimerEvent timerEvent2) {
        if (this.events.contains(timerEvent2)) {
            this.events.remove(timerEvent2);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.indestructable) {
            Debug.out("Attempt to destroy indestructable timer '" + this.getName() + "'");
        } else {
            this.destroyed = true;
            this.notify();
            SystemTime.unregisterClockChangeListener(this);
        }
        if (DEBUG_TIMERS) {
            try {
                timers_mon.enter();
                Iterator iterator = timers.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    Object t = weakReference.get();
                    if (t != null && t != this) continue;
                    iterator.remove();
                }
            }
            finally {
                timers_mon.exit();
            }
        }
    }

    public String getName() {
        return this.thread_pool.getName();
    }

    public synchronized void dump() {
        System.out.println("Timer '" + this.thread_pool.getName() + "': dump");
        for (TimerEvent timerEvent2 : this.events) {
            System.out.println("\t" + timerEvent2.getString());
        }
    }

    private class evidenceGenerator
    implements AEDiagnosticsEvidenceGenerator {
        private evidenceGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void generate(IndentWriter indentWriter) {
            if (!DEBUG_TIMERS) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            try {
                try {
                    timers_mon.enter();
                    Iterator iterator = timers.iterator();
                    while (iterator.hasNext()) {
                        WeakReference object = (WeakReference)iterator.next();
                        Timer timer = (Timer)object.get();
                        if (timer == null) {
                            iterator.remove();
                            continue;
                        }
                        ++n;
                        List list = timer.getEvents();
                        arrayList.add(timer.thread_pool.getName() + ", " + list.size() + " events:");
                        for (TimerEvent timerEvent2 : list) {
                            arrayList.add("  " + timerEvent2.getString());
                        }
                    }
                }
                finally {
                    timers_mon.exit();
                }
                indentWriter.println("Timers: " + n);
                indentWriter.indent();
                for (String string : arrayList) {
                    indentWriter.println(string);
                }
                indentWriter.exdent();
            }
            catch (Throwable throwable) {
                indentWriter.println(throwable.toString());
            }
        }
    }
}

