/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader.impl;

import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloaderImpl;

public class TorrentDownloaderManager
implements TorrentDownloaderCallBackInterface {
    private static TorrentDownloaderManager man = null;
    private boolean logged = false;
    private boolean autostart = false;
    private GlobalManager gm = null;
    private String downloaddir;
    private ArrayList running = new ArrayList();
    private ArrayList queued = new ArrayList();
    private ArrayList errors = new ArrayList();

    public TorrentDownloaderManager() {
        try {
            this.downloaddir = COConfigurationManager.getDirectoryParameter("Default save path");
        }
        catch (Exception exception) {
            this.downloaddir = null;
        }
    }

    public static TorrentDownloaderManager getInstance() {
        if (man == null) {
            man = new TorrentDownloaderManager();
        }
        return man;
    }

    public void init(GlobalManager globalManager, boolean bl, boolean bl2, String string) {
        this.gm = globalManager;
        this.logged = bl;
        this.autostart = bl2;
        if (string != null) {
            this.downloaddir = string;
        }
    }

    public TorrentDownloader add(TorrentDownloader torrentDownloader) {
        if (torrentDownloader.getDownloadState() == 4) {
            this.errors.add(torrentDownloader);
        } else if (this.running.contains(torrentDownloader) || this.queued.contains(torrentDownloader)) {
            ((TorrentDownloaderImpl)torrentDownloader).setDownloadState(5);
            ((TorrentDownloaderImpl)torrentDownloader).notifyListener();
            this.errors.add(torrentDownloader);
        } else if (this.autostart) {
            torrentDownloader.start();
        } else {
            this.queued.add(torrentDownloader);
        }
        return torrentDownloader;
    }

    public TorrentDownloader download(String string, String string2, boolean bl) {
        return this.add(TorrentDownloaderFactory.create((TorrentDownloaderCallBackInterface)this, string, null, string2, bl));
    }

    public TorrentDownloader download(String string, boolean bl) {
        return this.add(TorrentDownloaderFactory.create((TorrentDownloaderCallBackInterface)this, string, null, null, bl));
    }

    public TorrentDownloader download(String string, String string2) {
        return this.add(TorrentDownloaderFactory.create((TorrentDownloaderCallBackInterface)this, string, null, string2, this.logged));
    }

    public TorrentDownloader download(String string) {
        return this.add(TorrentDownloaderFactory.create(this, string, this.logged));
    }

    @Override
    public void TorrentDownloaderEvent(int n, TorrentDownloader torrentDownloader) {
        switch (n) {
            case 1: {
                if (this.queued.contains(torrentDownloader)) {
                    this.queued.remove(torrentDownloader);
                }
                if (this.running.contains(torrentDownloader)) break;
                this.running.add(torrentDownloader);
                break;
            }
            case 3: {
                this.remove(torrentDownloader);
                if (this.gm == null || this.downloaddir == null) break;
                this.gm.addDownloadManager(torrentDownloader.getFile().getAbsolutePath(), this.downloaddir);
                break;
            }
            case 4: {
                this.remove(torrentDownloader);
                this.errors.add(torrentDownloader);
            }
        }
    }

    public void remove(TorrentDownloader torrentDownloader) {
        if (this.running.contains(torrentDownloader)) {
            this.running.remove(torrentDownloader);
        }
        if (this.queued.contains(torrentDownloader)) {
            this.queued.remove(torrentDownloader);
        }
    }
}

