/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.net.UnknownHostException;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;

public class IpRangeImpl
implements IpRange {
    private static final byte FLAG_SESSION_ONLY = 1;
    private static final byte FLAG_ADDED_TO_RANGE_LIST = 2;
    private static final byte FLAG_INVALID_START = 8;
    private static final byte FLAG_INVALID_END = 16;
    private static final byte FLAG_INVALID = 24;
    private int ipStart;
    private int ipEnd;
    private byte flags;
    private Object descRef = null;
    private static final byte FLAG_MERGED = 4;
    private int merged_end;
    private IpRange[] my_merged_entries;

    public IpRangeImpl(String string, String string2, String string3, boolean bl) {
        if (bl) {
            this.flags = 1;
        }
        if (string2 == null || string3 == null) {
            throw new RuntimeException("Invalid start/end values - null not supported");
        }
        try {
            this.ipStart = PRHelpers.addressToInt(string2);
        }
        catch (UnknownHostException unknownHostException) {
            this.flags = (byte)(this.flags | 8);
        }
        try {
            this.ipEnd = PRHelpers.addressToInt(string3);
        }
        catch (UnknownHostException unknownHostException) {
            this.flags = (byte)(this.flags | 0x10);
        }
        if (string != "") {
            this.setDescription(string);
        }
        this.checkValid();
    }

    public IpRangeImpl(String string, int n, int n2, boolean bl) {
        if (bl) {
            this.flags = 1;
        }
        this.ipStart = n;
        this.ipEnd = n2;
        if (string != "") {
            this.setDescription(string);
        }
        this.checkValid();
    }

    @Override
    public void checkValid() {
        ((IpFilterImpl)IpFilterImpl.getInstance()).setValidOrNot(this, this.isValid());
    }

    @Override
    public boolean isValid() {
        if ((this.flags & 0x18) > 0) {
            return false;
        }
        long l = this.ipStart;
        long l2 = this.ipEnd;
        if (l < 0L) {
            l += 0x100000000L;
        }
        if (l2 < 0L) {
            l2 += 0x100000000L;
        }
        return l2 >= l;
    }

    @Override
    public boolean isInRange(String string) {
        if (!this.isValid()) {
            return false;
        }
        try {
            long l = PRHelpers.addressToInt(string);
            if (l < 0L) {
                l += 0x100000000L;
            }
            long l2 = this.ipStart;
            long l3 = this.ipEnd;
            if (l2 < 0L) {
                l2 += 0x100000000L;
            }
            if (l3 < 0L) {
                l3 += 0x100000000L;
            }
            return l >= l2 && l <= l3;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    @Override
    public String getDescription() {
        return new String(IpFilterManagerFactory.getSingleton().getDescription(this.descRef));
    }

    @Override
    public void setDescription(String string) {
        this.descRef = IpFilterManagerFactory.getSingleton().addDescription(this, string.getBytes());
    }

    @Override
    public String getStartIp() {
        return (this.flags & 8) > 0 ? "" : PRHelpers.intToAddress(this.ipStart);
    }

    @Override
    public long getStartIpLong() {
        if ((this.flags & 8) > 0) {
            return -1L;
        }
        long l = this.ipStart;
        if (l < 0L) {
            l += 0x100000000L;
        }
        return l;
    }

    @Override
    public void setStartIp(String string) {
        if (string == null) {
            throw new RuntimeException("Invalid start value - null not supported");
        }
        if (string.equals(this.getStartIp())) {
            return;
        }
        this.flags = (byte)(this.flags & 0xFFFFFFF7);
        try {
            this.ipStart = PRHelpers.addressToInt(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.flags = (byte)(this.flags | 8);
        }
        if ((this.flags & 0x18) == 0) {
            this.checkValid();
        }
    }

    @Override
    public String getEndIp() {
        return (this.flags & 0x10) > 0 ? "" : PRHelpers.intToAddress(this.ipEnd);
    }

    @Override
    public long getEndIpLong() {
        if ((this.flags & 0x10) > 0) {
            return -1L;
        }
        long l = this.ipEnd;
        if (l < 0L) {
            l += 0x100000000L;
        }
        return l;
    }

    @Override
    public void setEndIp(String string) {
        if (string == null) {
            throw new RuntimeException("Invalid end value - null not supported");
        }
        if (string.equals(this.getEndIp())) {
            return;
        }
        this.flags = (byte)(this.flags & 0xFFFFFFEF);
        try {
            this.ipEnd = PRHelpers.addressToInt(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.flags = (byte)(this.flags | 0x10);
        }
        if ((this.flags & 0x18) == 0) {
            this.checkValid();
        }
    }

    public String toString() {
        return this.getDescription() + " : " + this.getStartIp() + " - " + this.getEndIp();
    }

    @Override
    public boolean isSessionOnly() {
        return (this.flags & 1) != 0;
    }

    @Override
    public void setSessionOnly(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    @Override
    public int compareStartIpTo(IpRange ipRange) {
        long l = this.getStartIpLong() - ((IpRangeImpl)ipRange).getStartIpLong();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareEndIpTo(IpRange ipRange) {
        long l = this.getEndIpLong() - ((IpRangeImpl)ipRange).getEndIpLong();
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }

    protected void setAddedToRangeList(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    @Override
    public boolean getAddedToRangeList() {
        return (this.flags & 2) != 0;
    }

    @Override
    public int compareDescription(IpRange ipRange) {
        return this.getDescription().compareTo(ipRange.getDescription());
    }

    protected Object getDescRef() {
        return this.descRef;
    }

    protected void setDescRef(Object object) {
        this.descRef = object;
    }

    @Override
    public long getMergedEndLong() {
        return this.merged_end < 0 ? (long)this.merged_end + 0x100000000L : (long)this.merged_end;
    }

    @Override
    public IpRange[] getMergedEntries() {
        return this.my_merged_entries;
    }

    @Override
    public void resetMergeInfo() {
        this.flags = (byte)(this.flags & 0xFFFFFFFB);
        if ((this.flags & 0x10) == 0) {
            this.merged_end = this.ipEnd;
        }
    }

    @Override
    public boolean getMerged() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void setMerged() {
        this.flags = (byte)(this.flags | 4);
    }

    @Override
    public void setMergedEnd(long l) {
        this.merged_end = (int)(l >= 0x100000000L ? l - 0x100000000L : l);
    }

    @Override
    public void addMergedEntry(IpRange ipRange) {
        if (this.my_merged_entries == null) {
            this.my_merged_entries = new IpRange[]{ipRange};
        } else {
            IpRange[] ipRangeArray = new IpRange[this.my_merged_entries.length + 1];
            System.arraycopy(this.my_merged_entries, 0, ipRangeArray, 0, this.my_merged_entries.length);
            ipRangeArray[ipRangeArray.length - 1] = ipRange;
            this.my_merged_entries = ipRangeArray;
        }
    }
}

