/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.File;
import java.io.UnsupportedEncodingException;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class LocaleUtilDecoderFallback
implements LocaleUtilDecoder {
    public static String NAME = "Fallback";
    private static volatile int max_ok_name_length = 64;
    private static volatile boolean max_ok_name_length_determined;
    private static final String VALID_CHARS = "abcdefghijklmnopqrstuvwxyz1234567890_-.";
    private int index;

    protected LocaleUtilDecoderFallback(int n) {
        this.index = n;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String tryDecode(byte[] byArray, boolean bl) {
        return this.decode(byArray);
    }

    @Override
    public String decodeString(byte[] byArray) throws UnsupportedEncodingException {
        return this.decode(byArray);
    }

    protected String decode(byte[] byArray) {
        int n;
        int n2;
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n = byArray[n2];
            if (VALID_CHARS.indexOf(Character.toLowerCase((char)n)) != -1) {
                stringBuffer.append((char)n);
                continue;
            }
            stringBuffer.append("_");
            stringBuffer.append(ByteFormatter.nicePrint((byte)n));
        }
        n2 = stringBuffer.length();
        if (n2 > max_ok_name_length) {
            if (!max_ok_name_length_determined && this.fileLengthOK(n2)) {
                max_ok_name_length = n2;
            } else {
                if (!max_ok_name_length_determined) {
                    n = max_ok_name_length + 16;
                    while (n < n2 && this.fileLengthOK(n)) {
                        max_ok_name_length = n;
                        n += 16;
                    }
                    max_ok_name_length_determined = true;
                }
                String string = null;
                int n3 = stringBuffer.lastIndexOf(".");
                if (n3 != -1 && ((string = stringBuffer.substring(n3)).length() == 1 || string.length() > 4)) {
                    string = null;
                }
                byte[] byArray2 = new SHA1Hasher().calculateHash(byArray);
                String string2 = ByteFormatter.nicePrint(byArray2, true);
                stringBuffer = new StringBuffer(stringBuffer.substring(0, max_ok_name_length - string2.length() - (string == null ? 0 : string.length())));
                stringBuffer.append(string2);
                if (string != null) {
                    stringBuffer.append(string);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected boolean fileLengthOK(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("A");
        }
        try {
            File file = File.createTempFile(stringBuffer.toString(), "");
            file.delete();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

