/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerRequest;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class DiskManagerRequestImpl
implements DiskManagerRequest {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static boolean DEBUG;
    private static int next_id;
    private long start_time;
    private String name;

    protected abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStarts() {
        if (DEBUG) {
            try {
                Class<DiskManagerRequestImpl> clazz = DiskManagerRequestImpl.class;
                synchronized (DiskManagerRequestImpl.class) {
                    int n = next_id++;
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    this.name = this.getName() + " [" + n + "]";
                    this.start_time = SystemTime.getCurrentTime();
                    Logger.log(new LogEvent(LOGID, "DMRequest start: " + this.name));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void requestEnds(boolean bl) {
        if (DEBUG) {
            try {
                Logger.log(new LogEvent(LOGID, "DMRequest end: " + this.name + ",ok=" + bl + ", time=" + (SystemTime.getCurrentTime() - this.start_time)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener("diskmanager.request.debug.enable", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                DEBUG = COConfigurationManager.getBooleanParameter(string, false);
            }
        });
    }
}

