/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckInstance;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.impl.DiskManagerCheckRequestImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ConcurrentHasher;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequest;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequestListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;

public class DMCheckerImpl
implements DMChecker {
    protected static final LogIDs LOGID = LogIDs.DISK;
    private static boolean flush_pieces;
    private static boolean checking_read_priority;
    private static AEMonitor class_mon;
    private static List async_check_queue;
    private static AESemaphore async_check_queue_sem;
    private static boolean fully_async;
    protected DiskManagerHelper disk_manager;
    protected int async_checks;
    protected AESemaphore async_check_sem = new AESemaphore("DMChecker::asyncCheck");
    protected int async_reads;
    protected AESemaphore async_read_sem = new AESemaphore("DMChecker::asyncRead");
    private boolean started;
    protected volatile boolean stopped;
    private volatile boolean complete_recheck_in_progress;
    private volatile int complete_recheck_progress;
    private boolean checking_enabled = true;
    protected AEMonitor this_mon = new AEMonitor("DMChecker");

    public DMCheckerImpl(DiskManagerHelper diskManagerHelper) {
        this.disk_manager = diskManagerHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("DMChecker: start while started");
            }
            if (this.stopped) {
                throw new RuntimeException("DMChecker: start after stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        long l;
        int n;
        int n2;
        int n3;
        try {
            this.this_mon.enter();
            if (this.stopped || !this.started) {
                return;
            }
            this.stopped = true;
            n3 = this.async_reads;
            n2 = this.async_checks;
        }
        finally {
            this.this_mon.exit();
        }
        long l2 = SystemTime.getCurrentTime();
        for (n = 0; n < n3; ++n) {
            l = SystemTime.getCurrentTime();
            if (l < l2) {
                l2 = l;
            } else if (l - l2 > 1000L) {
                l2 = l;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for check-reads to complete - " + (n3 - n) + " remaining"));
                }
            }
            this.async_read_sem.reserve();
        }
        l2 = SystemTime.getCurrentTime();
        for (n = 0; n < n2; ++n) {
            l = SystemTime.getCurrentTime();
            if (l < l2) {
                l2 = l;
            } else if (l - l2 > 1000L) {
                l2 = l;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for checks to complete - " + (n3 - n) + " remaining"));
                }
            }
            this.async_check_sem.reserve();
        }
    }

    @Override
    public int getCompleteRecheckStatus() {
        if (this.complete_recheck_in_progress) {
            return this.complete_recheck_progress;
        }
        return -1;
    }

    @Override
    public void setCheckingEnabled(boolean bl) {
        this.checking_enabled = bl;
    }

    @Override
    public DiskManagerCheckRequest createCheckRequest(int n, Object object) {
        return new DiskManagerCheckRequestImpl(n, object);
    }

    @Override
    public void enqueueCompleteRecheckRequest(final DiskManagerCheckRequest diskManagerCheckRequest, final DiskManagerCheckRequestListener diskManagerCheckRequestListener) {
        if (!this.checking_enabled) {
            diskManagerCheckRequestListener.checkCompleted(diskManagerCheckRequest, true);
            return;
        }
        this.complete_recheck_progress = 0;
        this.complete_recheck_in_progress = true;
        new AEThread2("DMChecker::completeRecheck", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DiskManagerRecheckInstance diskManagerRecheckInstance = DMCheckerImpl.this.disk_manager.getRecheckScheduler().register(DMCheckerImpl.this.disk_manager, true);
                try {
                    int n;
                    final AESemaphore aESemaphore = new AESemaphore("DMChecker::completeRecheck");
                    int n2 = 0;
                    final AESemaphore aESemaphore2 = new AESemaphore("DMChecker::completeRecheck:runsem", 2);
                    int n3 = DMCheckerImpl.this.disk_manager.getNbPieces();
                    for (n = 0; n < n3; ++n) {
                        DMCheckerImpl.this.complete_recheck_progress = 1000 * n / n3;
                        DiskManagerPiece diskManagerPiece = DMCheckerImpl.this.disk_manager.getPiece(n);
                        if (!diskManagerPiece.isDone() && diskManagerPiece.isSkipped()) continue;
                        aESemaphore2.reserve();
                        while (!DMCheckerImpl.this.stopped && !diskManagerRecheckInstance.getPermission()) {
                        }
                        if (DMCheckerImpl.this.stopped) break;
                        DiskManagerCheckRequest diskManagerCheckRequest2 = DMCheckerImpl.this.createCheckRequest(n, diskManagerCheckRequest.getUserData());
                        DMCheckerImpl.this.enqueueCheckRequest(diskManagerCheckRequest2, new DiskManagerCheckRequestListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void checkCompleted(DiskManagerCheckRequest diskManagerCheckRequest, boolean bl) {
                                try {
                                    diskManagerCheckRequestListener.checkCompleted(diskManagerCheckRequest, bl);
                                }
                                catch (Throwable throwable) {
                                    Debug.printStackTrace(throwable);
                                }
                                finally {
                                    this.complete();
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void checkCancelled(DiskManagerCheckRequest diskManagerCheckRequest) {
                                try {
                                    diskManagerCheckRequestListener.checkCancelled(diskManagerCheckRequest);
                                }
                                catch (Throwable throwable) {
                                    Debug.printStackTrace(throwable);
                                }
                                finally {
                                    this.complete();
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void checkFailed(DiskManagerCheckRequest diskManagerCheckRequest, Throwable throwable) {
                                try {
                                    diskManagerCheckRequestListener.checkFailed(diskManagerCheckRequest, throwable);
                                }
                                catch (Throwable throwable2) {
                                    Debug.printStackTrace(throwable2);
                                }
                                finally {
                                    this.complete();
                                }
                            }

                            protected void complete() {
                                aESemaphore2.release();
                                aESemaphore.release();
                            }
                        }, false);
                        ++n2;
                    }
                    for (n = 0; n < n2; ++n) {
                        aESemaphore.reserve();
                    }
                }
                finally {
                    DMCheckerImpl.this.complete_recheck_in_progress = false;
                    diskManagerRecheckInstance.unregister();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueCheckRequest(DiskManagerCheckRequest diskManagerCheckRequest, DiskManagerCheckRequestListener diskManagerCheckRequestListener) {
        if (fully_async) {
            try {
                class_mon.enter();
                async_check_queue.add(new Object[]{this, diskManagerCheckRequest, diskManagerCheckRequestListener});
                if (async_check_queue.size() % 100 == 0) {
                    System.out.println("async check queue size=" + async_check_queue.size());
                }
            }
            finally {
                class_mon.exit();
            }
            async_check_queue_sem.release();
        } else {
            this.enqueueCheckRequest(diskManagerCheckRequest, diskManagerCheckRequestListener, flush_pieces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasOutstandingCheckRequestForPiece(int n) {
        if (fully_async) {
            try {
                class_mon.enter();
                for (int i = 0; i < async_check_queue.size(); ++i) {
                    DiskManagerCheckRequest diskManagerCheckRequest;
                    Object[] objectArray = (Object[])async_check_queue.get(i);
                    if (objectArray[0] != this || (diskManagerCheckRequest = (DiskManagerCheckRequest)objectArray[1]).getPieceNumber() != n) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                class_mon.exit();
            }
        }
        return false;
    }

    protected void enqueueCheckRequest(DiskManagerCheckRequest diskManagerCheckRequest, final DiskManagerCheckRequestListener diskManagerCheckRequestListener, boolean bl) {
        diskManagerCheckRequest.requestStarts();
        this.enqueueCheckRequestSupport(diskManagerCheckRequest, new DiskManagerCheckRequestListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void checkCompleted(DiskManagerCheckRequest diskManagerCheckRequest, boolean bl) {
                diskManagerCheckRequest.requestEnds(true);
                try {
                    int n = diskManagerCheckRequest.getPieceNumber();
                    DiskManagerPiece diskManagerPiece = DMCheckerImpl.this.disk_manager.getPiece(diskManagerCheckRequest.getPieceNumber());
                    diskManagerPiece.setDone(bl);
                    if (bl) {
                        DMPieceList dMPieceList = DMCheckerImpl.this.disk_manager.getPieceList(n);
                        for (int i = 0; i < dMPieceList.size(); ++i) {
                            DMPieceMapEntry dMPieceMapEntry = dMPieceList.get(i);
                            dMPieceMapEntry.getFile().dataChecked(dMPieceMapEntry.getOffset(), dMPieceMapEntry.getLength());
                        }
                    }
                }
                finally {
                    diskManagerCheckRequestListener.checkCompleted(diskManagerCheckRequest, bl);
                    if (Logger.isEnabled()) {
                        if (bl) {
                            Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 0, "Piece " + diskManagerCheckRequest.getPieceNumber() + " passed hash check."));
                        } else {
                            Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + diskManagerCheckRequest.getPieceNumber() + " failed hash check."));
                        }
                    }
                }
            }

            @Override
            public void checkCancelled(DiskManagerCheckRequest diskManagerCheckRequest) {
                diskManagerCheckRequest.requestEnds(false);
                diskManagerCheckRequestListener.checkCancelled(diskManagerCheckRequest);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + diskManagerCheckRequest.getPieceNumber() + " hash check cancelled."));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void checkFailed(DiskManagerCheckRequest diskManagerCheckRequest, Throwable throwable) {
                diskManagerCheckRequest.requestEnds(false);
                try {
                    DMCheckerImpl.this.disk_manager.getPiece(diskManagerCheckRequest.getPieceNumber()).setDone(false);
                }
                finally {
                    diskManagerCheckRequestListener.checkFailed(diskManagerCheckRequest, throwable);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)DMCheckerImpl.this.disk_manager, LOGID, 1, "Piece " + diskManagerCheckRequest.getPieceNumber() + " failed hash check - " + Debug.getNestedExceptionMessage(throwable)));
                    }
                }
            }
        }, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueCheckRequestSupport(final DiskManagerCheckRequest diskManagerCheckRequest, final DiskManagerCheckRequestListener diskManagerCheckRequestListener, boolean bl) {
        if (!this.checking_enabled) {
            diskManagerCheckRequestListener.checkCompleted(diskManagerCheckRequest, true);
            return;
        }
        final int n = diskManagerCheckRequest.getPieceNumber();
        try {
            int n2;
            final byte[] byArray = this.disk_manager.getPieceHash(n);
            final DMPieceList dMPieceList = this.disk_manager.getPieceList(n);
            try {
                n2 = dMPieceList.size() > 0 ? 1 : 0;
                for (int i = 0; i < dMPieceList.size(); ++i) {
                    int n3;
                    DMPieceMapEntry dMPieceMapEntry = dMPieceList.get(i);
                    DiskManagerFileInfoImpl diskManagerFileInfoImpl = dMPieceMapEntry.getFile();
                    CacheFile cacheFile = diskManagerFileInfoImpl.getCacheFile();
                    if (cacheFile.compareLength(dMPieceMapEntry.getOffset()) < 0L) {
                        diskManagerCheckRequestListener.checkCompleted(diskManagerCheckRequest, false);
                        return;
                    }
                    if (n2 == 0 || ((n3 = cacheFile.getStorageType()) == 2 || n3 == 4) && diskManagerFileInfoImpl.getNbPieces() > 2) continue;
                    n2 = 0;
                }
                if (n2 != 0) {
                    diskManagerCheckRequestListener.checkCompleted(diskManagerCheckRequest, false);
                    return;
                }
            }
            catch (Throwable throwable) {
                diskManagerCheckRequestListener.checkCancelled(diskManagerCheckRequest);
                return;
            }
            n2 = this.disk_manager.getPieceLength(n);
            DiskManagerReadRequest diskManagerReadRequest = this.disk_manager.createReadRequest(n, 0, n2);
            try {
                this.this_mon.enter();
                if (this.stopped) {
                    diskManagerCheckRequestListener.checkCancelled(diskManagerCheckRequest);
                    return;
                }
                ++this.async_reads;
            }
            finally {
                this.this_mon.exit();
            }
            diskManagerReadRequest.setFlush(bl);
            diskManagerReadRequest.setUseCache(!diskManagerCheckRequest.isAdHoc());
            this.disk_manager.enqueueReadRequest(diskManagerReadRequest, new DiskManagerReadRequestListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void readCompleted(DiskManagerReadRequest diskManagerReadRequest, DirectByteBuffer directByteBuffer) {
                    this.complete();
                    try {
                        DMCheckerImpl.this.this_mon.enter();
                        if (DMCheckerImpl.this.stopped) {
                            directByteBuffer.returnToPool();
                            diskManagerCheckRequestListener.checkCancelled(diskManagerCheckRequest);
                            return;
                        }
                        ++DMCheckerImpl.this.async_checks;
                    }
                    finally {
                        DMCheckerImpl.this.this_mon.exit();
                    }
                    try {
                        final DirectByteBuffer directByteBuffer2 = directByteBuffer;
                        ConcurrentHasher.getSingleton().addRequest(directByteBuffer.getBuffer((byte)8), new ConcurrentHasherRequestListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void complete(ConcurrentHasherRequest concurrentHasherRequest) {
                                block37: {
                                    int n = 3;
                                    try {
                                        byte[] byArray = concurrentHasherRequest.getResult();
                                        if (byArray == null) break block37;
                                        diskManagerCheckRequest.setHash(byArray);
                                        n = 1;
                                        for (int i = 0; i < byArray.length; ++i) {
                                            if (byArray[i] == byArray[i]) continue;
                                            n = 2;
                                            break;
                                        }
                                    }
                                    finally {
                                        try {
                                            if (n == 1) {
                                                try {
                                                    for (int i = 0; i < dMPieceList.size(); ++i) {
                                                        DMPieceMapEntry dMPieceMapEntry = dMPieceList.get(i);
                                                        DiskManagerFileInfoImpl diskManagerFileInfoImpl = dMPieceMapEntry.getFile();
                                                        if (diskManagerFileInfoImpl.getLength() <= 0L && diskManagerFileInfoImpl.isSkipped()) continue;
                                                        CacheFile cacheFile = diskManagerFileInfoImpl.getCacheFile();
                                                        cacheFile.setPieceComplete(n, directByteBuffer2);
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    directByteBuffer2.returnToPool();
                                                    Debug.out(throwable);
                                                    diskManagerCheckRequestListener.checkFailed(diskManagerCheckRequest, throwable);
                                                    try {
                                                        DMCheckerImpl.this.this_mon.enter();
                                                        --DMCheckerImpl.this.async_checks;
                                                        if (DMCheckerImpl.this.stopped) {
                                                            DMCheckerImpl.this.async_check_sem.release();
                                                        }
                                                    }
                                                    finally {
                                                        DMCheckerImpl.this.this_mon.exit();
                                                    }
                                                    return;
                                                }
                                            }
                                            directByteBuffer2.returnToPool();
                                            if (n == 1) {
                                                diskManagerCheckRequestListener.checkCompleted(diskManagerCheckRequest, true);
                                            } else if (n == 2) {
                                                diskManagerCheckRequestListener.checkCompleted(diskManagerCheckRequest, false);
                                            } else {
                                                diskManagerCheckRequestListener.checkCancelled(diskManagerCheckRequest);
                                            }
                                        }
                                        finally {
                                            try {
                                                DMCheckerImpl.this.this_mon.enter();
                                                --DMCheckerImpl.this.async_checks;
                                                if (DMCheckerImpl.this.stopped) {
                                                    DMCheckerImpl.this.async_check_sem.release();
                                                }
                                            }
                                            finally {
                                                DMCheckerImpl.this.this_mon.exit();
                                            }
                                        }
                                    }
                                }
                            }
                        }, diskManagerCheckRequest.isLowPriority());
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        directByteBuffer.returnToPool();
                        diskManagerCheckRequestListener.checkFailed(diskManagerCheckRequest, throwable);
                    }
                }

                @Override
                public void readFailed(DiskManagerReadRequest diskManagerReadRequest, Throwable throwable) {
                    this.complete();
                    diskManagerCheckRequestListener.checkFailed(diskManagerCheckRequest, throwable);
                }

                @Override
                public int getPriority() {
                    return checking_read_priority ? 0 : -1;
                }

                @Override
                public void requestExecuted(long l) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void complete() {
                    try {
                        DMCheckerImpl.this.this_mon.enter();
                        --DMCheckerImpl.this.async_reads;
                        if (DMCheckerImpl.this.stopped) {
                            DMCheckerImpl.this.async_read_sem.release();
                        }
                    }
                    finally {
                        DMCheckerImpl.this.this_mon.exit();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            this.disk_manager.setFailed("Piece check error - " + Debug.getNestedExceptionMessage(throwable));
            Debug.printStackTrace(throwable);
            diskManagerCheckRequestListener.checkFailed(diskManagerCheckRequest, throwable);
        }
    }

    static {
        class_mon = new AEMonitor("DMChecker:class");
        async_check_queue = new ArrayList();
        async_check_queue_sem = new AESemaphore("DMChecker::asyncCheck");
        fully_async = COConfigurationManager.getBooleanParameter("diskmanager.perf.checking.fully.async");
        if (fully_async) {
            new AEThread2("DMCheckerImpl:asyncCheckScheduler", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Object[] objectArray;
                        async_check_queue_sem.reserve();
                        try {
                            class_mon.enter();
                            objectArray = (Object[])async_check_queue.remove(0);
                            int n = async_check_queue.size();
                            if (n % 100 == 0 && n > 0) {
                                System.out.println("async check queue size=" + async_check_queue.size());
                            }
                        }
                        finally {
                            class_mon.exit();
                        }
                        ((DMCheckerImpl)objectArray[0]).enqueueCheckRequest((DiskManagerCheckRequest)objectArray[1], (DiskManagerCheckRequestListener)objectArray[2], flush_pieces);
                    }
                }
            }.start();
        }
        ParameterListener parameterListener = new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                flush_pieces = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.flushpieces");
                checking_read_priority = COConfigurationManager.getBooleanParameter("diskmanager.perf.checking.read.priority");
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"diskmanager.perf.cache.flushpieces", "diskmanager.perf.checking.read.priority"}, parameterListener);
    }
}

