/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.StringInterner;

public class DiskManagerFileInfoImpl
implements DiskManagerFileInfo,
CacheFileOwner {
    private File file;
    private int file_index;
    private CacheFile cache_file;
    private String extension;
    private long downloaded;
    private DiskManagerHelper diskManager;
    private TOTorrentFile torrent_file;
    private int priority = 0;
    protected boolean skipped = false;
    private CopyOnWriteList listeners;

    public DiskManagerFileInfoImpl(DiskManagerHelper diskManagerHelper, File file, int n, TOTorrentFile tOTorrentFile, int n2) throws CacheFileManagerException {
        this.diskManager = diskManagerHelper;
        this.torrent_file = tOTorrentFile;
        this.file = file;
        this.file_index = n;
        int n3 = DiskManagerUtil.convertDMStorageTypeToCache(n2);
        this.cache_file = CacheFileManagerFactory.getSingleton().createFile(this, file, n3);
        if (n3 == 2 || n3 == 4) {
            this.skipped = true;
        }
    }

    @Override
    public String getCacheFileOwnerName() {
        return this.diskManager.getInternalName();
    }

    @Override
    public TOTorrentFile getCacheFileTorrentFile() {
        return this.torrent_file;
    }

    @Override
    public File getCacheFileControlFileDir() {
        return this.diskManager.getDownloadState().getStateFile();
    }

    @Override
    public int getCacheMode() {
        return this.diskManager.getCacheMode();
    }

    @Override
    public void flushCache() throws Exception {
        this.cache_file.flushCache();
    }

    public void moveFile(File file, boolean bl) throws CacheFileManagerException {
        if (!bl) {
            this.cache_file.moveFile(file);
        }
        this.file = file;
    }

    public void renameFile(String string, boolean bl) throws CacheFileManagerException {
        if (!bl) {
            this.cache_file.renameFile(string);
        }
        this.file = new File(this.file.getParentFile(), string);
    }

    public CacheFile getCacheFile() {
        return this.cache_file;
    }

    public void setAccessMode(int n) throws CacheFileManagerException {
        int n2 = this.cache_file.getAccessMode();
        this.cache_file.setAccessMode(n == 1 ? 1 : 2);
        if (n2 != n) {
            this.diskManager.accessModeChanged(this, n2, n);
        }
    }

    @Override
    public int getAccessMode() {
        int n = this.cache_file.getAccessMode();
        return n == 1 ? 1 : 2;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public File getFile(boolean bl) {
        File file;
        if (bl && (file = this.getLink()) != null) {
            return file;
        }
        return this.file;
    }

    @Override
    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    @Override
    public boolean setLink(File file) {
        Debug.out("setLink: download must be stopped");
        return false;
    }

    @Override
    public boolean setLinkAtomic(File file) {
        Debug.out("setLink: download must be stopped");
        return false;
    }

    @Override
    public File getLink() {
        return this.diskManager.getDownloadState().getFileLink(this.getFile(false));
    }

    @Override
    public boolean setStorageType(int n) {
        DiskManagerFileInfoSet diskManagerFileInfoSet = this.diskManager.getFileSet();
        boolean[] blArray = new boolean[diskManagerFileInfoSet.nbFiles()];
        blArray[this.file_index] = true;
        return diskManagerFileInfoSet.setStorageTypes(blArray, n)[this.file_index];
    }

    @Override
    public int getStorageType() {
        return DiskManagerUtil.convertDMStorageTypeFromString(this.diskManager.getStorageType(this.file_index));
    }

    protected boolean isLinked() {
        return this.getLink() != null;
    }

    @Override
    public int getFirstPieceNumber() {
        return this.torrent_file.getFirstPieceNumber();
    }

    @Override
    public int getLastPieceNumber() {
        return this.torrent_file.getLastPieceNumber();
    }

    @Override
    public long getLength() {
        return this.torrent_file.getLength();
    }

    @Override
    public int getIndex() {
        return this.file_index;
    }

    @Override
    public int getNbPieces() {
        return this.torrent_file.getNumberOfPieces();
    }

    public void setDownloaded(long l) {
        this.downloaded = l;
    }

    public void setExtension(String string) {
        this.extension = StringInterner.intern(string);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int n) {
        this.priority = n;
        this.diskManager.priorityChanged(this);
    }

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    @Override
    public void setSkipped(boolean bl) {
        int n = this.getStorageType();
        if (!bl && n == 2 && !this.setStorageType(1)) {
            return;
        }
        if (!bl && n == 4 && !this.setStorageType(3)) {
            return;
        }
        this.skipped = bl;
        this.diskManager.skippedFileSetChanged(this);
        if (!bl) {
            boolean[] blArray = new boolean[this.diskManager.getFileSet().nbFiles()];
            blArray[this.file_index] = true;
            DiskManagerUtil.doFileExistenceChecks(this.diskManager.getFileSet(), blArray, this.diskManager.getDownloadState().getDownloadManager(), true);
        }
    }

    @Override
    public DiskManager getDiskManager() {
        return this.diskManager;
    }

    @Override
    public DownloadManager getDownloadManager() {
        DownloadManagerState downloadManagerState = this.diskManager.getDownloadState();
        if (downloadManagerState == null) {
            return null;
        }
        return downloadManagerState.getDownloadManager();
    }

    public void dataWritten(long l, long l2) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DiskManagerFileInfoListener)iterator.next()).dataWritten(l, l2);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public void dataChecked(long l, long l2) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DiskManagerFileInfoListener)iterator.next()).dataChecked(l, l2);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    @Override
    public DirectByteBuffer read(long l, int n) throws IOException {
        DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)6, n);
        try {
            this.cache_file.read(directByteBuffer, l, (short)1);
        }
        catch (Throwable throwable) {
            directByteBuffer.returnToPool();
            Debug.printStackTrace(throwable);
            throw new IOException(throwable.getMessage());
        }
        return directByteBuffer;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(final DiskManagerFileInfoListener diskManagerFileInfoListener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteList();
        }
        CopyOnWriteList copyOnWriteList = this.listeners;
        synchronized (copyOnWriteList) {
            if (this.listeners.getList().contains(diskManagerFileInfoListener)) {
                return;
            }
        }
        this.listeners.add(diskManagerFileInfoListener);
        new Runnable(){
            private long file_start;
            private long file_end;
            private long current_write_start = -1L;
            private long current_write_end = -1L;
            private long current_check_start = -1L;
            private long current_check_end = -1L;

            @Override
            public void run() {
                TOTorrentFile[] tOTorrentFileArray = DiskManagerFileInfoImpl.this.torrent_file.getTorrent().getFiles();
                long l = 0L;
                for (int i = 0; i < DiskManagerFileInfoImpl.this.file_index; ++i) {
                    l += tOTorrentFileArray[i].getLength();
                }
                this.file_start = l;
                this.file_end = this.file_start + DiskManagerFileInfoImpl.this.torrent_file.getLength();
                DiskManagerPiece[] diskManagerPieceArray = DiskManagerFileInfoImpl.this.diskManager.getPieces();
                int n = DiskManagerFileInfoImpl.this.getFirstPieceNumber();
                int n2 = DiskManagerFileInfoImpl.this.getLastPieceNumber();
                long l2 = DiskManagerFileInfoImpl.this.torrent_file.getTorrent().getPieceLength();
                for (int i = n; i <= n2; ++i) {
                    long l3 = l2 * (long)i;
                    DiskManagerPiece diskManagerPiece = diskManagerPieceArray[i];
                    if (diskManagerPiece.isDone()) {
                        long l4 = l3;
                        long l5 = l4 + (long)diskManagerPiece.getLength();
                        this.bitWritten(l4, l5, true);
                        continue;
                    }
                    int n3 = 0;
                    for (int j = 0; j < diskManagerPiece.getNbBlocks(); ++j) {
                        int n4 = diskManagerPiece.getBlockSize(j);
                        if (diskManagerPiece.isWritten(j)) {
                            long l6 = l3 + (long)n3;
                            long l7 = l6 + (long)n4;
                            this.bitWritten(l6, l7, false);
                        }
                        n3 += n4;
                    }
                }
                this.bitWritten(-1L, -1L, false);
            }

            protected void bitWritten(long l, long l2, boolean bl) {
                if (this.current_write_start == -1L) {
                    this.current_write_start = l;
                    this.current_write_end = l2;
                } else if (this.current_write_end == l) {
                    this.current_write_end = l2;
                } else {
                    if (this.current_write_start < this.file_start) {
                        this.current_write_start = this.file_start;
                    }
                    if (this.current_write_end > this.file_end) {
                        this.current_write_end = this.file_end;
                    }
                    if (this.current_write_start < this.current_write_end) {
                        try {
                            diskManagerFileInfoListener.dataWritten(this.current_write_start - this.file_start, this.current_write_end - this.current_write_start);
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                    this.current_write_start = l;
                    this.current_write_end = l2;
                }
                if (bl && this.current_check_start == -1L) {
                    this.current_check_start = l;
                    this.current_check_end = l2;
                } else if (bl && this.current_check_end == l) {
                    this.current_check_end = l2;
                } else {
                    if (this.current_check_start < this.file_start) {
                        this.current_check_start = this.file_start;
                    }
                    if (this.current_check_end > this.file_end) {
                        this.current_check_end = this.file_end;
                    }
                    if (this.current_check_start < this.current_check_end) {
                        try {
                            diskManagerFileInfoListener.dataChecked(this.current_check_start - this.file_start, this.current_check_end - this.current_check_start);
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                    if (bl) {
                        this.current_check_start = l;
                        this.current_check_end = l2;
                    } else {
                        this.current_check_start = -1L;
                        this.current_check_end = -1L;
                    }
                }
            }
        }.run();
    }

    @Override
    public void removeListener(DiskManagerFileInfoListener diskManagerFileInfoListener) {
        this.listeners.remove(diskManagerFileInfoListener);
    }
}

