/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.X509CRLEntryObject;

public class X509CRLObject
extends X509CRL {
    private CertificateList c;

    public X509CRLObject(CertificateList certificateList) {
        this.c = certificateList;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        return set != null && !set.isEmpty();
    }

    private Set getExtensionOIDs(boolean bl) {
        if (this.getVersion() == 2) {
            HashSet<String> hashSet = new HashSet<String>();
            X509Extensions x509Extensions = this.c.getTBSCertList().getExtensions();
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (bl != x509Extension.isCritical()) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public byte[] getExtensionValue(String string) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.c.getTBSCertList().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            try {
                dEROutputStream.writeObject(x509Extension.getValue());
                return byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                throw new RuntimeException("error encoding " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this.c);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, "BC");
    }

    @Override
    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (!this.c.getSignatureAlgorithm().equals(this.c.getTBSCertList().getSignature())) {
            throw new CRLException("Signature algorithm on CertifcateList does not match TBSCertList.");
        }
        Signature signature = Signature.getInstance(this.getSigAlgName(), string);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public int getVersion() {
        return this.c.getVersion();
    }

    @Override
    public Principal getIssuerDN() {
        return new X509Principal(this.c.getIssuer());
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.c.getIssuer());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getThisUpdate() {
        return this.c.getThisUpdate().getDate();
    }

    @Override
    public Date getNextUpdate() {
        if (this.c.getNextUpdate() != null) {
            return this.c.getNextUpdate().getDate();
        }
        return null;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        TBSCertList.CRLEntry[] cRLEntryArray = this.c.getRevokedCertificates();
        if (cRLEntryArray != null) {
            for (int i = 0; i < cRLEntryArray.length; ++i) {
                if (!cRLEntryArray[i].getUserCertificate().getValue().equals(bigInteger)) continue;
                return new X509CRLEntryObject(cRLEntryArray[i]);
            }
        }
        return null;
    }

    public Set getRevokedCertificates() {
        TBSCertList.CRLEntry[] cRLEntryArray = this.c.getRevokedCertificates();
        if (cRLEntryArray != null) {
            HashSet<X509CRLEntryObject> hashSet = new HashSet<X509CRLEntryObject>();
            for (int i = 0; i < cRLEntryArray.length; ++i) {
                hashSet.add(new X509CRLEntryObject(cRLEntryArray[i]));
            }
            return hashSet;
        }
        return null;
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this.c.getTBSCertList());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.c.getSignature().getBytes();
    }

    @Override
    public String getSigAlgName() {
        Provider provider2 = Security.getProvider("BC");
        String string = provider2.getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
        if (string != null) {
            return string;
        }
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i != providerArray.length; ++i) {
            string = providerArray[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    @Override
    public String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getObjectId().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.c.getSignatureAlgorithm().getParameters() != null) {
            try {
                DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
                dEROutputStream.writeObject(this.c.getSignatureAlgorithm().getParameters());
            }
            catch (Exception exception) {
                throw new RuntimeException("exception getting sig parameters " + exception);
            }
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    @Override
    public String toString() {
        return "X.509 CRL";
    }

    @Override
    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new RuntimeException("X.509 CRL used with non X.509 Cert");
        }
        TBSCertList.CRLEntry[] cRLEntryArray = this.c.getRevokedCertificates();
        if (cRLEntryArray != null) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            for (int i = 0; i < cRLEntryArray.length; ++i) {
                if (!cRLEntryArray[i].getUserCertificate().getValue().equals(bigInteger)) continue;
                return true;
            }
        }
        return false;
    }
}

