/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc;

import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketRequestDecoder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public abstract class PRUDPPacketRequest
extends PRUDPPacket {
    public static final int PR_HEADER_SIZE = 16;
    private static AEMonitor class_mon = new AEMonitor("PRUDPPacketRequest:class");
    private static Map packet_decoders = new HashMap();
    protected long connection_id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDecoders(Map map) {
        try {
            class_mon.enter();
            HashMap hashMap = new HashMap(packet_decoders);
            for (Integer n : map.keySet()) {
                if (!packet_decoders.containsKey(n)) continue;
                Debug.out("Duplicate codec! " + n);
            }
            hashMap.putAll(map);
            packet_decoders = hashMap;
        }
        finally {
            class_mon.exit();
        }
    }

    public PRUDPPacketRequest(int n, long l) {
        super(n);
        this.connection_id = l;
    }

    protected PRUDPPacketRequest(int n, long l, int n2) {
        super(n, n2);
        this.connection_id = l;
    }

    public long getConnectionId() {
        return this.connection_id;
    }

    @Override
    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(this.connection_id);
        dataOutputStream.writeInt(this.getAction());
        dataOutputStream.writeInt(this.getTransactionId());
    }

    public static PRUDPPacketRequest deserialiseRequest(PRUDPPacketHandler pRUDPPacketHandler, DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        PRUDPPacketRequestDecoder pRUDPPacketRequestDecoder = (PRUDPPacketRequestDecoder)packet_decoders.get(new Integer(n));
        if (pRUDPPacketRequestDecoder == null) {
            throw new IOException("No decoder registered for action '" + n + "'");
        }
        return pRUDPPacketRequestDecoder.decode(pRUDPPacketHandler, dataInputStream, l, n, n2);
    }

    @Override
    public String getString() {
        return super.getString() + ":request[con=" + this.connection_id + ",trans=" + this.getTransactionId() + "]";
    }
}

