/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;

public class ExternalSeedPeer
implements Peer,
ExternalSeedReaderListener {
    private ExternalSeedPlugin plugin;
    private Download download;
    private PeerManager manager;
    private PeerStats stats;
    private Map user_data;
    private ExternalSeedReader reader;
    private int state;
    private byte[] peer_id;
    private boolean[] available;
    private boolean availabilityAdded;
    private long snubbed;
    private boolean is_optimistic;
    private Monitor connection_mon;
    private boolean peer_added;
    private List<PeerReadRequest> request_list = new ArrayList<PeerReadRequest>();
    private CopyOnWriteList listeners;
    private Monitor listeners_mon;
    private boolean doing_allocations;

    protected ExternalSeedPeer(ExternalSeedPlugin externalSeedPlugin, Download download, ExternalSeedReader externalSeedReader) {
        this.plugin = externalSeedPlugin;
        this.download = download;
        this.reader = externalSeedReader;
        this.connection_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        Torrent torrent = this.reader.getTorrent();
        this.available = new boolean[(int)torrent.getPieceCount()];
        Arrays.fill(this.available, true);
        this.peer_id = new byte[20];
        new Random().nextBytes(this.peer_id);
        this.peer_id[0] = 69;
        this.peer_id[1] = 120;
        this.peer_id[2] = 116;
        this.peer_id[3] = 32;
        this.listeners = new CopyOnWriteList();
        this.listeners_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        externalSeedReader.addListener(this);
    }

    protected boolean sameAs(ExternalSeedPeer externalSeedPeer) {
        return this.reader.sameAs(externalSeedPeer.reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setManager(PeerManager peerManager) {
        this.setState(10);
        try {
            this.connection_mon.enter();
            this.manager = peerManager;
            this.stats = this.manager == null ? null : this.manager.createPeerStats(this);
            this.checkConnection();
        }
        finally {
            this.connection_mon.exit();
        }
    }

    @Override
    public PeerManager getManager() {
        return this.manager;
    }

    protected Download getDownload() {
        return this.download;
    }

    protected ExternalSeedReader getReader() {
        return this.reader;
    }

    protected void setState(int n) {
        this.state = n;
        this.fireEvent(1, new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConnection() {
        boolean bl = false;
        try {
            this.connection_mon.enter();
            boolean bl2 = this.reader.checkActivation(this.manager, this);
            if (this.manager != null && bl2 != this.peer_added) {
                bl = true;
                boolean bl3 = this.peer_added;
                this.peer_added = bl2;
                if (bl2) {
                    this.addPeer();
                } else if (bl3) {
                    this.removePeer();
                }
            }
        }
        finally {
            this.connection_mon.exit();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeer() {
        this.setState(20);
        this.manager.addPeer(this);
        if (this.peer_added) {
            this.setState(30);
            try {
                this.listeners_mon.enter();
                if (this.availabilityAdded) {
                    Debug.out("availabililty already added");
                } else {
                    this.availabilityAdded = true;
                    this.fireEvent(3, this.getAvailable());
                }
            }
            finally {
                this.listeners_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeer() {
        this.setState(40);
        try {
            this.listeners_mon.enter();
            if (this.availabilityAdded) {
                this.availabilityAdded = false;
                this.fireEvent(4, this.getAvailable());
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        this.manager.removePeer(this);
        this.setState(50);
    }

    @Override
    public void requestComplete(PeerReadRequest peerReadRequest, PooledByteBuffer pooledByteBuffer) {
        PeerManager peerManager = this.manager;
        if (peerReadRequest.isCancelled() || peerManager == null) {
            pooledByteBuffer.returnToPool();
        } else {
            try {
                peerManager.requestComplete(peerReadRequest, pooledByteBuffer, this);
            }
            catch (Throwable throwable) {
                pooledByteBuffer.returnToPool();
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void requestCancelled(PeerReadRequest peerReadRequest) {
        PeerManager peerManager = this.manager;
        if (peerManager != null) {
            peerManager.requestCancelled(peerReadRequest, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFailed(PeerReadRequest peerReadRequest) {
        PeerManager peerManager = this.manager;
        if (peerManager != null) {
            peerManager.requestCancelled(peerReadRequest, this);
            try {
                this.connection_mon.enter();
                if (this.peer_added) {
                    this.plugin.log(this.reader.getName() + " failed - " + this.reader.getStatus() + ", permanent = " + this.reader.isPermanentlyUnavailable());
                    this.peer_added = false;
                    this.removePeer();
                }
            }
            finally {
                this.connection_mon.exit();
            }
            if (this.reader.isTransient() && this.reader.isPermanentlyUnavailable()) {
                this.plugin.removePeer(this);
            }
        }
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public byte[] getId() {
        return this.peer_id;
    }

    public URL getURL() {
        return this.reader.getURL();
    }

    @Override
    public String getIp() {
        return this.reader.getIP();
    }

    @Override
    public int getTCPListenPort() {
        return 0;
    }

    @Override
    public int getUDPListenPort() {
        return 0;
    }

    @Override
    public int getUDPNonDataListenPort() {
        return 0;
    }

    @Override
    public int getPort() {
        return this.reader.getPort();
    }

    @Override
    public final boolean[] getAvailable() {
        return this.available;
    }

    @Override
    public final boolean isPieceAvailable(int n) {
        return true;
    }

    @Override
    public boolean isTransferAvailable() {
        return this.reader.isActive();
    }

    @Override
    public boolean isDownloadPossible() {
        return this.peer_added && this.reader.isActive();
    }

    @Override
    public boolean isChoked() {
        return false;
    }

    @Override
    public boolean isChoking() {
        return false;
    }

    @Override
    public boolean isInterested() {
        return false;
    }

    @Override
    public boolean isInteresting() {
        return true;
    }

    @Override
    public boolean isSeed() {
        return true;
    }

    @Override
    public boolean isSnubbed() {
        if (this.snubbed != 0L && this.reader.getRequestCount() == 0) {
            this.snubbed = 0L;
        }
        return this.snubbed != 0L;
    }

    @Override
    public long getSnubbedTime() {
        if (!this.isSnubbed()) {
            return 0L;
        }
        long l = this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
        if (l < this.snubbed) {
            this.snubbed = l - 26L;
        }
        return l - this.snubbed;
    }

    @Override
    public void setSnubbed(boolean bl) {
        if (!bl) {
            this.snubbed = 0L;
        } else if (this.snubbed == 0L) {
            this.snubbed = this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
        }
    }

    @Override
    public boolean isOptimisticUnchoke() {
        return this.is_optimistic;
    }

    @Override
    public void setOptimisticUnchoke(boolean bl) {
        this.is_optimistic = bl;
    }

    @Override
    public PeerStats getStats() {
        return this.stats;
    }

    @Override
    public boolean isIncoming() {
        return false;
    }

    @Override
    public int getPercentDone() {
        return 1000;
    }

    @Override
    public int getPercentDoneInThousandNotation() {
        return 1000;
    }

    @Override
    public String getClient() {
        return this.reader.getName();
    }

    @Override
    public List getExpiredRequests() {
        return this.reader.getExpiredRequests();
    }

    @Override
    public List<PeerReadRequest> getRequests() {
        List<PeerReadRequest> list = this.reader.getRequests();
        if (this.request_list.size() > 0) {
            try {
                list.addAll(this.request_list);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        return list;
    }

    @Override
    public int getMaximumNumberOfRequests() {
        return this.reader.getMaximumNumberOfRequests();
    }

    @Override
    public int getNumberOfRequests() {
        return this.reader.getRequestCount() + this.request_list.size();
    }

    @Override
    public int[] getPriorityOffsets() {
        return this.reader.getPriorityOffsets();
    }

    @Override
    public boolean requestAllocationStarts(int[] nArray) {
        PeerManager peerManager;
        if (this.doing_allocations) {
            Debug.out("recursive allocations");
        }
        this.doing_allocations = true;
        if (this.request_list.size() != 0) {
            Debug.out("req list must be empty");
        }
        if ((peerManager = this.manager) != null) {
            this.reader.calculatePriorityOffsets(peerManager, nArray);
        }
        return true;
    }

    @Override
    public void requestAllocationComplete() {
        this.reader.addRequests(this.request_list);
        this.request_list.clear();
        this.doing_allocations = false;
    }

    @Override
    public boolean addRequest(PeerReadRequest peerReadRequest) {
        if (!this.doing_allocations) {
            Debug.out("request added when not in allocation phase");
        }
        if (!this.request_list.contains(peerReadRequest)) {
            this.request_list.add(peerReadRequest);
            this.snubbed = 0L;
        }
        return true;
    }

    @Override
    public void cancelRequest(PeerReadRequest peerReadRequest) {
        this.reader.cancelRequest(peerReadRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String string, boolean bl, boolean bl2) {
        boolean bl3;
        try {
            this.connection_mon.enter();
            bl3 = this.peer_added;
            this.reader.cancelAllRequests();
            this.reader.deactivate(string);
            this.peer_added = false;
            try {
                this.listeners_mon.enter();
                if (this.availabilityAdded) {
                    this.availabilityAdded = false;
                    this.fireEvent(4, this.getAvailable());
                }
            }
            finally {
                this.listeners_mon.exit();
            }
        }
        finally {
            this.connection_mon.exit();
        }
        if (bl3) {
            this.manager.removePeer(this);
        }
        this.setState(50);
        if (this.reader.isTransient()) {
            this.plugin.removePeer(this);
        }
    }

    public void remove() {
        this.plugin.removePeer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PeerListener peerListener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(peerListener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PeerListener peerListener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(peerListener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PeerListener2 peerListener2) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(peerListener2);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PeerListener2 peerListener2) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(peerListener2);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(final int n, final Object object) {
        try {
            this.listeners_mon.enter();
            List list = this.listeners.getList();
            for (int i = 0; i < list.size(); ++i) {
                try {
                    Object object2;
                    Object t = list.get(i);
                    if (t instanceof PeerListener) {
                        object2 = (PeerListener)t;
                        if (n == 1) {
                            object2.stateChanged((Integer)object);
                            continue;
                        }
                        if (n != 2) continue;
                        Integer[] integerArray = (Integer[])object;
                        object2.sentBadChunk(integerArray[0], integerArray[1]);
                        continue;
                    }
                    object2 = (PeerListener2)t;
                    object2.eventOccurred(new PeerEvent(){

                        @Override
                        public int getType() {
                            return n;
                        }

                        @Override
                        public Object getData() {
                            return object;
                        }
                    });
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public Connection getConnection() {
        return null;
    }

    @Override
    public boolean supportsMessaging() {
        return false;
    }

    @Override
    public Message[] getSupportedMessages() {
        return new Message[0];
    }

    @Override
    public int readBytes(int n) {
        int n2 = this.reader.readBytes(n);
        if (n2 > 0) {
            this.stats.received(n2);
        }
        return n2;
    }

    @Override
    public int writeBytes(int n) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.reader.getPercentDoneOfCurrentIncomingRequest();
    }

    @Override
    public int getPercentDoneOfCurrentOutgoingRequest() {
        return 0;
    }

    public Map getProperties() {
        return new HashMap();
    }

    public String getName() {
        return this.reader.getName();
    }

    @Override
    public void setUserData(Object object, Object object2) {
        if (this.user_data == null) {
            this.user_data = new HashMap();
        }
        this.user_data.put(object, object2);
    }

    @Override
    public Object getUserData(Object object) {
        if (this.user_data == null) {
            return null;
        }
        return this.user_data.get(object);
    }

    @Override
    public byte[] getHandshakeReservedBytes() {
        return null;
    }

    @Override
    public boolean isPriorityConnection() {
        return false;
    }

    @Override
    public void setPriorityConnection(boolean bl) {
    }
}

