/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.vuzefile;

import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncoder;

public class VuzeFileImpl
implements VuzeFile {
    private VuzeFileHandler handler;
    private VuzeFileComponent[] components;

    protected VuzeFileImpl(VuzeFileHandler vuzeFileHandler) {
        this.handler = vuzeFileHandler;
        this.components = new VuzeFileComponent[0];
    }

    protected VuzeFileImpl(VuzeFileHandler vuzeFileHandler, Map map) {
        this.handler = vuzeFileHandler;
        List list = (List)map.get("components");
        this.components = new VuzeFileComponent[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Map map2 = (Map)list.get(i);
            int n = ((Long)map2.get("type")).intValue();
            Map map3 = (Map)map2.get("content");
            this.components[i] = new comp(n, map3);
        }
    }

    @Override
    public VuzeFileComponent[] getComponents() {
        return this.components;
    }

    @Override
    public VuzeFileComponent addComponent(int n, Map map) {
        comp comp2 = new comp(n, map);
        int n2 = this.components.length;
        VuzeFileComponent[] vuzeFileComponentArray = new VuzeFileComponent[n2 + 1];
        System.arraycopy(this.components, 0, vuzeFileComponentArray, 0, n2);
        vuzeFileComponentArray[n2] = comp2;
        this.components = vuzeFileComponentArray;
        return comp2;
    }

    @Override
    public Map exportToMap() throws IOException {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        hashMap.put("vuze", hashMap2);
        ArrayList arrayList = new ArrayList();
        hashMap2.put("components", arrayList);
        for (int i = 0; i < this.components.length; ++i) {
            VuzeFileComponent vuzeFileComponent = this.components[i];
            HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
            hashMap3.put("type", new Long(vuzeFileComponent.getType()));
            hashMap3.put("content", vuzeFileComponent.getContent());
            arrayList.add(hashMap3);
        }
        return hashMap;
    }

    @Override
    public byte[] exportToBytes() throws IOException {
        return BEncoder.encode(this.exportToMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(this.exportToBytes());
        }
    }

    protected class comp
    implements VuzeFileComponent {
        private int type;
        private Map contents;
        private boolean processed;
        private Map user_data;

        protected comp(int n, Map map) {
            this.type = n;
            this.contents = map;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public Map getContent() {
            return this.contents;
        }

        @Override
        public void setProcessed() {
            this.processed = true;
        }

        @Override
        public boolean isProcessed() {
            return this.processed;
        }

        @Override
        public synchronized void setData(Object object, Object object2) {
            if (this.user_data == null) {
                this.user_data = new HashMap();
            }
            this.user_data.put(object, object2);
        }

        @Override
        public synchronized Object getData(Object object) {
            if (this.user_data == null) {
                return null;
            }
            return this.user_data.get(object);
        }
    }
}

