/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;

public class PingSourceStats {
    final SpeedManagerPingSource source;
    double currPing;
    Average shortTerm = AverageFactory.MovingImmediateAverage(3);
    Average medTerm = AverageFactory.MovingImmediateAverage(6);
    Average longTerm = AverageFactory.MovingImmediateAverage(10);
    Average forChecks = AverageFactory.MovingImmediateAverage(100);

    public PingSourceStats(SpeedManagerPingSource speedManagerPingSource) {
        this.source = speedManagerPingSource;
    }

    public void madeChange() {
    }

    public void addPingTime(int n) {
        this.currPing = n;
        this.shortTerm.update(n);
        this.medTerm.update(n);
        this.longTerm.update(n);
    }

    public int getTrend() {
        int n = 0;
        if (this.currPing < 0.0) {
            --n;
        } else {
            n = this.currPing < this.shortTerm.getAverage() ? ++n : --n;
            n = this.currPing < this.medTerm.getAverage() ? ++n : --n;
            n = this.currPing < this.longTerm.getAverage() ? ++n : --n;
        }
        n = this.shortTerm.getAverage() < this.medTerm.getAverage() ? ++n : --n;
        n = this.shortTerm.getAverage() < this.longTerm.getAverage() ? ++n : --n;
        n = this.medTerm.getAverage() < this.longTerm.getAverage() ? ++n : --n;
        if (this.currPing < 30.0) {
            ++n;
        }
        if (this.shortTerm.getAverage() < 30.0) {
            ++n;
        }
        if (this.medTerm.getAverage() < 30.0) {
            ++n;
        }
        if (this.longTerm.getAverage() < 30.0) {
            ++n;
        }
        if (this.currPing > 300.0) {
            --n;
        }
        if (this.shortTerm.getAverage() > 300.0) {
            --n;
        }
        if (this.medTerm.getAverage() > 300.0) {
            --n;
        }
        if (this.longTerm.getAverage() > 300.0) {
            --n;
        }
        return n;
    }

    public Average getLongTermAve() {
        return this.longTerm;
    }

    public Average getHistory() {
        return this.forChecks;
    }
}

