/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.security.impl;

import com.aelitis.azureus.core.security.CryptoECCUtils;
import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManagerException;
import com.aelitis.azureus.core.security.CryptoManagerPasswordException;
import com.aelitis.azureus.core.security.CryptoSTSEngine;
import com.aelitis.azureus.core.security.impl.CryptoManagerImpl;
import com.aelitis.azureus.core.security.impl.CryptoSTSEngineImpl;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.bouncycastle.jce.provider.JCEIESCipher;
import org.bouncycastle.jce.spec.IEKeySpec;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class CryptoHandlerECC
implements CryptoHandler {
    private static final String DEFAULT_PASSWORD = "";
    private static final Long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    private static final int TIMEOUT_DEFAULT_SECS = 3600;
    private CryptoManagerImpl manager;
    private String CONFIG_PREFIX = "core.crypto.ecc.";
    private PrivateKey use_method_private_key;
    private PublicKey use_method_public_key;
    private long last_unlock_time;

    protected CryptoHandlerECC(CryptoManagerImpl cryptoManagerImpl, int n) {
        this.manager = cryptoManagerImpl;
        this.CONFIG_PREFIX = this.CONFIG_PREFIX + n + ".";
        if (this.getDefaultPasswordHandlerType() != 1) {
            COConfigurationManager.setParameter(this.CONFIG_PREFIX + "default_pwtype", 1);
        }
        if (this.getCurrentPasswordType() == 2 || COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "publickey", null) == null) {
            try {
                this.createAndStoreKeys(this.manager.setPassword(1, 1, DEFAULT_PASSWORD.toCharArray(), DEFAULT_TIMEOUT));
                Debug.outNoStack("Successfully migrated key management");
            }
            catch (Throwable throwable) {
                Debug.out("Failed to migrate key management", throwable);
            }
        }
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void unlock() throws CryptoManagerException {
        this.getMyPrivateKey("unlock");
    }

    @Override
    public synchronized boolean isUnlocked() {
        return this.use_method_private_key != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        boolean bl = false;
        CryptoHandlerECC cryptoHandlerECC = this;
        synchronized (cryptoHandlerECC) {
            bl = this.use_method_private_key != null;
            this.use_method_private_key = null;
        }
        if (bl) {
            this.manager.lockChanged(this);
        }
    }

    @Override
    public int getUnlockTimeoutSeconds() {
        return COConfigurationManager.getIntParameter(this.CONFIG_PREFIX + "timeout", 3600);
    }

    @Override
    public void setUnlockTimeoutSeconds(int n) {
        COConfigurationManager.setParameter(this.CONFIG_PREFIX + "timeout", n);
    }

    @Override
    public byte[] sign(byte[] byArray, String string) throws CryptoManagerException {
        PrivateKey privateKey = this.getMyPrivateKey(string);
        Signature signature = CryptoECCUtils.getSignature(privateKey);
        try {
            signature.update(byArray);
            return signature.sign();
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Signature failed", throwable);
        }
    }

    @Override
    public boolean verify(byte[] byArray, byte[] byArray2, byte[] byArray3) throws CryptoManagerException {
        PublicKey publicKey = CryptoECCUtils.rawdataToPubkey(byArray);
        Signature signature = CryptoECCUtils.getSignature(publicKey);
        try {
            signature.update(byArray2);
            return signature.verify(byArray3);
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Signature failed", throwable);
        }
    }

    @Override
    public byte[] encrypt(byte[] byArray, byte[] byArray2, String string) throws CryptoManagerException {
        try {
            IEKeySpec iEKeySpec = new IEKeySpec(this.getMyPrivateKey(string), CryptoECCUtils.rawdataToPubkey(byArray));
            byte[] byArray3 = new byte[16];
            byte[] byArray4 = new byte[16];
            RandomUtils.nextSecureBytes(byArray3);
            RandomUtils.nextSecureBytes(byArray4);
            IESParameterSpec iESParameterSpec = new IESParameterSpec(byArray3, byArray4, 128);
            InternalECIES internalECIES = new InternalECIES();
            internalECIES.internalEngineInit(1, iEKeySpec, iESParameterSpec, null);
            byte[] byArray5 = internalECIES.internalEngineDoFinal(byArray2, 0, byArray2.length);
            byte[] byArray6 = new byte[32 + byArray5.length];
            System.arraycopy(byArray3, 0, byArray6, 0, 16);
            System.arraycopy(byArray4, 0, byArray6, 16, 16);
            System.arraycopy(byArray5, 0, byArray6, 32, byArray5.length);
            return byArray6;
        }
        catch (CryptoManagerException cryptoManagerException) {
            throw cryptoManagerException;
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Encrypt failed", throwable);
        }
    }

    @Override
    public byte[] decrypt(byte[] byArray, byte[] byArray2, String string) throws CryptoManagerException {
        try {
            IEKeySpec iEKeySpec = new IEKeySpec(this.getMyPrivateKey(string), CryptoECCUtils.rawdataToPubkey(byArray));
            byte[] byArray3 = new byte[16];
            byte[] byArray4 = new byte[16];
            System.arraycopy(byArray2, 0, byArray3, 0, 16);
            System.arraycopy(byArray2, 16, byArray4, 0, 16);
            IESParameterSpec iESParameterSpec = new IESParameterSpec(byArray3, byArray4, 128);
            InternalECIES internalECIES = new InternalECIES();
            internalECIES.internalEngineInit(2, iEKeySpec, iESParameterSpec, null);
            return internalECIES.internalEngineDoFinal(byArray2, 32, byArray2.length - 32);
        }
        catch (CryptoManagerException cryptoManagerException) {
            throw cryptoManagerException;
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Decrypt failed", throwable);
        }
    }

    @Override
    public CryptoSTSEngine getSTSEngine(String string) throws CryptoManagerException {
        return new CryptoSTSEngineImpl(this.getMyPublicKey(string, true), this.getMyPrivateKey(string));
    }

    @Override
    public byte[] peekPublicKey() {
        try {
            return CryptoECCUtils.keyToRawdata(this.getMyPublicKey("peek", false));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public byte[] getPublicKey(String string) throws CryptoManagerException {
        return CryptoECCUtils.keyToRawdata(this.getMyPublicKey(string, true));
    }

    @Override
    public byte[] getEncryptedPrivateKey(String string) throws CryptoManagerException {
        this.getMyPrivateKey(string);
        byte[] byArray = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "privatekey", null);
        if (byArray == null) {
            throw new CryptoManagerException("Private key unavailable");
        }
        int n = this.getCurrentPasswordType();
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)n;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverKeys(byte[] byArray, byte[] byArray2) throws CryptoManagerException {
        boolean bl = false;
        CryptoHandlerECC cryptoHandlerECC = this;
        synchronized (cryptoHandlerECC) {
            bl = this.use_method_private_key != null;
            this.use_method_private_key = null;
            this.use_method_public_key = null;
            this.manager.clearPassword(1, 3);
            COConfigurationManager.setParameter(this.CONFIG_PREFIX + "publickey", byArray);
            int n = byArray2[0] & 0xFF;
            COConfigurationManager.setParameter(this.CONFIG_PREFIX + "pwtype", n);
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray3, 0, byArray3.length);
            COConfigurationManager.setParameter(this.CONFIG_PREFIX + "privatekey", byArray3);
            COConfigurationManager.save();
        }
        this.manager.keyChanged(this);
        if (bl) {
            this.manager.lockChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetKeys(String string) throws CryptoManagerException {
        boolean bl = false;
        CryptoHandlerECC cryptoHandlerECC = this;
        synchronized (cryptoHandlerECC) {
            bl = this.use_method_private_key != null;
            this.use_method_private_key = null;
            this.use_method_public_key = null;
            this.manager.clearPassword(1, 3);
            COConfigurationManager.removeParameter(this.CONFIG_PREFIX + "publickey");
            COConfigurationManager.removeParameter(this.CONFIG_PREFIX + "privatekey");
            COConfigurationManager.save();
        }
        if (bl) {
            this.manager.lockChanged(this);
        }
        try {
            this.createAndStoreKeys("resetting keys");
        }
        catch (CryptoManagerException cryptoManagerException) {
            this.manager.keyChanged(this);
            throw cryptoManagerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected PrivateKey getMyPrivateKey(String string) throws CryptoManagerException {
        boolean bl = false;
        try {
            int n;
            Object object = this;
            // MONITORENTER : object
            if (this.use_method_private_key != null && (n = this.getUnlockTimeoutSeconds()) > 0 && SystemTime.getCurrentTime() - this.last_unlock_time >= (long)(n * 1000)) {
                bl = true;
                this.use_method_private_key = null;
            }
            if (this.use_method_private_key != null) {
                PrivateKey privateKey = this.use_method_private_key;
                // MONITOREXIT : object
                return privateKey;
            }
            // MONITOREXIT : object
            object = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "privatekey", null);
            if (object == null) {
                PrivateKey privateKey = (PrivateKey)this.createAndStoreKeys(string)[1];
                return privateKey;
            }
            CryptoManagerImpl.passwordDetails passwordDetails2 = this.manager.getPassword(1, 2, string, new CryptoManagerImpl.passwordTester((byte[])object){
                final /* synthetic */ byte[] val$encoded;
                {
                    this.val$encoded = byArray;
                }

                @Override
                public boolean testPassword(char[] cArray) {
                    try {
                        CryptoHandlerECC.this.manager.decryptWithPBE(this.val$encoded, cArray);
                        return true;
                    }
                    catch (Throwable throwable) {
                        return false;
                    }
                }
            }, this.getCurrentPasswordType());
            Object object2 = this;
            // MONITORENTER : object2
            boolean bl2 = false;
            try {
                this.use_method_private_key = CryptoECCUtils.rawdataToPrivkey(this.manager.decryptWithPBE((byte[])object, passwordDetails2.getPassword()));
                bl = true;
                this.last_unlock_time = SystemTime.getCurrentTime();
                if (!this.checkKeysOK(string)) {
                    throw new CryptoManagerPasswordException(true, "Password incorrect");
                }
                bl2 = true;
                if (!bl2) {
                    this.manager.clearPassword(1, 3);
                    bl = true;
                    this.use_method_private_key = null;
                }
            }
            catch (CryptoManagerException cryptoManagerException) {
                try {
                    throw cryptoManagerException;
                    catch (Throwable throwable) {
                        throw new CryptoManagerException("Password incorrect", throwable);
                    }
                }
                catch (Throwable throwable) {
                    if (bl2) throw throwable;
                    this.manager.clearPassword(1, 3);
                    bl = true;
                    this.use_method_private_key = null;
                    throw throwable;
                }
            }
            if (this.use_method_private_key == null) {
                throw new CryptoManagerException("Failed to get private key");
            }
            object2 = this.use_method_private_key;
            return object2;
        }
        finally {
            if (bl) {
                this.manager.lockChanged(this);
            }
        }
    }

    protected boolean checkKeysOK(String string) throws CryptoManagerException {
        byte[] byArray = "test".getBytes();
        return this.verify(CryptoECCUtils.keyToRawdata(this.getMyPublicKey(string, true)), byArray, this.sign(byArray, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PublicKey getMyPublicKey(String string, boolean bl) throws CryptoManagerException {
        boolean bl2 = false;
        CryptoHandlerECC cryptoHandlerECC = this;
        synchronized (cryptoHandlerECC) {
            if (this.use_method_public_key == null) {
                byte[] byArray = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "publickey", null);
                if (byArray == null) {
                    if (!bl) return null;
                    bl2 = true;
                } else {
                    this.use_method_public_key = CryptoECCUtils.rawdataToPubkey(byArray);
                }
            }
            if (bl2) return (PublicKey)this.createAndStoreKeys(string)[0];
            if (this.use_method_public_key != null) return this.use_method_public_key;
            throw new CryptoManagerException("Failed to get public key");
        }
    }

    @Override
    public int getDefaultPasswordHandlerType() {
        return COConfigurationManager.getIntParameter(this.CONFIG_PREFIX + "default_pwtype", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultPasswordHandlerType(int n) throws CryptoManagerException {
        boolean bl;
        String string = "Changing password handler";
        boolean bl2 = bl = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "privatekey", null) != null;
        if (bl) {
            if (n == this.getCurrentPasswordType()) {
                return;
            }
            this.getMyPrivateKey(string);
            CryptoManagerImpl.passwordDetails passwordDetails2 = this.manager.getPassword(1, 1, string, null, n);
            CryptoHandlerECC cryptoHandlerECC = this;
            synchronized (cryptoHandlerECC) {
                if (this.use_method_private_key == null) {
                    throw new CryptoManagerException("Private key not available");
                }
                byte[] byArray = CryptoECCUtils.keyToRawdata(this.use_method_private_key);
                byte[] byArray2 = this.manager.encryptWithPBE(byArray, passwordDetails2.getPassword());
                COConfigurationManager.setParameter(this.CONFIG_PREFIX + "privatekey", byArray2);
                COConfigurationManager.setParameter(this.CONFIG_PREFIX + "pwtype", passwordDetails2.getHandlerType());
                COConfigurationManager.setParameter(this.CONFIG_PREFIX + "default_pwtype", passwordDetails2.getHandlerType());
                COConfigurationManager.save();
            }
        }
        CryptoHandlerECC cryptoHandlerECC = this;
        synchronized (cryptoHandlerECC) {
            if (COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "privatekey", null) == null) {
                COConfigurationManager.setParameter(this.CONFIG_PREFIX + "default_pwtype", n);
                COConfigurationManager.save();
            }
        }
    }

    protected Key[] createAndStoreKeys(String string) throws CryptoManagerException {
        CryptoManagerImpl.passwordDetails passwordDetails2 = this.manager.getPassword(1, 1, string, null, this.getDefaultPasswordHandlerType());
        return this.createAndStoreKeys(passwordDetails2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Key[] createAndStoreKeys(CryptoManagerImpl.passwordDetails passwordDetails2) throws CryptoManagerException {
        try {
            CryptoHandlerECC cryptoHandlerECC = this;
            synchronized (cryptoHandlerECC) {
                Key[] keyArray;
                if (this.use_method_public_key == null || this.use_method_private_key == null) {
                    keyArray = CryptoECCUtils.createKeys();
                    this.use_method_public_key = keyArray.getPublic();
                    this.use_method_private_key = keyArray.getPrivate();
                    this.last_unlock_time = SystemTime.getCurrentTime();
                    COConfigurationManager.setParameter(this.CONFIG_PREFIX + "publickey", CryptoECCUtils.keyToRawdata(this.use_method_public_key));
                    byte[] byArray = CryptoECCUtils.keyToRawdata(this.use_method_private_key);
                    byte[] byArray2 = this.manager.encryptWithPBE(byArray, passwordDetails2.getPassword());
                    COConfigurationManager.setParameter(this.CONFIG_PREFIX + "privatekey", byArray2);
                    COConfigurationManager.setParameter(this.CONFIG_PREFIX + "pwtype", passwordDetails2.getHandlerType());
                    COConfigurationManager.save();
                }
                keyArray = new Key[]{this.use_method_public_key, this.use_method_private_key};
                return keyArray;
            }
        }
        finally {
            this.manager.keyChanged(this);
            this.manager.lockChanged(this);
        }
    }

    @Override
    public boolean verifyPublicKey(byte[] byArray) {
        try {
            CryptoECCUtils.rawdataToPubkey(byArray);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public String exportKeys() throws CryptoManagerException {
        return "id:      " + Base32.encode(this.manager.getSecureID()) + "\r\n" + "public:  " + Base32.encode(this.getPublicKey("Key export")) + "\r\n" + "private: " + Base32.encode(this.getEncryptedPrivateKey("Key export"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importKeys(String string) throws CryptoManagerException {
        int n;
        String string2 = "Key import";
        byte[] byArray = this.manager.getSecureID();
        byte[] byArray2 = this.peekPublicKey();
        byte[] byArray3 = byArray2 == null ? null : this.getEncryptedPrivateKey(string2);
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        String[] stringArray = string.split("\n");
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2;
            String string3 = stringArray[n].trim();
            if (string3.length() == 0 || (stringArray2 = string3.split(":")).length != 2) continue;
            String string4 = stringArray2[0].trim();
            String string5 = stringArray2[1].trim();
            byte[] byArray7 = Base32.decode(string5);
            if (string4.equals("id")) {
                byArray4 = byArray7;
                continue;
            }
            if (string4.equals("public")) {
                byArray5 = byArray7;
                continue;
            }
            if (!string4.equals("private")) continue;
            byArray6 = byArray7;
        }
        if (byArray4 == null || byArray5 == null || byArray6 == null) {
            throw new CryptoManagerException("Invalid input file");
        }
        n = 0;
        boolean bl = false;
        try {
            boolean bl2 = bl = !Arrays.equals(byArray, byArray4);
            if (bl) {
                this.manager.setSecureID(byArray4);
            }
            this.recoverKeys(byArray5, byArray6);
            if (!this.checkKeysOK(string2)) {
                throw new CryptoManagerException("Invalid key pair");
            }
            n = 1;
        }
        finally {
            if (n == 0) {
                bl = false;
                this.manager.setSecureID(byArray);
                if (byArray2 != null) {
                    this.recoverKeys(byArray2, byArray3);
                }
            }
        }
        return bl;
    }

    protected int getCurrentPasswordType() {
        return COConfigurationManager.getIntParameter(this.CONFIG_PREFIX + "pwtype", 1);
    }

    class InternalECIES
    extends JCEIESCipher.ECIES {
        InternalECIES() {
        }

        public void internalEngineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.engineInit(n, key, algorithmParameterSpec, secureRandom);
        }

        protected byte[] internalEngineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
            return this.engineDoFinal(byArray, n, n2);
        }
    }
}

