/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import com.aelitis.azureus.core.peermanager.utils.BTPeerIDByteDecoderDefinitions;

class BTPeerIDByteDecoderUtils {
    BTPeerIDByteDecoderUtils() {
    }

    public static String decodeMnemonic(char c) {
        switch (c) {
            case 'B': 
            case 'b': {
                return "Beta";
            }
            case 'X': 
            case 'Z': 
            case 'x': {
                return "(Dev)";
            }
        }
        return null;
    }

    public static String decodeNumericValueOfByte(byte by) {
        return String.valueOf(by & 0xFF);
    }

    public static String decodeNumericValueOfByte(byte by, int n) {
        String string = BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(by);
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }

    public static String decodeNumericChar(char c) {
        String string = BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c);
        if (string == null || string.length() == 1) {
            return string;
        }
        return null;
    }

    public static String intchar(char c) {
        String string = BTPeerIDByteDecoderUtils.decodeNumericChar(c);
        if (string == null) {
            throw new IllegalArgumentException("not an integer character: " + c);
        }
        return string;
    }

    public static String decodeAlphaNumericChar(char c) {
        if ('0' <= c && c <= '9') {
            return String.valueOf(c);
        }
        if ('A' <= c && c <= 'Z') {
            return String.valueOf(10 + (c - 65));
        }
        if ('a' <= c && c <= 'z') {
            return String.valueOf(36 + (c - 65));
        }
        if (c == '.') {
            return "62";
        }
        return null;
    }

    public static boolean isAzStyle(String string) {
        if (string.charAt(0) != '-') {
            return false;
        }
        if (string.charAt(7) == '-') {
            return true;
        }
        if (string.substring(1, 3).equals("FG")) {
            return true;
        }
        if (string.substring(1, 3).equals("LH")) {
            return true;
        }
        if (string.substring(1, 3).equals("NE")) {
            return true;
        }
        if (string.substring(1, 3).equals("KT")) {
            return true;
        }
        return string.substring(1, 3).equals("SP");
    }

    public static boolean isShadowStyle(String string) {
        int n;
        if (string.charAt(5) != '-') {
            return false;
        }
        if (!Character.isLetter(string.charAt(0))) {
            return false;
        }
        if (!Character.isDigit(string.charAt(1)) && string.charAt(1) != '-') {
            return false;
        }
        for (n = 4; n > 0 && string.charAt(n) == '-'; --n) {
        }
        for (int i = 1; i <= n; ++i) {
            char c = string.charAt(i);
            if (c == '-') {
                return false;
            }
            if (BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c) != null) continue;
            return false;
        }
        return true;
    }

    public static boolean isMainlineStyle(String string) {
        return string.charAt(2) == '-' && string.charAt(7) == '-' && (string.charAt(4) == '-' || string.charAt(5) == '-');
    }

    public static boolean isPossibleSpoofClient(String string) {
        return string.endsWith("UDP0") || string.endsWith("HTTPBT");
    }

    public static String getMainlineStyleVersionNumber(String string) {
        boolean bl = string.charAt(5) == '-';
        String string2 = BTPeerIDByteDecoderUtils.decodeNumericChar(string.charAt(3));
        if (bl) {
            string2 = BTPeerIDByteDecoderUtils.join(string2, BTPeerIDByteDecoderUtils.decodeNumericChar(string.charAt(4)));
        }
        return BTPeerIDByteDecoderUtils.joinAsDotted(BTPeerIDByteDecoderUtils.decodeNumericChar(string.charAt(1)), string2, BTPeerIDByteDecoderUtils.decodeNumericChar(string.charAt(bl ? 6 : 5)));
    }

    public static String getShadowStyleVersionNumber(String string) {
        char c;
        String string2 = BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(string.charAt(1));
        if (string2 == null) {
            return null;
        }
        for (int i = 2; i < 6 && string2 != null && (c = string.charAt(i)) != '-'; ++i) {
            string2 = BTPeerIDByteDecoderUtils.joinAsDotted(string2, BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(string.charAt(i)));
        }
        while (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    public static String decodeAzStyleVersionNumber(String string, String string2) {
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        char c3 = string.charAt(2);
        char c4 = string.charAt(3);
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_TRANSMISSION_STYLE) {
            string2 = string.startsWith("000") ? "3.4" : (string.startsWith("00") ? BTPeerIDByteDecoderDefinitions.VER_AZ_SKIP_FIRST_ONE_MAJ_TWO_MIN : BTPeerIDByteDecoderDefinitions.VER_AZ_ONE_MAJ_TWO_MIN_PLUS_MNEMONIC);
        }
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_FOUR_DIGITS) {
            return BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(c2) + "." + BTPeerIDByteDecoderUtils.intchar(c3) + "." + BTPeerIDByteDecoderUtils.intchar(c4);
        }
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_THREE_DIGITS || string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_THREE_DIGITS_PLUS_MNEMONIC || string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_ONE_MAJ_TWO_MIN_PLUS_MNEMONIC) {
            String string3;
            String string4 = string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_ONE_MAJ_TWO_MIN_PLUS_MNEMONIC ? BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(c2) + BTPeerIDByteDecoderUtils.intchar(c3) : BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(c2) + "." + BTPeerIDByteDecoderUtils.intchar(c3);
            if ((string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_THREE_DIGITS_PLUS_MNEMONIC || string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_ONE_MAJ_TWO_MIN_PLUS_MNEMONIC) && (string3 = BTPeerIDByteDecoderUtils.decodeMnemonic(c4)) != null) {
                string4 = string4 + " " + string3;
            }
            return string4;
        }
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_TWO_MAJ_TWO_MIN) {
            return (c == '0' ? "" : BTPeerIDByteDecoderUtils.intchar(c)) + BTPeerIDByteDecoderUtils.intchar(c2) + "." + BTPeerIDByteDecoderUtils.intchar(c3) + BTPeerIDByteDecoderUtils.intchar(c4);
        }
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_LAST_THREE_DIGITS) {
            return BTPeerIDByteDecoderUtils.intchar(c2) + "." + BTPeerIDByteDecoderUtils.intchar(c3) + "." + BTPeerIDByteDecoderUtils.intchar(c4);
        }
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_THREE_ALPHANUMERIC_DIGITS) {
            return BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c) + "." + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c2) + "." + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c3);
        }
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_SKIP_FIRST_ONE_MAJ_TWO_MIN) {
            return BTPeerIDByteDecoderUtils.intchar(c2) + "." + BTPeerIDByteDecoderUtils.intchar(c3) + BTPeerIDByteDecoderUtils.intchar(c4);
        }
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_AZ_KTORRENT_STYLE) {
            switch (c3) {
                case 'R': {
                    return BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(c2) + " RC" + BTPeerIDByteDecoderUtils.intchar(c4);
                }
                case 'D': {
                    return BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(c2) + " Dev";
                }
            }
            return BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(c2);
        }
        if (string2.equals("1.234")) {
            return BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(c2) + BTPeerIDByteDecoderUtils.intchar(c3) + BTPeerIDByteDecoderUtils.intchar(c4);
        }
        if (string2.equals("1.2(34)")) {
            return BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(c2) + "(" + BTPeerIDByteDecoderUtils.intchar(c3) + BTPeerIDByteDecoderUtils.intchar(c4) + ")";
        }
        if (string2.equals("1.2.34")) {
            return BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(c2) + "." + BTPeerIDByteDecoderUtils.intchar(c3) + BTPeerIDByteDecoderUtils.intchar(c4);
        }
        if (string2.equals("v1234")) {
            return "v" + BTPeerIDByteDecoderUtils.intchar(c) + BTPeerIDByteDecoderUtils.intchar(c2) + BTPeerIDByteDecoderUtils.intchar(c3) + BTPeerIDByteDecoderUtils.intchar(c4);
        }
        if (string2.equals("1.2")) {
            return BTPeerIDByteDecoderUtils.intchar(c) + "." + BTPeerIDByteDecoderUtils.intchar(c2);
        }
        if (string2.equals("3.4")) {
            return BTPeerIDByteDecoderUtils.intchar(c3) + "." + BTPeerIDByteDecoderUtils.intchar(c4);
        }
        if (string2.equals("12.3-4")) {
            return BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c) + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c2) + "." + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c3) + "-" + BTPeerIDByteDecoderUtils.decodeAlphaNumericChar(c4);
        }
        throw new RuntimeException("unknown AZ style version number scheme - " + string2);
    }

    public static String getTwoByteThreePartVersion(byte by, byte by2) {
        String string = BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(by2, 2);
        return BTPeerIDByteDecoderUtils.joinAsDotted(BTPeerIDByteDecoderUtils.decodeNumericValueOfByte(by), string.substring(0, 1), string.substring(1, 2));
    }

    public static String extractReadableVersionSubstringFromPeerID(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '.') continue;
            return string.substring(0, i);
        }
        return string;
    }

    public static String decodeCustomVersionNumber(String string, String string2) {
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_BLOCK) {
            return string;
        }
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_DOTTED_BLOCK || string2 == BTPeerIDByteDecoderDefinitions.VER_BYTE_BLOCK_DOTTED_CHAR) {
            int n = string2 == BTPeerIDByteDecoderDefinitions.VER_DOTTED_BLOCK ? 2 : 1;
            String string3 = string.substring(0, 1);
            for (int i = 0 + n; i < string.length(); i += n) {
                string3 = BTPeerIDByteDecoderUtils.joinAsDotted(string3, String.valueOf(string.charAt(i)));
            }
            return string3;
        }
        if (string2 == BTPeerIDByteDecoderDefinitions.VER_BITS_ON_WHEELS) {
            if (string.equals("A0C")) {
                return "1.0.6";
            }
            if (string.equals("A0B")) {
                return "1.0.5";
            }
            throw new RuntimeException("Unknown BitsOnWheels version number - " + string);
        }
        throw new RuntimeException("unknown custom version number scheme - " + string2);
    }

    private static String join(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return null;
        }
        return string + string2;
    }

    private static String joinAsDotted(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return null;
        }
        return string + "." + string2;
    }

    private static String joinAsDotted(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return null;
        }
        if (string3 == null) {
            return null;
        }
        return string + "." + string2 + "." + string3;
    }
}

