/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.SelectorGuard;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class VirtualChannelSelectorImpl {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final boolean MAYBE_BROKEN_SELECT;
    private boolean select_is_broken;
    private int select_looks_broken_count;
    private boolean logged_broken_select;
    protected Selector selector;
    private final SelectorGuard selector_guard;
    private final LinkedList<Object> register_cancel_list = new LinkedList();
    private final AEMonitor register_cancel_list_mon = new AEMonitor("VirtualChannelSelector:RCL");
    private final HashMap<AbstractSelectableChannel, Boolean> paused_states = new HashMap();
    private final int INTEREST_OP;
    private final boolean pause_after_select;
    protected final VirtualChannelSelector parent;
    private volatile boolean destroyed;
    private boolean randomise_keys;
    private int next_select_loop_pos = 0;
    private static final int WRITE_SELECTOR_DEBUG_CHECK_PERIOD = 10000;
    private static final int WRITE_SELECTOR_DEBUG_MAX_TIME = 20000;
    private long last_write_select_debug;
    private long last_select_debug;

    public VirtualChannelSelectorImpl(VirtualChannelSelector virtualChannelSelector, int n, boolean bl, boolean bl2) {
        String string;
        this.parent = virtualChannelSelector;
        this.INTEREST_OP = n;
        this.pause_after_select = bl;
        this.randomise_keys = bl2;
        switch (this.INTEREST_OP) {
            case 8: {
                string = "OP_CONNECT";
                break;
            }
            case 1: {
                string = "OP_READ";
                break;
            }
            default: {
                string = "OP_WRITE";
            }
        }
        this.selector_guard = new SelectorGuard(string, new SelectorGuard.GuardListener(){

            @Override
            public boolean safeModeSelectEnabled() {
                return VirtualChannelSelectorImpl.this.parent.isSafeSelectionModeEnabled();
            }

            @Override
            public void spinDetected() {
                VirtualChannelSelectorImpl.this.closeExistingSelector();
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.parent.enableSafeSelectionMode();
            }

            @Override
            public void failureDetected() {
                try {
                    Thread.sleep(10000L);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.closeExistingSelector();
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.selector = VirtualChannelSelectorImpl.this.openNewSelector();
            }
        });
        this.selector = this.openNewSelector();
    }

    protected Selector openNewSelector() {
        Selector selector = null;
        try {
            selector = Selector.open();
            AEDiagnostics.logWithStack("seltrace", "Selector created for '" + this.parent.getName() + "'," + this.selector_guard.getType());
        }
        catch (Throwable throwable) {
            Debug.out("ERROR: caught exception on Selector.open()", throwable);
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            int n = 1;
            while (n < 10) {
                try {
                    selector = Selector.open();
                    AEDiagnostics.logWithStack("seltrace", "Selector created for '" + this.parent.getName() + "'," + this.selector_guard.getType());
                    break;
                }
                catch (Throwable throwable3) {
                    Debug.out(throwable3);
                    ++n;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Throwable throwable4) {
                        throwable4.printStackTrace();
                    }
                }
            }
            if (n < 10) {
                Debug.out("NOTICE: socket Selector successfully opened after " + n + " failures.");
            }
            Logger.log(new LogAlert(true, 3, "ERROR: socket Selector.open() failed 10 times in a row, aborting.\nAzureus / Java is likely being firewalled!"));
        }
        return selector;
    }

    public void setRandomiseKeys(boolean bl) {
        this.randomise_keys = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSelects(AbstractSelectableChannel abstractSelectableChannel) {
        if (abstractSelectableChannel == null) {
            return;
        }
        SelectionKey selectionKey = abstractSelectableChannel.keyFor(this.selector);
        if (selectionKey != null && selectionKey.isValid()) {
            selectionKey.interestOps(selectionKey.interestOps() & ~this.INTEREST_OP);
        } else if (abstractSelectableChannel.isOpen()) {
            try {
                this.register_cancel_list_mon.enter();
                this.paused_states.put(abstractSelectableChannel, new Boolean(true));
            }
            finally {
                this.register_cancel_list_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSelects(AbstractSelectableChannel abstractSelectableChannel) {
        if (abstractSelectableChannel == null) {
            Debug.printStackTrace(new Exception("resumeSelects():: channel == null"));
            return;
        }
        SelectionKey selectionKey = abstractSelectableChannel.keyFor(this.selector);
        if (selectionKey != null && selectionKey.isValid()) {
            if ((selectionKey.interestOps() & this.INTEREST_OP) == 0) {
                RegistrationData registrationData = (RegistrationData)selectionKey.attachment();
                registrationData.last_select_success_time = SystemTime.getCurrentTime();
                registrationData.non_progress_count = 0;
            }
            selectionKey.interestOps(selectionKey.interestOps() | this.INTEREST_OP);
        } else {
            try {
                this.register_cancel_list_mon.enter();
                this.paused_states.remove(abstractSelectableChannel);
            }
            finally {
                this.register_cancel_list_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AbstractSelectableChannel abstractSelectableChannel) {
        if (this.destroyed) {
            // empty if block
        }
        if (abstractSelectableChannel == null) {
            Debug.out("Attempt to cancel selects for null channel");
            return;
        }
        try {
            this.register_cancel_list_mon.enter();
            Iterator iterator = this.register_cancel_list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (abstractSelectableChannel != e && (!(e instanceof RegistrationData) || ((RegistrationData)e).channel != abstractSelectableChannel)) continue;
                iterator.remove();
                break;
            }
            this.pauseSelects(abstractSelectableChannel);
            this.register_cancel_list.add(abstractSelectableChannel);
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AbstractSelectableChannel abstractSelectableChannel, VirtualChannelSelector.VirtualAbstractSelectorListener virtualAbstractSelectorListener, Object object) {
        if (this.destroyed) {
            Debug.out("register called after selector destroyed");
        }
        if (abstractSelectableChannel == null) {
            Debug.out("Attempt to register selects for null channel");
            return;
        }
        try {
            this.register_cancel_list_mon.enter();
            Iterator iterator = this.register_cancel_list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (abstractSelectableChannel != e && (!(e instanceof RegistrationData) || ((RegistrationData)e).channel != abstractSelectableChannel)) continue;
                iterator.remove();
                break;
            }
            this.paused_states.remove(abstractSelectableChannel);
            this.register_cancel_list.add(new RegistrationData(abstractSelectableChannel, virtualAbstractSelectorListener, object));
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int select(long l) {
        long l2;
        RegistrationData registrationData;
        boolean bl;
        ArrayList<SelectionKey> arrayList;
        Object object;
        Object object2;
        long l3 = SystemTime.getCurrentTime();
        if (this.selector == null) {
            Debug.out("VirtualChannelSelector.select() op called with null selector");
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return 0;
        }
        if (!this.selector.isOpen()) {
            Debug.out("VirtualChannelSelector.select() op called with closed selector");
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return 0;
        }
        Set<SelectionKey> set = null;
        Throwable throwable = null;
        try {
            this.register_cancel_list_mon.enter();
            while (this.register_cancel_list.size() > 0) {
                SelectionKey selectionKey;
                Object object3 = this.register_cancel_list.remove(0);
                if (object3 instanceof AbstractSelectableChannel) {
                    object2 = (AbstractSelectableChannel)object3;
                    try {
                        selectionKey = ((AbstractSelectableChannel)object2).keyFor(this.selector);
                        if (selectionKey == null) continue;
                        selectionKey.cancel();
                    }
                    catch (Throwable throwable2) {
                        Debug.printStackTrace(throwable2);
                    }
                    continue;
                }
                object2 = (RegistrationData)object3;
                if (object2 == null) {
                    Debug.out("data == null");
                } else if (((RegistrationData)object2).channel == null) {
                    Debug.out("data.channel == null");
                }
                try {
                    if (((RegistrationData)object2).channel.isOpen()) {
                        selectionKey = ((RegistrationData)object2).channel.keyFor(this.selector);
                        if (selectionKey != null && selectionKey.isValid()) {
                            selectionKey.attach(object2);
                            selectionKey.interestOps(selectionKey.interestOps() | this.INTEREST_OP);
                        } else {
                            ((RegistrationData)object2).channel.register(this.selector, this.INTEREST_OP, object2);
                        }
                        if ((object = this.paused_states.get(((RegistrationData)object2).channel)) == null) continue;
                        this.pauseSelects(((RegistrationData)object2).channel);
                        continue;
                    }
                    set = object2;
                    throwable = new Throwable("select registration: channel is closed");
                }
                catch (Throwable throwable3) {
                    Debug.printStackTrace(throwable3);
                    set = object2;
                    throwable = throwable3;
                }
            }
            this.paused_states.clear();
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
        if (set != null) {
            try {
                this.parent.selectFailure(((RegistrationData)((Object)set)).listener, ((RegistrationData)((Object)set)).channel, ((RegistrationData)((Object)set)).attachment, throwable);
            }
            catch (Throwable throwable4) {
                Debug.printStackTrace(throwable4);
            }
        }
        int n = 0;
        this.selector_guard.markPreSelectTime();
        try {
            n = this.selector.select(l);
        }
        catch (Throwable throwable5) {
            long l4 = SystemTime.getCurrentTime();
            if (this.last_select_debug > l4 || l4 - this.last_select_debug > 5000L) {
                this.last_select_debug = l4;
                String string = throwable5.getMessage();
                if (string == null || !string.equalsIgnoreCase("bad file descriptor")) {
                    Debug.out("Caught exception on selector.select() op: " + string, throwable5);
                }
            }
            try {
                Thread.sleep(l);
            }
            catch (Throwable throwable6) {
                throwable6.printStackTrace();
            }
        }
        if (this.destroyed) {
            this.closeExistingSelector();
            return 0;
        }
        if (MAYBE_BROKEN_SELECT && !this.select_is_broken && (this.INTEREST_OP == 1 || this.INTEREST_OP == 4)) {
            if (this.selector.selectedKeys().size() == 0) {
                object2 = this.selector.keys();
                Iterator<SelectionKey> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if ((((SelectionKey)object).readyOps() & this.INTEREST_OP) == 0) continue;
                    ++this.select_looks_broken_count;
                    break;
                }
                if (this.select_looks_broken_count >= 5) {
                    this.select_is_broken = true;
                    if (!this.logged_broken_select) {
                        this.logged_broken_select = true;
                        Debug.outNoStack("Select operation looks broken, trying workaround");
                    }
                }
            } else {
                this.select_looks_broken_count = 0;
            }
        }
        this.selector_guard.verifySelectorIntegrity(n, 12L);
        if (!this.selector.isOpen()) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        long l5 = SystemTime.getCurrentTime();
        HashSet<SelectionKey> hashSet = null;
        if (this.INTEREST_OP == 4 && (l5 < this.last_write_select_debug || l5 - this.last_write_select_debug > 10000L)) {
            this.last_write_select_debug = l5;
            hashSet = new HashSet<SelectionKey>(this.selector.keys());
        }
        if (MAYBE_BROKEN_SELECT && this.select_is_broken) {
            Set<SelectionKey> set2 = this.selector.keys();
            arrayList = new ArrayList();
            for (SelectionKey selectionKey : set2) {
                if ((selectionKey.readyOps() & this.INTEREST_OP) == 0) continue;
                arrayList.add(selectionKey);
            }
        } else {
            arrayList = new ArrayList<SelectionKey>(this.selector.selectedKeys());
        }
        if (bl = this.randomise_keys) {
            Collections.shuffle(arrayList);
        }
        Set<SelectionKey> set3 = this.selector.selectedKeys();
        int n4 = arrayList.size();
        int n5 = this.next_select_loop_pos++;
        int n6 = n5 + n4;
        for (int i = n5; i < n6; ++i) {
            SelectionKey selectionKey = (SelectionKey)arrayList.get(i % n4);
            ++n3;
            set3.remove(selectionKey);
            registrationData = (RegistrationData)selectionKey.attachment();
            if (hashSet != null) {
                hashSet.remove(selectionKey);
            }
            registrationData.last_select_success_time = l5;
            if (selectionKey.isValid()) {
                boolean bl2;
                if ((selectionKey.interestOps() & this.INTEREST_OP) == 0) continue;
                if (this.pause_after_select) {
                    try {
                        selectionKey.interestOps(selectionKey.interestOps() & ~this.INTEREST_OP);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        // empty catch block
                    }
                }
                if (bl2 = this.parent.selectSuccess(registrationData.listener, registrationData.channel, registrationData.attachment)) {
                    ++n2;
                    registrationData.non_progress_count = 0;
                    continue;
                }
                ++registrationData.non_progress_count;
                boolean bl3 = false;
                if (this.INTEREST_OP != 16) {
                    SocketChannel socketChannel = (SocketChannel)registrationData.channel;
                    bl3 = socketChannel.socket().getInetAddress().isLoopbackAddress();
                }
                if (bl3) {
                    if (registrationData.non_progress_count != 10000) continue;
                    Debug.out("No progress for " + registrationData.non_progress_count + ", closing connection");
                    try {
                        registrationData.channel.close();
                    }
                    catch (Throwable throwable7) {
                        throwable7.printStackTrace();
                    }
                    continue;
                }
                if (registrationData.non_progress_count != 10 && (registrationData.non_progress_count % 100 != 0 || registrationData.non_progress_count <= 0)) continue;
                Debug.out("VirtualChannelSelector: No progress for op " + this.INTEREST_OP + ": listener = " + registrationData.listener.getClass() + ", count = " + registrationData.non_progress_count + ", socket: open = " + registrationData.channel.isOpen() + (this.INTEREST_OP == 16 ? "" : ", connected = " + ((SocketChannel)registrationData.channel).isConnected()));
                if (registrationData.non_progress_count != 1000) continue;
                Debug.out("No progress for " + registrationData.non_progress_count + ", closing connection");
                try {
                    registrationData.channel.close();
                }
                catch (Throwable throwable8) {
                    throwable8.printStackTrace();
                }
                continue;
            }
            selectionKey.cancel();
            this.parent.selectFailure(registrationData.listener, registrationData.channel, registrationData.attachment, new Throwable("key is invalid"));
        }
        if (hashSet != null) {
            for (SelectionKey selectionKey : hashSet) {
                registrationData = (RegistrationData)selectionKey.attachment();
                try {
                    if ((selectionKey.interestOps() & this.INTEREST_OP) == 0) {
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {}
                continue;
                long l6 = l5 - registrationData.last_select_success_time;
                if (l6 < 0L) {
                    registrationData.last_select_success_time = l5;
                    continue;
                }
                if (l6 <= 20000L) continue;
                Logger.log(new LogEvent(LOGID, 1, "Write select for " + selectionKey.channel() + " stalled for " + l6));
                if (selectionKey.isValid()) {
                    if (this.pause_after_select) {
                        selectionKey.interestOps(selectionKey.interestOps() & ~this.INTEREST_OP);
                    }
                    if (!this.parent.selectSuccess(registrationData.listener, registrationData.channel, registrationData.attachment)) continue;
                    registrationData.non_progress_count = 0;
                    continue;
                }
                selectionKey.cancel();
                this.parent.selectFailure(registrationData.listener, registrationData.channel, registrationData.attachment, new Throwable("key is invalid"));
            }
        }
        if ((n3 == 0 || n2 != n3) && (l2 = SystemTime.getCurrentTime() - l3) < l && l2 >= 0L) {
            try {
                Thread.sleep(l - l2);
            }
            catch (Throwable throwable9) {
                throwable9.printStackTrace();
            }
        }
        return n;
    }

    public void destroy() {
        this.destroyed = true;
    }

    protected void closeExistingSelector() {
        for (SelectionKey selectionKey : this.selector.keys()) {
            RegistrationData registrationData = (RegistrationData)selectionKey.attachment();
            this.parent.selectFailure(registrationData.listener, registrationData.channel, registrationData.attachment, new Throwable("selector destroyed"));
        }
        try {
            this.selector.close();
            AEDiagnostics.log("seltrace", "Selector destroyed for '" + this.parent.getName() + "'," + this.selector_guard.getType());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        String string = System.getProperty("java.vm.name", "");
        boolean bl = string.startsWith("Diablo");
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            String string2;
            if (Constants.isFreeBSD || Constants.isLinux) {
                String string3 = System.getenv("OSTYPE");
                if (string3 != null && string3.equals("FreeBSD")) {
                    char c;
                    String string4 = System.getProperty("os.version", "");
                    String string5 = "";
                    for (int i = 0; i < string4.length() && Character.isDigit(c = string4.charAt(i)); ++i) {
                        string5 = string5 + c;
                    }
                    if (string5.length() > 0) {
                        bl2 = Integer.parseInt(string5) >= 7;
                    }
                }
            } else if (Constants.isOSX && (string2 = System.getProperty("os.version", "")).startsWith("10.6")) {
                bl3 = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        boolean bl4 = MAYBE_BROKEN_SELECT = bl2 || bl || bl3;
        if (MAYBE_BROKEN_SELECT) {
            System.out.println("Enabling broken select detection: diablo=" + bl + ", freebsd 7+=" + bl2 + ", osx 10.6=" + bl3);
        }
    }

    private static class RegistrationData {
        protected final AbstractSelectableChannel channel;
        protected final VirtualChannelSelector.VirtualAbstractSelectorListener listener;
        protected final Object attachment;
        protected int non_progress_count;
        protected long last_select_success_time;

        private RegistrationData(AbstractSelectableChannel abstractSelectableChannel, VirtualChannelSelector.VirtualAbstractSelectorListener virtualAbstractSelectorListener, Object object) {
            this.channel = abstractSelectableChannel;
            this.listener = virtualAbstractSelectorListener;
            this.attachment = object;
            this.last_select_success_time = SystemTime.getCurrentTime();
        }
    }
}

