/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SystemTime;

public class ProxyLoginHandler {
    private static final int READ_DONE = 0;
    private static final int READ_NOT_DONE = 1;
    private static final int READ_NO_PROGRESS = 2;
    public static InetSocketAddress DEFAULT_SOCKS_SERVER_ADDRESS;
    private static String default_socks_version;
    private static String default_socks_user;
    private static String default_socks_password;
    private final TCPTransportImpl proxy_connection;
    private final InetSocketAddress remote_address;
    private final ProxyListener proxy_listener;
    private final String mapped_ip;
    private int socks5_handshake_phase = 0;
    private int socks5_address_length;
    private long read_start_time = 0L;
    private final String socks_version;
    private final String socks_user;
    private final String socks_password;

    static void readConfig() {
        boolean bl = COConfigurationManager.getBooleanParameter("Proxy.Data.Same");
        String string = COConfigurationManager.getStringParameter(bl ? "Proxy.Host" : "Proxy.Data.Host");
        int n = 0;
        try {
            String string2 = COConfigurationManager.getStringParameter(bl ? "Proxy.Port" : "Proxy.Data.Port");
            string2 = string2.trim();
            if (string2.length() > 0) {
                n = Integer.parseInt(COConfigurationManager.getStringParameter(bl ? "Proxy.Port" : "Proxy.Data.Port"));
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        DEFAULT_SOCKS_SERVER_ADDRESS = new InetSocketAddress(string, n);
        default_socks_version = COConfigurationManager.getStringParameter("Proxy.Data.SOCKS.version");
        default_socks_user = COConfigurationManager.getStringParameter(bl ? "Proxy.Username" : "Proxy.Data.Username");
        if (default_socks_user.trim().equalsIgnoreCase("<none>")) {
            default_socks_user = "";
        }
        default_socks_password = COConfigurationManager.getStringParameter(bl ? "Proxy.Password" : "Proxy.Data.Password");
    }

    public ProxyLoginHandler(TCPTransportImpl tCPTransportImpl, InetSocketAddress inetSocketAddress, ProxyListener proxyListener) {
        this(tCPTransportImpl, inetSocketAddress, proxyListener, default_socks_version, default_socks_user, default_socks_password);
    }

    public ProxyLoginHandler(TCPTransportImpl tCPTransportImpl, InetSocketAddress inetSocketAddress, ProxyListener proxyListener, String string, String string2, String string3) {
        this.proxy_connection = tCPTransportImpl;
        this.remote_address = inetSocketAddress;
        this.proxy_listener = proxyListener;
        this.socks_version = string;
        this.socks_user = string2;
        this.socks_password = string3;
        this.mapped_ip = this.remote_address.isUnresolved() || this.remote_address.getAddress() == null ? AEProxyFactory.getAddressMapper().internalise(this.remote_address.getHostName()) : this.remote_address.getAddress().getHostName();
        if (this.socks_version.equals("V4")) {
            try {
                this.doSocks4Login(this.createSocks4Message());
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
                this.proxy_listener.connectFailure(throwable);
            }
        } else if (this.socks_version.equals("V4a")) {
            try {
                this.doSocks4Login(this.createSocks4aMessage());
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
                this.proxy_listener.connectFailure(throwable);
            }
        } else {
            this.doSocks5Login();
        }
    }

    private void doSocks4Login(final ByteBuffer[] byteBufferArray) {
        try {
            this.sendMessage(byteBufferArray[0]);
            TCPNetworkManager.getSingleton().getReadSelector().register(this.proxy_connection.getSocketChannel(), new VirtualChannelSelector.VirtualSelectorListener(){

                @Override
                public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                    try {
                        int n = ProxyLoginHandler.this.readMessage(byteBufferArray[1]);
                        if (n == 0) {
                            TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                            ProxyLoginHandler.this.parseSocks4Reply(byteBufferArray[1]);
                            ProxyLoginHandler.this.proxy_listener.connectSuccess();
                        } else {
                            TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                        }
                        return n != 2;
                    }
                    catch (Throwable throwable) {
                        TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                        ProxyLoginHandler.this.proxy_listener.connectFailure(throwable);
                        return false;
                    }
                }

                @Override
                public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                    Debug.out(throwable);
                    TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                    ProxyLoginHandler.this.proxy_listener.connectFailure(throwable);
                }
            }, null);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            TCPNetworkManager.getSingleton().getReadSelector().cancel(this.proxy_connection.getSocketChannel());
            this.proxy_listener.connectFailure(throwable);
        }
    }

    private void doSocks5Login() {
        try {
            final ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(2);
            ByteBuffer[] byteBufferArray = this.createSocks5Message();
            arrayList.add(byteBufferArray[0]);
            arrayList.add(byteBufferArray[1]);
            this.sendMessage((ByteBuffer)arrayList.get(0));
            TCPNetworkManager.getSingleton().getReadSelector().register(this.proxy_connection.getSocketChannel(), new VirtualChannelSelector.VirtualSelectorListener(){

                @Override
                public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                    try {
                        int n = ProxyLoginHandler.this.readMessage((ByteBuffer)arrayList.get(1));
                        if (n == 0) {
                            boolean bl = ProxyLoginHandler.this.parseSocks5Reply((ByteBuffer)arrayList.get(1));
                            if (bl) {
                                TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                                ProxyLoginHandler.this.proxy_listener.connectSuccess();
                            } else {
                                ByteBuffer[] byteBufferArray = ProxyLoginHandler.this.createSocks5Message();
                                arrayList.set(0, byteBufferArray[0]);
                                arrayList.set(1, byteBufferArray[1]);
                                if (byteBufferArray[0] != null) {
                                    ProxyLoginHandler.this.sendMessage(byteBufferArray[0]);
                                }
                                TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                            }
                        } else {
                            TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                        }
                        return n != 2;
                    }
                    catch (Throwable throwable) {
                        TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                        ProxyLoginHandler.this.proxy_listener.connectFailure(throwable);
                        return false;
                    }
                }

                @Override
                public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                    Debug.out(throwable);
                    TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                    ProxyLoginHandler.this.proxy_listener.connectFailure(throwable);
                }
            }, null);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            SocketChannel socketChannel = this.proxy_connection.getSocketChannel();
            if (socketChannel != null) {
                TCPNetworkManager.getSingleton().getReadSelector().cancel(socketChannel);
            }
            this.proxy_listener.connectFailure(throwable);
        }
    }

    private void parseSocks4Reply(ByteBuffer byteBuffer) throws IOException {
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        if (by != 0 || by2 != 90) {
            throw new IOException("SOCKS 4(a): connection declined [" + by + "/" + by2 + "]");
        }
    }

    private void sendMessage(ByteBuffer byteBuffer) throws IOException {
        long l = SystemTime.getCurrentTime();
        while (byteBuffer.hasRemaining()) {
            if (this.proxy_connection.write(new ByteBuffer[]{byteBuffer}, 0, 1) >= 1L) continue;
            if (SystemTime.getCurrentTime() - l > 30000L) {
                String string = "proxy handshake message send timed out after 30sec";
                Debug.out(string);
                throw new IOException(string);
            }
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private int readMessage(ByteBuffer byteBuffer) throws IOException {
        if (this.read_start_time == 0L) {
            this.read_start_time = SystemTime.getCurrentTime();
        }
        long l = this.proxy_connection.read(new ByteBuffer[]{byteBuffer}, 0, 1);
        if (!byteBuffer.hasRemaining()) {
            byteBuffer.position(0);
            this.read_start_time = 0L;
            return 0;
        }
        if (SystemTime.getCurrentTime() - this.read_start_time > 30000L) {
            String string = "proxy message read timed out after 30sec";
            Debug.out(string);
            throw new IOException(string);
        }
        return l == 0L ? 2 : 1;
    }

    private ByteBuffer[] createSocks4Message() throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(256 + this.mapped_ip.length());
        byteBuffer.put((byte)4);
        byteBuffer.put((byte)1);
        byteBuffer.putShort((short)this.remote_address.getPort());
        byte[] byArray = HostNameToIPResolver.syncResolve(this.remote_address.getAddress().getHostAddress()).getAddress();
        byteBuffer.put(byArray[0]);
        byteBuffer.put(byArray[1]);
        byteBuffer.put(byArray[2]);
        byteBuffer.put(byArray[3]);
        if (this.socks_user.length() > 0) {
            byteBuffer.put(this.socks_user.getBytes());
        }
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        return new ByteBuffer[]{byteBuffer, ByteBuffer.allocate(8)};
    }

    private ByteBuffer[] createSocks4aMessage() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(256 + this.mapped_ip.length());
        byteBuffer.put((byte)4);
        byteBuffer.put((byte)1);
        byteBuffer.putShort((short)this.remote_address.getPort());
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)1);
        if (this.socks_user.length() > 0) {
            byteBuffer.put(this.socks_user.getBytes());
        }
        byteBuffer.put((byte)0);
        byteBuffer.put(this.mapped_ip.getBytes());
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        return new ByteBuffer[]{byteBuffer, ByteBuffer.allocate(8)};
    }

    private ByteBuffer[] createSocks5Message() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(256 + this.mapped_ip.length());
        if (this.socks5_handshake_phase == 0) {
            byteBuffer.put((byte)5);
            byteBuffer.put((byte)2);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)2);
            byteBuffer.flip();
            this.socks5_handshake_phase = 1;
            return new ByteBuffer[]{byteBuffer, ByteBuffer.allocate(2)};
        }
        if (this.socks5_handshake_phase == 1) {
            byteBuffer.put((byte)1);
            byteBuffer.put((byte)this.socks_user.length());
            byteBuffer.put(this.socks_user.getBytes());
            byteBuffer.put((byte)this.socks_password.length());
            byteBuffer.put(this.socks_password.getBytes());
            byteBuffer.flip();
            this.socks5_handshake_phase = 2;
            return new ByteBuffer[]{byteBuffer, ByteBuffer.allocate(2)};
        }
        if (this.socks5_handshake_phase == 2) {
            byteBuffer.put((byte)5);
            byteBuffer.put((byte)1);
            byteBuffer.put((byte)0);
            try {
                byte[] byArray = HostNameToIPResolver.syncResolve(this.mapped_ip).getAddress();
                byteBuffer.put((byte)1);
                byteBuffer.put(byArray[0]);
                byteBuffer.put(byArray[1]);
                byteBuffer.put(byArray[2]);
                byteBuffer.put(byArray[3]);
            }
            catch (Throwable throwable) {
                byteBuffer.put((byte)3);
                byteBuffer.put((byte)this.mapped_ip.length());
                byteBuffer.put(this.mapped_ip.getBytes());
            }
            byteBuffer.putShort((short)this.remote_address.getPort());
            byteBuffer.flip();
            this.socks5_handshake_phase = 3;
            return new ByteBuffer[]{byteBuffer, ByteBuffer.allocate(5)};
        }
        this.socks5_handshake_phase = 4;
        return new ByteBuffer[]{null, ByteBuffer.allocate(this.socks5_address_length)};
    }

    private boolean parseSocks5Reply(ByteBuffer byteBuffer) throws IOException {
        if (this.socks5_handshake_phase == 1) {
            byteBuffer.get();
            byte by = byteBuffer.get();
            if (by != 0 && by != 2) {
                throw new IOException("SOCKS 5: no valid method [" + by + "]");
            }
            if (by == 0) {
                this.socks5_handshake_phase = 2;
            }
            return false;
        }
        if (this.socks5_handshake_phase == 2) {
            byteBuffer.get();
            byte by = byteBuffer.get();
            if (by != 0) {
                throw new IOException("SOCKS 5: authentication fails [status=" + by + "]");
            }
            return false;
        }
        if (this.socks5_handshake_phase == 3) {
            byteBuffer.get();
            byte by = byteBuffer.get();
            if (by != 0) {
                String[] stringArray = new String[]{"", "General SOCKS server failure", "connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused", "TTL expired", "Command not supported", "Address type not supported"};
                String string = by < stringArray.length ? stringArray[by] : "Unknown error";
                throw new IOException("SOCKS request failure [" + string + "/" + by + "]");
            }
            byteBuffer.get();
            byte by2 = byteBuffer.get();
            byte by3 = byteBuffer.get();
            this.socks5_address_length = by2 == 1 ? 3 : (by2 == 3 ? (int)by3 : 15);
            this.socks5_address_length += 2;
            return false;
        }
        return true;
    }

    static {
        COConfigurationManager.addListener(new COConfigurationListener(){

            @Override
            public void configurationSaved() {
                ProxyLoginHandler.readConfig();
            }
        });
        ProxyLoginHandler.readConfig();
    }

    public static interface ProxyListener {
        public void connectSuccess();

        public void connectFailure(Throwable var1);
    }
}

