/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderPHE;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public abstract class ProtocolDecoder {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final int TIMEOUT_CHECK = 5000;
    private static final int LOG_TICKS = 12;
    private static List decoders = new ArrayList();
    private static AEMonitor class_mon = new AEMonitor("TCPProtocolDecoder:class");
    private static int loop = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProtocolDecoder(boolean bl) {
        if (bl) {
            try {
                class_mon.enter();
                decoders.add(this);
            }
            finally {
                class_mon.exit();
            }
        }
    }

    public abstract boolean isComplete(long var1);

    public abstract TransportHelperFilter getFilter();

    public static void addSecrets(byte[][] byArray) {
        ProtocolDecoderPHE.addSecretsSupport(byArray);
    }

    public static void removeSecrets(byte[][] byArray) {
        ProtocolDecoderPHE.removeSecretsSupport(byArray);
    }

    static {
        SimpleTimer.addPeriodicEvent("ProtocolDecoder:timeouts", 5000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent timerEvent2) {
                loop++;
                long l = SystemTime.getCurrentTime();
                try {
                    class_mon.enter();
                    if (loop % 12 == 0 && Logger.isEnabled() && decoders.size() > 0) {
                        Logger.log(new LogEvent(LOGID, "Active protocol decoders = " + decoders.size()));
                    }
                    boolean bl = true;
                    block3: while (bl) {
                        bl = false;
                        for (int i = 0; i < decoders.size(); ++i) {
                            ProtocolDecoder protocolDecoder = (ProtocolDecoder)decoders.get(i);
                            if (!protocolDecoder.isComplete(l)) continue;
                            decoders.remove(protocolDecoder);
                            bl = true;
                            continue block3;
                        }
                    }
                }
                finally {
                    class_mon.exit();
                }
            }
        });
    }
}

