/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class MultiPeerUploader
implements RateControlledEntity {
    private static final int FLUSH_CHECK_LOOP_TIME = 500;
    private static final int FLUSH_WAIT_TIME = 3000;
    private long last_flush_check_time = 0L;
    private final RateHandler rate_handler;
    private boolean destroyed = false;
    private final HashMap waiting_connections = new HashMap();
    private final LinkedList ready_connections = new LinkedList();
    private final AEMonitor lists_lock = new AEMonitor("PacketFillingMultiPeerUploader:lists_lock");

    public MultiPeerUploader(RateHandler rateHandler) {
        this.rate_handler = rateHandler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.rate_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCheck() {
        long l = SystemTime.getCurrentTime() - this.last_flush_check_time;
        if (!(this.destroyed || l <= 500L && l >= 0L)) {
            try {
                this.lists_lock.enter();
                long l2 = SystemTime.getCurrentTime();
                Iterator iterator = this.waiting_connections.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    PeerData peerData = (PeerData)entry.getValue();
                    long l3 = l2 - peerData.last_message_added_time;
                    if (l3 <= 3000L && l3 >= 0L) continue;
                    NetworkConnectionBase networkConnectionBase = (NetworkConnectionBase)entry.getKey();
                    if (networkConnectionBase.getOutgoingMessageQueue().getTotalSize() > 0) {
                        networkConnectionBase.getOutgoingMessageQueue().cancelQueueListener(peerData.queue_listener);
                        iterator.remove();
                        this.addToReadyList(networkConnectionBase);
                        continue;
                    }
                    peerData.last_message_added_time = l2;
                }
            }
            finally {
                this.lists_lock.exit();
            }
            this.last_flush_check_time = SystemTime.getCurrentTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        try {
            this.lists_lock.enter();
            for (Map.Entry entry : this.waiting_connections.entrySet()) {
                NetworkConnectionBase networkConnectionBase = (NetworkConnectionBase)entry.getKey();
                PeerData peerData = (PeerData)entry.getValue();
                networkConnectionBase.getOutgoingMessageQueue().cancelQueueListener(peerData.queue_listener);
            }
            this.waiting_connections.clear();
            this.ready_connections.clear();
        }
        finally {
            this.lists_lock.exit();
        }
    }

    public void addPeerConnection(NetworkConnectionBase networkConnectionBase) {
        int n = networkConnectionBase.getMssSize();
        boolean bl = networkConnectionBase.getOutgoingMessageQueue().hasUrgentMessage();
        int n2 = networkConnectionBase.getOutgoingMessageQueue().getTotalSize();
        if (n2 >= n || bl) {
            this.addToReadyList(networkConnectionBase);
        } else {
            this.addToWaitingList(networkConnectionBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePeerConnection(NetworkConnectionBase networkConnectionBase) {
        try {
            this.lists_lock.enter();
            PeerData peerData = (PeerData)this.waiting_connections.remove(networkConnectionBase);
            if (peerData != null) {
                networkConnectionBase.getOutgoingMessageQueue().cancelQueueListener(peerData.queue_listener);
                boolean bl = true;
                return bl;
            }
            if (this.ready_connections.remove(networkConnectionBase)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lists_lock.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToWaitingList(final NetworkConnectionBase networkConnectionBase) {
        final PeerData peerData = new PeerData();
        OutgoingMessageQueue.MessageQueueListener messageQueueListener = new OutgoingMessageQueue.MessageQueueListener(){

            @Override
            public boolean messageAdded(Message message) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageQueued(Message message) {
                try {
                    MultiPeerUploader.this.lists_lock.enter();
                    if (MultiPeerUploader.this.waiting_connections.get(networkConnectionBase) == null) {
                        return;
                    }
                    int n = networkConnectionBase.getMssSize();
                    boolean bl = networkConnectionBase.getOutgoingMessageQueue().hasUrgentMessage();
                    int n2 = networkConnectionBase.getOutgoingMessageQueue().getTotalSize();
                    if (n2 >= n || bl) {
                        MultiPeerUploader.this.waiting_connections.remove(networkConnectionBase);
                        networkConnectionBase.getOutgoingMessageQueue().cancelQueueListener(this);
                        MultiPeerUploader.this.addToReadyList(networkConnectionBase);
                    } else if (!peerData.bumped) {
                        peerData.bumped = true;
                        peerData.last_message_added_time = SystemTime.getCurrentTime();
                    }
                }
                finally {
                    MultiPeerUploader.this.lists_lock.exit();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flush() {
                try {
                    MultiPeerUploader.this.lists_lock.enter();
                    if (MultiPeerUploader.this.waiting_connections.remove(networkConnectionBase) != null) {
                        networkConnectionBase.getOutgoingMessageQueue().cancelQueueListener(this);
                        MultiPeerUploader.this.addToReadyList(networkConnectionBase);
                    }
                }
                finally {
                    MultiPeerUploader.this.lists_lock.exit();
                }
            }

            @Override
            public void messageRemoved(Message message) {
            }

            @Override
            public void messageSent(Message message) {
            }

            @Override
            public void protocolBytesSent(int n) {
            }

            @Override
            public void dataBytesSent(int n) {
            }
        };
        peerData.queue_listener = messageQueueListener;
        peerData.last_message_added_time = SystemTime.getCurrentTime();
        peerData.bumped = false;
        try {
            this.lists_lock.enter();
            this.waiting_connections.put(networkConnectionBase, peerData);
            networkConnectionBase.getOutgoingMessageQueue().registerQueueListener(messageQueueListener);
        }
        finally {
            this.lists_lock.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToReadyList(NetworkConnectionBase networkConnectionBase) {
        try {
            this.lists_lock.enter();
            this.ready_connections.addLast(networkConnectionBase);
        }
        finally {
            this.lists_lock.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(EventWaiter eventWaiter, int n) {
        int n2;
        if (n < 1) {
            Debug.out("num_bytes_to_write < 1");
            return 0;
        }
        HashMap<NetworkConnectionBase, Throwable> hashMap = new HashMap<NetworkConnectionBase, Throwable>();
        ArrayList<NetworkConnectionBase> arrayList = new ArrayList<NetworkConnectionBase>();
        int n3 = n;
        try {
            this.lists_lock.enter();
            n2 = 0;
            while (n3 > 0 && n2 < this.ready_connections.size()) {
                int n4;
                NetworkConnectionBase object2 = (NetworkConnectionBase)this.ready_connections.removeFirst();
                if (!object2.getTransportBase().isReadyForWrite(eventWaiter)) {
                    this.ready_connections.addLast(object2);
                    ++n2;
                    continue;
                }
                int n5 = object2.getOutgoingMessageQueue().getTotalSize();
                if (n5 < 1) {
                    this.addToWaitingList(object2);
                    continue;
                }
                int n6 = object2.getMssSize();
                int n7 = n3 > n6 ? n6 : n3;
                int n8 = n4 = n5 > n6 ? n6 : n5;
                if (n7 >= n4) {
                    int n9 = 0;
                    try {
                        n9 = object2.getOutgoingMessageQueue().deliverToTransport(n4, true);
                        if (n9 > 0) {
                            arrayList.add(object2);
                        }
                        boolean bl = object2.getOutgoingMessageQueue().hasUrgentMessage();
                        int n10 = object2.getOutgoingMessageQueue().getTotalSize();
                        if (n10 >= n6 || bl) {
                            this.ready_connections.addLast(object2);
                            n2 = 0;
                        } else {
                            this.addToWaitingList(object2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof IOException)) {
                            Debug.printStackTrace(throwable);
                        }
                        hashMap.put(object2, throwable);
                        this.addToWaitingList(object2);
                    }
                    n3 -= n9;
                    continue;
                }
                this.ready_connections.addLast(object2);
                ++n2;
            }
        }
        finally {
            this.lists_lock.exit();
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            NetworkConnectionBase networkConnectionBase = (NetworkConnectionBase)arrayList.get(n2);
            networkConnectionBase.getOutgoingMessageQueue().doListenerNotifications();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            NetworkConnectionBase networkConnectionBase = (NetworkConnectionBase)entry.getKey();
            Throwable throwable = (Throwable)entry.getValue();
            networkConnectionBase.notifyOfException(throwable);
        }
        int n11 = n - n3;
        if (n11 > 0) {
            this.rate_handler.bytesProcessed(n11);
        }
        return n11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBytesReadyToWrite() {
        long l = 0L;
        try {
            this.lists_lock.enter();
            for (NetworkConnectionBase networkConnectionBase : this.waiting_connections.keySet()) {
                l += (long)networkConnectionBase.getOutgoingMessageQueue().getTotalSize();
            }
            for (NetworkConnectionBase networkConnectionBase : this.ready_connections) {
                l += (long)networkConnectionBase.getOutgoingMessageQueue().getTotalSize();
            }
        }
        finally {
            this.lists_lock.exit();
        }
        return l;
    }

    @Override
    public int getConnectionCount() {
        return this.waiting_connections.size() + this.ready_connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReadyConnectionCount(EventWaiter eventWaiter) {
        int n = 0;
        try {
            this.lists_lock.enter();
            for (NetworkConnectionBase networkConnectionBase : this.waiting_connections.keySet()) {
                if (!networkConnectionBase.getTransportBase().isReadyForWrite(eventWaiter)) continue;
                ++n;
            }
            for (NetworkConnectionBase networkConnectionBase : this.ready_connections) {
                if (!networkConnectionBase.getTransportBase().isReadyForWrite(eventWaiter)) continue;
                ++n;
            }
        }
        finally {
            this.lists_lock.exit();
        }
        return n;
    }

    @Override
    public boolean canProcess(EventWaiter eventWaiter) {
        this.flushCheck();
        if (this.ready_connections.isEmpty()) {
            return false;
        }
        return this.rate_handler.getCurrentNumBytesAllowed() >= 1;
    }

    @Override
    public int doProcessing(EventWaiter eventWaiter, int n) {
        int n2 = this.rate_handler.getCurrentNumBytesAllowed();
        if (n2 < 1) {
            return 0;
        }
        if (n > 0 && n < n2) {
            n2 = n;
        }
        return this.write(eventWaiter, n2);
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean getPriorityBoost() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MPU (" + this.waiting_connections.size() + "/" + this.ready_connections.size() + "): ");
        stringBuffer.append("can_process=" + this.canProcess(null) + ",bytes_allowed=" + this.rate_handler.getCurrentNumBytesAllowed() + ", waiting=");
        try {
            this.lists_lock.enter();
            int n = 0;
            for (NetworkConnectionBase networkConnectionBase : this.waiting_connections.keySet()) {
                if (n++ > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(networkConnectionBase.getString());
            }
            stringBuffer.append(": ready=");
            n = 0;
            for (NetworkConnectionBase networkConnectionBase : this.ready_connections) {
                if (n++ > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(networkConnectionBase.getString());
            }
        }
        finally {
            this.lists_lock.exit();
        }
        return stringBuffer.toString();
    }

    private static class PeerData {
        private OutgoingMessageQueue.MessageQueueListener queue_listener;
        private long last_message_added_time;
        private boolean bumped;

        private PeerData() {
        }
    }
}

