/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web;

import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchLoginException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.DateParser;
import com.aelitis.azureus.core.metasearch.impl.DateParserRegex;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.CookieParser;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.util.GeneralUtils;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class WebEngine
extends EngineImpl {
    public static final String AM_TRANSPARENT = "transparent";
    public static final String AM_PROXY = "proxy";
    private static final Pattern baseTagPattern = Pattern.compile("(?i)<base.*?href=\"([^\"]+)\".*?>");
    private static final Pattern rootURLPattern = Pattern.compile("(https?://[^/]+)");
    private static final Pattern baseURLPattern = Pattern.compile("(https?://.*/)");
    private String searchURLFormat;
    private String timeZone;
    private boolean automaticDateParser;
    private String userDateFormat;
    private String downloadLinkCSS;
    private FieldMapping[] mappings;
    private String rootPage;
    private String basePage;
    private DateParser dateParser;
    private boolean needsAuth;
    private String authMethod;
    private String loginPageUrl;
    private String[] requiredCookies;
    private String local_cookies;

    public WebEngine(MetaSearchImpl metaSearchImpl, int n, long l, long l2, float f, String string, String string2, String string3, boolean bl, String string4, FieldMapping[] fieldMappingArray, boolean bl2, String string5, String string6, String[] stringArray) {
        super(metaSearchImpl, n, l, l2, f, string);
        this.searchURLFormat = string2;
        this.timeZone = string3;
        this.automaticDateParser = bl;
        this.userDateFormat = string4;
        this.mappings = fieldMappingArray;
        this.needsAuth = bl2;
        this.authMethod = string5;
        this.loginPageUrl = string6;
        this.requiredCookies = stringArray;
        this.init();
    }

    protected WebEngine(MetaSearchImpl metaSearchImpl, Map map) throws IOException {
        super(metaSearchImpl, map);
        this.searchURLFormat = ImportExportUtils.importString(map, "web.search_url_format");
        this.timeZone = ImportExportUtils.importString(map, "web.time_zone");
        this.userDateFormat = ImportExportUtils.importString(map, "web.date_format");
        this.downloadLinkCSS = ImportExportUtils.importString(map, "web.dl_link_css");
        this.needsAuth = ImportExportUtils.importBoolean(map, "web.needs_auth", false);
        this.authMethod = ImportExportUtils.importString(map, "web.auth_method", AM_TRANSPARENT);
        this.loginPageUrl = ImportExportUtils.importString(map, "web.login_page");
        this.requiredCookies = ImportExportUtils.importStringArray(map, "web.required_cookies");
        this.automaticDateParser = ImportExportUtils.importBoolean(map, "web.auto_date", true);
        List list = (List)map.get("web.maps");
        this.mappings = new FieldMapping[list.size()];
        for (int i = 0; i < this.mappings.length; ++i) {
            Map map2 = (Map)list.get(i);
            this.mappings[i] = new FieldMapping(ImportExportUtils.importString(map2, "name"), ((Long)map2.get("field")).intValue());
        }
        this.init();
    }

    @Override
    protected void exportToBencodedMap(Map map) throws IOException {
        super.exportToBencodedMap(map);
        ImportExportUtils.exportString(map, "web.search_url_format", this.searchURLFormat);
        ImportExportUtils.exportString(map, "web.time_zone", this.timeZone);
        ImportExportUtils.exportString(map, "web.date_format", this.userDateFormat);
        ImportExportUtils.exportString(map, "web.dl_link_css", this.downloadLinkCSS);
        ImportExportUtils.exportBoolean(map, "web.needs_auth", this.needsAuth);
        ImportExportUtils.exportString(map, "web.auth_method", this.authMethod);
        ImportExportUtils.exportString(map, "web.login_page", this.loginPageUrl);
        ImportExportUtils.exportStringArray(map, "web.required_cookies", this.requiredCookies);
        ImportExportUtils.exportBoolean(map, "web.auto_date", this.automaticDateParser);
        ArrayList arrayList = new ArrayList();
        map.put("web.maps", arrayList);
        for (int i = 0; i < this.mappings.length; ++i) {
            FieldMapping fieldMapping = this.mappings[i];
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            ImportExportUtils.exportString(hashMap, "name", fieldMapping.getName());
            hashMap.put("field", new Long(fieldMapping.getField()));
            arrayList.add(hashMap);
        }
    }

    protected WebEngine(MetaSearchImpl metaSearchImpl, int n, long l, long l2, float f, String string, JSONObject jSONObject) throws IOException {
        super(metaSearchImpl, n, l, l2, f, string, jSONObject);
        this.searchURLFormat = ImportExportUtils.importURL(jSONObject, "searchURL");
        this.timeZone = ImportExportUtils.importString(jSONObject, "timezone");
        this.userDateFormat = ImportExportUtils.importString(jSONObject, "time_format");
        this.downloadLinkCSS = ImportExportUtils.importURL(jSONObject, "download_link");
        this.needsAuth = ImportExportUtils.importBoolean(jSONObject, "needs_auth", false);
        this.authMethod = ImportExportUtils.importString(jSONObject, "auth_method", AM_TRANSPARENT);
        this.loginPageUrl = ImportExportUtils.importURL(jSONObject, "login_page");
        this.requiredCookies = ImportExportUtils.importStringArray(jSONObject, "required_cookies");
        this.automaticDateParser = this.userDateFormat == null || this.userDateFormat.trim().length() == 0;
        List list = (List)jSONObject.get("column_map");
        ArrayList<FieldMapping> arrayList = new ArrayList<FieldMapping>();
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            Map map = (Map)list.get(i);
            Map map2 = (Map)map.get("mapping");
            if (map2 != null) {
                map = map2;
            }
            String string2 = ImportExportUtils.importString(map, "vuze_field").toUpperCase();
            String string3 = ImportExportUtils.importString(map, "group_nb");
            if (string3 == null) {
                string3 = ImportExportUtils.importString(map, "field_name");
            }
            if (string2 == null || string3 == null) {
                this.log("Missing field mapping name/value in '" + map + "'");
            }
            if ((n2 = this.vuzeFieldToID(string2)) == -1) {
                this.log("Unrecognised field mapping '" + string2 + "'");
                continue;
            }
            arrayList.add(new FieldMapping(string3, n2));
        }
        this.mappings = arrayList.toArray(new FieldMapping[arrayList.size()]);
        this.init();
    }

    @Override
    protected void exportToJSONObject(JSONObject jSONObject) throws IOException {
        super.exportToJSONObject(jSONObject);
        ImportExportUtils.exportJSONURL(jSONObject, "searchURL", this.searchURLFormat);
        ImportExportUtils.exportJSONString(jSONObject, "timezone", this.timeZone);
        if (this.downloadLinkCSS != null) {
            ImportExportUtils.exportJSONURL(jSONObject, "download_link", this.downloadLinkCSS);
        }
        ImportExportUtils.exportJSONBoolean(jSONObject, "needs_auth", this.needsAuth);
        ImportExportUtils.exportJSONString(jSONObject, "auth_method", this.authMethod);
        ImportExportUtils.exportJSONURL(jSONObject, "login_page", this.loginPageUrl);
        ImportExportUtils.exportJSONStringArray(jSONObject, "required_cookies", this.requiredCookies);
        if (!this.automaticDateParser) {
            ImportExportUtils.exportJSONString(jSONObject, "time_format", this.userDateFormat);
        }
        JSONArray jSONArray = new JSONArray();
        jSONObject.put("column_map", jSONArray);
        for (int i = 0; i < this.mappings.length; ++i) {
            FieldMapping fieldMapping = this.mappings[i];
            int n = fieldMapping.getField();
            String string = this.vuzeIDToField(n);
            if (string == null) {
                this.log("JSON export: unknown field id " + n);
                continue;
            }
            JSONObject jSONObject2 = new JSONObject();
            jSONArray.add(jSONObject2);
            jSONObject2.put("vuze_field", string);
            if (this.getType() == 2) {
                jSONObject2.put("field_name", fieldMapping.getName());
                continue;
            }
            jSONObject2.put("group_nb", fieldMapping.getName());
        }
    }

    protected void init() {
        Matcher matcher;
        try {
            matcher = rootURLPattern.matcher(this.searchURLFormat);
            if (matcher.find()) {
                this.rootPage = matcher.group(1);
            }
        }
        catch (Exception exception) {
            this.rootPage = null;
        }
        try {
            matcher = baseURLPattern.matcher(this.searchURLFormat);
            if (matcher.find()) {
                this.basePage = matcher.group(1);
            }
        }
        catch (Exception exception) {
            this.basePage = null;
        }
        this.dateParser = new DateParserRegex(this.timeZone, this.automaticDateParser, this.userDateFormat);
        this.local_cookies = this.getLocalString("cookies");
        this.authMethod = this.authMethod.intern();
        int n = this.searchURLFormat.indexOf(":COOKIE:");
        if (n != -1) {
            String string = this.searchURLFormat.substring(n + 8);
            this.setNeedsAuth(true);
            this.setCookies(string);
            this.setRequiredCookies(CookieParser.getCookiesNames(string));
            this.searchURLFormat = this.searchURLFormat.substring(0, n);
            this.setPublic(false);
            String string2 = this.getName();
            int n2 = string2.indexOf(":COOKIE:");
            if (n2 != -1) {
                this.setName(string2.substring(0, n2));
            }
        }
    }

    @Override
    public String getNameEx() {
        String string;
        String string2 = this.getRootPage();
        if (string2 == null || string2.length() == 0) {
            string2 = this.searchURLFormat;
        }
        if ((string = this.getName()).indexOf(string2) == -1) {
            return string + " (" + string2 + ")";
        }
        return string;
    }

    @Override
    public String getReferer() {
        return this.getRootPage();
    }

    @Override
    public boolean supportsContext(String string) {
        try {
            URL uRL = new URL(this.searchURLFormat);
            String string2 = uRL.getHost();
            if (Constants.isAzureusDomain(string2)) {
                return true;
            }
            if (UrlFilter.getInstance().isWhitelisted(this.searchURLFormat)) {
                return true;
            }
            InetAddress inetAddress = InetAddress.getByName(string2);
            if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isShareable() {
        try {
            return !UrlUtils.containsPasskey(new URL(this.searchURLFormat));
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected pageDetails getWebPageContent(SearchParameter[] searchParameterArray, Map<String, String> map, String string, boolean bl) throws SearchException {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n9;
        String string5;
        byte[] byArray2;
        String string2;
        Object object2;
        Object object4;
        Object object5;
        Object object7;
        block58: {
            int n5;
            Object object3;
            Object object6;
            block56: {
                Object object8;
                block57: {
                    try {
                        Object object9;
                        Map.Entry<String, String> entry2222;
                        TorrentUtils.setTLSDescription("Search: " + this.getName());
                        if (this.requiresLogin()) {
                            throw new SearchLoginException("login required");
                        }
                        String string3 = this.searchURLFormat;
                        String[] stringArray = new String[searchParameterArray.length];
                        String[] stringArray2 = new String[searchParameterArray.length];
                        for (int i = 0; i < searchParameterArray.length; ++i) {
                            entry2222 = searchParameterArray[i];
                            stringArray[i] = "%" + ((SearchParameter)((Object)entry2222)).getMatchPattern();
                            stringArray2[i] = URLEncoder.encode(((SearchParameter)((Object)entry2222)).getValue(), "UTF-8");
                        }
                        string3 = GeneralUtils.replaceAll(string3, stringArray, stringArray2);
                        for (Map.Entry<String, String> entry2222 : map.entrySet()) {
                            object7 = entry2222.getKey();
                            if (!this.supportsContext((String)object7)) continue;
                            string3 = string3.indexOf(63) == -1 ? string3 + "?" : string3 + "&";
                            object9 = entry2222.getValue();
                            string3 = string3 + (String)object7 + "=" + URLEncoder.encode((String)object9, "UTF-8");
                        }
                        entry2222 = StaticUtilities.getResourceDownloaderFactory();
                        int n6 = string3.indexOf("azmethod=");
                        if (n6 > 0) {
                            object6 = string3.substring(n6 + 9);
                            string3 = string3.substring(0, n6 - 1);
                            this.debugLog("search_url: " + string3 + ", post=" + (String)object6);
                            object7 = new URL(string3);
                            int n7 = ((String)object6).indexOf(58);
                            object5 = ((String)object6).substring(0, n7);
                            if (!((String)object5).equals("post_basic")) {
                                throw new SearchException("Only basic type supported");
                            }
                            object6 = ((String)object6).substring(n7 + 1);
                            object9 = entry2222.create((URL)object7, (String)object6);
                            object9.setProperty("URL_Content-Type", "application/x-www-form-urlencoded");
                        } else {
                            this.debugLog("search_url: " + string3);
                            object7 = new URL(string3);
                            object9 = entry2222.create((URL)object7);
                        }
                        this.setHeaders((ResourceDownloader)object9, string);
                        if (this.needsAuth && this.local_cookies != null) {
                            object9.setProperty("URL_Cookie", this.local_cookies);
                        }
                        if (bl) {
                            object6 = this.getLocalString("last_mod");
                            String string4 = this.getLocalString("etag");
                            if (object6 != null) {
                                object9.setProperty("URL_If-Modified-Since", object6);
                            }
                            if (string4 != null) {
                                object9.setProperty("URL_If-None-Match", string4);
                            }
                        }
                        object4 = "UTF-8";
                        object5 = null;
                        if (((URL)object7).getProtocol().equalsIgnoreCase("file")) {
                            int n8;
                            object3 = ((URL)object7).toExternalForm();
                            if (((URL)object7).getAuthority() != null) {
                                object3 = ((String)object3).replaceFirst("://", ":/");
                            }
                            if ((n8 = ((String)object3).indexOf(63)) != -1) {
                                object3 = ((String)object3).substring(0, n8);
                            }
                            object6 = new FileInputStream(new File(new URL((String)object3).toURI()));
                            break block56;
                        }
                        object5 = entry2222.getMetaRefreshDownloader((ResourceDownloader)object9);
                        try {
                            object6 = object5.download();
                        }
                        catch (ResourceDownloaderException resourceDownloaderException) {
                            Long l = (Long)object5.getProperty("URL_HTTP_Response");
                            if (l == null) throw resourceDownloaderException;
                            if (l != 304L) throw resourceDownloaderException;
                            pageDetails pageDetails2 = new pageDetails((URL)object7, (URL)object7, "");
                            TorrentUtils.setTLSDescription(null);
                            return pageDetails2;
                        }
                        if (!this.needsAuth) break block57;
                    }
                    catch (SearchException searchException) {
                        throw searchException;
                    }
                    catch (Throwable throwable) {
                        this.debugLog("Failed to load page: " + Debug.getNestedExceptionMessageAndStack(throwable));
                        throw new SearchException("Failed to load page", throwable);
                    }
                    finally {
                        TorrentUtils.setTLSDescription(null);
                    }
                    object3 = (List)object5.getProperty("URL_Set-Cookie");
                    object8 = new ArrayList();
                    if (object3 == null) break block57;
                    for (n5 = 0; n5 < object3.size(); ++n5) {
                        object2 = ((String)object3.get(n5)).split(";");
                        for (int i = 0; i < ((String[])object2).length; ++i) {
                            string2 = object2[i].trim();
                            if (string2.indexOf(61) == -1) continue;
                            object8.add(string2);
                        }
                    }
                }
                if (bl) {
                    object3 = this.extractProperty(object5.getProperty("URL_Last-Modified"));
                    object8 = this.extractProperty(object5.getProperty("URL_ETag"));
                    if (object3 != null) {
                        this.setLocalString("last_mod", (String)object3);
                    }
                    if (object8 != null) {
                        this.setLocalString("etag", (String)object8);
                    }
                }
                if ((object3 = (List)object5.getProperty("URL_Content-Type")) != null && object3.size() > 0 && (n5 = ((String)(object8 = (String)object3.get(0))).toLowerCase().indexOf("charset")) != -1 && (n5 = ((String)(object8 = ((String)object8).substring(n5 + 1))).indexOf(61)) != -1) {
                    if ((n5 = ((String)(object8 = ((String)object8).substring(n5 + 1).trim())).indexOf(59)) != -1) {
                        object8 = ((String)object8).substring(0, n5).trim();
                    }
                    try {
                        if (Charset.isSupported((String)object8)) {
                            this.debugLog("charset: " + (String)object8);
                            object4 = object8;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            object8 = ((String)object8).toUpperCase();
                            if (Charset.isSupported((String)object8)) {
                                this.debugLog("charset: " + (String)object8);
                                object4 = object8;
                            }
                        }
                        catch (Throwable throwable2) {
                            this.log("Content type '" + (String)object8 + "' not supported", throwable2);
                        }
                    }
                }
            }
            object3 = new ByteArrayOutputStream(8192);
            byte[] byArray = new byte[8192];
            while (true) {
                if ((n5 = ((InputStream)object6).read(byArray)) <= 0) {
                    byArray2 = ((ByteArrayOutputStream)object3).toByteArray();
                    object2 = null;
                    string5 = new String(byArray2, 0, Math.min(byArray2.length, 2048), (String)object4);
                    string2 = string5.toLowerCase();
                    n9 = string2.indexOf("<?xml");
                    if (n9 != -1) {
                        break;
                    }
                    break block58;
                }
                ((ByteArrayOutputStream)object3).write(byArray, 0, n5);
            }
            n4 = string2.indexOf("?>");
            if (n4 != -1) {
                n3 = string2.indexOf("encoding", n9);
                if (n3 != -1) {
                    n3 = string2.indexOf("\"", n3);
                }
                if (n3 > n9 && n3 < n4 && (n2 = string2.indexOf("\"", ++n3)) > n3 && n2 < n4) {
                    String string6 = string5.substring(n3, n2).trim();
                    try {
                        if (Charset.isSupported(string6)) {
                            this.debugLog("charset from xml tag: " + string6);
                            object4 = string6;
                            n = n4;
                            int n10 = 64;
                            while (byArray2[n] != 63 && n10-- > 0) {
                                ++n;
                            }
                            object2 = string5.substring(0, n3) + "utf-8" + string5.substring(n2, n4) + new String(byArray2, n, byArray2.length - n, (String)object4);
                        }
                    }
                    catch (Throwable throwable) {
                        this.log("Content type '" + string6 + "' not supported", throwable);
                    }
                }
            }
        }
        if (object2 == null) {
            n9 = 0;
            while ((n4 = string2.indexOf("http-equiv", n9)) != -1 && (n3 = string2.indexOf(">", n4)) != -1) {
                int n11;
                n2 = string2.indexOf("charset", n4);
                if (n2 != -1 && n2 < n3 && (n2 = string2.indexOf("=", n2)) != -1 && (n11 = string2.indexOf("\"", ++n2)) != -1) {
                    n = string2.indexOf(";", n2);
                    if (n != -1 && n < n11) {
                        n11 = n;
                    }
                    String string7 = string5.substring(n2, n11).trim();
                    try {
                        if (!Charset.isSupported(string7)) break;
                        this.debugLog("charset from http-equiv : " + string7);
                        object4 = string7;
                        int n12 = n3;
                        int n13 = 64;
                        while (byArray2[n12] != 63 && n13-- > 0) {
                            ++n12;
                        }
                        object2 = string5.substring(0, n2) + "utf-8" + string5.substring(n11, n3) + new String(byArray2, n12, byArray2.length - n12, (String)object4);
                    }
                    catch (Throwable throwable) {
                        this.log("Content type '" + string7 + "' not supported", throwable);
                    }
                    break;
                }
                n9 = n3;
            }
        }
        if (object2 == null) {
            object2 = new String(byArray2, (String)object4);
        }
        this.debugLog("page:");
        this.debugLog((String)object2);
        try {
            object = baseTagPattern.matcher((CharSequence)object2);
            if (((Matcher)object).find()) {
                this.basePage = ((Matcher)object).group(1);
                this.debugLog("base_page: " + this.basePage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = object7;
        if (object5 == null) return new pageDetails((URL)object7, (URL)object, (String)object2);
        URL uRL = (URL)object5.getProperty("URL_URL");
        if (uRL == null) return new pageDetails((URL)object7, (URL)object, (String)object2);
        object = uRL;
        return new pageDetails((URL)object7, (URL)object, (String)object2);
    }

    protected String extractProperty(Object object) {
        List list;
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof List && (list = (List)object).size() > 0) {
            Object e;
            if (list.size() > 1) {
                Debug.out("Property has multiple values!");
            }
            if ((e = list.get(0)) instanceof String) {
                return (String)e;
            }
            Debug.out("Property value isn't a String:" + e);
        }
        return null;
    }

    protected void setHeaders(ResourceDownloader resourceDownloader, String string) {
        UrlUtils.setBrowserHeaders(resourceDownloader, string, this.rootPage);
    }

    @Override
    public String getIcon() {
        if (this.rootPage != null) {
            return this.rootPage + "/favicon.ico";
        }
        return null;
    }

    protected FieldMapping[] getMappings() {
        return this.mappings;
    }

    @Override
    public boolean supportsField(int n) {
        for (int i = 0; i < this.mappings.length; ++i) {
            if (this.mappings[i].getField() != n) continue;
            return true;
        }
        return false;
    }

    protected String getRootPage() {
        return this.rootPage;
    }

    protected String getBasePage() {
        return this.basePage;
    }

    protected DateParser getDateParser() {
        return this.dateParser;
    }

    @Override
    public String getDownloadLinkCSS() {
        if (this.downloadLinkCSS == null) {
            return "";
        }
        return this.downloadLinkCSS;
    }

    public boolean requiresLogin() {
        return this.needsAuth && !CookieParser.cookiesContain(this.requiredCookies, this.local_cookies);
    }

    public void setCookies(String string) {
        this.local_cookies = string;
        this.setLocalString("cookies", string);
    }

    public String getSearchUrl() {
        return this.searchURLFormat.replaceAll("%s", "");
    }

    public String getLoginPageUrl() {
        return this.searchURLFormat.replaceAll("%s", "");
    }

    public void setLoginPageUrl(String string) {
        this.loginPageUrl = string;
    }

    public String[] getRequiredCookies() {
        return this.requiredCookies;
    }

    public void setRequiredCookies(String[] stringArray) {
        this.requiredCookies = stringArray;
    }

    public boolean isNeedsAuth() {
        return this.needsAuth;
    }

    protected void setNeedsAuth(boolean bl) {
        this.needsAuth = bl;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public String getCookies() {
        return this.local_cookies;
    }

    @Override
    public String getString() {
        return this.getString(false);
    }

    @Override
    public String getString(boolean bl) {
        return super.getString() + (bl ? ", url=" + this.searchURLFormat : "") + ", auth=" + this.isNeedsAuth() + (this.isNeedsAuth() ? " [cookies=" + this.local_cookies + "]" : "");
    }

    public static class pageDetails {
        private URL initial_url;
        private URL final_url;
        private String content;

        protected pageDetails(URL uRL, URL uRL2, String string) {
            this.initial_url = uRL;
            this.final_url = uRL2;
            this.content = string;
        }

        public URL getInitialURL() {
            return this.initial_url;
        }

        public URL getFinalURL() {
            return this.final_url;
        }

        public String getContent() {
            return this.content;
        }
    }
}

