/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import com.aelitis.azureus.util.JSONUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class PlatformMessage {
    private final String messageID;
    private final String listenerID;
    private final String operationID;
    private final Map parameters;
    private final long fireBeforeDate;
    private final long messageCreatedOn;
    private long lSequenceNo = -1L;
    private boolean requiresAuthorization = false;
    private boolean loginAndRetry = false;
    private boolean sendAZID = true;
    private long contentNetworkID;

    public PlatformMessage(String string, String string2, String string3, Map map, long l) {
        this.messageID = string;
        this.listenerID = string2;
        this.operationID = string3;
        this.parameters = JSONUtils.encodeToJSONObject(map);
        this.contentNetworkID = 1L;
        this.messageCreatedOn = SystemTime.getCurrentTime();
        this.fireBeforeDate = this.messageCreatedOn + l;
    }

    public PlatformMessage(String string, String string2, String string3, Object[] objectArray, long l) {
        this.messageID = string;
        this.listenerID = string2;
        this.operationID = string3;
        this.parameters = JSONUtils.encodeToJSONObject(PlatformMessage.parseParams(objectArray));
        this.contentNetworkID = 1L;
        this.messageCreatedOn = SystemTime.getCurrentTime();
        this.fireBeforeDate = this.messageCreatedOn + l;
    }

    public static Map parseParams(Object[] objectArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            try {
                if (!(objectArray[i] instanceof String)) continue;
                if (objectArray[i + 1] instanceof String[]) {
                    List<String> list = Arrays.asList((String[])objectArray[i + 1]);
                    hashMap.put((String)objectArray[i], list);
                    continue;
                }
                if (objectArray[i + 1] instanceof Object[]) {
                    hashMap.put((String)objectArray[i], PlatformMessage.parseParams((Object[])objectArray[i + 1]));
                    continue;
                }
                if (objectArray[i + 1] instanceof Map) {
                    hashMap.put((String)objectArray[i], (Map)objectArray[i + 1]);
                    continue;
                }
                hashMap.put((String)objectArray[i], objectArray[i + 1]);
                continue;
            }
            catch (Exception exception) {
                Debug.out("making JSONObject out of parsedParams", exception);
            }
        }
        return hashMap;
    }

    public long getFireBefore() {
        return this.fireBeforeDate;
    }

    public long getMessageCreated() {
        return this.messageCreatedOn;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public String getListenerID() {
        return this.listenerID;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getOperationID() {
        return this.operationID;
    }

    protected long getSequenceNo() {
        return this.lSequenceNo;
    }

    protected void setSequenceNo(long l) {
        this.lSequenceNo = l;
    }

    public String toString() {
        String string = this.parameters.toString();
        return "PlaformMessage {cn" + this.contentNetworkID + ", " + this.lSequenceNo + ", " + this.messageID + ", " + this.listenerID + ", " + this.operationID + ", " + (string.length() > Short.MAX_VALUE ? string.substring(0, Short.MAX_VALUE) : string) + "}";
    }

    public String toShortString() {
        return (this.requiresAuthorization ? "AUTH: " : "") + this.getMessageID() + "." + this.getListenerID() + "." + this.getOperationID();
    }

    public boolean sendAZID() {
        return this.sendAZID;
    }

    public void setSendAZID(boolean bl) {
        this.sendAZID = bl;
        if (bl && this.requiresAuthorization) {
            System.err.println("requiresAuthorization overrides sendAZID disabling");
        }
    }

    public long getContentNetworkID() {
        return this.contentNetworkID;
    }

    public void setContentNetworkID(long l) {
        this.contentNetworkID = l;
    }
}

