/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManagerFile;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PieceRTAProvider;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.PlayUtils;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.RealTimeInfo;
import org.gudy.azureus2.core3.util.SystemTime;

public class EnhancedDownloadManager {
    public static int DEFAULT_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA = 30;
    public static int MINIMUM_INITIAL_BUFFER_SECS;
    public static final int REACTIVATE_PROVIDER_PERIOD = 5000;
    public static final int REACTIVATE_PROVIDER_PERIOD_TICKS = 5;
    public static final int LOG_PROG_STATS_PERIOD = 10000;
    public static final int LOG_PROG_STATS_TICKS = 10;
    private static final int content_stream_bps_min_increase_ratio = 5;
    private static final int content_stream_bps_max_increase_ratio = 8;
    private DownloadManagerEnhancer enhancer;
    private DownloadManager download_manager;
    private boolean explicit_progressive;
    private volatile PiecePicker current_piece_pickler;
    private volatile boolean progressive_active = false;
    private long content_min_delivery_bps;
    private int minimum_initial_buffer_secs_for_eta;
    private bufferETAProvider buffer_provider = new bufferETAProvider();
    private progressiveStats progressive_stats;
    private boolean marked_active;
    private boolean destroyed;
    private DownloadManagerListener dmListener;
    private EnhancedDownloadManagerFile[] enhanced_files;
    private EnhancedDownloadManagerFile primary_file;

    protected EnhancedDownloadManager(DownloadManagerEnhancer downloadManagerEnhancer, DownloadManager downloadManager) {
        int n;
        this.enhancer = downloadManagerEnhancer;
        this.download_manager = downloadManager;
        DiskManagerFileInfo[] diskManagerFileInfoArray = this.download_manager.getDiskManagerFileInfo();
        this.minimum_initial_buffer_secs_for_eta = DEFAULT_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA;
        this.enhanced_files = new EnhancedDownloadManagerFile[diskManagerFileInfoArray.length];
        long l = 0L;
        for (n = 0; n < diskManagerFileInfoArray.length; ++n) {
            DiskManagerFileInfo diskManagerFileInfo = diskManagerFileInfoArray[n];
            this.enhanced_files[n] = new EnhancedDownloadManagerFile(diskManagerFileInfo, l);
            l += diskManagerFileInfo.getLength();
        }
        n = PlayUtils.getPrimaryFileIndex(this.download_manager);
        this.primary_file = this.enhanced_files[n == -1 ? 0 : n];
        this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
        this.download_manager.addPeerListener(new DownloadManagerPeerListener(){

            @Override
            public void peerManagerWillBeAdded(PEPeerManager pEPeerManager) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void peerManagerAdded(PEPeerManager pEPeerManager) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    EnhancedDownloadManager.this.current_piece_pickler = pEPeerManager.getPiecePicker();
                    if (EnhancedDownloadManager.this.progressive_active && EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.activate(EnhancedDownloadManager.this.current_piece_pickler);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void peerManagerRemoved(PEPeerManager pEPeerManager) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    EnhancedDownloadManager.this.progressive_active = false;
                    if (EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.deactivate(EnhancedDownloadManager.this.current_piece_pickler);
                        EnhancedDownloadManager.this.current_piece_pickler = null;
                    }
                }
            }

            @Override
            public void peerAdded(PEPeer pEPeer) {
            }

            @Override
            public void peerRemoved(PEPeer pEPeer) {
            }
        });
    }

    public void setExplicitProgressive(int n, long l, int n2) {
        if (n2 >= 0 && n2 < this.enhanced_files.length) {
            this.explicit_progressive = true;
            this.minimum_initial_buffer_secs_for_eta = n;
            this.content_min_delivery_bps = l;
            this.primary_file = this.enhanced_files[n2];
            this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
        }
    }

    public String getName() {
        return this.download_manager.getDisplayName();
    }

    public byte[] getHash() {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent == null) {
            return null;
        }
        try {
            return tOTorrent.getHash();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean isPlatform() {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent != null) {
            return PlatformTorrentUtils.isContent(tOTorrent, true);
        }
        return false;
    }

    public EnhancedDownloadManagerFile[] getFiles() {
        return this.enhanced_files;
    }

    protected long getTargetSpeed() {
        long l;
        long l2 = l = this.progressive_active ? this.progressive_stats.getStreamBytesPerSecondMax() : this.content_min_delivery_bps;
        if (l < this.content_min_delivery_bps) {
            l = this.content_min_delivery_bps;
        }
        return l;
    }

    protected void updateStats(int n) {
        this.updateProgressiveStats(n);
    }

    public boolean supportsProgressiveMode() {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent == null) {
            return false;
        }
        return this.enhancer.isProgressiveAvailable() && (PlatformTorrentUtils.isContentProgressive(tOTorrent) || this.explicit_progressive);
    }

    public boolean setProgressiveMode(boolean bl) {
        return this.setProgressiveMode(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setProgressiveMode(boolean bl, boolean bl2) {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent == null || this.primary_file == null) {
            return false;
        }
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.progressive_active == bl) {
                return true;
            }
            if (bl && !this.supportsProgressiveMode()) {
                Debug.out("Attempt to set progress mode on non-progressible content - " + this.getName());
                return false;
            }
            this.log("Progressive mode changed to " + bl);
            final GlobalManager globalManager = this.download_manager.getGlobalManager();
            if (bl) {
                if (this.dmListener == null) {
                    this.dmListener = new DownloadManagerAdapter(){

                        @Override
                        public void downloadComplete(DownloadManager downloadManager) {
                            globalManager.resumeDownloads();
                        }
                    };
                }
                this.download_manager.addListener(this.dmListener);
                Object[] objectArray = globalManager.getDownloadManagers().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    EnhancedDownloadManager enhancedDownloadManager2;
                    DownloadManager downloadManager = (DownloadManager)objectArray[i];
                    if (downloadManager.equals(this.download_manager) || downloadManager.isDownloadComplete(false)) continue;
                    int n = downloadManager.getState();
                    if (n == 50 || n == 75) {
                        downloadManager.pause();
                    }
                    if ((enhancedDownloadManager2 = this.enhancer.getEnhancedDownload(downloadManager)) == null || !enhancedDownloadManager2.getProgressiveMode()) continue;
                    enhancedDownloadManager2.setProgressiveMode(false, true);
                }
                if (this.download_manager.isPaused()) {
                    this.download_manager.resume();
                }
                if (this.download_manager.getState() == 70) {
                    this.download_manager.setStateWaiting();
                }
                if (this.download_manager.getPosition() != 1) {
                    this.download_manager.getGlobalManager().moveTo(this.download_manager, 1);
                }
            } else {
                this.download_manager.removeListener(this.dmListener);
                if (!bl2) {
                    globalManager.resumeDownloads();
                }
            }
            this.progressive_active = bl;
            if (this.current_piece_pickler != null) {
                if (this.progressive_active) {
                    this.buffer_provider.activate(this.current_piece_pickler);
                    this.progressive_stats.update(0);
                } else {
                    this.buffer_provider.deactivate(this.current_piece_pickler);
                    this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
                }
            } else {
                this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
            }
            if (!bl2) {
                if (bl) {
                    RealTimeInfo.setProgressiveActive(this.progressive_stats.getStreamBytesPerSecondMax());
                } else {
                    RealTimeInfo.setProgressiveInactive();
                }
            }
        }
        return true;
    }

    public boolean getProgressiveMode() {
        return this.progressive_active;
    }

    public long getProgressivePlayETA() {
        progressiveStats progressiveStats2 = this.getProgressiveStats();
        if (progressiveStats2 == null) {
            return Long.MAX_VALUE;
        }
        long l = progressiveStats2.getETA();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected progressiveStats getProgressiveStats() {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.progressive_stats == null) {
                return null;
            }
            return this.progressive_stats.getCopy();
        }
    }

    protected progressiveStats createProgressiveStats(DownloadManager downloadManager, EnhancedDownloadManagerFile enhancedDownloadManagerFile) {
        return new progressiveStatsCommon(downloadManager, enhancedDownloadManagerFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProgressiveStats(int n) {
        if (!this.progressive_active) {
            return;
        }
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            PiecePicker piecePicker;
            if (!this.progressive_active || this.progressive_stats == null) {
                return;
            }
            if (n % 5 == 0 && (piecePicker = this.current_piece_pickler) != null) {
                this.buffer_provider.checkActivation(piecePicker);
            }
            this.progressive_stats.update(n);
            long l = this.progressive_stats.getStreamBytesPerSecondMax();
            if (RealTimeInfo.getProgressiveActiveBytesPerSec() != l) {
                RealTimeInfo.setProgressiveActive(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRTA(boolean bl) {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.marked_active && !bl) {
                this.marked_active = false;
                RealTimeInfo.removeRealTimeTask();
            }
            if (this.destroyed) {
                return;
            }
            if (!this.marked_active && bl) {
                this.marked_active = true;
                RealTimeInfo.addRealTimeTask();
            }
        }
    }

    public DiskManagerFileInfo getPrimaryFile() {
        return this.primary_file.getFile();
    }

    public long getContiguousAvailableBytes(int n, long l, long l2) {
        long l3;
        if (n < 0 || n >= this.enhanced_files.length) {
            return -1L;
        }
        EnhancedDownloadManagerFile enhancedDownloadManagerFile = this.enhanced_files[n];
        DiskManagerFileInfo diskManagerFileInfo = enhancedDownloadManagerFile.getFile();
        DiskManager diskManager = this.download_manager.getDiskManager();
        if (diskManager == null) {
            if (diskManagerFileInfo.getDownloaded() == diskManagerFileInfo.getLength()) {
                return diskManagerFileInfo.getLength() - l;
            }
            return -1L;
        }
        int n2 = diskManager.getPieceLength();
        DiskManagerFileInfo[] diskManagerFileInfoArray = diskManager.getFiles();
        long l4 = enhancedDownloadManagerFile.getByteOffestInTorrent() + l;
        int n3 = (int)(l4 / (long)n2);
        int n4 = (int)(l4 % (long)n2);
        int n5 = diskManagerFileInfo.getLastPieceNumber();
        DiskManagerPiece[] diskManagerPieceArray = diskManager.getPieces();
        DiskManagerPiece diskManagerPiece = diskManagerPieceArray[n3];
        long l5 = 0L;
        if (!diskManagerPiece.isDone()) {
            boolean[] blArray = diskManagerPiece.getWritten();
            if (blArray == null) {
                if (diskManagerPiece.isDone()) {
                    l5 = diskManagerPiece.getLength() - n4;
                }
            } else {
                int n6 = 0;
                for (int i = 0; i < blArray.length && blArray[i]; ++i) {
                    int n7 = diskManagerPiece.getBlockSize(i);
                    n6 += n7;
                    if (l5 == 0L) {
                        if (n6 <= n4) continue;
                        l5 = n6 - n4;
                        continue;
                    }
                    l5 += (long)n7;
                }
            }
        } else {
            DiskManagerPiece diskManagerPiece2;
            l5 = diskManagerPiece.getLength() - n4;
            for (int i = n3 + 1; i <= n5 && (l2 <= 0L || l5 < l2); l5 += (long)diskManagerPiece2.getLength(), ++i) {
                diskManagerPiece2 = diskManagerPieceArray[i];
                if (diskManagerPiece2.isDone()) {
                    continue;
                }
                boolean[] blArray = diskManagerPiece2.getWritten();
                if (blArray == null) {
                    if (!diskManagerPiece2.isDone()) break;
                    l5 += (long)diskManagerPiece2.getLength();
                    break;
                }
                for (int j = 0; j < blArray.length && blArray[j]; ++j) {
                    l5 += (long)diskManagerPiece2.getBlockSize(j);
                }
                break;
            }
        }
        if (l5 > (l3 = diskManagerFileInfo.getLength() - l)) {
            l5 = l3;
        }
        return l5;
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            this.setRTA(false);
            this.destroyed = true;
        }
    }

    protected void log(String string) {
        this.log(string, true);
    }

    protected void log(String string, boolean bl) {
        this.log(this.download_manager, string, bl);
    }

    protected void log(DownloadManager downloadManager, String string, boolean bl) {
        string = downloadManager.getDisplayName() + ": " + string;
        if (bl) {
            AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("v3.Stream");
            aEDiagnosticsLogger.log(string);
        }
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + string);
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"filechannel.rt.buffer.millis"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                int n = COConfigurationManager.getIntParameter("filechannel.rt.buffer.millis");
                MINIMUM_INITIAL_BUFFER_SECS = 2 * n / 1000;
            }
        });
    }

    protected class progressiveStatsCommon
    extends progressiveStats {
        private EnhancedDownloadManagerFile primary_file;
        private PieceRTAProvider current_provider;
        private String current_user_agent;
        private long content_stream_bps_min;
        private long content_stream_bps_max;
        private Average capped_download_rate_average;
        private Average discard_rate_average;
        private long last_discard_bytes;
        private long actual_bytes_to_download;
        private long weighted_bytes_to_download;
        private long provider_life_secs;
        private long provider_initial_position;
        private long provider_byte_position;
        private long provider_last_byte_position;
        private long provider_blocking_byte_position;
        private Average provider_speed_average;

        protected progressiveStatsCommon(DownloadManager downloadManager, EnhancedDownloadManagerFile enhancedDownloadManagerFile) {
            this.capped_download_rate_average = AverageFactory.MovingImmediateAverage(10);
            this.discard_rate_average = AverageFactory.MovingImmediateAverage(10);
            this.last_discard_bytes = EnhancedDownloadManager.this.download_manager.getStats().getDiscarded();
            this.provider_last_byte_position = -1L;
            this.provider_speed_average = AverageFactory.MovingImmediateAverage(10);
            this.primary_file = enhancedDownloadManagerFile;
            TOTorrent tOTorrent = EnhancedDownloadManager.this.download_manager.getTorrent();
            long l = this.content_stream_bps_min = EnhancedDownloadManager.this.explicit_progressive ? EnhancedDownloadManager.this.content_min_delivery_bps : PlatformTorrentUtils.getContentStreamSpeedBps(tOTorrent);
            if (this.content_stream_bps_min == 0L) {
                long l2 = tOTorrent.getSize();
                this.content_stream_bps_min = l2 < 0xC800000L ? 30720L : (l2 < 1048576000L ? 204800L : 409600L);
            }
            this.content_stream_bps_min += this.content_stream_bps_min / 5L;
            this.content_stream_bps_max = this.content_stream_bps_min + this.content_stream_bps_min / 8L;
            EnhancedDownloadManager.this.setRTA(false);
            EnhancedDownloadManager.this.log(EnhancedDownloadManager.this.download_manager, "content_stream_bps=" + this.getStreamBytesPerSecondMin() + ",primary=" + this.primary_file.getFile().getIndex(), true);
        }

        protected void updateCurrentProvider(PieceRTAProvider pieceRTAProvider) {
            long l = this.primary_file.getByteOffestInTorrent();
            if (this.current_provider != pieceRTAProvider || pieceRTAProvider == null) {
                this.current_provider = pieceRTAProvider;
                this.current_user_agent = null;
                this.provider_speed_average = AverageFactory.MovingImmediateAverage(10);
                if (this.current_provider == null) {
                    this.provider_life_secs = 0L;
                    this.provider_initial_position = l;
                    this.provider_byte_position = l;
                    this.provider_blocking_byte_position = -1L;
                    this.provider_last_byte_position = -1L;
                } else {
                    this.provider_byte_position = this.provider_initial_position = Math.max(l, this.current_provider.getStartPosition());
                    this.provider_last_byte_position = this.provider_initial_position;
                    this.provider_blocking_byte_position = this.current_provider.getBlockingPosition();
                    this.provider_life_secs = (SystemTime.getCurrentTime() - this.current_provider.getStartTime()) / 1000L;
                    if (this.provider_life_secs < 0L) {
                        this.provider_life_secs = 0L;
                    }
                }
                EnhancedDownloadManager.this.setRTA(this.current_provider != null);
            } else {
                ++this.provider_life_secs;
                if (this.current_user_agent == null) {
                    this.current_user_agent = this.current_provider.getUserAgent();
                    if (this.current_user_agent != null) {
                        EnhancedDownloadManager.this.log("Provider user agent = " + this.current_user_agent);
                    }
                }
                this.provider_byte_position = Math.max(l, this.current_provider.getCurrentPosition());
                this.provider_blocking_byte_position = this.current_provider.getBlockingPosition();
                long l2 = this.provider_byte_position - this.provider_last_byte_position;
                this.provider_speed_average.update(l2);
                this.provider_last_byte_position = this.provider_byte_position;
            }
        }

        @Override
        protected boolean isProviderActive() {
            return this.current_provider != null;
        }

        protected long getInitialProviderPosition() {
            return this.provider_initial_position;
        }

        @Override
        protected long getCurrentProviderPosition(boolean bl) {
            long l = this.provider_byte_position;
            if (bl) {
                if (l == 0L) {
                    l = this.primary_file.getByteOffestInTorrent();
                }
            } else if ((l -= this.primary_file.getByteOffestInTorrent()) < 0L) {
                l = 0L;
            }
            return l;
        }

        protected long getProviderLifeSecs() {
            return this.provider_life_secs;
        }

        @Override
        protected void update(int n) {
            long l = EnhancedDownloadManager.this.download_manager.getStats().getDataReceiveRate();
            this.capped_download_rate_average.update(l);
            long l2 = EnhancedDownloadManager.this.download_manager.getStats().getDiscarded();
            this.discard_rate_average.update(l2 - this.last_discard_bytes);
            this.last_discard_bytes = l2;
            DiskManager diskManager = EnhancedDownloadManager.this.download_manager.getDiskManager();
            PiecePicker piecePicker = EnhancedDownloadManager.this.current_piece_pickler;
            if (this.getStreamBytesPerSecondMin() > 0L && diskManager != null && piecePicker != null) {
                long l3;
                List list = piecePicker.getRTAProviders();
                long l4 = 0L;
                PieceRTAProvider pieceRTAProvider = null;
                for (int i = 0; i < list.size(); ++i) {
                    PieceRTAProvider pieceRTAProvider2 = (PieceRTAProvider)list.get(i);
                    if (pieceRTAProvider2.getStartTime() <= 0L || (l3 = pieceRTAProvider2.getCurrentPosition()) < l4) continue;
                    pieceRTAProvider = pieceRTAProvider2;
                    l4 = l3;
                }
                this.updateCurrentProvider(pieceRTAProvider);
                if (pieceRTAProvider != null) {
                    long l5 = this.getCurrentProviderPosition(false);
                    l3 = EnhancedDownloadManager.this.getContiguousAvailableBytes(this.primary_file.getIndex(), l5, this.getStreamBytesPerSecondMin() * 60L);
                    long l6 = l3 / this.getStreamBytesPerSecondMin();
                    l6 = Math.max(10L, l6);
                    pieceRTAProvider.setBufferMillis(15000L, l6 * 1000L);
                }
                DiskManagerPiece[] diskManagerPieceArray = diskManager.getPieces();
                this.actual_bytes_to_download = 0L;
                this.weighted_bytes_to_download = 0L;
                int n2 = -1;
                int n3 = diskManager.getPieceLength();
                int n4 = this.primary_file.getFile().getLastPieceNumber();
                for (int i = (int)(this.provider_byte_position / (long)n3); i <= n4; ++i) {
                    int n5;
                    DiskManagerPiece diskManagerPiece = diskManagerPieceArray[i];
                    if (diskManagerPiece.isDone()) continue;
                    if (n2 == -1) {
                        n2 = i;
                    }
                    boolean[] blArray = diskManagerPiece.getWritten();
                    int n6 = 0;
                    if (blArray == null) {
                        n6 = diskManagerPiece.getLength();
                    } else {
                        for (n5 = 0; n5 < blArray.length; ++n5) {
                            if (blArray[n5]) continue;
                            n6 += diskManagerPiece.getBlockSize(n5);
                        }
                    }
                    if (n6 <= 0) continue;
                    this.actual_bytes_to_download += (long)n6;
                    n5 = i - n2;
                    if (n5 == 0) {
                        this.weighted_bytes_to_download += (long)n6;
                        continue;
                    }
                    int n7 = diskManagerPiece.getLength() - n6;
                    n7 = n7 * (diskManagerPieceArray.length - i) / (diskManagerPieceArray.length - n2);
                    this.weighted_bytes_to_download += (long)(diskManagerPiece.getLength() - n7);
                }
            }
            EnhancedDownloadManager.this.log(this.getString(), n % 10 == 0);
        }

        @Override
        protected long getETA() {
            long l;
            long l2;
            long l3;
            long l4;
            DiskManagerFileInfo diskManagerFileInfo = this.primary_file.getFile();
            if (diskManagerFileInfo.getLength() == diskManagerFileInfo.getDownloaded()) {
                return 0L;
            }
            long l5 = this.getDownloadBytesPerSecond();
            if (l5 <= 0L) {
                return Long.MAX_VALUE;
            }
            long l6 = this.getBufferBytes();
            long l7 = l6 - (l4 = EnhancedDownloadManager.this.getContiguousAvailableBytes(diskManagerFileInfo.getIndex(), this.getCurrentProviderPosition(false), l6));
            long l8 = l7 <= 0L ? 0L : l7 / l5;
            if (l8 > (l3 = (l2 = this.getSecondsToDownload()) - (l = this.getSecondsToWatch())) && l8 > 0L) {
                l3 = l8;
            }
            return l3;
        }

        @Override
        protected long getStreamBytesPerSecondMax() {
            return this.content_stream_bps_max;
        }

        @Override
        protected long getStreamBytesPerSecondMin() {
            return this.content_stream_bps_min;
        }

        @Override
        public long getBufferBytes() {
            long l = (long)EnhancedDownloadManager.this.minimum_initial_buffer_secs_for_eta * this.getStreamBytesPerSecondMax();
            return l;
        }

        @Override
        protected EnhancedDownloadManagerFile getFile() {
            return this.primary_file;
        }

        @Override
        protected long getDownloadBytesPerSecond() {
            int n;
            long l;
            long l2 = l = (long)this.capped_download_rate_average.getAverage();
            int n2 = EnhancedDownloadManager.this.download_manager.getStats().getDownloadRateLimitBytesPerSecond();
            if (n2 > 0) {
                l2 = Math.min(l2, (long)n2);
            }
            if ((n = TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond()) > 0) {
                l2 = Math.min(l2, (long)n);
            }
            return l2;
        }

        @Override
        protected long getSecondsToDownload() {
            long l = this.getDownloadBytesPerSecond();
            if (l == 0L) {
                return Long.MAX_VALUE;
            }
            return this.weighted_bytes_to_download / l;
        }

        @Override
        public long getSecondsToWatch() {
            return (this.primary_file.getLength() - this.getCurrentProviderPosition(false)) / this.getStreamBytesPerSecondMin();
        }

        protected String getString() {
            long l = this.getDownloadBytesPerSecond();
            long l2 = this.getBufferBytes();
            long l3 = EnhancedDownloadManager.this.getContiguousAvailableBytes(this.primary_file.getIndex(), this.getCurrentProviderPosition(false), l2);
            return "play_eta=" + this.getETA() + "/d=" + this.getSecondsToDownload() + "/w=" + this.getSecondsToWatch() + ", dl_rate=" + this.formatSpeed(l) + ", download_rem=" + this.formatBytes(this.weighted_bytes_to_download) + "/" + this.formatBytes(this.actual_bytes_to_download) + ", discard_rate=" + this.formatSpeed((long)this.discard_rate_average.getAverage()) + ", buffer: " + l2 + "/" + l3 + ", prov: byte=" + this.formatBytes(this.provider_byte_position) + " secs=" + this.provider_byte_position / this.getStreamBytesPerSecondMin() + " speed=" + this.formatSpeed((long)this.provider_speed_average.getAverage()) + " block= " + this.formatBytes(this.provider_blocking_byte_position);
        }
    }

    protected abstract class progressiveStats
    implements Cloneable {
        protected progressiveStats() {
        }

        protected abstract EnhancedDownloadManagerFile getFile();

        protected abstract boolean isProviderActive();

        protected abstract long getCurrentProviderPosition(boolean var1);

        protected abstract long getStreamBytesPerSecondMax();

        protected abstract long getStreamBytesPerSecondMin();

        protected abstract long getDownloadBytesPerSecond();

        protected abstract long getETA();

        public abstract long getBufferBytes();

        protected abstract long getSecondsToDownload();

        protected abstract long getSecondsToWatch();

        protected abstract void update(int var1);

        protected progressiveStats getCopy() {
            try {
                return (progressiveStats)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Debug.printStackTrace(cloneNotSupportedException);
                return null;
            }
        }

        protected String formatBytes(long l) {
            return DisplayFormatters.formatByteCountToKiBEtc(l);
        }

        protected String formatSpeed(long l) {
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(l);
        }
    }

    protected class bufferETAProvider
    implements PieceRTAProvider {
        private boolean is_buffering = true;
        private long[] piece_rtas;
        private long last_buffer_size;
        private long last_buffer_size_time;
        private boolean active;
        private long last_recalc;

        protected bufferETAProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(PiecePicker piecePicker) {
            EnhancedDownloadManager.this.log("Activating RTA provider");
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                this.active = true;
                piecePicker.addRTAProvider(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deactivate(PiecePicker piecePicker) {
            if (this.active) {
                EnhancedDownloadManager.this.log("Deactivating RTA provider");
            }
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                piecePicker.removeRTAProvider(this);
                this.piece_rtas = null;
                this.active = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkActivation(PiecePicker piecePicker) {
            if (EnhancedDownloadManager.this.getProgressivePlayETA() > 0L) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    if (this.piece_rtas == null) {
                        this.activate(piecePicker);
                    }
                }
            }
        }

        @Override
        public long[] updateRTAs(PiecePicker piecePicker) {
            block14: {
                long l;
                int n;
                long l2;
                long l3;
                progressiveStats progressiveStats2;
                block12: {
                    DiskManagerPiece[] diskManagerPieceArray;
                    long l4;
                    long l5;
                    long l6;
                    DiskManager diskManager;
                    block15: {
                        block13: {
                            boolean bl;
                            long l7 = SystemTime.getMonotonousTime();
                            if (l7 - this.last_recalc < 500L) {
                                return this.piece_rtas;
                            }
                            this.last_recalc = l7;
                            diskManager = EnhancedDownloadManager.this.download_manager.getDiskManager();
                            progressiveStats2 = EnhancedDownloadManager.this.progressive_stats;
                            EnhancedDownloadManagerFile enhancedDownloadManagerFile = progressiveStats2.getFile();
                            if (diskManager == null || progressiveStats2 == null || enhancedDownloadManagerFile.isComplete()) {
                                this.deactivate(piecePicker);
                                return null;
                            }
                            l6 = progressiveStats2.getCurrentProviderPosition(true);
                            long l8 = progressiveStats2.getCurrentProviderPosition(false);
                            l3 = progressiveStats2.getBufferBytes();
                            boolean bl2 = bl = EnhancedDownloadManager.this.getProgressivePlayETA() >= 0L;
                            if (bl && (l2 = EnhancedDownloadManager.this.getContiguousAvailableBytes(enhancedDownloadManagerFile.getIndex(), l8, l3)) == l3) {
                                bl = false;
                            }
                            if (bl != this.is_buffering) {
                                if (bl) {
                                    EnhancedDownloadManager.this.log("Switching to buffer mode");
                                } else {
                                    EnhancedDownloadManager.this.log("Switching to RTA mode");
                                }
                                this.is_buffering = bl;
                            }
                            l2 = diskManager.getPieceLength();
                            int n2 = (int)(l6 / l2);
                            n = enhancedDownloadManagerFile.getFile().getLastPieceNumber();
                            this.piece_rtas = new long[piecePicker.getNumberOfPieces()];
                            l = SystemTime.getCurrentTime();
                            if (!this.is_buffering) break block12;
                            for (int i = n2; i <= n; ++i) {
                                this.piece_rtas[i] = l + (long)(i * 60000);
                            }
                            l5 = EnhancedDownloadManager.this.getContiguousAvailableBytes(enhancedDownloadManagerFile.getIndex(), l8, 0L);
                            if (this.last_buffer_size == l5) break block13;
                            this.last_buffer_size = l5;
                            this.last_buffer_size_time = l;
                            break block14;
                        }
                        if (l >= this.last_buffer_size_time) break block15;
                        this.last_buffer_size_time = l;
                        break block14;
                    }
                    long l9 = l - this.last_buffer_size_time;
                    long l10 = EnhancedDownloadManager.this.progressive_stats.getDownloadBytesPerSecond();
                    if (l10 <= 0L || l9 <= Math.max(5000L, 5L * (l4 = 0xFA0000L / l10))) break block14;
                    long l11 = l + l4;
                    int n3 = (int)((l6 + l5) / (long)diskManager.getPieceLength());
                    if (n3 < (diskManagerPieceArray = diskManager.getPieces()).length && diskManagerPieceArray[n3].isDone()) {
                        if (++n3 < diskManagerPieceArray.length) {
                            if (diskManagerPieceArray[n3].isDone()) {
                                n3 = -1;
                            }
                        } else {
                            n3 = -1;
                        }
                    }
                    if (n3 < 0) break block14;
                    this.piece_rtas[n3] = l11;
                    EnhancedDownloadManager.this.log("Buffer provider: reprioritising lagging piece " + n3 + " with rta " + l4);
                    break block14;
                }
                long l12 = 0L;
                long l13 = progressiveStats2.getStreamBytesPerSecondMax();
                for (int i = n2; i <= n; ++i) {
                    this.piece_rtas[i] = l + 1000L * (l12 / l13);
                    if ((l12 += l2) > l3) break;
                }
            }
            return this.piece_rtas;
        }

        @Override
        public long getCurrentPosition() {
            return 0L;
        }

        @Override
        public long getStartTime() {
            return 0L;
        }

        @Override
        public long getStartPosition() {
            return 0L;
        }

        @Override
        public long getBlockingPosition() {
            return 0L;
        }

        @Override
        public void setBufferMillis(long l, long l2) {
        }

        @Override
        public String getUserAgent() {
            return null;
        }
    }
}

