/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerFileInfoFile
implements DiskManagerFileInfo {
    private byte[] hash;
    private File file;

    public DiskManagerFileInfoFile(File file) {
        this.file = file;
        try {
            this.hash = new SHA1Simple().calculateHash(this.file.getAbsolutePath().getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    @Override
    public void setPriority(boolean bl) {
    }

    @Override
    public int getNumericPriorty() {
        return 0;
    }

    @Override
    public void setNumericPriority(int n) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void setSkipped(boolean bl) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void setDeleted(boolean bl) {
    }

    @Override
    public void setLink(File file) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public File getLink() {
        return null;
    }

    @Override
    public int getAccessMode() {
        return 1;
    }

    @Override
    public long getDownloaded() {
        return this.getLength();
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File getFile(boolean bl) {
        return this.file;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public int getFirstPieceNumber() {
        return 0;
    }

    @Override
    public long getPieceSize() {
        return 32768L;
    }

    @Override
    public int getNumPieces() {
        long l = this.getPieceSize();
        return (int)((this.getLength() + l - 1L) / l);
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    @Override
    public boolean isSkipped() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public byte[] getDownloadHash() {
        return this.hash;
    }

    @Override
    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    @Override
    public DiskManagerChannel createChannel() throws DownloadException {
        return new channel();
    }

    protected class channel
    implements DiskManagerChannel {
        private volatile boolean channel_destroyed;
        private volatile long channel_position;

        protected channel() {
        }

        @Override
        public DiskManagerRequest createRequest() {
            return new request();
        }

        @Override
        public DiskManagerFileInfo getFile() {
            return DiskManagerFileInfoFile.this;
        }

        @Override
        public long getPosition() {
            return this.channel_position;
        }

        @Override
        public boolean isDestroyed() {
            return this.channel_destroyed;
        }

        @Override
        public void destroy() {
            this.channel_destroyed = true;
        }

        protected class request
        implements DiskManagerRequest {
            private long offset;
            private long length;
            private long position;
            private int max_read_chunk = 131072;
            private volatile boolean cancelled;
            private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

            protected request() {
            }

            @Override
            public void setType(int n) {
                if (n != 1) {
                    throw new RuntimeException("Not supported");
                }
            }

            @Override
            public void setOffset(long l) {
                this.offset = l;
            }

            @Override
            public void setLength(long l) {
                if (l < 0L) {
                    throw new RuntimeException("Illegal argument");
                }
                this.length = l;
            }

            @Override
            public void setMaximumReadChunkSize(int n) {
                this.max_read_chunk = n;
            }

            @Override
            public long getAvailableBytes() {
                return this.getRemaining();
            }

            @Override
            public long getRemaining() {
                return this.offset + this.length - this.position;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RandomAccessFile randomAccessFile = null;
                try {
                    randomAccessFile = new RandomAccessFile(DiskManagerFileInfoFile.this.file, "r");
                    randomAccessFile.seek(this.offset);
                    byte[] byArray = new byte[this.max_read_chunk];
                    long l = this.length;
                    long l2 = this.offset;
                    while (l > 0L) {
                        if (this.cancelled) {
                            throw new Exception("Cancelled");
                        }
                        if (channel.this.channel_destroyed) {
                            throw new Exception("Destroyed");
                        }
                        int n = (int)Math.min(l, (long)this.max_read_chunk);
                        int n2 = randomAccessFile.read(byArray, 0, n);
                        this.sendEvent(new event(new PooledByteBufferImpl(byArray, 0, n2), l2, n2));
                        l -= (long)n2;
                        l2 += (long)n2;
                    }
                }
                catch (Throwable throwable) {
                    this.sendEvent(new event(throwable));
                }
                finally {
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Throwable throwable) {
                            Debug.out(throwable);
                        }
                    }
                }
            }

            @Override
            public void cancel() {
                this.cancelled = true;
            }

            @Override
            public void setUserAgent(String string) {
            }

            protected void sendEvent(event event2) {
                for (DiskManagerListener diskManagerListener : this.listeners) {
                    diskManagerListener.eventOccurred(event2);
                }
            }

            @Override
            public void addListener(DiskManagerListener diskManagerListener) {
                this.listeners.add(diskManagerListener);
            }

            @Override
            public void removeListener(DiskManagerListener diskManagerListener) {
                this.listeners.remove(diskManagerListener);
            }

            protected class event
            implements DiskManagerEvent {
                private int event_type;
                private Throwable error;
                private PooledByteBuffer buffer;
                private long event_offset;
                private int event_length;

                protected event(Throwable throwable) {
                    this.event_type = 2;
                    this.error = throwable;
                }

                protected event(PooledByteBuffer pooledByteBuffer, long l, int n) {
                    this.event_type = 1;
                    this.buffer = pooledByteBuffer;
                    this.event_offset = l;
                    this.event_length = n;
                    channel.this.channel_position = l + (long)n - 1L;
                }

                @Override
                public int getType() {
                    return this.event_type;
                }

                @Override
                public DiskManagerRequest getRequest() {
                    return request.this;
                }

                @Override
                public long getOffset() {
                    return this.event_offset;
                }

                @Override
                public int getLength() {
                    return this.event_length;
                }

                @Override
                public PooledByteBuffer getBuffer() {
                    return this.buffer;
                }

                @Override
                public Throwable getFailure() {
                    return this.error;
                }
            }
        }
    }
}

