/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessController;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;

public abstract class FMFileImpl
implements FMFile {
    protected static final String READ_ACCESS_MODE = "r";
    protected static final String WRITE_ACCESS_MODE = "rw";
    private static Map file_map = new HashMap();
    private static AEMonitor file_map_mon = new AEMonitor("FMFile:map");
    private static boolean OUTPUT_REOPEN_RELATED_ERRORS = true;
    private FMFileManagerImpl manager;
    private FMFileOwner owner;
    private int access_mode = 1;
    private File linked_file;
    private String canonical_path;
    private RandomAccessFile raf;
    private FMFileAccessController file_access;
    private File created_dirs_leaf;
    private List created_dirs;
    protected AEMonitor this_mon = new AEMonitor("FMFile");
    private boolean clone;

    protected FMFileImpl(FMFileOwner fMFileOwner, FMFileManagerImpl fMFileManagerImpl, File file, int n) throws FMFileManagerException {
        this.owner = fMFileOwner;
        this.manager = fMFileManagerImpl;
        this.linked_file = this.manager.getFileLink(this.owner.getTorrentFile().getTorrent(), file);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            try {
                this.canonical_path = this.linked_file.getCanonicalPath();
                if (this.canonical_path.equals(this.linked_file.getPath())) {
                    this.canonical_path = this.linked_file.getPath();
                }
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                if (string != null && string.indexOf("There are no more files") != -1) {
                    String string2 = this.linked_file.getAbsolutePath();
                    String string3 = "Caught 'There are no more files' exception during file.getCanonicalPath(). os=[" + Constants.OSName + "], file.getPath()=[" + this.linked_file.getPath() + "], file.getAbsolutePath()=[" + string2 + "]. ";
                    Debug.out(string3, iOException);
                }
                throw iOException;
            }
            this.createDirs(this.linked_file);
            this.reserveFile();
            bl2 = true;
            this.file_access = new FMFileAccessController(this, n);
            bl3 = true;
        }
        catch (Throwable throwable) {
            if (bl) {
                this.linked_file.delete();
            }
            this.deleteDirs();
            if (throwable instanceof FMFileManagerException) {
                throw (FMFileManagerException)throwable;
            }
            throw new FMFileManagerException("initialisation failed", throwable);
        }
        finally {
            if (bl2 && !bl3) {
                this.releaseFile();
            }
        }
    }

    protected FMFileImpl(FMFileImpl fMFileImpl) throws FMFileManagerException {
        this.owner = fMFileImpl.owner;
        this.manager = fMFileImpl.manager;
        this.linked_file = fMFileImpl.linked_file;
        this.canonical_path = fMFileImpl.canonical_path;
        this.clone = true;
        try {
            this.file_access = new FMFileAccessController(this, fMFileImpl.file_access.getStorageType());
        }
        catch (Throwable throwable) {
            if (throwable instanceof FMFileManagerException) {
                throw (FMFileManagerException)throwable;
            }
            throw new FMFileManagerException("initialisation failed", throwable);
        }
    }

    protected FMFileManagerImpl getManager() {
        return this.manager;
    }

    @Override
    public String getName() {
        return this.linked_file.toString();
    }

    @Override
    public boolean exists() {
        return this.linked_file.exists();
    }

    @Override
    public FMFileOwner getOwner() {
        return this.owner;
    }

    @Override
    public boolean isClone() {
        return this.clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStorageType(int n) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            boolean bl = this.isOpen();
            if (bl) {
                this.closeSupport(false);
            }
            try {
                this.file_access.setStorageType(n);
            }
            finally {
                if (bl) {
                    this.openSupport("Re-open after storage type change");
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getStorageType() {
        return this.file_access.getStorageType();
    }

    @Override
    public int getAccessMode() {
        return this.access_mode;
    }

    protected void setAccessModeSupport(int n) {
        this.access_mode = n;
    }

    protected File getLinkedFile() {
        return this.linked_file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveFile(File file) throws FMFileManagerException {
        block17: {
            try {
                String string;
                this.this_mon.enter();
                File file2 = this.manager.getFileLink(this.owner.getTorrentFile().getTorrent(), file);
                try {
                    try {
                        string = file2.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        String string2 = iOException.getMessage();
                        if (string2 != null && string2.indexOf("There are no more files") != -1) {
                            String string3 = file2.getAbsolutePath();
                            String string4 = "Caught 'There are no more files' exception during new_file.getCanonicalPath(). os=[" + Constants.OSName + "], new_file.getPath()=[" + file2.getPath() + "], new_file.getAbsolutePath()=[" + string3 + "]. ";
                            Debug.out(string4, iOException);
                        }
                        throw iOException;
                    }
                }
                catch (Throwable throwable) {
                    throw new FMFileManagerException("getCanonicalPath fails", throwable);
                }
                if (file2.exists()) {
                    throw new FMFileManagerException("moveFile fails - file '" + string + "' already exists");
                }
                boolean bl = this.isOpen();
                this.close();
                this.createDirs(file2);
                if (!this.linked_file.exists() || FileUtil.renameFile(this.linked_file, file2)) {
                    this.linked_file = file2;
                    this.canonical_path = string;
                    this.reserveFile();
                    if (bl) {
                        this.ensureOpen("moveFile target");
                    }
                    break block17;
                }
                try {
                    this.reserveFile();
                }
                catch (FMFileManagerException fMFileManagerException) {
                    Debug.printStackTrace(fMFileManagerException);
                }
                if (bl) {
                    try {
                        this.ensureOpen("moveFile recovery");
                    }
                    catch (FMFileManagerException fMFileManagerException) {
                        Debug.printStackTrace(fMFileManagerException);
                    }
                }
                throw new FMFileManagerException("moveFile fails");
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(String string) throws FMFileManagerException {
        block17: {
            try {
                String string2;
                this.this_mon.enter();
                File file = new File(this.linked_file.getParentFile(), string);
                try {
                    try {
                        string2 = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        String string3 = iOException.getMessage();
                        if (string3 != null && string3.indexOf("There are no more files") != -1) {
                            String string4 = file.getAbsolutePath();
                            String string5 = "Caught 'There are no more files' exception during new_file.getCanonicalPath(). os=[" + Constants.OSName + "], new_file.getPath()=[" + file.getPath() + "], new_file.getAbsolutePath()=[" + string4 + "]. ";
                            Debug.out(string5, iOException);
                        }
                        throw iOException;
                    }
                }
                catch (Throwable throwable) {
                    throw new FMFileManagerException("getCanonicalPath fails", throwable);
                }
                if (file.exists()) {
                    throw new FMFileManagerException("renameFile fails - file '" + string2 + "' already exists");
                }
                boolean bl = this.isOpen();
                this.close();
                if (!this.linked_file.exists() || this.linked_file.renameTo(file)) {
                    this.linked_file = file;
                    this.canonical_path = string2;
                    this.reserveFile();
                    if (bl) {
                        this.ensureOpen("renameFile target");
                    }
                    break block17;
                }
                try {
                    this.reserveFile();
                }
                catch (FMFileManagerException fMFileManagerException) {
                    Debug.printStackTrace(fMFileManagerException);
                }
                if (bl) {
                    try {
                        this.ensureOpen("renameFile recovery");
                    }
                    catch (FMFileManagerException fMFileManagerException) {
                        Debug.printStackTrace(fMFileManagerException);
                    }
                }
                throw new FMFileManagerException("renameFile fails");
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureOpen(String string) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            if (this.isOpen()) {
                return;
            }
            this.openSupport(string);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getLengthSupport() throws FMFileManagerException {
        try {
            return this.file_access.getLength(this.raf);
        }
        catch (FMFileManagerException fMFileManagerException) {
            if (OUTPUT_REOPEN_RELATED_ERRORS) {
                Debug.printStackTrace(fMFileManagerException);
            }
            try {
                this.reopen(fMFileManagerException);
                return this.file_access.getLength(this.raf);
            }
            catch (Throwable throwable) {
                throw fMFileManagerException;
            }
        }
    }

    protected void setLengthSupport(long l) throws FMFileManagerException {
        try {
            this.file_access.setLength(this.raf, l);
        }
        catch (FMFileManagerException fMFileManagerException) {
            if (OUTPUT_REOPEN_RELATED_ERRORS) {
                Debug.printStackTrace(fMFileManagerException);
            }
            try {
                this.reopen(fMFileManagerException);
                this.file_access.setLength(this.raf, l);
            }
            catch (Throwable throwable) {
                throw fMFileManagerException;
            }
        }
    }

    protected void reopen(FMFileManagerException fMFileManagerException) throws Throwable {
        if (!fMFileManagerException.isRecoverable()) {
            throw fMFileManagerException;
        }
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.file_access.aboutToOpen();
        this.raf = new RandomAccessFile(this.linked_file, this.access_mode == 1 ? READ_ACCESS_MODE : WRITE_ACCESS_MODE);
        Debug.outNoStack("Recovered connection to " + this.getName() + " after access failure");
    }

    protected void openSupport(String string) throws FMFileManagerException {
        if (this.raf != null) {
            throw new FMFileManagerException("file already open");
        }
        this.reserveAccess(string);
        try {
            this.file_access.aboutToOpen();
            this.raf = new RandomAccessFile(this.linked_file, this.access_mode == 1 ? READ_ACCESS_MODE : WRITE_ACCESS_MODE);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            throw new FMFileManagerException("open fails", throwable);
        }
    }

    protected void closeSupport(boolean bl) throws FMFileManagerException {
        FMFileManagerException fMFileManagerException = null;
        try {
            this.flush();
        }
        catch (FMFileManagerException fMFileManagerException2) {
            fMFileManagerException = fMFileManagerException2;
        }
        if (this.raf == null) {
            if (bl) {
                this.releaseFile();
                this.deleteDirs();
            }
        } else {
            try {
                this.raf.close();
            }
            catch (Throwable throwable) {
                throw new FMFileManagerException("close fails", throwable);
            }
            finally {
                this.raf = null;
                if (bl) {
                    this.releaseFile();
                }
            }
        }
        if (fMFileManagerException != null) {
            throw fMFileManagerException;
        }
    }

    @Override
    public void flush() throws FMFileManagerException {
        this.file_access.flush();
    }

    protected boolean isPieceCompleteProcessingNeeded(int n) throws FMFileManagerException {
        return this.file_access.isPieceCompleteProcessingNeeded(n);
    }

    protected void setPieceCompleteSupport(int n, DirectByteBuffer directByteBuffer) throws FMFileManagerException {
        this.file_access.setPieceComplete(this.raf, n, directByteBuffer);
    }

    @Override
    public void delete() throws FMFileManagerException {
        this.close();
        if (this.linked_file.exists() && !this.linked_file.delete()) {
            throw new FMFileManagerException("Failed to delete '" + this.linked_file + "'");
        }
    }

    protected void readSupport(DirectByteBuffer directByteBuffer, long l) throws FMFileManagerException {
        this.readSupport(new DirectByteBuffer[]{directByteBuffer}, l);
    }

    protected void readSupport(DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        try {
            this.file_access.read(this.raf, directByteBufferArray, l);
        }
        catch (FMFileManagerException fMFileManagerException) {
            if (OUTPUT_REOPEN_RELATED_ERRORS) {
                Debug.printStackTrace(fMFileManagerException);
            }
            try {
                this.reopen(fMFileManagerException);
                this.file_access.read(this.raf, directByteBufferArray, l);
            }
            catch (Throwable throwable) {
                throw fMFileManagerException;
            }
        }
    }

    protected void writeSupport(DirectByteBuffer directByteBuffer, long l) throws FMFileManagerException {
        this.writeSupport(new DirectByteBuffer[]{directByteBuffer}, l);
    }

    protected void writeSupport(DirectByteBuffer[] directByteBufferArray, long l) throws FMFileManagerException {
        try {
            this.file_access.write(this.raf, directByteBufferArray, l);
        }
        catch (FMFileManagerException fMFileManagerException) {
            if (OUTPUT_REOPEN_RELATED_ERRORS) {
                Debug.printStackTrace(fMFileManagerException);
            }
            try {
                this.reopen(fMFileManagerException);
                this.file_access.write(this.raf, directByteBufferArray, l);
            }
            catch (Throwable throwable) {
                throw fMFileManagerException;
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.raf != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserveFile() throws FMFileManagerException {
        if (this.clone) {
            return;
        }
        try {
            file_map_mon.enter();
            ArrayList<Object[]> arrayList = (ArrayList<Object[]>)file_map.get(this.canonical_path);
            if (arrayList == null) {
                arrayList = new ArrayList<Object[]>();
                file_map.put(this.canonical_path, arrayList);
            }
            for (Object[] objectArray : arrayList) {
                String string = ((FMFileOwner)objectArray[0]).getName();
                if (!this.owner.getName().equals(string)) continue;
                Debug.out("reserve file - entry already present");
                objectArray[1] = new Boolean(false);
                return;
            }
            arrayList.add(new Object[]{this.owner, new Boolean(false), "<reservation>"});
        }
        finally {
            file_map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserveAccess(String string) throws FMFileManagerException {
        if (this.clone) {
            return;
        }
        try {
            file_map_mon.enter();
            List list = (List)file_map.get(this.canonical_path);
            Object[] objectArray = null;
            if (list == null) {
                Debug.out("reserveAccess fail");
                throw new FMFileManagerException("File '" + this.canonical_path + "' has not been reserved (no entries), '" + this.owner.getName() + "'");
            }
            for (Object[] objectArray2 : list) {
                String string2 = ((FMFileOwner)objectArray2[0]).getName();
                if (!this.owner.getName().equals(string2)) continue;
                objectArray = objectArray2;
            }
            if (objectArray == null) {
                Debug.out("reserveAccess fail");
                throw new FMFileManagerException("File '" + this.canonical_path + "' has not been reserved (not found), '" + this.owner.getName() + "'");
            }
            objectArray[1] = new Boolean(this.access_mode == 2);
            objectArray[2] = string;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            TOTorrentFile tOTorrentFile = this.owner.getTorrentFile();
            String string3 = "";
            for (Object[] objectArray3 : list) {
                FMFileOwner fMFileOwner = (FMFileOwner)objectArray3[0];
                if (((Boolean)objectArray3[1]).booleanValue()) {
                    ++n2;
                    TOTorrentFile tOTorrentFile2 = fMFileOwner.getTorrentFile();
                    if (tOTorrentFile != null && tOTorrentFile2 != null && tOTorrentFile.getLength() == tOTorrentFile2.getLength()) {
                        ++n3;
                    }
                    string3 = string3 + (string3.length() == 0 ? "" : ",") + fMFileOwner.getName() + " [write]";
                    continue;
                }
                ++n;
                string3 = string3 + (string3.length() == 0 ? "" : ",") + fMFileOwner.getName() + " [read]";
            }
            if (n2 > 1 || n2 == 1 && n > 0) {
                if (!COConfigurationManager.getBooleanParameter("File.strict.locking") && n3 == n2) {
                    return;
                }
                Debug.out("reserveAccess fail");
                throw new FMFileManagerException("File '" + this.canonical_path + "' is in use by '" + string3 + "'");
            }
        }
        finally {
            file_map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseFile() {
        if (this.clone) {
            return;
        }
        try {
            file_map_mon.enter();
            List list = (List)file_map.get(this.canonical_path);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    if (!this.owner.getName().equals(((FMFileOwner)objectArray[0]).getName())) continue;
                    iterator.remove();
                    break;
                }
                if (list.size() == 0) {
                    file_map.remove(this.canonical_path);
                }
            }
        }
        finally {
            file_map_mon.exit();
        }
    }

    protected void createDirs(File file) throws FMFileManagerException {
        if (this.clone) {
            return;
        }
        this.deleteDirs();
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file3 = file2; file3 != null && !file3.exists(); file3 = file3.getParentFile()) {
                arrayList.add(file3);
            }
            this.created_dirs_leaf = file;
            this.created_dirs = new ArrayList();
            if (FileUtil.mkdirs(file2)) {
                this.created_dirs_leaf = file;
                this.created_dirs = arrayList;
            } else {
                throw new FMFileManagerException("Failed to create parent directory '" + file2 + "'");
            }
        }
    }

    protected void deleteDirs() {
        if (this.clone) {
            return;
        }
        if (this.created_dirs_leaf != null) {
            if (!this.created_dirs_leaf.exists()) {
                File[] fileArray;
                File file;
                Iterator iterator = this.created_dirs.iterator();
                while (iterator.hasNext() && (file = (File)iterator.next()).exists() && file.isDirectory() && ((fileArray = file.listFiles()) == null || fileArray.length == 0)) {
                    file.delete();
                }
            }
            this.created_dirs_leaf = null;
            this.created_dirs = null;
        }
    }

    protected String getString() {
        File file = new File(this.canonical_path);
        String string = file.equals(this.linked_file) ? "can/link=" + Debug.secretFileName(this.canonical_path) : "can=" + Debug.secretFileName(this.canonical_path) + ",link=" + Debug.secretFileName(this.linked_file.toString());
        return string + ",raf=" + this.raf + ",acc=" + this.access_mode + ",ctrl = " + this.file_access.getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println(file_map.size() + " FMFile Reservations");
        try {
            indentWriter.indent();
            try {
                file_map_mon.enter();
                for (String string : file_map.keySet()) {
                    List list = (List)file_map.get(string);
                    Iterator iterator = list.iterator();
                    String string2 = "";
                    while (iterator.hasNext()) {
                        Object[] objectArray = (Object[])iterator.next();
                        FMFileOwner fMFileOwner = (FMFileOwner)objectArray[0];
                        Boolean bl = (Boolean)objectArray[1];
                        String string3 = (String)objectArray[2];
                        string2 = string2 + (string2.length() == 0 ? "" : ", ") + fMFileOwner.getName() + "[" + (bl != false ? "write" : "read") + "/" + string3 + "]";
                    }
                    indentWriter.println(Debug.secretFileName(string) + " -> " + string2);
                }
            }
            finally {
                file_map_mon.exit();
            }
            FMFileManagerImpl.generateEvidence(indentWriter);
        }
        finally {
            indentWriter.exdent();
        }
    }

    static {
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            @Override
            public void generate(IndentWriter indentWriter) {
                FMFileImpl.generateEvidence(indentWriter);
            }
        });
    }
}

