/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.util;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportFindValueReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportQueryStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportRequestHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.util.DHTTransportStatsImpl;
import java.util.List;

public class DHTTransportRequestCounter
implements DHTTransportRequestHandler {
    private DHTTransportRequestHandler delegate;
    private DHTTransportStatsImpl stats;

    public DHTTransportRequestCounter(DHTTransportRequestHandler dHTTransportRequestHandler, DHTTransportStatsImpl dHTTransportStatsImpl) {
        this.delegate = dHTTransportRequestHandler;
        this.stats = dHTTransportStatsImpl;
    }

    @Override
    public void pingRequest(DHTTransportContact dHTTransportContact) {
        this.stats.pingReceived();
        this.delegate.pingRequest(dHTTransportContact);
    }

    @Override
    public void keyBlockRequest(DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2) {
        this.stats.keyBlockReceived();
        this.delegate.keyBlockRequest(dHTTransportContact, byArray, byArray2);
    }

    @Override
    public DHTTransportFullStats statsRequest(DHTTransportContact dHTTransportContact) {
        this.stats.statsReceived();
        return this.delegate.statsRequest(dHTTransportContact);
    }

    @Override
    public DHTTransportStoreReply storeRequest(DHTTransportContact dHTTransportContact, byte[][] byArray, DHTTransportValue[][] dHTTransportValueArray) {
        this.stats.storeReceived();
        return this.delegate.storeRequest(dHTTransportContact, byArray, dHTTransportValueArray);
    }

    @Override
    public DHTTransportQueryStoreReply queryStoreRequest(DHTTransportContact dHTTransportContact, int n, List<Object[]> list) {
        this.stats.queryStoreReceived();
        return this.delegate.queryStoreRequest(dHTTransportContact, n, list);
    }

    @Override
    public DHTTransportContact[] findNodeRequest(DHTTransportContact dHTTransportContact, byte[] byArray) {
        this.stats.findNodeReceived();
        return this.delegate.findNodeRequest(dHTTransportContact, byArray);
    }

    @Override
    public DHTTransportFindValueReply findValueRequest(DHTTransportContact dHTTransportContact, byte[] byArray, int n, byte by) {
        this.stats.findValueReceived();
        return this.delegate.findValueRequest(dHTTransportContact, byArray, n, by);
    }

    @Override
    public void contactImported(DHTTransportContact dHTTransportContact) {
        this.delegate.contactImported(dHTTransportContact);
    }

    @Override
    public void contactRemoved(DHTTransportContact dHTTransportContact) {
        this.delegate.contactRemoved(dHTTransportContact);
    }

    @Override
    public int getTransportEstimatedDHTSize() {
        return this.delegate.getTransportEstimatedDHTSize();
    }

    @Override
    public void setTransportEstimatedDHTSize(int n) {
        this.delegate.setTransportEstimatedDHTSize(n);
    }
}

