/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl.packethandler;

import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerStats;

public class DHTUDPPacketHandlerStats {
    private long packets_sent;
    private long packets_received;
    private long bytes_sent;
    private long bytes_received;
    private long timeouts;
    private PRUDPPacketHandlerStats stats;

    protected DHTUDPPacketHandlerStats(PRUDPPacketHandler pRUDPPacketHandler) {
        this.stats = pRUDPPacketHandler.getStats();
    }

    protected DHTUDPPacketHandlerStats(DHTUDPPacketHandlerStats dHTUDPPacketHandlerStats, PRUDPPacketHandlerStats pRUDPPacketHandlerStats) {
        this.packets_sent = dHTUDPPacketHandlerStats.packets_sent;
        this.packets_received = dHTUDPPacketHandlerStats.packets_received;
        this.bytes_sent = dHTUDPPacketHandlerStats.bytes_sent;
        this.bytes_received = dHTUDPPacketHandlerStats.bytes_received;
        this.timeouts = dHTUDPPacketHandlerStats.timeouts;
        this.stats = pRUDPPacketHandlerStats;
    }

    protected void timeout() {
        ++this.timeouts;
    }

    protected void packetSent(long l) {
        ++this.packets_sent;
        this.bytes_sent += l;
    }

    protected void packetReceived(long l) {
        ++this.packets_received;
        this.bytes_received += l;
    }

    public long getPacketsSent() {
        return this.packets_sent;
    }

    public long getPacketsReceived() {
        return this.packets_received;
    }

    public long getRequestsTimedOut() {
        return this.timeouts;
    }

    public long getBytesSent() {
        return this.bytes_sent;
    }

    public long getBytesReceived() {
        return this.bytes_received;
    }

    public long getSendQueueLength() {
        return this.stats.getSendQueueLength();
    }

    public long getReceiveQueueLength() {
        return this.stats.getReceiveQueueLength();
    }

    public DHTUDPPacketHandlerStats snapshot() {
        return new DHTUDPPacketHandlerStats(this, this.stats.snapshot());
    }
}

