/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacket;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTUDPUtils {
    protected static final int CT_UDP = 1;
    private static Map<String, byte[]> node_id_history = new LinkedHashMap<String, byte[]>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, byte[]> entry) {
            return this.size() > 128;
        }
    };
    private static SHA1Simple hasher = new SHA1Simple();
    public static final int INETSOCKETADDRESS_IPV4_SIZE = 7;
    public static final int INETSOCKETADDRESS_IPV6_SIZE = 19;
    public static final int DHTTRANSPORTCONTACT_SIZE = 9;
    public static final int DHTTRANSPORTVALUE_SIZE_WITHOUT_VALUE = 26;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getNodeID(InetSocketAddress inetSocketAddress, byte by) throws DHTTransportException {
        String string;
        Object object;
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            throw new DHTTransportException("Address '" + inetSocketAddress + "' is unresolved");
        }
        if (by >= 50) {
            object = inetAddress.getAddress();
            if (((byte[])object).length == 4) {
                long l = (long)inetSocketAddress.getPort() % 5L;
                l = ((long)object[3] << 8 & 0xFF00L | l) % 50L;
                l = ((long)object[2] << 16 & 0xFF0000L | l) % 2500L;
                l = (long)object[1] << 24 & 0xFF000000L | l;
                l = (long)object[0] << 32 & 0xFF00000000L | l;
                string = String.valueOf(l);
            } else {
                string = inetAddress.getHostAddress() + ":" + inetSocketAddress.getPort() % 8;
            }
        } else {
            string = by >= 33 ? inetAddress.getHostAddress() + ":" + inetSocketAddress.getPort() % 8 : (by >= 32 ? inetAddress.getHostAddress() + ":" + inetSocketAddress.getPort() % 1999 : inetAddress.getHostAddress() + ":" + inetSocketAddress.getPort());
        }
        Map<String, byte[]> map = node_id_history;
        object = map;
        synchronized (map) {
            byte[] byArray = node_id_history.get(string);
            if (byArray == null) {
                byArray = hasher.calculateHash(string.getBytes());
                node_id_history.put(string, byArray);
            }
            // ** MonitorExit[var4_3 /* !! */ ] (shouldn't be in output)
            return byArray;
        }
    }

    protected static byte[] getBogusNodeID() {
        byte[] byArray = new byte[20];
        new Random().nextBytes(byArray);
        return byArray;
    }

    protected static void serialiseLength(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        if (n > n2) {
            throw new IOException("Invalid DHT data length: max=" + n2 + ",actual=" + n);
        }
        if (n2 < 256) {
            dataOutputStream.writeByte(n);
        } else if (n2 < 65536) {
            dataOutputStream.writeShort(n);
        } else {
            dataOutputStream.writeInt(n);
        }
    }

    protected static int deserialiseLength(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = n < 256 ? dataInputStream.readByte() & 0xFF : (n < 65536 ? dataInputStream.readShort() & 0xFFFF : dataInputStream.readInt());
        if (n2 > n) {
            throw new IOException("Invalid DHT data length: max=" + n + ",actual=" + n2);
        }
        return n2;
    }

    protected static byte[] deserialiseByteArray(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = DHTUDPUtils.deserialiseLength(dataInputStream, n);
        byte[] byArray = new byte[n2];
        dataInputStream.read(byArray);
        return byArray;
    }

    protected static void serialiseByteArray(DataOutputStream dataOutputStream, byte[] byArray, int n) throws IOException {
        DHTUDPUtils.serialiseByteArray(dataOutputStream, byArray, 0, byArray.length, n);
    }

    protected static void serialiseByteArray(DataOutputStream dataOutputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        DHTUDPUtils.serialiseLength(dataOutputStream, n2, n3);
        dataOutputStream.write(byArray, n, n2);
    }

    protected static void serialiseByteArrayArray(DataOutputStream dataOutputStream, byte[][] byArray, int n) throws IOException {
        DHTUDPUtils.serialiseLength(dataOutputStream, byArray.length, n);
        for (int i = 0; i < byArray.length; ++i) {
            DHTUDPUtils.serialiseByteArray(dataOutputStream, byArray[i], n);
        }
    }

    protected static byte[][] deserialiseByteArrayArray(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = DHTUDPUtils.deserialiseLength(dataInputStream, n);
        byte[][] byArrayArray = new byte[n2][];
        for (int i = 0; i < byArrayArray.length; ++i) {
            byArrayArray[i] = DHTUDPUtils.deserialiseByteArray(dataInputStream, n);
        }
        return byArrayArray;
    }

    protected static void serialiseAddress(DataOutputStream dataOutputStream, InetSocketAddress inetSocketAddress) throws IOException, DHTTransportException {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            Debug.out("Address '" + inetSocketAddress + "' is unresolved");
            throw new DHTTransportException("Address '" + inetSocketAddress + "' is unresolved");
        }
        DHTUDPUtils.serialiseByteArray(dataOutputStream, inetAddress.getAddress(), 16);
        dataOutputStream.writeShort(inetSocketAddress.getPort());
    }

    protected static InetSocketAddress deserialiseAddress(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = DHTUDPUtils.deserialiseByteArray(dataInputStream, 16);
        int n = dataInputStream.readShort() & 0xFFFF;
        return new InetSocketAddress(InetAddress.getByAddress(byArray), n);
    }

    protected static DHTTransportValue[][] deserialiseTransportValuesArray(DHTUDPPacket dHTUDPPacket, DataInputStream dataInputStream, long l, int n) throws IOException {
        int n2 = DHTUDPUtils.deserialiseLength(dataInputStream, n);
        DHTTransportValue[][] dHTTransportValueArray = new DHTTransportValue[n2][];
        for (int i = 0; i < dHTTransportValueArray.length; ++i) {
            dHTTransportValueArray[i] = DHTUDPUtils.deserialiseTransportValues(dHTUDPPacket, dataInputStream, l);
        }
        return dHTTransportValueArray;
    }

    protected static void serialiseTransportValuesArray(DHTUDPPacket dHTUDPPacket, DataOutputStream dataOutputStream, DHTTransportValue[][] dHTTransportValueArray, long l, int n) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseLength(dataOutputStream, dHTTransportValueArray.length, n);
        for (int i = 0; i < dHTTransportValueArray.length; ++i) {
            DHTUDPUtils.serialiseTransportValues(dHTUDPPacket, dataOutputStream, dHTTransportValueArray[i], l);
        }
    }

    protected static void serialiseContact(DataOutputStream dataOutputStream, DHTTransportContact dHTTransportContact) throws IOException, DHTTransportException {
        if (!(dHTTransportContact.getTransport() instanceof DHTTransportUDP)) {
            throw new IOException("Unsupported contact type:" + dHTTransportContact.getClass().getName());
        }
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(dHTTransportContact.getProtocolVersion());
        DHTUDPUtils.serialiseAddress(dataOutputStream, dHTTransportContact.getExternalAddress());
    }

    protected static DHTTransportUDPContactImpl deserialiseContact(DHTTransportUDPImpl dHTTransportUDPImpl, DataInputStream dataInputStream) throws IOException, DHTTransportException {
        byte by = dataInputStream.readByte();
        if (by != 1) {
            throw new IOException("Unsupported contact type:" + by);
        }
        byte by2 = dataInputStream.readByte();
        InetSocketAddress inetSocketAddress = DHTUDPUtils.deserialiseAddress(dataInputStream);
        return new DHTTransportUDPContactImpl(false, dHTTransportUDPImpl, inetSocketAddress, inetSocketAddress, by2, 0, 0L);
    }

    protected static DHTTransportValue[] deserialiseTransportValues(DHTUDPPacket dHTUDPPacket, DataInputStream dataInputStream, long l) throws IOException {
        int n = DHTUDPUtils.deserialiseLength(dataInputStream, 65535);
        ArrayList<DHTTransportValue> arrayList = new ArrayList<DHTTransportValue>(n);
        for (int i = 0; i < n; ++i) {
            try {
                arrayList.add(DHTUDPUtils.deserialiseTransportValue(dHTUDPPacket, dataInputStream, l));
                continue;
            }
            catch (DHTTransportException dHTTransportException) {
                Debug.printStackTrace(dHTTransportException);
            }
        }
        DHTTransportValue[] dHTTransportValueArray = new DHTTransportValue[arrayList.size()];
        arrayList.toArray(dHTTransportValueArray);
        return dHTTransportValueArray;
    }

    protected static void serialiseTransportValues(DHTUDPPacket dHTUDPPacket, DataOutputStream dataOutputStream, DHTTransportValue[] dHTTransportValueArray, long l) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseLength(dataOutputStream, dHTTransportValueArray.length, 65535);
        for (int i = 0; i < dHTTransportValueArray.length; ++i) {
            DHTUDPUtils.serialiseTransportValue(dHTUDPPacket, dataOutputStream, dHTTransportValueArray[i], l);
        }
    }

    protected static DHTTransportValue deserialiseTransportValue(DHTUDPPacket dHTUDPPacket, DataInputStream dataInputStream, long l) throws IOException, DHTTransportException {
        final int n = dHTUDPPacket.getProtocolVersion() >= 11 ? dataInputStream.readInt() : -1;
        final long l2 = dataInputStream.readLong() + l;
        final byte[] byArray = DHTUDPUtils.deserialiseByteArray(dataInputStream, 512);
        final DHTTransportUDPContactImpl dHTTransportUDPContactImpl = DHTUDPUtils.deserialiseContact(dHTUDPPacket.getTransport(), dataInputStream);
        final int n2 = dataInputStream.readByte() & 0xFF;
        final int n3 = dHTUDPPacket.getProtocolVersion() >= 23 ? dataInputStream.readByte() & 0xFF : 0;
        final byte by = dHTUDPPacket.getProtocolVersion() >= 24 ? (byte)dataInputStream.readByte() : (byte)-1;
        DHTTransportValue dHTTransportValue = new DHTTransportValue(){

            @Override
            public boolean isLocal() {
                return false;
            }

            @Override
            public long getCreationTime() {
                return l2;
            }

            @Override
            public byte[] getValue() {
                return byArray;
            }

            @Override
            public int getVersion() {
                return n;
            }

            @Override
            public DHTTransportContact getOriginator() {
                return dHTTransportUDPContactImpl;
            }

            @Override
            public int getFlags() {
                return n2;
            }

            @Override
            public int getLifeTimeHours() {
                return n3;
            }

            @Override
            public byte getReplicationControl() {
                return by;
            }

            @Override
            public byte getReplicationFactor() {
                return by == -1 ? (byte)-1 : (byte)(by & 0xF);
            }

            @Override
            public byte getReplicationFrequencyHours() {
                return by == -1 ? (byte)-1 : (byte)(by >> 4);
            }

            @Override
            public String getString() {
                long l = SystemTime.getCurrentTime();
                return DHTLog.getString(byArray) + " - " + new String(byArray) + "{v=" + n + ",f=" + Integer.toHexString(n2) + ",l=" + n3 + ",r=" + Integer.toHexString(this.getReplicationControl()) + ",ca=" + (l - l2) + ",or=" + dHTTransportUDPContactImpl.getString() + "}";
            }
        };
        return dHTTransportValue;
    }

    protected static void serialiseTransportValue(DHTUDPPacket dHTUDPPacket, DataOutputStream dataOutputStream, DHTTransportValue dHTTransportValue, long l) throws IOException, DHTTransportException {
        if (dHTUDPPacket.getProtocolVersion() >= 11) {
            int n = dHTTransportValue.getVersion();
            dataOutputStream.writeInt(n);
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeLong(dHTTransportValue.getCreationTime() + l);
        DHTUDPUtils.serialiseByteArray(dataOutputStream, dHTTransportValue.getValue(), 512);
        DHTUDPUtils.serialiseContact(dataOutputStream, dHTTransportValue.getOriginator());
        dataOutputStream.writeByte(dHTTransportValue.getFlags());
        if (dHTUDPPacket.getProtocolVersion() >= 23) {
            dataOutputStream.writeByte(dHTTransportValue.getLifeTimeHours());
        }
        if (dHTUDPPacket.getProtocolVersion() >= 24) {
            dataOutputStream.writeByte(dHTTransportValue.getReplicationControl());
        }
    }

    protected static void serialiseContacts(DataOutputStream dataOutputStream, DHTTransportContact[] dHTTransportContactArray) throws IOException {
        DHTUDPUtils.serialiseLength(dataOutputStream, dHTTransportContactArray.length, 65535);
        for (int i = 0; i < dHTTransportContactArray.length; ++i) {
            try {
                DHTUDPUtils.serialiseContact(dataOutputStream, dHTTransportContactArray[i]);
                continue;
            }
            catch (DHTTransportException dHTTransportException) {
                Debug.printStackTrace(dHTTransportException);
                throw new IOException(dHTTransportException.getMessage());
            }
        }
    }

    protected static DHTTransportContact[] deserialiseContacts(DHTTransportUDPImpl dHTTransportUDPImpl, DataInputStream dataInputStream) throws IOException {
        int n = DHTUDPUtils.deserialiseLength(dataInputStream, 65535);
        ArrayList<DHTTransportUDPContactImpl> arrayList = new ArrayList<DHTTransportUDPContactImpl>(n);
        for (int i = 0; i < n; ++i) {
            try {
                arrayList.add(DHTUDPUtils.deserialiseContact(dHTTransportUDPImpl, dataInputStream));
                continue;
            }
            catch (DHTTransportException dHTTransportException) {
                Debug.printStackTrace(dHTTransportException);
            }
        }
        DHTTransportContact[] dHTTransportContactArray = new DHTTransportContact[arrayList.size()];
        arrayList.toArray(dHTTransportContactArray);
        return dHTTransportContactArray;
    }

    protected static void serialiseVivaldi(DHTUDPPacketReply dHTUDPPacketReply, DataOutputStream dataOutputStream) throws IOException {
        DHTNetworkPosition[] dHTNetworkPositionArray = dHTUDPPacketReply.getNetworkPositions();
        if (dHTUDPPacketReply.getProtocolVersion() >= 15) {
            dataOutputStream.writeByte((byte)dHTNetworkPositionArray.length);
            boolean bl = false;
            for (int i = 0; i < dHTNetworkPositionArray.length; ++i) {
                DHTNetworkPosition dHTNetworkPosition = dHTNetworkPositionArray[i];
                if (dHTNetworkPosition.getPositionType() == 1) {
                    bl = true;
                }
                dataOutputStream.writeByte(dHTNetworkPosition.getPositionType());
                dataOutputStream.writeByte(dHTNetworkPosition.getSerialisedSize());
                dHTNetworkPosition.serialise(dataOutputStream);
            }
            if (!bl) {
                Debug.out("Vivaldi V1 missing");
                throw new IOException("Vivaldi V1 missing");
            }
        } else {
            for (int i = 0; i < dHTNetworkPositionArray.length; ++i) {
                if (dHTNetworkPositionArray[i].getPositionType() != 1) continue;
                dHTNetworkPositionArray[i].serialise(dataOutputStream);
                return;
            }
            Debug.out("Vivaldi V1 missing");
            throw new IOException("Vivaldi V1 missing");
        }
    }

    protected static void deserialiseVivaldi(DHTUDPPacketReply dHTUDPPacketReply, DataInputStream dataInputStream) throws IOException {
        int n;
        DHTNetworkPosition[] dHTNetworkPositionArray;
        int n2;
        if (dHTUDPPacketReply.getProtocolVersion() >= 15) {
            int n3;
            int n4;
            n2 = dataInputStream.readByte() & 0xFF;
            dHTNetworkPositionArray = new DHTNetworkPosition[n2];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                n4 = dataInputStream.readByte();
                n3 = dataInputStream.readByte();
                DHTNetworkPosition dHTNetworkPosition = DHTNetworkPositionManager.deserialise(dHTUDPPacketReply.getAddress().getAddress(), (byte)n4, dataInputStream);
                if (dHTNetworkPosition == null) {
                    ++n;
                    for (int j = 0; j < n3; ++j) {
                        dataInputStream.readByte();
                    }
                    continue;
                }
                dHTNetworkPositionArray[i] = dHTNetworkPosition;
            }
            if (n > 0) {
                DHTNetworkPosition[] dHTNetworkPositionArray2 = new DHTNetworkPosition[n2 - n];
                n4 = 0;
                for (n3 = 0; n3 < dHTNetworkPositionArray.length; ++n3) {
                    if (dHTNetworkPositionArray[n3] == null) continue;
                    dHTNetworkPositionArray2[n4++] = dHTNetworkPositionArray[n3];
                }
                dHTNetworkPositionArray = dHTNetworkPositionArray2;
            }
        } else {
            dHTNetworkPositionArray = new DHTNetworkPosition[]{DHTNetworkPositionManager.deserialise(dHTUDPPacketReply.getAddress().getAddress(), (byte)1, dataInputStream)};
        }
        n2 = 0;
        for (n = 0; n < dHTNetworkPositionArray.length; ++n) {
            if (dHTNetworkPositionArray[n].getPositionType() != 1) continue;
            n2 = 1;
        }
        if (n2 == 0) {
            throw new IOException("Vivaldi V1 missing");
        }
        dHTUDPPacketReply.setNetworkPositions(dHTNetworkPositionArray);
    }

    protected static void serialiseStats(int n, DataOutputStream dataOutputStream, DHTTransportFullStats dHTTransportFullStats) throws IOException {
        dataOutputStream.writeLong(dHTTransportFullStats.getDBValuesStored());
        dataOutputStream.writeLong(dHTTransportFullStats.getRouterNodes());
        dataOutputStream.writeLong(dHTTransportFullStats.getRouterLeaves());
        dataOutputStream.writeLong(dHTTransportFullStats.getRouterContacts());
        dataOutputStream.writeLong(dHTTransportFullStats.getTotalBytesReceived());
        dataOutputStream.writeLong(dHTTransportFullStats.getTotalBytesSent());
        dataOutputStream.writeLong(dHTTransportFullStats.getTotalPacketsReceived());
        dataOutputStream.writeLong(dHTTransportFullStats.getTotalPacketsSent());
        dataOutputStream.writeLong(dHTTransportFullStats.getTotalPingsReceived());
        dataOutputStream.writeLong(dHTTransportFullStats.getTotalFindNodesReceived());
        dataOutputStream.writeLong(dHTTransportFullStats.getTotalFindValuesReceived());
        dataOutputStream.writeLong(dHTTransportFullStats.getTotalStoresReceived());
        dataOutputStream.writeLong(dHTTransportFullStats.getAverageBytesReceived());
        dataOutputStream.writeLong(dHTTransportFullStats.getAverageBytesSent());
        dataOutputStream.writeLong(dHTTransportFullStats.getAveragePacketsReceived());
        dataOutputStream.writeLong(dHTTransportFullStats.getAveragePacketsSent());
        dataOutputStream.writeLong(dHTTransportFullStats.getIncomingRequests());
        String string = dHTTransportFullStats.getVersion() + "[" + n + "]";
        DHTUDPUtils.serialiseByteArray(dataOutputStream, string.getBytes(), 64);
        dataOutputStream.writeLong(dHTTransportFullStats.getRouterUptime());
        dataOutputStream.writeInt(dHTTransportFullStats.getRouterCount());
        if (n >= 14) {
            dataOutputStream.writeLong(dHTTransportFullStats.getDBKeysBlocked());
            dataOutputStream.writeLong(dHTTransportFullStats.getTotalKeyBlocksReceived());
        }
        if (n >= 20) {
            dataOutputStream.writeLong(dHTTransportFullStats.getDBKeyCount());
            dataOutputStream.writeLong(dHTTransportFullStats.getDBValueCount());
            dataOutputStream.writeLong(dHTTransportFullStats.getDBStoreSize());
            dataOutputStream.writeLong(dHTTransportFullStats.getDBKeyDivFreqCount());
            dataOutputStream.writeLong(dHTTransportFullStats.getDBKeyDivSizeCount());
        }
    }

    protected static DHTTransportFullStats deserialiseStats(int n, DataInputStream dataInputStream) throws IOException {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        final long l8 = dataInputStream.readLong();
        final long l9 = dataInputStream.readLong();
        final long l10 = dataInputStream.readLong();
        final long l11 = dataInputStream.readLong();
        final long l12 = dataInputStream.readLong();
        final long l13 = dataInputStream.readLong();
        final long l14 = dataInputStream.readLong();
        final long l15 = dataInputStream.readLong();
        final long l16 = dataInputStream.readLong();
        final long l17 = dataInputStream.readLong();
        final long l18 = dataInputStream.readLong();
        final long l19 = dataInputStream.readLong();
        final long l20 = dataInputStream.readLong();
        final long l21 = dataInputStream.readLong();
        final long l22 = dataInputStream.readLong();
        final long l23 = dataInputStream.readLong();
        final long l24 = dataInputStream.readLong();
        final String string = new String(DHTUDPUtils.deserialiseByteArray(dataInputStream, 64));
        final long l25 = dataInputStream.readLong();
        final int n2 = dataInputStream.readInt();
        if (n >= 14) {
            l7 = dataInputStream.readLong();
            l6 = dataInputStream.readLong();
        } else {
            l7 = -1L;
            l6 = -1L;
        }
        if (n >= 20) {
            l5 = dataInputStream.readLong();
            l4 = dataInputStream.readLong();
            l3 = dataInputStream.readLong();
            l2 = dataInputStream.readLong();
            l = dataInputStream.readLong();
        } else {
            l5 = -1L;
            l4 = -1L;
            l3 = -1L;
            l2 = -1L;
            l = -1L;
        }
        DHTTransportFullStats dHTTransportFullStats = new DHTTransportFullStats(){

            @Override
            public long getDBValuesStored() {
                return l8;
            }

            @Override
            public long getDBKeysBlocked() {
                return l7;
            }

            @Override
            public long getDBValueCount() {
                return l4;
            }

            @Override
            public long getDBKeyCount() {
                return l5;
            }

            @Override
            public long getDBKeyDivSizeCount() {
                return l;
            }

            @Override
            public long getDBKeyDivFreqCount() {
                return l2;
            }

            @Override
            public long getDBStoreSize() {
                return l3;
            }

            @Override
            public long getRouterNodes() {
                return l9;
            }

            @Override
            public long getRouterLeaves() {
                return l10;
            }

            @Override
            public long getRouterContacts() {
                return l11;
            }

            @Override
            public long getRouterUptime() {
                return l25;
            }

            @Override
            public int getRouterCount() {
                return n2;
            }

            @Override
            public long getTotalBytesReceived() {
                return l12;
            }

            @Override
            public long getTotalBytesSent() {
                return l13;
            }

            @Override
            public long getTotalPacketsReceived() {
                return l14;
            }

            @Override
            public long getTotalPacketsSent() {
                return l15;
            }

            @Override
            public long getTotalPingsReceived() {
                return l16;
            }

            @Override
            public long getTotalFindNodesReceived() {
                return l17;
            }

            @Override
            public long getTotalFindValuesReceived() {
                return l18;
            }

            @Override
            public long getTotalStoresReceived() {
                return l19;
            }

            @Override
            public long getTotalKeyBlocksReceived() {
                return l6;
            }

            @Override
            public long getAverageBytesReceived() {
                return l20;
            }

            @Override
            public long getAverageBytesSent() {
                return l21;
            }

            @Override
            public long getAveragePacketsReceived() {
                return l22;
            }

            @Override
            public long getAveragePacketsSent() {
                return l23;
            }

            @Override
            public long getIncomingRequests() {
                return l24;
            }

            @Override
            public String getVersion() {
                return string;
            }

            @Override
            public String getString() {
                return "transport:" + this.getTotalBytesReceived() + "," + this.getTotalBytesSent() + "," + this.getTotalPacketsReceived() + "," + this.getTotalPacketsSent() + "," + this.getTotalPingsReceived() + "," + this.getTotalFindNodesReceived() + "," + this.getTotalFindValuesReceived() + "," + this.getTotalStoresReceived() + "," + this.getTotalKeyBlocksReceived() + "," + this.getAverageBytesReceived() + "," + this.getAverageBytesSent() + "," + this.getAveragePacketsReceived() + "," + this.getAveragePacketsSent() + "," + this.getIncomingRequests() + ",router:" + this.getRouterNodes() + "," + this.getRouterLeaves() + "," + this.getRouterContacts() + ",database:" + this.getDBKeyCount() + "," + this.getDBValueCount() + "," + this.getDBValuesStored() + "," + this.getDBStoreSize() + "," + this.getDBKeyDivFreqCount() + "," + this.getDBKeyDivSizeCount() + "," + this.getDBKeysBlocked() + ",version:" + this.getVersion() + "," + this.getRouterUptime() + "," + this.getRouterCount();
            }
        };
        return dHTTransportFullStats;
    }
}

