/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketRequestFindValue
extends DHTUDPPacketRequest {
    private byte[] id;
    private byte flags;
    private byte maximum_values;

    public DHTUDPPacketRequestFindValue(DHTTransportUDPImpl dHTTransportUDPImpl, long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTTransportUDPContactImpl dHTTransportUDPContactImpl2) {
        super(dHTTransportUDPImpl, 1030, l, dHTTransportUDPContactImpl, dHTTransportUDPContactImpl2);
    }

    protected DHTUDPPacketRequestFindValue(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, DataInputStream dataInputStream, long l, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, dataInputStream, 1030, l, n);
        this.id = DHTUDPUtils.deserialiseByteArray(dataInputStream, 64);
        this.flags = dataInputStream.readByte();
        this.maximum_values = dataInputStream.readByte();
        super.postDeserialise(dataInputStream);
    }

    @Override
    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        DHTUDPUtils.serialiseByteArray(dataOutputStream, this.id, 64);
        dataOutputStream.writeByte(this.flags);
        dataOutputStream.writeByte(this.maximum_values);
        super.postSerialise(dataOutputStream);
    }

    protected void setID(byte[] byArray) {
        this.id = byArray;
    }

    protected byte[] getID() {
        return this.id;
    }

    protected byte getFlags() {
        return this.flags;
    }

    protected void setFlags(byte by) {
        this.flags = by;
    }

    protected void setMaximumValues(int n) {
        if (n > 255) {
            n = 255;
        }
        this.maximum_values = (byte)n;
    }

    protected int getMaximumValues() {
        return this.maximum_values & 0xFF;
    }

    @Override
    public String getString() {
        return super.getString();
    }
}

