/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class DHTUDPPacketReplyQueryStorage
extends DHTUDPPacketReply {
    private int random_id;
    private int header_length;
    private List<byte[]> response;

    public DHTUDPPacketReplyQueryStorage(DHTTransportUDPImpl dHTTransportUDPImpl, int n, long l, DHTTransportContact dHTTransportContact, DHTTransportContact dHTTransportContact2) {
        super(dHTTransportUDPImpl, 1039, n, l, dHTTransportContact, dHTTransportContact2);
    }

    protected DHTUDPPacketReplyQueryStorage(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, InetSocketAddress inetSocketAddress, DataInputStream dataInputStream, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, 1039, n);
        int n2 = dataInputStream.readShort();
        this.response = new ArrayList<byte[]>(n2);
        if (n2 > 0) {
            this.header_length = dataInputStream.readByte() & 0xFF;
            byte[] byArray = new byte[n2 + 0];
            dataInputStream.read(byArray);
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                if (i % 8 == 0) {
                    n4 = byArray[n3++] & 0xFF;
                }
                if ((n4 & 0x80) != 0) {
                    byte[] byArray2 = new byte[this.header_length];
                    dataInputStream.read(byArray2);
                    this.response.add(byArray2);
                } else {
                    this.response.add(null);
                }
                n4 <<= 1;
            }
        }
    }

    @Override
    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        int n = this.response.size();
        dataOutputStream.writeShort(n);
        if (n > 0) {
            dataOutputStream.writeByte(this.header_length);
            byte[] byArray = new byte[n + 0];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (byte[] byArray2 : this.response) {
                n3 <<= 1;
                if (byArray2 != null) {
                    ++n3;
                }
                if (n4 % 8 == 7) {
                    byArray[n2++] = (byte)n3;
                    n3 = 0;
                }
                ++n4;
            }
            if (n4 % 8 != 0) {
                byArray[n2++] = (byte)(n3 << 8 - n4 % 8);
            }
            dataOutputStream.write(byArray);
            for (byte[] byArray2 : this.response) {
                if (byArray2 == null) continue;
                dataOutputStream.write(byArray2);
            }
        }
    }

    protected void setRandomID(int n) {
        this.random_id = n;
    }

    protected int getRandomID() {
        return this.random_id;
    }

    protected void setResponse(int n, List<byte[]> list) {
        this.header_length = n;
        this.response = list;
    }

    protected List<byte[]> getResponse() {
        return this.response;
    }
}

