/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.db.impl;

import com.aelitis.azureus.core.dht.DHTStorageKey;
import com.aelitis.azureus.core.dht.db.impl.DHTDBImpl;
import com.aelitis.azureus.core.dht.db.impl.DHTDBValueImpl;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTDBMapping {
    private static final boolean TRACE_ADDS = false;
    private DHTDBImpl db;
    private HashWrapper key;
    private ShortHash short_key;
    private DHTStorageKey adapter_key;
    private Map<HashWrapper, DHTDBValueImpl> direct_originator_map_may_be_null;
    private Map<HashWrapper, DHTDBValueImpl> indirect_originator_value_map = this.createLinkedMap();
    private int hits;
    private int direct_data_size;
    private int indirect_data_size;
    private int local_size;
    private byte diversification_state = 1;
    private static final int IP_COUNT_BLOOM_SIZE_INCREASE_CHUNK = 50;
    private Object ip_count_bloom_filter;

    protected DHTDBMapping(DHTDBImpl dHTDBImpl, HashWrapper hashWrapper, boolean bl) {
        this.db = dHTDBImpl;
        this.key = hashWrapper;
        this.short_key = new ShortHash(this.key.getBytes());
        try {
            if (this.db.getAdapter() != null) {
                this.adapter_key = this.db.getAdapter().keyCreated(this.key, bl);
                if (this.adapter_key != null) {
                    this.diversification_state = this.adapter_key.getDiversificationType();
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected Map<HashWrapper, DHTDBValueImpl> createLinkedMap() {
        return new LinkedHashMap<HashWrapper, DHTDBValueImpl>(1, 0.75f, true);
    }

    protected HashWrapper getKey() {
        return this.key;
    }

    protected ShortHash getShortKey() {
        return this.short_key;
    }

    protected void updateLocalContact(DHTTransportContact dHTTransportContact) {
        if (this.direct_originator_map_may_be_null == null) {
            return;
        }
        ArrayList<DHTDBValueImpl> arrayList = new ArrayList<DHTDBValueImpl>();
        Iterator<DHTDBValueImpl> iterator = this.direct_originator_map_may_be_null.values().iterator();
        while (iterator.hasNext()) {
            DHTDBValueImpl dHTDBValueImpl = iterator.next();
            if (!dHTDBValueImpl.isLocal()) continue;
            dHTDBValueImpl.setOriginatorAndSender(dHTTransportContact);
            arrayList.add(dHTDBValueImpl);
            this.direct_data_size -= dHTDBValueImpl.getValue().length;
            this.local_size -= dHTDBValueImpl.getValue().length;
            iterator.remove();
            this.informDeleted(dHTDBValueImpl);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.add((DHTDBValueImpl)arrayList.get(i));
        }
    }

    protected void add(DHTDBValueImpl dHTDBValueImpl) {
        DHTTransportContact dHTTransportContact = dHTDBValueImpl.getOriginator();
        DHTTransportContact dHTTransportContact2 = dHTDBValueImpl.getSender();
        HashWrapper hashWrapper = new HashWrapper(dHTTransportContact.getID());
        boolean bl = Arrays.equals(dHTTransportContact.getID(), dHTTransportContact2.getID());
        if (bl) {
            this.addDirectValue(hashWrapper, dHTDBValueImpl);
            Iterator<Map.Entry<HashWrapper, DHTDBValueImpl>> iterator = this.indirect_originator_value_map.entrySet().iterator();
            ArrayList<HashWrapper> arrayList = new ArrayList<HashWrapper>();
            while (iterator.hasNext()) {
                Map.Entry<HashWrapper, DHTDBValueImpl> entry = iterator.next();
                HashWrapper hashWrapper2 = entry.getKey();
                DHTDBValueImpl dHTDBValueImpl2 = entry.getValue();
                if (!Arrays.equals(dHTDBValueImpl2.getOriginator().getID(), dHTTransportContact.getID())) continue;
                arrayList.add(hashWrapper2);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.removeIndirectValue((HashWrapper)arrayList.get(i));
            }
        } else {
            if (this.direct_originator_map_may_be_null != null && this.direct_originator_map_may_be_null.get(hashWrapper) != null) {
                return;
            }
            HashWrapper hashWrapper3 = this.getOriginatorValueID(dHTDBValueImpl);
            DHTDBValueImpl dHTDBValueImpl3 = this.indirect_originator_value_map.get(hashWrapper3);
            if (dHTDBValueImpl3 != null) {
                this.addIndirectValue(hashWrapper3, dHTDBValueImpl);
            } else if (this.diversification_state == 1) {
                this.addIndirectValue(hashWrapper3, dHTDBValueImpl);
            }
        }
    }

    private HashWrapper getOriginatorValueID(DHTDBValueImpl dHTDBValueImpl) {
        DHTTransportContact dHTTransportContact = dHTDBValueImpl.getOriginator();
        byte[] byArray = dHTTransportContact.getID();
        return new HashWrapper(byArray);
    }

    protected void addHit() {
        ++this.hits;
    }

    protected int getHits() {
        return this.hits;
    }

    protected int getIndirectSize() {
        return this.indirect_data_size;
    }

    protected int getDirectSize() {
        return this.direct_data_size - this.local_size;
    }

    protected int getLocalSize() {
        return this.local_size;
    }

    protected DHTDBValueImpl[] get(DHTTransportContact dHTTransportContact, int n, byte by) {
        if ((by & 8) != 0) {
            if (this.adapter_key != null) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    this.adapter_key.serialiseStats(dataOutputStream);
                    dataOutputStream.close();
                    return new DHTDBValueImpl[]{new DHTDBValueImpl(SystemTime.getCurrentTime(), byteArrayOutputStream.toByteArray(), 0, this.db.getLocalContact(), this.db.getLocalContact(), true, 8, 0, -1)};
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            return new DHTDBValueImpl[0];
        }
        ArrayList<DHTDBValueImpl> arrayList = new ArrayList<DHTDBValueImpl>();
        HashSet<HashWrapper> hashSet = new HashSet<HashWrapper>();
        Map[] mapArray = new Map[]{this.direct_originator_map_may_be_null, this.indirect_originator_value_map};
        for (int i = 0; i < mapArray.length; ++i) {
            Map map = mapArray[i];
            if (map == null) continue;
            ArrayList<HashWrapper> arrayList2 = new ArrayList<HashWrapper>();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext() && (n == 0 || arrayList.size() < n)) {
                Map.Entry entry = iterator.next();
                HashWrapper hashWrapper = (HashWrapper)entry.getKey();
                DHTDBValueImpl dHTDBValueImpl = (DHTDBValueImpl)entry.getValue();
                HashWrapper hashWrapper2 = new HashWrapper(dHTDBValueImpl.getValue());
                if (hashSet.contains(hashWrapper2)) continue;
                hashSet.add(hashWrapper2);
                if (dHTDBValueImpl.getValue().length <= 0) continue;
                arrayList.add(dHTDBValueImpl);
                arrayList2.add(hashWrapper);
            }
            for (int j = 0; j < arrayList2.size(); ++j) {
                map.get(arrayList2.get(j));
            }
        }
        this.informRead(dHTTransportContact);
        DHTDBValueImpl[] dHTDBValueImplArray = new DHTDBValueImpl[arrayList.size()];
        arrayList.toArray(dHTDBValueImplArray);
        return dHTDBValueImplArray;
    }

    protected DHTDBValueImpl get(DHTTransportContact dHTTransportContact) {
        if (this.direct_originator_map_may_be_null == null) {
            return null;
        }
        HashWrapper hashWrapper = new HashWrapper(dHTTransportContact.getID());
        DHTDBValueImpl dHTDBValueImpl = this.direct_originator_map_may_be_null.get(hashWrapper);
        return dHTDBValueImpl;
    }

    protected DHTDBValueImpl remove(DHTTransportContact dHTTransportContact) {
        HashWrapper hashWrapper = new HashWrapper(dHTTransportContact.getID());
        DHTDBValueImpl dHTDBValueImpl = this.removeDirectValue(hashWrapper);
        return dHTDBValueImpl;
    }

    protected int getValueCount() {
        if (this.direct_originator_map_may_be_null == null) {
            return this.indirect_originator_value_map.size();
        }
        return this.direct_originator_map_may_be_null.size() + this.indirect_originator_value_map.size();
    }

    protected int getDirectValueCount() {
        if (this.direct_originator_map_may_be_null == null) {
            return 0;
        }
        return this.direct_originator_map_may_be_null.size();
    }

    protected int getIndirectValueCount() {
        return this.indirect_originator_value_map.size();
    }

    protected Iterator<DHTDBValueImpl> getValues() {
        return new valueIterator(true, true);
    }

    protected Iterator<DHTDBValueImpl> getDirectValues() {
        return new valueIterator(true, false);
    }

    protected Iterator<DHTDBValueImpl> getIndirectValues() {
        return new valueIterator(false, true);
    }

    protected byte getDiversificationType() {
        return this.diversification_state;
    }

    protected void addDirectValue(HashWrapper hashWrapper, DHTDBValueImpl dHTDBValueImpl) {
        DHTDBValueImpl dHTDBValueImpl2;
        if (this.direct_originator_map_may_be_null == null) {
            this.direct_originator_map_may_be_null = this.createLinkedMap();
        }
        if ((dHTDBValueImpl2 = this.direct_originator_map_may_be_null.put(hashWrapper, dHTDBValueImpl)) != null) {
            int n = dHTDBValueImpl2.getVersion();
            int n2 = dHTDBValueImpl.getVersion();
            if (n != -1 && n2 != -1 && n >= n2) {
                if (n == n2) {
                    dHTDBValueImpl2.reset();
                }
                this.direct_originator_map_may_be_null.put(hashWrapper, dHTDBValueImpl2);
                return;
            }
            this.direct_data_size -= dHTDBValueImpl2.getValue().length;
            if (dHTDBValueImpl2.isLocal()) {
                this.local_size -= dHTDBValueImpl2.getValue().length;
            }
        }
        this.direct_data_size += dHTDBValueImpl.getValue().length;
        if (dHTDBValueImpl.isLocal()) {
            this.local_size += dHTDBValueImpl.getValue().length;
        }
        if (dHTDBValueImpl2 == null) {
            this.informAdded(dHTDBValueImpl);
        } else {
            this.informUpdated(dHTDBValueImpl2, dHTDBValueImpl);
        }
    }

    protected DHTDBValueImpl removeDirectValue(HashWrapper hashWrapper) {
        if (this.direct_originator_map_may_be_null == null) {
            return null;
        }
        DHTDBValueImpl dHTDBValueImpl = this.direct_originator_map_may_be_null.remove(hashWrapper);
        if (dHTDBValueImpl != null) {
            this.direct_data_size -= dHTDBValueImpl.getValue().length;
            if (dHTDBValueImpl.isLocal()) {
                this.local_size -= dHTDBValueImpl.getValue().length;
            }
            this.informDeleted(dHTDBValueImpl);
        }
        return dHTDBValueImpl;
    }

    protected void addIndirectValue(HashWrapper hashWrapper, DHTDBValueImpl dHTDBValueImpl) {
        DHTDBValueImpl dHTDBValueImpl2 = this.indirect_originator_value_map.put(hashWrapper, dHTDBValueImpl);
        if (dHTDBValueImpl2 != null) {
            int n = dHTDBValueImpl2.getVersion();
            int n2 = dHTDBValueImpl.getVersion();
            if (n != -1 && n2 != -1 && n >= n2) {
                if (n == n2) {
                    dHTDBValueImpl2.reset();
                }
                this.indirect_originator_value_map.put(hashWrapper, dHTDBValueImpl2);
                return;
            }
            if ((n == -1 || n2 == -1) && dHTDBValueImpl2.getCreationTime() > dHTDBValueImpl.getCreationTime() + 30000L) {
                this.indirect_originator_value_map.put(hashWrapper, dHTDBValueImpl2);
                return;
            }
            this.indirect_data_size -= dHTDBValueImpl2.getValue().length;
            if (dHTDBValueImpl2.isLocal()) {
                this.local_size -= dHTDBValueImpl2.getValue().length;
            }
        }
        this.indirect_data_size += dHTDBValueImpl.getValue().length;
        if (dHTDBValueImpl.isLocal()) {
            this.local_size += dHTDBValueImpl.getValue().length;
        }
        if (dHTDBValueImpl2 == null) {
            this.informAdded(dHTDBValueImpl);
        } else {
            this.informUpdated(dHTDBValueImpl2, dHTDBValueImpl);
        }
    }

    protected DHTDBValueImpl removeIndirectValue(HashWrapper hashWrapper) {
        DHTDBValueImpl dHTDBValueImpl = this.indirect_originator_value_map.remove(hashWrapper);
        if (dHTDBValueImpl != null) {
            this.indirect_data_size -= dHTDBValueImpl.getValue().length;
            if (dHTDBValueImpl.isLocal()) {
                this.local_size -= dHTDBValueImpl.getValue().length;
            }
            this.informDeleted(dHTDBValueImpl);
        }
        return dHTDBValueImpl;
    }

    protected void destroy() {
        try {
            if (this.adapter_key != null) {
                Iterator<DHTDBValueImpl> iterator = this.getValues();
                while (iterator.hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
                this.db.getAdapter().keyDeleted(this.adapter_key);
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    private void informDeleted(DHTDBValueImpl dHTDBValueImpl) {
        boolean bl;
        boolean bl2 = bl = !dHTDBValueImpl.isLocal() && Arrays.equals(dHTDBValueImpl.getOriginator().getID(), dHTDBValueImpl.getSender().getID());
        if (bl) {
            this.removeFromBloom(dHTDBValueImpl);
        }
        try {
            if (this.adapter_key != null) {
                this.db.getAdapter().valueDeleted(this.adapter_key, dHTDBValueImpl);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    private void informAdded(DHTDBValueImpl dHTDBValueImpl) {
        boolean bl;
        boolean bl2 = bl = !dHTDBValueImpl.isLocal() && Arrays.equals(dHTDBValueImpl.getOriginator().getID(), dHTDBValueImpl.getSender().getID());
        if (bl) {
            this.addToBloom(dHTDBValueImpl);
        }
        try {
            if (this.adapter_key != null) {
                this.db.getAdapter().valueAdded(this.adapter_key, dHTDBValueImpl);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    private void informUpdated(DHTDBValueImpl dHTDBValueImpl, DHTDBValueImpl dHTDBValueImpl2) {
        boolean bl;
        boolean bl2 = !dHTDBValueImpl.isLocal() && Arrays.equals(dHTDBValueImpl.getOriginator().getID(), dHTDBValueImpl.getSender().getID());
        boolean bl3 = bl = !dHTDBValueImpl2.isLocal() && Arrays.equals(dHTDBValueImpl2.getOriginator().getID(), dHTDBValueImpl2.getSender().getID());
        if (bl && !bl2) {
            this.addToBloom(dHTDBValueImpl2);
        }
        try {
            if (this.adapter_key != null) {
                this.db.getAdapter().valueUpdated(this.adapter_key, dHTDBValueImpl, dHTDBValueImpl2);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    private void informRead(DHTTransportContact dHTTransportContact) {
        try {
            if (this.adapter_key != null && dHTTransportContact != null) {
                this.db.getAdapter().keyRead(this.adapter_key, dHTTransportContact);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected void addToBloom(DHTDBValueImpl dHTDBValueImpl) {
        BloomFilter bloomFilter;
        DHTTransportContact dHTTransportContact = dHTDBValueImpl.getOriginator();
        byte[] byArray = dHTTransportContact.getAddress().getAddress().getAddress();
        if (this.ip_count_bloom_filter == null) {
            this.ip_count_bloom_filter = byArray;
            return;
        }
        if (this.ip_count_bloom_filter instanceof byte[]) {
            byte[] byArray2 = (byte[])this.ip_count_bloom_filter;
            bloomFilter = BloomFilterFactory.createAddRemove4Bit(50);
            this.ip_count_bloom_filter = bloomFilter;
            bloomFilter.add(byArray2);
        } else {
            bloomFilter = (BloomFilter)this.ip_count_bloom_filter;
        }
        int n = bloomFilter.add(byArray);
        if (bloomFilter.getSize() / bloomFilter.getEntryCount() < 10) {
            this.rebuildIPBloomFilter(true);
        }
        if (n >= 15) {
            this.db.banContact(dHTTransportContact, "local flood on '" + DHTLog.getFullString(this.key.getBytes()) + "'");
        }
    }

    protected void removeFromBloom(DHTDBValueImpl dHTDBValueImpl) {
        DHTTransportContact dHTTransportContact = dHTDBValueImpl.getOriginator();
        if (this.ip_count_bloom_filter == null) {
            return;
        }
        byte[] byArray = dHTTransportContact.getAddress().getAddress().getAddress();
        if (this.ip_count_bloom_filter instanceof byte[]) {
            byte[] byArray2 = (byte[])this.ip_count_bloom_filter;
            if (Arrays.equals(byArray, byArray2)) {
                this.ip_count_bloom_filter = null;
            }
            return;
        }
        BloomFilter bloomFilter = (BloomFilter)this.ip_count_bloom_filter;
        int n = bloomFilter.remove(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildIPBloomFilter(boolean bl) {
        int n = this.ip_count_bloom_filter instanceof BloomFilter ? ((BloomFilter)this.ip_count_bloom_filter).getSize() : 50;
        BloomFilter bloomFilter = bl ? BloomFilterFactory.createAddRemove4Bit(n + 50) : BloomFilterFactory.createAddRemove4Bit(n);
        try {
            Iterator<DHTDBValueImpl> iterator = this.getDirectValues();
            int n2 = 0;
            while (iterator.hasNext()) {
                int n3;
                DHTDBValueImpl dHTDBValueImpl = iterator.next();
                if (dHTDBValueImpl.isLocal() || (n3 = bloomFilter.add(dHTDBValueImpl.getOriginator().getAddress().getAddress().getAddress())) <= n2) continue;
                n2 = n3;
            }
        }
        finally {
            this.ip_count_bloom_filter = bloomFilter;
        }
    }

    protected void print() {
        int n = this.ip_count_bloom_filter == null ? 0 : (this.ip_count_bloom_filter instanceof byte[] ? 1 : ((BloomFilter)this.ip_count_bloom_filter).getEntryCount());
        System.out.println(ByteFormatter.encodeString(this.key.getBytes()) + ": " + "dir=" + (this.direct_originator_map_may_be_null == null ? 0 : this.direct_originator_map_may_be_null.size()) + "," + "indir=" + this.indirect_originator_value_map.size() + "," + "bloom=" + n);
        System.out.println("    indirect");
        Iterator<DHTDBValueImpl> iterator = this.getIndirectValues();
        while (iterator.hasNext()) {
            DHTDBValueImpl dHTDBValueImpl = iterator.next();
            System.out.println("        " + dHTDBValueImpl.getOriginator().getString() + ": " + new String(dHTDBValueImpl.getValue()));
        }
    }

    public static class ShortHash {
        private byte[] bytes;
        private int hash_code;

        protected ShortHash(byte[] byArray) {
            this.bytes = byArray;
            int n = 0;
            for (int i = 0; i < 6; ++i) {
                n = 31 * n + this.bytes[i];
            }
            this.hash_code = n;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof ShortHash)) {
                return false;
            }
            ShortHash shortHash = (ShortHash)object;
            byte[] byArray = shortHash.bytes;
            for (int i = 0; i < 6; ++i) {
                if (this.bytes[i] == byArray[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hash_code;
        }
    }

    protected class valueIterator
    implements Iterator<DHTDBValueImpl> {
        private List<Map<HashWrapper, DHTDBValueImpl>> maps = new ArrayList<Map<HashWrapper, DHTDBValueImpl>>(2);
        private int map_index = 0;
        private Map<HashWrapper, DHTDBValueImpl> map;
        private Iterator<DHTDBValueImpl> it;
        private DHTDBValueImpl value;

        protected valueIterator(boolean bl, boolean bl2) {
            if (bl && DHTDBMapping.this.direct_originator_map_may_be_null != null) {
                this.maps.add(DHTDBMapping.this.direct_originator_map_may_be_null);
            }
            if (bl2) {
                this.maps.add(DHTDBMapping.this.indirect_originator_value_map);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.it != null && this.it.hasNext()) {
                return true;
            }
            while (this.map_index < this.maps.size()) {
                this.map = this.maps.get(this.map_index++);
                this.it = this.map.values().iterator();
                if (!this.it.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public DHTDBValueImpl next() {
            if (this.hasNext()) {
                this.value = this.it.next();
                return this.value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.it == null) {
                throw new IllegalStateException();
            }
            if (this.value != null) {
                if (this.value.isLocal()) {
                    DHTDBMapping.this.local_size -= this.value.getValue().length;
                }
                if (this.map == DHTDBMapping.this.indirect_originator_value_map) {
                    DHTDBMapping.this.indirect_data_size -= this.value.getValue().length;
                } else {
                    DHTDBMapping.this.direct_data_size -= this.value.getValue().length;
                }
            } else {
                throw new IllegalStateException();
            }
            this.it.remove();
            DHTDBMapping.this.informDeleted(this.value);
            this.value = null;
        }
    }
}

