/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeActionVetoException;
import com.aelitis.azureus.core.devices.TranscodeAnalysisListener;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeProviderAdapter;
import com.aelitis.azureus.core.devices.TranscodeProviderAnalysis;
import com.aelitis.azureus.core.devices.TranscodeProviderJob;
import com.aelitis.azureus.core.devices.TranscodeQueue;
import com.aelitis.azureus.core.devices.TranscodeQueueActionListener;
import com.aelitis.azureus.core.devices.TranscodeQueueListener;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeJobImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeManagerImpl;
import com.aelitis.azureus.core.devices.impl.TranscodePipe;
import com.aelitis.azureus.core.devices.impl.TranscodePipeStreamSource2;
import com.aelitis.azureus.core.messenger.config.PlatformDevicesMessenger;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class TranscodeQueueImpl
implements TranscodeQueue {
    private static final String CONFIG_FILE = "xcodejobs.config";
    private static final Object KEY_XCODE_ERROR = new Object();
    private TranscodeManagerImpl manager;
    private List<TranscodeJobImpl> queue = new ArrayList<TranscodeJobImpl>();
    private AESemaphore queue_sem = new AESemaphore("XcodeQ");
    private AEThread2 queue_thread;
    private volatile TranscodeJobImpl current_job;
    private AsyncDispatcher anaylsis_dispatcher = new AsyncDispatcher();
    private CopyOnWriteList<TranscodeQueueListener> listeners = new CopyOnWriteList();
    private CopyOnWriteList<TranscodeQueueActionListener> action_listeners = new CopyOnWriteList();
    private volatile boolean paused;
    private volatile int max_bytes_per_sec;
    private volatile boolean config_dirty;

    protected TranscodeQueueImpl(TranscodeManagerImpl transcodeManagerImpl) {
        this.manager = transcodeManagerImpl;
    }

    protected void initialise() {
        this.loadConfig();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"xcode.queue.paused", "xcode.queue.maxbps"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                TranscodeQueueImpl.this.paused = COConfigurationManager.getBooleanParameter("xcode.queue.paused", false);
                TranscodeQueueImpl.this.max_bytes_per_sec = COConfigurationManager.getIntParameter("xcode.queue.maxbps", 0);
            }
        });
        DelayedTask delayedTask = UtilitiesImpl.addDelayedTask("TranscodeQueue:schedule", new Runnable(){

            @Override
            public void run() {
                TranscodeQueueImpl.this.schedule();
            }
        });
        delayedTask.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean process(final TranscodeJobImpl transcodeJobImpl) {
        TranscodePipe transcodePipe = null;
        this.current_job = transcodeJobImpl;
        DeviceImpl deviceImpl = transcodeJobImpl.getDevice();
        deviceImpl.setTranscoding(true);
        try {
            Object object;
            TranscodeProviderAnalysis transcodeProviderAnalysis;
            boolean bl;
            transcodeJobImpl.starts();
            TranscodeProvider transcodeProvider = transcodeJobImpl.getProfile().getProvider();
            final TranscodeException[] transcodeExceptionArray = new TranscodeException[]{null};
            TranscodeProfile transcodeProfile = transcodeJobImpl.getProfile();
            final TranscodeFileImpl transcodeFileImpl = transcodeJobImpl.getTranscodeFile();
            if (transcodeProvider == null) {
                bl = false;
                transcodeProviderAnalysis = null;
            } else {
                int n;
                transcodeProviderAnalysis = this.analyse(transcodeJobImpl);
                bl = transcodeProviderAnalysis.getBooleanProperty(1);
                if (transcodeJobImpl.isStream()) {
                    n = 3;
                } else {
                    n = transcodeJobImpl.getTranscodeRequirement();
                    if (deviceImpl instanceof TranscodeTarget && transcodeProviderAnalysis.getLongProperty(4) == 0L && ((TranscodeTarget)((Object)deviceImpl)).isAudioCompatible(transcodeFileImpl)) {
                        n = 1;
                    }
                }
                if (n == 1) {
                    bl = false;
                } else if (n == 3) {
                    bl = true;
                    transcodeProviderAnalysis.setBooleanProperty(5, true);
                }
            }
            if (bl) {
                Object object2;
                object = new AESemaphore("xcode:proc");
                final TranscodeProviderJob[] transcodeProviderJobArray = new TranscodeProviderJob[]{null};
                TranscodeProviderAdapter transcodeProviderAdapter = new TranscodeProviderAdapter((AESemaphore)object){
                    private boolean resolution_updated;
                    private final int ETA_AVERAGE_SIZE = 10;
                    private int last_eta;
                    private int eta_samples;
                    private Average eta_average = AverageFactory.MovingAverage(10);
                    private int last_percent;
                    final /* synthetic */ AESemaphore val$xcode_sem;
                    {
                        this.val$xcode_sem = aESemaphore;
                    }

                    @Override
                    public void updateProgress(int n, int n2, int n3, int n4) {
                        this.last_eta = n2;
                        this.last_percent = n;
                        TranscodeProviderJob transcodeProviderJob = transcodeProviderJobArray[0];
                        if (transcodeProviderJob == null) {
                            return;
                        }
                        int n5 = transcodeJobImpl.getState();
                        if (n5 == 4 || n5 == 7) {
                            transcodeProviderJob.cancel();
                        } else if (TranscodeQueueImpl.this.paused || n5 == 2) {
                            transcodeProviderJob.pause();
                        } else {
                            if (n5 == 1) {
                                transcodeProviderJob.resume();
                            }
                            transcodeJobImpl.updateProgress(n, n2);
                            transcodeProviderJob.setMaxBytesPerSecond(TranscodeQueueImpl.this.max_bytes_per_sec);
                            if (!this.resolution_updated && n3 > 0 && n4 > 0) {
                                transcodeFileImpl.setResolution(n3, n4);
                                this.resolution_updated = true;
                            }
                        }
                    }

                    @Override
                    public void streamStats(long l, long l2) {
                        if (Constants.isOSX && transcodeJobImpl.getEnableAutoRetry() && transcodeJobImpl.canUseDirectInput() && transcodeJobImpl.getAutoRetryCount() == 0) {
                            if (l > 5L && this.last_percent < 100) {
                                long l3 = (long)this.eta_average.update(this.last_eta);
                                ++this.eta_samples;
                                if (this.eta_samples >= 10) {
                                    double d;
                                    long l4 = l3 * 100L / (long)(100 - this.last_percent);
                                    long l5 = l4 * l2;
                                    DiskManagerFileInfo diskManagerFileInfo = transcodeJobImpl.getFile();
                                    long l6 = diskManagerFileInfo.getLength();
                                    if (l6 > 0L && (d = (double)l5 / (double)l6) > 5.0) {
                                        this.failed(new TranscodeException("Overwrite limit exceeded, abandoning transcode"));
                                        transcodeProviderJobArray[0].cancel();
                                    }
                                }
                            } else {
                                this.eta_samples = 0;
                            }
                        }
                    }

                    @Override
                    public void failed(TranscodeException transcodeException) {
                        if (transcodeExceptionArray[0] == null) {
                            transcodeExceptionArray[0] = transcodeException;
                        }
                        this.val$xcode_sem.release();
                    }

                    @Override
                    public void complete() {
                        this.val$xcode_sem.release();
                    }
                };
                boolean bl2 = transcodeJobImpl.useDirectInput();
                if (transcodeJobImpl.isStream()) {
                    transcodePipe = new TranscodePipeStreamSource2(new TranscodePipeStreamSource2.streamListener(){

                        @Override
                        public void gotStream(InputStream inputStream) {
                            transcodeJobImpl.setStream(inputStream);
                        }
                    });
                    transcodeProviderJobArray[0] = transcodeProvider.transcode(transcodeProviderAdapter, transcodeProviderAnalysis, bl2, transcodeJobImpl.getFile(), transcodeProfile, new URL("tcp://127.0.0.1:" + transcodePipe.getPort()));
                } else {
                    object2 = transcodeFileImpl.getCacheFile();
                    transcodeProviderJobArray[0] = transcodeProvider.transcode(transcodeProviderAdapter, transcodeProviderAnalysis, bl2, transcodeJobImpl.getFile(), transcodeProfile, ((File)object2).toURI().toURL());
                }
                transcodeProviderJobArray[0].setMaxBytesPerSecond(this.max_bytes_per_sec);
                object2 = new TranscodeQueueListener(){

                    @Override
                    public void jobAdded(TranscodeJob transcodeJob) {
                    }

                    @Override
                    public void jobChanged(TranscodeJob transcodeJob) {
                        if (transcodeJob == transcodeJobImpl) {
                            int n = transcodeJobImpl.getState();
                            if (n == 2) {
                                transcodeProviderJobArray[0].pause();
                            } else if (n == 1) {
                                transcodeProviderJobArray[0].resume();
                            } else if (n == 4 || n == 6) {
                                transcodeProviderJobArray[0].cancel();
                            }
                        }
                    }

                    @Override
                    public void jobRemoved(TranscodeJob transcodeJob) {
                        if (transcodeJob == transcodeJobImpl) {
                            transcodeProviderJobArray[0].cancel();
                        }
                    }
                };
                try {
                    this.addListener((TranscodeQueueListener)object2);
                    ((AESemaphore)object).reserve();
                }
                finally {
                    this.removeListener((TranscodeQueueListener)object2);
                }
                if (transcodeExceptionArray[0] != null) {
                    throw transcodeExceptionArray[0];
                }
            } else {
                object = transcodeJobImpl.getFile();
                transcodeFileImpl.setTranscodeRequired(false);
                if (transcodeJobImpl.isStream()) {
                    PluginInterface pluginInterface = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByID("azupnpav");
                    if (pluginInterface == null) {
                        throw new TranscodeException("Media Server plugin not found");
                    }
                    IPCInterface iPCInterface = pluginInterface.getIPC();
                    String string = (String)iPCInterface.invoke("getContentURL", new Object[]{object});
                    if (string == null || string.length() == 0) {
                        File file = object.getFile();
                        if (!file.exists()) throw new TranscodeException("No UPnPAV URL and file doesn't exist");
                        transcodeJobImpl.setStream(new BufferedInputStream(new FileInputStream(file)));
                    } else {
                        URL uRL = new URL(string);
                        transcodeJobImpl.setStream(uRL.openConnection().getInputStream());
                    }
                } else if (deviceImpl.getAlwaysCacheFiles()) {
                    Object object3;
                    Object object4;
                    long l;
                    InputStream inputStream;
                    Object object5;
                    PluginInterface pluginInterface = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByID("azupnpav");
                    if (pluginInterface == null) {
                        throw new TranscodeException("Media Server plugin not found");
                    }
                    IPCInterface iPCInterface = pluginInterface.getIPC();
                    String string = (String)iPCInterface.invoke("getContentURL", new Object[]{object});
                    if (string == null || string.length() == 0) {
                        object5 = object.getFile();
                        if (!((File)object5).exists()) throw new TranscodeException("No UPnPAV URL and file doesn't exist");
                        inputStream = new BufferedInputStream(new FileInputStream((File)object5));
                        l = ((File)object5).length();
                    } else {
                        object5 = new URL(string);
                        object4 = ((URL)object5).openConnection();
                        inputStream = ((URL)object5).openConnection().getInputStream();
                        object3 = ((URLConnection)object4).getHeaderField("content-length");
                        l = object3 != null ? Long.parseLong((String)object3) : -1L;
                    }
                    object5 = null;
                    object4 = new boolean[]{false};
                    object3 = new TranscodeQueueListener((boolean[])object4){
                        final /* synthetic */ boolean[] val$cancel_copy;
                        {
                            this.val$cancel_copy = blArray;
                        }

                        @Override
                        public void jobAdded(TranscodeJob transcodeJob) {
                        }

                        @Override
                        public void jobChanged(TranscodeJob transcodeJob) {
                            int n;
                            if (transcodeJob == transcodeJobImpl && (n = transcodeJobImpl.getState()) != 2 && n != 1 && (n == 4 || n == 6)) {
                                this.val$cancel_copy[0] = true;
                            }
                        }

                        @Override
                        public void jobRemoved(TranscodeJob transcodeJob) {
                            if (transcodeJob == transcodeJobImpl) {
                                this.val$cancel_copy[0] = true;
                            }
                        }
                    };
                    try {
                        this.addListener((TranscodeQueueListener)object3);
                        object5 = new FileOutputStream(transcodeFileImpl.getCacheFile());
                        long l2 = 0L;
                        byte[] byArray = new byte[131072];
                        while (true) {
                            if (object4[0] != false) {
                                throw new TranscodeException("Copy cancelled");
                            }
                            int n = inputStream.read(byArray);
                            if (n <= 0) {
                                break;
                            }
                            ((OutputStream)object5).write(byArray, 0, n);
                            l2 += (long)n;
                            if (l > 0L) {
                                transcodeJobImpl.updateProgress((int)(l2 * 100L / l), -1);
                            }
                            l2 += (long)n;
                        }
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            Debug.out(throwable);
                        }
                        try {
                            if (object5 != null) {
                                ((OutputStream)object5).close();
                            }
                        }
                        catch (Throwable throwable) {
                            Debug.out(throwable);
                        }
                        this.removeListener((TranscodeQueueListener)object3);
                    }
                }
            }
            transcodeJobImpl.complete();
            boolean bl3 = true;
            return bl3;
        }
        catch (Throwable throwable) {
            transcodeJobImpl.failed(throwable);
            throwable.printStackTrace();
            if (!transcodeJobImpl.isStream() && transcodeJobImpl.getEnableAutoRetry() && transcodeJobImpl.getAutoRetryCount() == 0 && transcodeJobImpl.canUseDirectInput() && !transcodeJobImpl.useDirectInput()) {
                this.log("Auto-retrying transcode with direct input");
                transcodeJobImpl.setUseDirectInput();
                transcodeJobImpl.setAutoRetry(true);
                this.queue_sem.release();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (transcodePipe != null) {
                transcodePipe.destroy();
            }
            deviceImpl.setTranscoding(false);
            this.current_job = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            if (this.queue.size() > 0 && this.queue_thread == null) {
                this.queue_thread = new AEThread2("XcodeQ", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            while (true) {
                                TranscodeQueueImpl.this.checkJobStatus();
                                boolean bl = TranscodeQueueImpl.this.queue_sem.reserve(30000L);
                                TranscodeJobImpl transcodeJobImpl = null;
                                TranscodeQueueImpl transcodeQueueImpl = TranscodeQueueImpl.this;
                                synchronized (transcodeQueueImpl) {
                                    block14: {
                                        if (bl || TranscodeQueueImpl.this.queue.size() != 0) break block14;
                                        TranscodeQueueImpl.this.queue_thread = null;
                                        return;
                                    }
                                    for (TranscodeJobImpl transcodeJobImpl2 : TranscodeQueueImpl.this.queue) {
                                        int n = transcodeJobImpl2.getState();
                                        if (n == 5 && transcodeJobImpl2.isAutoRetry()) {
                                            transcodeJobImpl2.setAutoRetry(false);
                                            transcodeJobImpl2.reset();
                                            transcodeJobImpl = transcodeJobImpl2;
                                            break;
                                        }
                                        if (n == 2) {
                                            transcodeJobImpl = transcodeJobImpl2;
                                            continue;
                                        }
                                        if (n != 0 || transcodeJobImpl != null || transcodeJobImpl2.getDownloadETA() != 0L) continue;
                                        transcodeJobImpl = transcodeJobImpl2;
                                    }
                                }
                                TranscodeQueueImpl.this.checkJobStatus();
                                if (transcodeJobImpl == null || !TranscodeQueueImpl.this.process(transcodeJobImpl)) continue;
                                try {
                                    TranscodeQueueImpl.this.remove(transcodeJobImpl, true);
                                }
                                catch (TranscodeActionVetoException transcodeActionVetoException) {
                                    Debug.out(transcodeActionVetoException);
                                }
                            }
                        }
                        finally {
                            TranscodeQueueImpl.this.checkJobStatus();
                        }
                    }
                };
                this.queue_thread.start();
            }
        }
    }

    protected void updateStatus(int n) {
        if (this.queue.size() > 0) {
            TranscodeJobImpl[] transcodeJobImplArray;
            for (TranscodeJobImpl transcodeJobImpl : transcodeJobImplArray = this.getJobs()) {
                transcodeJobImpl.updateStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkJobStatus() {
        HashSet<DeviceImpl> hashSet = new HashSet<DeviceImpl>(Arrays.asList(this.manager.getManager().getDevices()));
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            for (TranscodeJobImpl transcodeJobImpl : this.queue) {
                if (transcodeJobImpl.getState() != 5) continue;
                DeviceImpl deviceImpl = transcodeJobImpl.getDevice();
                deviceImpl.setError(KEY_XCODE_ERROR, MessageText.getString("device.error.xcodefail"));
                hashSet.remove(deviceImpl);
            }
        }
        for (DeviceImpl deviceImpl : hashSet) {
            deviceImpl.setError(KEY_XCODE_ERROR, null);
        }
    }

    @Override
    public TranscodeJobImpl add(TranscodeTarget transcodeTarget, TranscodeProfile transcodeProfile, DiskManagerFileInfo diskManagerFileInfo, boolean bl) throws TranscodeException {
        return this.add(transcodeTarget, transcodeProfile, diskManagerFileInfo, bl, false, -1);
    }

    @Override
    public TranscodeJobImpl add(TranscodeTarget transcodeTarget, TranscodeProfile transcodeProfile, DiskManagerFileInfo diskManagerFileInfo, int n, boolean bl) throws TranscodeException {
        return this.add(transcodeTarget, transcodeProfile, diskManagerFileInfo, bl, false, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeJobImpl add(TranscodeTarget transcodeTarget, TranscodeProfile transcodeProfile, DiskManagerFileInfo diskManagerFileInfo, boolean bl, boolean bl2, int n) throws TranscodeException {
        Iterator<TranscodeQueueListener> iterator;
        Object object;
        TranscodeFileImpl transcodeFileImpl = ((DeviceImpl)transcodeTarget.getDevice()).lookupFile(transcodeProfile, diskManagerFileInfo);
        if (transcodeFileImpl != null) {
            object = new ArrayList();
            iterator = this;
            synchronized (iterator) {
                for (TranscodeJobImpl transcodeJobImpl : this.queue) {
                    if (transcodeJobImpl.getTarget() != transcodeTarget || !transcodeJobImpl.getTranscodeFile().equals(transcodeFileImpl)) continue;
                    object.add(transcodeJobImpl);
                }
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                TranscodeJobImpl transcodeJobImpl = (TranscodeJobImpl)iterator.next();
                transcodeJobImpl.removeForce();
            }
            if (!bl2) {
                transcodeFileImpl.delete(true);
            }
        }
        object = new TranscodeJobImpl(this, transcodeTarget, transcodeProfile, diskManagerFileInfo, bl, n, bl2);
        try {
            iterator = this;
            synchronized (iterator) {
                this.queue.add((TranscodeJobImpl)object);
                this.queue_sem.release();
                this.configDirty();
            }
            try {
                PlatformDevicesMessenger.qosTranscode((TranscodeJob)object, 0);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
            for (TranscodeQueueListener transcodeQueueListener : this.listeners) {
                try {
                    transcodeQueueListener.jobAdded((TranscodeJob)object);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        finally {
            this.schedule();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(TranscodeJobImpl transcodeJobImpl, boolean bl) throws TranscodeActionVetoException {
        Iterator<TranscodeQueueListener> iterator = this;
        synchronized (iterator) {
            if (!this.queue.contains(transcodeJobImpl)) {
                return;
            }
        }
        if (!bl) {
            for (TranscodeQueueActionListener object : this.action_listeners) {
                try {
                    object.jobWillBeActioned(transcodeJobImpl, 1);
                }
                catch (TranscodeActionVetoException throwable) {
                    throw throwable;
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
            }
        }
        iterator = this;
        synchronized (iterator) {
            if (!this.queue.remove(transcodeJobImpl)) {
                return;
            }
        }
        this.configDirty();
        transcodeJobImpl.destroy();
        for (TranscodeQueueListener transcodeQueueListener : this.listeners) {
            try {
                transcodeQueueListener.jobRemoved(transcodeJobImpl);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        this.checkJobStatus();
        this.schedule();
    }

    protected void jobChanged(TranscodeJob transcodeJob, boolean bl, boolean bl2) {
        for (TranscodeQueueListener transcodeQueueListener : this.listeners) {
            try {
                transcodeQueueListener.jobChanged(transcodeJob);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (bl2) {
            this.configDirty();
        }
        if (bl) {
            this.queue_sem.release();
            this.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getIndex(TranscodeJobImpl transcodeJobImpl) {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            return this.queue.indexOf(transcodeJobImpl) + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeJobImpl[] getJobs() {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            return this.queue.toArray(new TranscodeJobImpl[this.queue.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getJobCount() {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            return this.queue.size();
        }
    }

    @Override
    public TranscodeJob getCurrentJob() {
        return this.current_job;
    }

    @Override
    public boolean isTranscoding() {
        return this.current_job != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TranscodeJobImpl getJob(TranscodeFile transcodeFile) {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            for (TranscodeJobImpl transcodeJobImpl : this.queue) {
                if (!transcodeJobImpl.getTranscodeFile().equals(transcodeFile)) continue;
                return transcodeJobImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUp(TranscodeJobImpl transcodeJobImpl) {
        TranscodeJobImpl[] transcodeJobImplArray = this;
        synchronized (this) {
            int n = this.queue.indexOf(transcodeJobImpl);
            if (n <= 0 || this.queue.size() == 1) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            this.queue.remove(transcodeJobImpl);
            this.queue.add(n - 1, transcodeJobImpl);
            TranscodeJobImpl[] transcodeJobImplArray2 = this.getJobs();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (TranscodeJobImpl transcodeJobImpl2 : transcodeJobImplArray2) {
                this.jobChanged(transcodeJobImpl2, false, true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDown(TranscodeJobImpl transcodeJobImpl) {
        TranscodeJobImpl[] transcodeJobImplArray = this;
        synchronized (this) {
            int n = this.queue.indexOf(transcodeJobImpl);
            if (n < 0 || n == this.queue.size() - 1) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            this.queue.remove(transcodeJobImpl);
            this.queue.add(n + 1, transcodeJobImpl);
            TranscodeJobImpl[] transcodeJobImplArray2 = this.getJobs();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (TranscodeJobImpl transcodeJobImpl2 : transcodeJobImplArray2) {
                this.jobChanged(transcodeJobImpl2, false, true);
            }
            return;
        }
    }

    @Override
    public void pause() {
        if (!this.paused && this.paused) {
            COConfigurationManager.setParameter("xcode.paused", true);
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void resume() {
        if (this.paused) {
            COConfigurationManager.setParameter("xcode.queue.paused", false);
        }
    }

    @Override
    public long getMaxBytesPerSecond() {
        return this.max_bytes_per_sec;
    }

    @Override
    public void setMaxBytesPerSecond(long l) {
        COConfigurationManager.setParameter("xcode.queue.maxbps", l);
    }

    protected TranscodeTarget lookupTarget(String string) throws TranscodeException {
        return this.manager.lookupTarget(string);
    }

    protected TranscodeProfile lookupProfile(String string) throws TranscodeException {
        TranscodeProfile transcodeProfile = this.manager.getProfileFromUID(string);
        if (transcodeProfile == null) {
            throw new TranscodeException("Transcode profile with id '" + string + "' not found");
        }
        return transcodeProfile;
    }

    protected DiskManagerFileInfo lookupFile(byte[] byArray, int n) throws TranscodeException {
        return this.manager.lookupFile(byArray, n);
    }

    protected void analyse(final TranscodeJobImpl transcodeJobImpl, final TranscodeAnalysisListener transcodeAnalysisListener) throws TranscodeException {
        this.anaylsis_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    TranscodeProviderAnalysis transcodeProviderAnalysis = TranscodeQueueImpl.this.analyse(transcodeJobImpl);
                    transcodeAnalysisListener.analysisComplete(transcodeJobImpl, transcodeProviderAnalysis);
                }
                catch (TranscodeException transcodeException) {
                    transcodeAnalysisListener.analysisFailed(transcodeJobImpl, transcodeException);
                }
                catch (Throwable throwable) {
                    transcodeAnalysisListener.analysisFailed(transcodeJobImpl, new TranscodeException("Analysis failed", throwable));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TranscodeProviderAnalysis analyse(final TranscodeJobImpl transcodeJobImpl) throws TranscodeException {
        TranscodeProvider transcodeProvider = transcodeJobImpl.getProfile().getProvider();
        final TranscodeException[] transcodeExceptionArray = new TranscodeException[]{null};
        TranscodeProfile transcodeProfile = transcodeJobImpl.getProfile();
        final AESemaphore aESemaphore = new AESemaphore("analysis:proc");
        final boolean bl = transcodeJobImpl.getState() == 6;
        TranscodeProviderAdapter transcodeProviderAdapter = new TranscodeProviderAdapter(){

            @Override
            public void updateProgress(int n, int n2, int n3, int n4) {
            }

            @Override
            public void streamStats(long l, long l2) {
            }

            @Override
            public void failed(TranscodeException transcodeException) {
                transcodeExceptionArray[0] = transcodeException;
                aESemaphore.release();
            }

            @Override
            public void complete() {
                aESemaphore.release();
            }
        };
        final TranscodeProviderAnalysis transcodeProviderAnalysis = transcodeProvider.analyse(transcodeProviderAdapter, transcodeJobImpl.getFile(), transcodeProfile);
        TranscodeQueueListener transcodeQueueListener = new TranscodeQueueListener(){

            @Override
            public void jobAdded(TranscodeJob transcodeJob) {
            }

            @Override
            public void jobChanged(TranscodeJob transcodeJob) {
                if (transcodeJob == transcodeJobImpl) {
                    int n = transcodeJobImpl.getState();
                    if (n == 4) {
                        transcodeProviderAnalysis.cancel();
                    } else if (n == 6 && !bl) {
                        transcodeProviderAnalysis.cancel();
                    }
                }
            }

            @Override
            public void jobRemoved(TranscodeJob transcodeJob) {
                if (transcodeJob == transcodeJobImpl) {
                    transcodeProviderAnalysis.cancel();
                }
            }
        };
        try {
            this.addListener(transcodeQueueListener);
            aESemaphore.reserve();
        }
        finally {
            this.removeListener(transcodeQueueListener);
        }
        if (transcodeExceptionArray[0] != null) {
            throw transcodeExceptionArray[0];
        }
        TranscodeFileImpl transcodeFileImpl = transcodeJobImpl.getTranscodeFile();
        transcodeFileImpl.update(transcodeProviderAnalysis);
        return transcodeProviderAnalysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("TranscodeQueue:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    TranscodeQueueImpl transcodeQueueImpl = TranscodeQueueImpl.this;
                    synchronized (transcodeQueueImpl) {
                        if (!TranscodeQueueImpl.this.config_dirty) {
                            return;
                        }
                        TranscodeQueueImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        if (!FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
            return;
        }
        this.log("Loading configuration");
        try {
            TranscodeQueueImpl transcodeQueueImpl = this;
            synchronized (transcodeQueueImpl) {
                Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
                List list = (List)map.get("jobs");
                if (list != null) {
                    for (Map map2 : list) {
                        try {
                            TranscodeJobImpl transcodeJobImpl = new TranscodeJobImpl(this, map2);
                            this.queue.add(transcodeJobImpl);
                            this.queue_sem.release();
                        }
                        catch (Throwable throwable) {
                            this.log("Failed to restore job: " + map2, throwable);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.log("Configuration load failed", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        TranscodeQueueImpl transcodeQueueImpl = this;
        synchronized (transcodeQueueImpl) {
            this.config_dirty = false;
            if (this.queue.size() == 0) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                HashMap hashMap = new HashMap();
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                hashMap.put("jobs", arrayList);
                for (TranscodeJobImpl transcodeJobImpl : this.queue) {
                    if (transcodeJobImpl.isStream()) continue;
                    try {
                        arrayList.add(transcodeJobImpl.toMap());
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to save job", throwable);
                    }
                }
                FileUtil.writeResilientConfigFile(CONFIG_FILE, hashMap);
            }
        }
    }

    protected void close() {
        if (this.config_dirty) {
            this.saveConfig();
        }
    }

    @Override
    public void addListener(TranscodeQueueListener transcodeQueueListener) {
        if (!this.listeners.contains(transcodeQueueListener)) {
            this.listeners.add(transcodeQueueListener);
        }
    }

    @Override
    public void removeListener(TranscodeQueueListener transcodeQueueListener) {
        this.listeners.remove(transcodeQueueListener);
    }

    @Override
    public void addActionListener(TranscodeQueueActionListener transcodeQueueActionListener) {
        this.action_listeners.add(transcodeQueueActionListener);
    }

    @Override
    public void removeActionListener(TranscodeQueueActionListener transcodeQueueActionListener) {
        this.action_listeners.remove(transcodeQueueActionListener);
    }

    protected void log(String string) {
        this.manager.log("Queue: " + string);
    }

    protected void log(String string, Throwable throwable) {
        this.manager.log("Queue: " + string, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("Transcode Queue: paused=" + this.paused + ",max_bps=" + this.max_bytes_per_sec);
        try {
            TranscodeJobImpl[] transcodeJobImplArray;
            indentWriter.indent();
            for (TranscodeJobImpl transcodeJobImpl : transcodeJobImplArray = this.getJobs()) {
                transcodeJobImpl.generate(indentWriter);
            }
        }
        finally {
            indentWriter.exdent();
        }
    }
}

