/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererManual;
import com.aelitis.azureus.core.drivedetector.DriveDetectedInfo;
import com.aelitis.azureus.core.drivedetector.DriveDetectedListener;
import com.aelitis.azureus.core.drivedetector.DriveDetectorFactory;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;

public class DeviceDriveManager
implements DriveDetectedListener {
    private DeviceManagerImpl manager;
    private Map<String, DeviceMediaRendererManual> device_map = new HashMap<String, DeviceMediaRendererManual>();
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher();
    private boolean listener_added;

    protected DeviceDriveManager(DeviceManagerImpl deviceManagerImpl) {
        this.manager = deviceManagerImpl;
        if (this.manager.getAutoSearch()) {
            this.listener_added = true;
            DriveDetectorFactory.getDeviceDetector().addListener(this);
        }
    }

    protected void search() {
        this.async_dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                if (DeviceDriveManager.this.listener_added) {
                    return;
                }
                try {
                    DriveDetectorFactory.getDeviceDetector().addListener(DeviceDriveManager.this);
                }
                finally {
                    DriveDetectorFactory.getDeviceDetector().removeListener(DeviceDriveManager.this);
                }
            }
        });
    }

    @Override
    public void driveDetected(final DriveDetectedInfo driveDetectedInfo) {
        this.async_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                File[] fileArray;
                Map<String, Object> map = driveDetectedInfo.getInfoMap();
                boolean bl = MapUtils.getMapBoolean(map, "isWritableUSB", false);
                File file = driveDetectedInfo.getLocation();
                String string = MapUtils.getMapString(map, "ProductID", MapUtils.getMapString(map, "Product Name", "")).trim();
                String string2 = MapUtils.getMapString(map, "VendorID", MapUtils.getMapString(map, "Vendor Name", "")).trim();
                if (string.toLowerCase().contains("android") || string2.toLowerCase().contains("motorola") || string2.equalsIgnoreCase("samsung")) {
                    if (bl && string2.equalsIgnoreCase("samsung")) {
                        bl = !string.startsWith("Y") && string.matches(".*[A-Z]-.*");
                    }
                    boolean bl2 = false;
                    String string3 = string2;
                    if (string3.length() > 0) {
                        string3 = string3 + " ";
                    }
                    string3 = string3 + string;
                    if (string2.compareToIgnoreCase("motorola") == 0) {
                        if (string.equalsIgnoreCase("a855")) {
                            string3 = "Droid";
                        } else if (string.equalsIgnoreCase("a955")) {
                            string3 = "Droid 2";
                        } else if (string.equalsIgnoreCase("mb810")) {
                            string3 = "Droid X";
                        }
                    } else if (string.equalsIgnoreCase("sgh-t959")) {
                        string3 = "Samsung Vibrant";
                    } else if (string.toLowerCase().contains("sgh-t959")) {
                        bl2 = true;
                    }
                    String string4 = "android.";
                    string4 = string4 + string.replaceAll(" ", ".").toLowerCase();
                    if (string2.length() > 0) {
                        string4 = string4 + "." + string2.replaceAll(" ", ".").toLowerCase();
                    }
                    if (bl) {
                        DeviceDriveManager.this.addDevice(string3, string4, file, new File(file, "videos"), bl2);
                    } else {
                        DeviceMediaRenderer deviceMediaRenderer = DeviceDriveManager.this.getDeviceMediaRendererByClassification(string4);
                        if (deviceMediaRenderer != null) {
                            deviceMediaRenderer.remove();
                        }
                    }
                    return;
                }
                if (bl && string2.toLowerCase().equals("rim") && !string.toLowerCase().contains(" SD")) {
                    String string5 = string2;
                    if (string5.length() > 0) {
                        string5 = string5 + " ";
                    }
                    string5 = string5 + string;
                    String string6 = "";
                    string6 = string6 + string.replaceAll(" ", ".").toLowerCase();
                    if (string2.length() > 0) {
                        string6 = string6 + "." + string2.replaceAll(" ", ".").toLowerCase();
                    }
                    DeviceDriveManager.this.addDevice(string5, string6, file, new File(file, "videos"), false);
                    return;
                }
                if (bl && file.exists() && (fileArray = file.listFiles()) != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (File file2 : fileArray) {
                        hashSet.add(file2.getName().toLowerCase());
                    }
                    if (hashSet.contains("psp") && hashSet.contains("video")) {
                        DeviceDriveManager.this.addDevice("PSP", "sony.PSP", file, new File(file, "VIDEO"), false);
                    }
                }
            }
        });
    }

    protected DeviceMediaRenderer getDeviceMediaRendererByClassification(String string) {
        DeviceImpl[] deviceImplArray;
        for (DeviceImpl deviceImpl : deviceImplArray = this.manager.getDevices()) {
            DeviceMediaRenderer deviceMediaRenderer;
            String string2;
            if (!(deviceImpl instanceof DeviceMediaRenderer) || !(string2 = (deviceMediaRenderer = (DeviceMediaRenderer)((Object)deviceImpl)).getClassification()).equalsIgnoreCase(string)) continue;
            return deviceMediaRenderer;
        }
        return null;
    }

    protected void addDevice(String string, String string2, File file, File file2, boolean bl) {
        DeviceMediaRenderer deviceMediaRenderer = this.getDeviceMediaRendererByClassification(string2);
        if (deviceMediaRenderer instanceof DeviceMediaRendererManual) {
            this.mapDevice((DeviceMediaRendererManual)deviceMediaRenderer, file, file2);
            return;
        }
        DeviceTemplate[] deviceTemplateArray = this.manager.getDeviceTemplates(3);
        DeviceMediaRendererManual deviceMediaRendererManual = null;
        for (DeviceTemplate deviceTemplate : deviceTemplateArray) {
            if (!deviceTemplate.getClassification().equalsIgnoreCase(string2)) continue;
            try {
                deviceMediaRendererManual = (DeviceMediaRendererManual)deviceTemplate.createInstance(string);
                break;
            }
            catch (Throwable throwable) {
                this.log("Failed to add device", throwable);
            }
        }
        if (deviceMediaRendererManual == null) {
            try {
                deviceMediaRendererManual = (DeviceMediaRendererManual)this.manager.createDevice(3, null, string2, string);
            }
            catch (Throwable throwable) {
                this.log("Failed to add device", throwable);
            }
        }
        if (deviceMediaRendererManual != null) {
            try {
                deviceMediaRendererManual.setAutoCopyToFolder(true);
                deviceMediaRendererManual.setHidden(bl);
                this.mapDevice(deviceMediaRendererManual, file, file2);
                return;
            }
            catch (Throwable throwable) {
                this.log("Failed to add device", throwable);
            }
        }
    }

    @Override
    public void driveRemoved(final DriveDetectedInfo driveDetectedInfo) {
        this.async_dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                DeviceDriveManager.this.unMapDevice(driveDetectedInfo.getLocation());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapDevice(DeviceMediaRendererManual deviceMediaRendererManual, File file, File file2) {
        DeviceMediaRendererManual deviceMediaRendererManual2;
        Map<String, DeviceMediaRendererManual> map = this.device_map;
        synchronized (map) {
            deviceMediaRendererManual2 = this.device_map.put(file.getAbsolutePath(), deviceMediaRendererManual);
        }
        if (deviceMediaRendererManual2 != null && deviceMediaRendererManual2 != deviceMediaRendererManual) {
            this.log("Unmapped " + deviceMediaRendererManual2.getName() + " from " + file);
            deviceMediaRendererManual2.setCopyToFolder(null);
        }
        this.log("Mapped " + deviceMediaRendererManual.getName() + " to " + file);
        deviceMediaRendererManual.setCopyToFolder(file2);
        deviceMediaRendererManual.setLivenessDetectable(true);
        deviceMediaRendererManual.alive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unMapDevice(File file) {
        DeviceMediaRendererManual deviceMediaRendererManual;
        Map<String, DeviceMediaRendererManual> map = this.device_map;
        synchronized (map) {
            deviceMediaRendererManual = this.device_map.remove(file.getAbsolutePath());
        }
        if (deviceMediaRendererManual != null) {
            this.log("Unmapped " + deviceMediaRendererManual.getName() + " from " + file);
            deviceMediaRendererManual.setCopyToFolder(null);
            deviceMediaRendererManual.dead();
        }
    }

    protected void log(String string) {
        this.manager.log("DriveMan: " + string);
    }

    protected void log(String string, Throwable throwable) {
        this.manager.log("DriveMan: " + string, throwable);
    }
}

