/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.cnetwork.impl;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkException;
import com.aelitis.azureus.core.cnetwork.ContentNetworkListener;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManager;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkImpl;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkVuze;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkVuzeGeneric;
import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationManager;
import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.config.PlatformContentNetworkMessenger;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class ContentNetworkManagerImpl
implements ContentNetworkManager,
AEDiagnosticsEvidenceGenerator {
    private static final boolean LOAD_ALL_NETWORKS = true;
    private static final String CONFIG_FILE = "cnetworks.config";
    private static ContentNetworkManagerImpl singleton = new ContentNetworkManagerImpl();
    private List<ContentNetworkImpl> networks = new ArrayList<ContentNetworkImpl>();
    private CopyOnWriteList<ContentNetworkListener> listeners = new CopyOnWriteList();

    public static void preInitialise() {
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            @Override
            public void process(VuzeFile[] vuzeFileArray, int n) {
                for (int i = 0; i < vuzeFileArray.length; ++i) {
                    VuzeFile vuzeFile = vuzeFileArray[i];
                    VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
                    for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                        VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                        if (vuzeFileComponent.getType() != 128) continue;
                        try {
                            ((ContentNetworkManagerImpl)ContentNetworkManagerImpl.getSingleton()).importNetwork(vuzeFileComponent.getContent());
                            vuzeFileComponent.setProcessed();
                            continue;
                        }
                        catch (Throwable throwable) {
                            ContentNetworkManagerImpl.log("Failed to import from vuze file", throwable);
                            Debug.out(throwable);
                        }
                    }
                }
            }
        });
    }

    public static ContentNetworkManager getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentNetworkManagerImpl() {
        this.loadConfig();
        this.addNetwork(new ContentNetworkVuze(this));
        AEDiagnostics.addEvidenceGenerator(this);
        CustomizationManager customizationManager = CustomizationManagerFactory.getSingleton();
        Customization customization = customizationManager.getActiveCustomization();
        if (customization != null) {
            boolean bl;
            String string = COConfigurationManager.getStringParameter("cnetworks.custom.name", "");
            String string2 = COConfigurationManager.getStringParameter("cnetworks.custom.version", "0");
            boolean bl2 = !string.equals(customization.getName());
            boolean bl3 = bl = Constants.compareVersions(string2, customization.getVersion()) < 0;
            if (bl2 || bl) {
                try {
                    InputStream[] inputStreamArray = customization.getResources("cnetworks");
                    for (int i = 0; i < inputStreamArray.length; ++i) {
                        InputStream inputStream = inputStreamArray[i];
                        try {
                            VuzeFile vuzeFile = VuzeFileHandler.getSingleton().loadVuzeFile(inputStream);
                            if (vuzeFile == null) continue;
                            VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
                            for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                                VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                                int n = vuzeFileComponent.getType();
                                if (n != 128) continue;
                                try {
                                    ContentNetworkImpl contentNetworkImpl = this.importNetwork(vuzeFileComponent.getContent());
                                    contentNetworkImpl.setPersistentProperty("is_cust", true);
                                    vuzeFileComponent.setProcessed();
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    ContentNetworkManagerImpl.log("Failed to import customisation network", throwable);
                                }
                            }
                            continue;
                        }
                        finally {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                finally {
                    COConfigurationManager.setParameter("cnetworks.custom.name", customization.getName());
                    COConfigurationManager.setParameter("cnetworks.custom.version", customization.getVersion());
                }
            }
        }
        SimpleTimer.addPeriodicEvent("MetaSearchRefresh", 82800000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent2) {
                ContentNetworkManagerImpl.this.checkForUpdates();
            }
        });
        if (this.networks.size() <= 1) {
            // empty if block
        }
        new AEThread2("CNetwork:init", true){

            @Override
            public void run() {
                ContentNetworkManagerImpl.this.checkForUpdates();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForUpdates() {
        ContentNetworkManagerImpl contentNetworkManagerImpl = this;
        synchronized (contentNetworkManagerImpl) {
            if (this.networks.size() < 2) {
                // empty if block
            }
        }
        PlatformContentNetworkMessenger.listNetworksAync(new PlatformContentNetworkMessenger.listNetworksListener(){

            @Override
            public void networkListReturned(List<PlatformContentNetworkMessenger.contentNetworkDetails> list) {
                try {
                    String string = "";
                    for (PlatformContentNetworkMessenger.contentNetworkDetails contentNetworkDetails2 : list) {
                        ContentNetworkImpl contentNetworkImpl;
                        string = string + (string.length() == 0 ? "" : ", ") + contentNetworkDetails2.getString();
                        ContentNetworkImpl contentNetworkImpl2 = ContentNetworkManagerImpl.this.getContentNetwork(contentNetworkDetails2.getID());
                        if (contentNetworkImpl2 != null) {
                            contentNetworkImpl = ContentNetworkManagerImpl.this.createNetwork(contentNetworkDetails2);
                            ContentNetworkManagerImpl.this.addNetwork(contentNetworkImpl);
                            continue;
                        }
                        contentNetworkImpl = ContentNetworkManagerImpl.this.createNetwork(contentNetworkDetails2);
                        ContentNetworkManagerImpl.this.addNetwork(contentNetworkImpl);
                    }
                    ContentNetworkManagerImpl.log("Latest networks: " + string);
                }
                catch (Throwable throwable) {
                    ContentNetworkManagerImpl.log("Failed to load network list", throwable);
                }
            }
        }, 11110);
    }

    protected ContentNetworkImpl importNetwork(Map map) throws IOException {
        ContentNetworkImpl contentNetworkImpl = ContentNetworkImpl.importFromBEncodedMapStatic(this, map);
        return this.addNetwork(contentNetworkImpl);
    }

    @Override
    public void addContentNetwork(final long l) throws ContentNetworkException {
        try {
            PlatformContentNetworkMessenger.listNetworksAync(new PlatformContentNetworkMessenger.listNetworksListener(){

                @Override
                public void networkListReturned(List<PlatformContentNetworkMessenger.contentNetworkDetails> list) {
                    if (list == null) {
                        PlatformMessengerException platformMessengerException = new PlatformMessengerException("No networks returned");
                        for (ContentNetworkListener contentNetworkImpl : ContentNetworkManagerImpl.this.listeners) {
                            contentNetworkImpl.networkAddFailed(l, platformMessengerException);
                        }
                        return;
                    }
                    for (PlatformContentNetworkMessenger.contentNetworkDetails object : list) {
                        if (object.getID() != l) continue;
                        try {
                            ContentNetworkImpl contentNetworkListener = ContentNetworkManagerImpl.this.createNetwork(object);
                            ContentNetworkManagerImpl.this.addNetwork(contentNetworkListener);
                        }
                        catch (ContentNetworkException contentNetworkException) {
                            for (ContentNetworkListener contentNetworkListener : ContentNetworkManagerImpl.this.listeners) {
                                contentNetworkListener.networkAddFailed(l, contentNetworkException);
                            }
                        }
                        return;
                    }
                    ContentNetworkException contentNetworkException = new ContentNetworkException("Content Network with id " + l + " not found");
                    for (ContentNetworkListener contentNetworkListener : ContentNetworkManagerImpl.this.listeners) {
                        contentNetworkListener.networkAddFailed(l, contentNetworkException);
                    }
                }
            }, 500);
        }
        catch (Throwable throwable) {
            ContentNetworkException contentNetworkException = new ContentNetworkException("Failed to list permitted networks", throwable);
            for (ContentNetworkListener contentNetworkListener : this.listeners) {
                contentNetworkListener.networkAddFailed(l, contentNetworkException);
            }
            throw contentNetworkException;
        }
    }

    @Override
    public ContentNetwork getContentNetworkForURL(String string) {
        try {
            String string2 = new URL(string).getHost();
            for (ContentNetwork contentNetwork : this.getContentNetworks()) {
                String string3 = (String)contentNetwork.getProperty(1);
                if (string3 == null || !string3.endsWith(string2)) continue;
                return contentNetwork;
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return null;
    }

    @Override
    public ContentNetwork getStartupContentNetwork() {
        ContentNetwork[] contentNetworkArray;
        for (ContentNetwork contentNetwork : contentNetworkArray = this.getContentNetworks()) {
            if (!contentNetwork.isStartupNetwork()) continue;
            return contentNetwork;
        }
        return this.getContentNetwork(1L);
    }

    protected ContentNetworkImpl createNetwork(PlatformContentNetworkMessenger.contentNetworkDetails contentNetworkDetails2) throws ContentNetworkException {
        String string;
        String string2 = contentNetworkDetails2.getMainURL();
        String string3 = contentNetworkDetails2.getIconURL();
        try {
            string = new URL(string2).getHost();
        }
        catch (Throwable throwable) {
            ContentNetworkManagerImpl.log("Failed to get main-url host", throwable);
            throw new ContentNetworkException("main url invald", throwable);
        }
        ContentNetworkImpl contentNetworkImpl = this.getContentNetwork(contentNetworkDetails2.getID());
        Map<String, Object> map = null;
        Set<Integer> set = null;
        if (contentNetworkImpl != null) {
            map = contentNetworkImpl.getPersistentPropertyDefaults();
            if (contentNetworkImpl instanceof ContentNetworkVuzeGeneric) {
                set = ((ContentNetworkVuzeGeneric)contentNetworkImpl).getServiceExclusions();
            }
        }
        return new ContentNetworkVuzeGeneric(this, contentNetworkDetails2.getID(), contentNetworkDetails2.getVersion(), contentNetworkDetails2.getName(), map, set, string, string2, string3, null, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentNetwork[] getContentNetworks() {
        ContentNetworkManagerImpl contentNetworkManagerImpl = this;
        synchronized (contentNetworkManagerImpl) {
            return this.networks.toArray(new ContentNetworkImpl[this.networks.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentNetworkImpl getContentNetwork(long l) {
        ContentNetworkManagerImpl contentNetworkManagerImpl = this;
        synchronized (contentNetworkManagerImpl) {
            for (int i = 0; i < this.networks.size(); ++i) {
                ContentNetworkImpl contentNetworkImpl = this.networks.get(i);
                if (contentNetworkImpl.getID() != l) continue;
                return contentNetworkImpl;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentNetworkImpl addNetwork(ContentNetworkImpl contentNetworkImpl) {
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            for (ContentNetworkImpl contentNetworkImpl2 : this.networks) {
                if (contentNetworkImpl2.getID() != contentNetworkImpl.getID()) continue;
                if (contentNetworkImpl.getVersion() > contentNetworkImpl2.getVersion()) {
                    try {
                        contentNetworkImpl2.updateFrom(contentNetworkImpl);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                    contentNetworkImpl = contentNetworkImpl2;
                    bl = true;
                    break;
                }
                ContentNetworkManagerImpl.log("Network " + contentNetworkImpl2.getString() + " already up to date");
                return contentNetworkImpl2;
            }
            if (bl) {
                ContentNetworkManagerImpl.log("Updated network: " + contentNetworkImpl.getString());
            } else {
                ContentNetworkManagerImpl.log("Added network: " + contentNetworkImpl.getString());
                this.networks.add(contentNetworkImpl);
            }
            if (contentNetworkImpl.getID() != 1L) {
                this.saveConfig();
            }
        }
        object = this.listeners.iterator();
        while (object.hasNext()) {
            try {
                if (bl) {
                    ((ContentNetworkListener)object.next()).networkChanged(contentNetworkImpl);
                    continue;
                }
                ((ContentNetworkListener)object.next()).networkAdded(contentNetworkImpl);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        return contentNetworkImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNetwork(ContentNetworkImpl contentNetworkImpl) {
        Object object = this;
        synchronized (object) {
            if (!this.networks.remove(contentNetworkImpl)) {
                return;
            }
            contentNetworkImpl.destroy();
            this.saveConfig();
        }
        ContentNetworkManagerImpl.log("Removed network: " + contentNetworkImpl.getString());
        object = this.listeners.iterator();
        while (object.hasNext()) {
            try {
                ((ContentNetworkListener)object.next()).networkRemoved(contentNetworkImpl);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    protected void loadConfig() {
        Map map;
        List list;
        if (FileUtil.resilientConfigFileExists(CONFIG_FILE) && (list = (List)(map = FileUtil.readResilientConfigFile(CONFIG_FILE)).get("networks")) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Map map2 = (Map)list.get(i);
                try {
                    ContentNetworkImpl contentNetworkImpl = ContentNetworkImpl.importFromBEncodedMapStatic(this, map2);
                    if (contentNetworkImpl.getID() == 1L) continue;
                    this.networks.add(contentNetworkImpl);
                    continue;
                }
                catch (Throwable throwable) {
                    ContentNetworkManagerImpl.log("Failed to load " + map2, throwable);
                }
            }
        }
    }

    protected void saveConfig() {
        HashMap hashMap = new HashMap();
        ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
        hashMap.put("networks", arrayList);
        for (ContentNetworkImpl contentNetworkImpl : this.networks) {
            if (contentNetworkImpl.getID() == 1L) continue;
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            try {
                contentNetworkImpl.exportToBEncodedMap(hashMap2);
                arrayList.add(hashMap2);
            }
            catch (Throwable throwable) {
                ContentNetworkManagerImpl.log("Failed to save " + contentNetworkImpl.getName(), throwable);
            }
        }
        if (arrayList.size() == 0) {
            FileUtil.deleteResilientConfigFile(CONFIG_FILE);
        } else {
            FileUtil.writeResilientConfigFile(CONFIG_FILE, hashMap);
        }
    }

    @Override
    public void addListener(ContentNetworkListener contentNetworkListener) {
        this.listeners.add(contentNetworkListener);
    }

    @Override
    public void removeListener(ContentNetworkListener contentNetworkListener) {
        this.listeners.remove(contentNetworkListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("Content Networks");
        try {
            indentWriter.indent();
            ContentNetworkManagerImpl contentNetworkManagerImpl = this;
            synchronized (contentNetworkManagerImpl) {
                for (ContentNetworkImpl contentNetworkImpl : this.networks) {
                    indentWriter.println(contentNetworkImpl.getString());
                }
            }
        }
        finally {
            indentWriter.exdent();
        }
    }

    public static void log(String string, Throwable throwable) {
        AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("CNetworks");
        aEDiagnosticsLogger.log(string);
        aEDiagnosticsLogger.log(throwable);
    }

    public static void log(String string) {
        AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger("CNetworks");
        aEDiagnosticsLogger.log(string);
    }
}

