/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.read;

import com.googlecode.mp4parser.h264.BTree;
import com.googlecode.mp4parser.h264.Debug;
import com.googlecode.mp4parser.h264.read.BitstreamReader;
import java.io.IOException;
import java.io.InputStream;

public class CAVLCReader
extends BitstreamReader {
    public CAVLCReader(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public long readNBit(int n, String string) throws IOException {
        long l = this.readNBit(n);
        this.trace(string, String.valueOf(l));
        return l;
    }

    private int readUE() throws IOException {
        int n = 0;
        while (this.read1Bit() == 0) {
            ++n;
        }
        int n2 = 0;
        if (n > 0) {
            long l = this.readNBit(n);
            n2 = (int)((long)((1 << n) - 1) + l);
        }
        return n2;
    }

    public int readUE(String string) throws IOException {
        int n = this.readUE();
        this.trace(string, String.valueOf(n));
        return n;
    }

    public int readSE(String string) throws IOException {
        int n = this.readUE();
        int n2 = ((n & 1) << 1) - 1;
        n = ((n >> 1) + (n & 1)) * n2;
        this.trace(string, String.valueOf(n));
        return n;
    }

    public boolean readBool(String string) throws IOException {
        boolean bl = this.read1Bit() != 0;
        this.trace(string, bl ? "1" : "0");
        return bl;
    }

    public int readU(int n, String string) throws IOException {
        return (int)this.readNBit(n, string);
    }

    public byte[] read(int n) throws IOException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)this.readByte();
        }
        return byArray;
    }

    public boolean readAE() {
        throw new UnsupportedOperationException("Stan");
    }

    public int readTE(int n) throws IOException {
        if (n > 1) {
            return this.readUE();
        }
        return ~this.read1Bit() & 1;
    }

    public int readAEI() {
        throw new UnsupportedOperationException("Stan");
    }

    public int readME(String string) throws IOException {
        return this.readUE(string);
    }

    public Object readCE(BTree bTree, String string) throws IOException {
        Object object;
        do {
            int n;
            if ((bTree = bTree.down(n = this.read1Bit())) != null) continue;
            throw new RuntimeException("Illegal code");
        } while ((object = bTree.getValue()) == null);
        this.trace(string, object.toString());
        return object;
    }

    public int readZeroBitCount(String string) throws IOException {
        int n = 0;
        while (this.read1Bit() == 0) {
            ++n;
        }
        this.trace(string, String.valueOf(n));
        return n;
    }

    public void readTrailingBits() throws IOException {
        this.read1Bit();
        this.readRemainingByte();
    }

    private void trace(String string, String string2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = String.valueOf(bitsRead - this.debugBits.length());
        int n2 = 8 - string3.length();
        stringBuilder.append("@" + string3);
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        n2 = 100 - stringBuilder.length() - this.debugBits.length();
        for (n = 0; n < n2; ++n) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(this.debugBits);
        stringBuilder.append(" (" + string2 + ")");
        this.debugBits.clear();
        Debug.println(stringBuilder.toString());
    }
}

