/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.h264.model;

import com.googlecode.mp4parser.h264.read.CAVLCReader;
import com.googlecode.mp4parser.h264.write.CAVLCWriter;
import java.io.IOException;

public class ScalingList {
    public int[] scalingList;
    public boolean useDefaultScalingMatrixFlag;

    public void write(CAVLCWriter cAVLCWriter) throws IOException {
        if (this.useDefaultScalingMatrixFlag) {
            cAVLCWriter.writeSE(0, "SPS: ");
            return;
        }
        int n = 8;
        int n2 = 8;
        for (int i = 0; i < this.scalingList.length; ++i) {
            if (n2 != 0) {
                int n3 = this.scalingList[i] - n - 256;
                cAVLCWriter.writeSE(n3, "SPS: ");
            }
            n = this.scalingList[i];
        }
    }

    public static ScalingList read(CAVLCReader cAVLCReader, int n) throws IOException {
        ScalingList scalingList = new ScalingList();
        scalingList.scalingList = new int[n];
        int n2 = 8;
        int n3 = 8;
        for (int i = 0; i < n; ++i) {
            if (n3 != 0) {
                int n4 = cAVLCReader.readSE("deltaScale");
                n3 = (n2 + n4 + 256) % 256;
                scalingList.useDefaultScalingMatrixFlag = i == 0 && n3 == 0;
            }
            scalingList.scalingList[i] = n3 == 0 ? n2 : n3;
            n2 = scalingList.scalingList[i];
        }
        return scalingList;
    }

    public String toString() {
        return "ScalingList{scalingList=" + this.scalingList + ", useDefaultScalingMatrixFlag=" + this.useDefaultScalingMatrixFlag + '}';
    }
}

