/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.cenc;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.googlecode.mp4parser.AbstractFullBox;
import com.googlecode.mp4parser.util.UUIDConverter;
import java.nio.ByteBuffer;
import java.util.UUID;

public class ProtectionSystemSpecificHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "pssh";
    public static byte[] OMA2_SYSTEM_ID = UUIDConverter.convert(UUID.fromString("A2B55680-6F43-11E0-9A3F-0002A5D5C51B"));
    public static byte[] PLAYREADY_SYSTEM_ID = UUIDConverter.convert(UUID.fromString("9A04F079-9840-4286-AB92-E65BE0885F95"));
    byte[] content;
    byte[] systemId;

    public byte[] getSystemId() {
        return this.systemId;
    }

    public void setSystemId(byte[] byArray) {
        assert (byArray.length == 16);
        this.systemId = byArray;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] byArray) {
        this.content = byArray;
    }

    public ProtectionSystemSpecificHeaderBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return 24 + this.content.length;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        assert (this.systemId.length == 16);
        byteBuffer.put(this.systemId, 0, 16);
        IsoTypeWriter.writeUInt32(byteBuffer, this.content.length);
        byteBuffer.put(this.content);
    }

    @Override
    protected void _parseDetails(ByteBuffer byteBuffer) {
        this.parseVersionAndFlags(byteBuffer);
        this.systemId = new byte[16];
        byteBuffer.get(this.systemId);
        long l = IsoTypeReader.readUInt32(byteBuffer);
        this.content = new byte[byteBuffer.remaining()];
        byteBuffer.get(this.content);
        assert (l == (long)this.content.length);
    }
}

