/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.List;

public class ReplaceSampleTrack
extends AbstractTrack {
    Track origTrack;
    private long sampleNumber;
    private ByteBuffer sampleContent;
    private List<ByteBuffer> samples;

    public ReplaceSampleTrack(Track track, long l, ByteBuffer byteBuffer) {
        this.origTrack = track;
        this.sampleNumber = l;
        this.sampleContent = byteBuffer;
        this.samples = new ReplaceASingleEntryList();
    }

    @Override
    public List<ByteBuffer> getSamples() {
        return this.samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.origTrack.getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        return this.origTrack.getDecodingTimeEntries();
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.origTrack.getCompositionTimeEntries();
    }

    @Override
    public synchronized long[] getSyncSamples() {
        return this.origTrack.getSyncSamples();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.origTrack.getSampleDependencies();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.origTrack.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.origTrack.getHandler();
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.origTrack.getMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.origTrack.getSubsampleInformationBox();
    }

    private class ReplaceASingleEntryList
    extends AbstractList<ByteBuffer> {
        private ReplaceASingleEntryList() {
        }

        @Override
        public ByteBuffer get(int n) {
            if (ReplaceSampleTrack.this.sampleNumber == (long)n) {
                return ReplaceSampleTrack.this.sampleContent;
            }
            return ReplaceSampleTrack.this.origTrack.getSamples().get(n);
        }

        @Override
        public int size() {
            return ReplaceSampleTrack.this.origTrack.getSamples().size();
        }
    }
}

