/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AppendTrack
extends AbstractTrack {
    Track[] tracks;
    SampleDescriptionBox stsd;

    public AppendTrack(Track ... trackArray) throws IOException {
        this.tracks = trackArray;
        for (Track track : trackArray) {
            AudioSampleEntry audioSampleEntry;
            if (this.stsd == null) {
                this.stsd = track.getSampleDescriptionBox();
                continue;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            track.getSampleDescriptionBox().getBox(Channels.newChannel(byteArrayOutputStream));
            this.stsd.getBox(Channels.newChannel(byteArrayOutputStream2));
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            if (Arrays.equals(byArray2, byArray)) continue;
            SampleDescriptionBox sampleDescriptionBox = track.getSampleDescriptionBox();
            if (this.stsd.getBoxes().size() == 1 && sampleDescriptionBox.getBoxes().size() == 1 && this.stsd.getBoxes().get(0) instanceof AudioSampleEntry && sampleDescriptionBox.getBoxes().get(0) instanceof AudioSampleEntry && (audioSampleEntry = this.mergeAudioSampleEntries((AudioSampleEntry)this.stsd.getBoxes().get(0), (AudioSampleEntry)sampleDescriptionBox.getBoxes().get(0))) != null) {
                this.stsd.setBoxes(Collections.singletonList(audioSampleEntry));
                return;
            }
            throw new IOException("Cannot append " + track + " to " + trackArray[0] + " since their Sample Description Boxes differ: \n" + track.getSampleDescriptionBox() + "\n vs. \n" + trackArray[0].getSampleDescriptionBox());
        }
    }

    private AudioSampleEntry mergeAudioSampleEntries(AudioSampleEntry audioSampleEntry, AudioSampleEntry audioSampleEntry2) throws IOException {
        if (audioSampleEntry.getType().equals(audioSampleEntry2.getType())) {
            AudioSampleEntry audioSampleEntry3 = new AudioSampleEntry(audioSampleEntry2.getType());
            if (audioSampleEntry.getBytesPerFrame() != audioSampleEntry2.getBytesPerFrame()) {
                return null;
            }
            audioSampleEntry3.setBytesPerFrame(audioSampleEntry.getBytesPerFrame());
            if (audioSampleEntry.getBytesPerPacket() != audioSampleEntry2.getBytesPerPacket()) {
                return null;
            }
            audioSampleEntry3.setBytesPerPacket(audioSampleEntry.getBytesPerPacket());
            if (audioSampleEntry.getBytesPerSample() != audioSampleEntry2.getBytesPerSample()) {
                return null;
            }
            audioSampleEntry3.setBytesPerSample(audioSampleEntry.getBytesPerSample());
            if (audioSampleEntry.getChannelCount() != audioSampleEntry2.getChannelCount()) {
                return null;
            }
            audioSampleEntry3.setChannelCount(audioSampleEntry.getChannelCount());
            if (audioSampleEntry.getPacketSize() != audioSampleEntry2.getPacketSize()) {
                return null;
            }
            audioSampleEntry3.setPacketSize(audioSampleEntry.getPacketSize());
            if (audioSampleEntry.getCompressionId() != audioSampleEntry2.getCompressionId()) {
                return null;
            }
            audioSampleEntry3.setCompressionId(audioSampleEntry.getCompressionId());
            if (audioSampleEntry.getSampleRate() != audioSampleEntry2.getSampleRate()) {
                return null;
            }
            audioSampleEntry3.setSampleRate(audioSampleEntry.getSampleRate());
            if (audioSampleEntry.getSampleSize() != audioSampleEntry2.getSampleSize()) {
                return null;
            }
            audioSampleEntry3.setSampleSize(audioSampleEntry.getSampleSize());
            if (audioSampleEntry.getSamplesPerPacket() != audioSampleEntry2.getSamplesPerPacket()) {
                return null;
            }
            audioSampleEntry3.setSamplesPerPacket(audioSampleEntry.getSamplesPerPacket());
            if (audioSampleEntry.getSoundVersion() != audioSampleEntry2.getSoundVersion()) {
                return null;
            }
            audioSampleEntry3.setSoundVersion(audioSampleEntry.getSoundVersion());
            if (!Arrays.equals(audioSampleEntry.getSoundVersion2Data(), audioSampleEntry2.getSoundVersion2Data())) {
                return null;
            }
            audioSampleEntry3.setSoundVersion2Data(audioSampleEntry.getSoundVersion2Data());
            if (audioSampleEntry.getBoxes().size() == audioSampleEntry2.getBoxes().size()) {
                Iterator<Box> iterator = audioSampleEntry.getBoxes().iterator();
                Iterator<Box> iterator2 = audioSampleEntry2.getBoxes().iterator();
                while (iterator.hasNext()) {
                    Box box = iterator.next();
                    Box box2 = iterator2.next();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    box.getBox(Channels.newChannel(byteArrayOutputStream));
                    box2.getBox(Channels.newChannel(byteArrayOutputStream2));
                    if (Arrays.equals(byteArrayOutputStream.toByteArray(), byteArrayOutputStream2.toByteArray())) {
                        audioSampleEntry3.addBox(box);
                        continue;
                    }
                    if (!"esds".equals(box.getType()) || !"esds".equals(box2.getType())) continue;
                    ESDescriptorBox eSDescriptorBox = (ESDescriptorBox)box;
                    ESDescriptorBox eSDescriptorBox2 = (ESDescriptorBox)box2;
                    ESDescriptor eSDescriptor = eSDescriptorBox.getEsDescriptor();
                    ESDescriptor eSDescriptor2 = eSDescriptorBox2.getEsDescriptor();
                    if (eSDescriptor.getURLFlag() != eSDescriptor2.getURLFlag()) {
                        return null;
                    }
                    if (eSDescriptor.getURLLength() != eSDescriptor2.getURLLength()) {
                        return null;
                    }
                    if (eSDescriptor.getDependsOnEsId() != eSDescriptor2.getDependsOnEsId()) {
                        return null;
                    }
                    if (eSDescriptor.getEsId() != eSDescriptor2.getEsId()) {
                        return null;
                    }
                    if (eSDescriptor.getoCREsId() != eSDescriptor2.getoCREsId()) {
                        return null;
                    }
                    if (eSDescriptor.getoCRstreamFlag() != eSDescriptor2.getoCRstreamFlag()) {
                        return null;
                    }
                    if (eSDescriptor.getRemoteODFlag() != eSDescriptor2.getRemoteODFlag()) {
                        return null;
                    }
                    if (eSDescriptor.getStreamDependenceFlag() != eSDescriptor2.getStreamDependenceFlag()) {
                        return null;
                    }
                    if (eSDescriptor.getStreamPriority() != eSDescriptor2.getStreamPriority()) {
                        return null;
                    }
                    if (eSDescriptor.getURLString() != null ? !eSDescriptor.getURLString().equals(eSDescriptor2.getURLString()) : eSDescriptor2.getURLString() != null) {
                        return null;
                    }
                    if (eSDescriptor.getDecoderConfigDescriptor() != null ? !eSDescriptor.getDecoderConfigDescriptor().equals(eSDescriptor2.getDecoderConfigDescriptor()) : eSDescriptor2.getDecoderConfigDescriptor() != null) {
                        DecoderConfigDescriptor decoderConfigDescriptor = eSDescriptor.getDecoderConfigDescriptor();
                        DecoderConfigDescriptor decoderConfigDescriptor2 = eSDescriptor2.getDecoderConfigDescriptor();
                        if (!decoderConfigDescriptor.getAudioSpecificInfo().equals(decoderConfigDescriptor2.getAudioSpecificInfo())) {
                            return null;
                        }
                        if (decoderConfigDescriptor.getAvgBitRate() != decoderConfigDescriptor2.getAvgBitRate()) {
                            // empty if block
                        }
                        if (decoderConfigDescriptor.getBufferSizeDB() != decoderConfigDescriptor2.getBufferSizeDB()) {
                            // empty if block
                        }
                        if (decoderConfigDescriptor.getDecoderSpecificInfo() != null ? !decoderConfigDescriptor.getDecoderSpecificInfo().equals(decoderConfigDescriptor2.getDecoderSpecificInfo()) : decoderConfigDescriptor2.getDecoderSpecificInfo() != null) {
                            return null;
                        }
                        if (decoderConfigDescriptor.getMaxBitRate() != decoderConfigDescriptor2.getMaxBitRate()) {
                            // empty if block
                        }
                        if (!decoderConfigDescriptor.getProfileLevelIndicationDescriptors().equals(decoderConfigDescriptor2.getProfileLevelIndicationDescriptors())) {
                            return null;
                        }
                        if (decoderConfigDescriptor.getObjectTypeIndication() != decoderConfigDescriptor2.getObjectTypeIndication()) {
                            return null;
                        }
                        if (decoderConfigDescriptor.getStreamType() != decoderConfigDescriptor2.getStreamType()) {
                            return null;
                        }
                        if (decoderConfigDescriptor.getUpStream() != decoderConfigDescriptor2.getUpStream()) {
                            return null;
                        }
                    }
                    if (eSDescriptor.getOtherDescriptors() != null ? !eSDescriptor.getOtherDescriptors().equals(eSDescriptor2.getOtherDescriptors()) : eSDescriptor2.getOtherDescriptors() != null) {
                        return null;
                    }
                    if (eSDescriptor.getSlConfigDescriptor() != null ? !eSDescriptor.getSlConfigDescriptor().equals(eSDescriptor2.getSlConfigDescriptor()) : eSDescriptor2.getSlConfigDescriptor() != null) {
                        return null;
                    }
                    audioSampleEntry3.addBox(box);
                }
            }
            return audioSampleEntry3;
        }
        return null;
    }

    @Override
    public List<ByteBuffer> getSamples() {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        for (Track track : this.tracks) {
            arrayList.addAll(track.getSamples());
        }
        return arrayList;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.stsd;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        if (this.tracks[0].getDecodingTimeEntries() != null && !this.tracks[0].getDecodingTimeEntries().isEmpty()) {
            LinkedList<long[]> linkedList = new LinkedList<long[]>();
            for (Track track : this.tracks) {
                linkedList.add(TimeToSampleBox.blowupTimeToSamples(track.getDecodingTimeEntries()));
            }
            LinkedList linkedList2 = new LinkedList();
            for (long[] lArray : linkedList) {
                for (Object object : (Track)lArray) {
                    TimeToSampleBox.Entry entry;
                    if (linkedList2.isEmpty() || ((TimeToSampleBox.Entry)linkedList2.getLast()).getDelta() != object) {
                        entry = new TimeToSampleBox.Entry(1L, (long)object);
                        linkedList2.add(entry);
                        continue;
                    }
                    entry = (TimeToSampleBox.Entry)linkedList2.getLast();
                    entry.setCount(entry.getCount() + 1L);
                }
            }
            return linkedList2;
        }
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        if (this.tracks[0].getCompositionTimeEntries() != null && !this.tracks[0].getCompositionTimeEntries().isEmpty()) {
            LinkedList<int[]> linkedList = new LinkedList<int[]>();
            for (Track track : this.tracks) {
                linkedList.add(CompositionTimeToSample.blowupCompositionTimes(track.getCompositionTimeEntries()));
            }
            LinkedList linkedList2 = new LinkedList();
            for (int[] nArray : linkedList) {
                for (Object object : (Track)nArray) {
                    CompositionTimeToSample.Entry entry;
                    if (linkedList2.isEmpty() || ((CompositionTimeToSample.Entry)linkedList2.getLast()).getOffset() != object) {
                        entry = new CompositionTimeToSample.Entry(1, (int)object);
                        linkedList2.add(entry);
                        continue;
                    }
                    entry = (CompositionTimeToSample.Entry)linkedList2.getLast();
                    entry.setCount(entry.getCount() + 1);
                }
            }
            return linkedList2;
        }
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        if (this.tracks[0].getSyncSamples() != null && this.tracks[0].getSyncSamples().length > 0) {
            int n = 0;
            for (Track track : this.tracks) {
                n += track.getSyncSamples().length;
            }
            long[] lArray = new long[n];
            int n2 = 0;
            long l = 0L;
            for (Track track : this.tracks) {
                for (long l2 : track.getSyncSamples()) {
                    lArray[n2++] = l + l2;
                }
                l += (long)track.getSamples().size();
            }
            return lArray;
        }
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.tracks[0].getSampleDependencies() != null && !this.tracks[0].getSampleDependencies().isEmpty()) {
            LinkedList<SampleDependencyTypeBox.Entry> linkedList = new LinkedList<SampleDependencyTypeBox.Entry>();
            for (Track track : this.tracks) {
                linkedList.addAll(track.getSampleDependencies());
            }
            return linkedList;
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.tracks[0].getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.tracks[0].getHandler();
    }

    @Override
    public Box getMediaHeaderBox() {
        return this.tracks[0].getMediaHeaderBox();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.tracks[0].getSubsampleInformationBox();
    }
}

